/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckIterator;
import org.eclipse.jdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;

public class JavaSpellingEngine
extends SpellingEngine {
    protected void check(IDocument document, IRegion[] regions, ISpellChecker checker, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        SpellingEngine.SpellEventListener listener = new SpellingEngine.SpellEventListener(collector, document);
        boolean isIgnoringJavaStrings = PreferenceConstants.getPreferenceStore().getBoolean("spelling_ignore_java_strings");
        try {
            int i = 0;
            while (i < regions.length) {
                IRegion region = regions[i];
                ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)"___java_partitioning", (int)region.getOffset(), (int)region.getLength(), (boolean)false);
                int index = 0;
                while (index < partitions.length) {
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    if (listener.isProblemsThresholdReached()) {
                        return;
                    }
                    ITypedRegion partition = partitions[index];
                    String type = partition.getType();
                    if (!(isIgnoringJavaStrings && type.equals("__java_string") || type.equals("__dftl_partition_content_type") || type.equals("__java_character"))) {
                        checker.execute(listener, new SpellCheckIterator(document, (IRegion)partition, checker.getLocale()));
                    }
                    ++index;
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (AssertionFailedException assertionFailedException) {
            // empty catch block
        }
    }
}

