/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling.engine;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.spelling.engine.DefaultPhoneticDistanceAlgorithm;
import org.eclipse.jdt.internal.ui.text.spelling.engine.DefaultPhoneticHashProvider;
import org.eclipse.jdt.internal.ui.text.spelling.engine.IPhoneticDistanceAlgorithm;
import org.eclipse.jdt.internal.ui.text.spelling.engine.IPhoneticHashProvider;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellDictionary;
import org.eclipse.jdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSpellDictionary
implements ISpellDictionary {
    private static final String UTF_8 = "UTF-8";
    protected static final int BUCKET_CAPACITY = 4;
    protected static final int BUFFER_CAPACITY = 32;
    protected static final int DISTANCE_THRESHOLD = 160;
    protected static final float LOAD_FACTOR = 0.85f;
    private IPhoneticDistanceAlgorithm fDistanceAlgorithm = new DefaultPhoneticDistanceAlgorithm();
    private final Map<ByteArrayWrapper, Object> fHashBuckets = new HashMap<ByteArrayWrapper, Object>(this.getInitialSize(), 0.85f);
    private IPhoneticHashProvider fHashProvider = new DefaultPhoneticHashProvider();
    private boolean fLoaded = false;
    private boolean fMustLoad = true;
    boolean fIsStrippingNonLetters = true;

    protected int getInitialSize() {
        return 32;
    }

    protected final Object getCandidates(String hash) {
        ByteArrayWrapper hashBytes;
        try {
            hashBytes = new ByteArrayWrapper(hash.getBytes(UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            JavaPlugin.log(e);
            return null;
        }
        return this.fHashBuckets.get(hashBytes);
    }

    protected final Set<RankedWordProposal> getCandidates(String word, boolean sentence, ArrayList<String> hashs) {
        int distance = 0;
        String hash = null;
        StringBuffer buffer = new StringBuffer(32);
        HashSet<RankedWordProposal> result = new HashSet<RankedWordProposal>(4 * hashs.size());
        int index = 0;
        while (index < hashs.size()) {
            hash = hashs.get(index);
            Object candidates = this.getCandidates(hash);
            if (candidates != null) {
                if (candidates instanceof byte[]) {
                    String candidate;
                    try {
                        candidate = new String((byte[])candidates, UTF_8);
                    }
                    catch (UnsupportedEncodingException e) {
                        JavaPlugin.log(e);
                        return result;
                    }
                    distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                    if (distance < 160) {
                        buffer.setLength(0);
                        buffer.append(candidate);
                        if (sentence) {
                            buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                        }
                        result.add(new RankedWordProposal(buffer.toString(), -distance));
                    }
                } else {
                    ArrayList candidateList = (ArrayList)candidates;
                    int candidateSize = Math.min(500, candidateList.size());
                    int offset = 0;
                    while (offset < candidateSize) {
                        String candidate;
                        try {
                            candidate = new String((byte[])candidateList.get(offset), UTF_8);
                        }
                        catch (UnsupportedEncodingException e) {
                            JavaPlugin.log(e);
                            return result;
                        }
                        distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                        if (distance < 160) {
                            buffer.setLength(0);
                            buffer.append(candidate);
                            if (sentence) {
                                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                            }
                            result.add(new RankedWordProposal(buffer.toString(), -distance));
                        }
                        ++offset;
                    }
                }
            }
            ++index;
        }
        return result;
    }

    protected final void getCandidates(String word, boolean sentence, Set<RankedWordProposal> result) {
        int distance = 0;
        int minimum = Integer.MAX_VALUE;
        StringBuffer buffer = new StringBuffer(32);
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return;
        }
        if (candidates instanceof byte[]) {
            String candidate;
            try {
                candidate = new String((byte[])candidates, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                JavaPlugin.log(e);
                return;
            }
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            buffer.append(candidate);
            if (sentence) {
                buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
            }
            result.add(new RankedWordProposal(buffer.toString(), -distance));
            return;
        }
        ArrayList candidateList = (ArrayList)candidates;
        ArrayList<RankedWordProposal> matches = new ArrayList<RankedWordProposal>(candidateList.size());
        int index = 0;
        while (index < candidateList.size()) {
            String candidate;
            try {
                candidate = new String((byte[])candidateList.get(index), UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                JavaPlugin.log(e);
                return;
            }
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            if (distance <= minimum) {
                if (distance < minimum) {
                    matches.clear();
                }
                buffer.setLength(0);
                buffer.append(candidate);
                if (sentence) {
                    buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                }
                matches.add(new RankedWordProposal(buffer.toString(), -distance));
                minimum = distance;
            }
            ++index;
        }
        result.addAll(matches);
    }

    protected boolean isEmpty() {
        return this.fHashBuckets.size() == 0;
    }

    protected final IPhoneticDistanceAlgorithm getDistanceAlgorithm() {
        return this.fDistanceAlgorithm;
    }

    protected final IPhoneticHashProvider getHashProvider() {
        return this.fHashProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<RankedWordProposal> getProposals(String word, boolean sentence) {
        block14: {
            try {
                if (this.fLoaded) break block14;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String hash = this.fHashProvider.getHash(word);
        char[] mutators = this.fHashProvider.getMutators();
        ArrayList<String> neighborhood = new ArrayList<String>((word.length() + 1) * (mutators.length + 2));
        neighborhood.add(hash);
        Set<RankedWordProposal> candidates = this.getCandidates(word, sentence, neighborhood);
        neighborhood.clear();
        char previous = '\u0000';
        char next = '\u0000';
        char[] characters = word.toCharArray();
        int index = 0;
        while (index < word.length() - 1) {
            next = characters[index];
            characters[index] = previous = characters[index + 1];
            characters[index + 1] = next;
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            characters[index] = next;
            characters[index + 1] = previous;
            ++index;
        }
        String sentinel = String.valueOf(word) + " ";
        characters = sentinel.toCharArray();
        int offset = characters.length - 1;
        while (true) {
            int index2 = 0;
            while (index2 < mutators.length) {
                characters[offset] = mutators[index2];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++index2;
            }
            if (offset == 0) break;
            characters[offset] = characters[offset - 1];
            --offset;
        }
        char mutated = '\u0000';
        characters = word.toCharArray();
        int index3 = 0;
        while (index3 < word.length()) {
            mutated = characters[index3];
            int mutator = 0;
            while (mutator < mutators.length) {
                characters[index3] = mutators[mutator];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++mutator;
            }
            characters[index3] = mutated;
            ++index3;
        }
        characters = word.toCharArray();
        char[] deleted = new char[characters.length - 1];
        int index4 = 0;
        while (index4 < deleted.length) {
            deleted[index4] = characters[index4];
            ++index4;
        }
        next = characters[characters.length - 1];
        offset = deleted.length;
        while (true) {
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            if (offset == 0) break;
            previous = next;
            next = deleted[offset - 1];
            deleted[offset - 1] = previous;
            --offset;
        }
        neighborhood.remove(hash);
        Set<RankedWordProposal> matches = this.getCandidates(word, sentence, neighborhood);
        if (matches.size() == 0 && candidates.size() == 0) {
            this.getCandidates(word, sentence, candidates);
        }
        candidates.addAll(matches);
        return candidates;
    }

    protected abstract URL getURL() throws MalformedURLException;

    protected final void hashWord(String word) {
        byte[] wordBytes;
        ByteArrayWrapper hashBytes;
        String hash = this.fHashProvider.getHash(word);
        try {
            hashBytes = new ByteArrayWrapper(hash.getBytes(UTF_8));
            wordBytes = word.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            JavaPlugin.log(e);
            return;
        }
        Object bucket = this.fHashBuckets.get(hashBytes);
        if (bucket == null) {
            this.fHashBuckets.put(hashBytes, wordBytes);
        } else if (bucket instanceof ArrayList) {
            ArrayList bucketList = (ArrayList)bucket;
            bucketList.add(wordBytes);
        } else {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(bucket);
            list.add(wordBytes);
            this.fHashBuckets.put(hashBytes, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrect(String word) {
        byte[] lowercaseWordBytes;
        byte[] wordBytes;
        block14: {
            word = this.stripNonLetters(word);
            try {
                if (this.fLoaded) break block14;
                AbstractSpellDictionary abstractSpellDictionary = this;
                synchronized (abstractSpellDictionary) {
                    this.fLoaded = this.load(this.getURL());
                    if (this.fLoaded) {
                        this.compact();
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Object candidates = this.getCandidates(this.fHashProvider.getHash(word));
        if (candidates == null) {
            return false;
        }
        if (candidates instanceof byte[]) {
            String candidate;
            try {
                candidate = new String((byte[])candidates, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                JavaPlugin.log(e);
                return false;
            }
            return candidate.equals(word) || candidate.equals(word.toLowerCase());
        }
        ArrayList candidateList = (ArrayList)candidates;
        try {
            wordBytes = word.getBytes(UTF_8);
            lowercaseWordBytes = word.toLowerCase().getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            JavaPlugin.log(e);
            return false;
        }
        int index = 0;
        while (index < candidateList.size()) {
            byte[] candidate = (byte[])candidateList.get(index);
            if (Arrays.equals(candidate, wordBytes) || Arrays.equals(candidate, lowercaseWordBytes)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    @Override
    public void setStripNonLetters(boolean state) {
        this.fIsStrippingNonLetters = state;
    }

    /*
     * Unable to fully structure code
     */
    protected String stripNonLetters(String word) {
        if (!this.fIsStrippingNonLetters) {
            return word;
        }
        i = 0;
        j = word.length() - 1;
        while (i <= j && !Character.isLetter(word.charAt(i))) {
            ++i;
        }
        if (i <= j) ** GOTO lbl11
        return "";
lbl-1000:
        // 1 sources

        {
            --j;
lbl11:
            // 2 sources

            ** while (j > i && !Character.isLetter((char)word.charAt((int)j)))
        }
lbl12:
        // 1 sources

        return word.substring(i, j + 1);
    }

    @Override
    public final synchronized boolean isLoaded() {
        return this.fLoaded || this.fHashBuckets.size() > 0;
    }

    protected synchronized boolean load(URL url) {
        block31: {
            if (!this.fMustLoad) {
                return this.fLoaded;
            }
            if (url != null) {
                InputStream stream = null;
                int line = 0;
                try {
                    stream = url.openStream();
                    if (stream == null) break block31;
                    String word = null;
                    CharsetDecoder decoder = Charset.forName(this.getEncoding()).newDecoder();
                    decoder.onMalformedInput(CodingErrorAction.REPORT);
                    decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream, decoder));
                    boolean doRead = true;
                    while (doRead) {
                        try {
                            word = reader.readLine();
                        }
                        catch (MalformedInputException ex) {
                            decoder.onMalformedInput(CodingErrorAction.REPLACE);
                            decoder.reset();
                            word = reader.readLine();
                            decoder.onMalformedInput(CodingErrorAction.REPORT);
                            String message = Messages.format(JavaUIMessages.AbstractSpellingDictionary_encodingError, new String[]{word, decoder.replacement(), BasicElementLabels.getURLPart(url.toString())});
                            Status status = new Status(4, "org.eclipse.jdt.ui", 0, message, (Throwable)ex);
                            JavaPlugin.log((IStatus)status);
                            doRead = word != null;
                            continue;
                        }
                        boolean bl = doRead = word != null;
                        if (!doRead) continue;
                        this.hashWord(word);
                    }
                    return true;
                }
                catch (FileNotFoundException ex) {
                    String urlString = url.toString();
                    String lowercaseUrlString = urlString.toLowerCase();
                    if (urlString.equals(lowercaseUrlString)) {
                        JavaPlugin.log(ex);
                        break block31;
                    }
                    try {
                        boolean bl = this.load(new URL(lowercaseUrlString));
                        return bl;
                    }
                    catch (MalformedURLException e) {
                        JavaPlugin.log(e);
                    }
                }
                catch (IOException exception) {
                    if (line > 0) {
                        String message = Messages.format(JavaUIMessages.AbstractSpellingDictionary_encodingError, new Object[]{new Integer(line), BasicElementLabels.getURLPart(url.toString())});
                        Status status = new Status(4, "org.eclipse.jdt.ui", 0, message, (Throwable)exception);
                        JavaPlugin.log((IStatus)status);
                    } else {
                        JavaPlugin.log(exception);
                    }
                }
                finally {
                    this.fMustLoad = false;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return false;
    }

    private void compact() {
        for (Object element : this.fHashBuckets.values()) {
            if (!(element instanceof ArrayList)) continue;
            ((ArrayList)element).trimToSize();
        }
    }

    protected final void setDistanceAlgorithm(IPhoneticDistanceAlgorithm algorithm) {
        this.fDistanceAlgorithm = algorithm;
    }

    protected final void setHashProvider(IPhoneticHashProvider provider) {
        this.fHashProvider = provider;
    }

    @Override
    public synchronized void unload() {
        this.fLoaded = false;
        this.fMustLoad = true;
        this.fHashBuckets.clear();
    }

    @Override
    public boolean acceptsWords() {
        return false;
    }

    @Override
    public void addWord(String word) {
    }

    protected String getEncoding() {
        String encoding = JavaPlugin.getDefault().getPreferenceStore().getString("spelling_user_dictionary_encoding");
        if (encoding == null || encoding.length() == 0) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return encoding;
    }

    private static class ByteArrayWrapper {
        private byte[] byteArray;

        private static int hashCode(byte[] array) {
            int prime = 31;
            if (array == null) {
                return 0;
            }
            int result = 1;
            int index = 0;
            while (index < array.length) {
                result = prime * result + array[index];
                ++index;
            }
            return result;
        }

        public ByteArrayWrapper(byte[] byteArray) {
            this.byteArray = byteArray;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ByteArrayWrapper.hashCode(this.byteArray);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ByteArrayWrapper)) {
                return false;
            }
            ByteArrayWrapper other = (ByteArrayWrapper)obj;
            return Arrays.equals(this.byteArray, other.byteArray);
        }
    }
}

