/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.Arrays;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.FocusDescriptor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class HierarchyLabelProvider
extends AppearanceAwareLabelProvider {
    private Color fSpecialColor;
    private ViewerFilter fFilter;
    private TypeHierarchyLifeCycle fHierarchy;

    public HierarchyLabelProvider(TypeHierarchyLifeCycle lifeCycle) {
        super(317896301477929L, 1);
        this.fHierarchy = lifeCycle;
        this.fFilter = null;
    }

    public ViewerFilter getFilter() {
        return this.fFilter;
    }

    public void setFilter(ViewerFilter filter) {
        this.fFilter = filter;
    }

    protected boolean isInDifferentHierarchyScope(IType type) {
        if (this.fFilter != null && !this.fFilter.select(null, null, (Object)type)) {
            return true;
        }
        IJavaElement[] input = this.fHierarchy.getInputElements();
        if (input == null) {
            return false;
        }
        int i = 0;
        while (i < input.length) {
            if (input[i] == null || input[i].getElementType() == 7) {
                return false;
            }
            IJavaElement parent = type.getAncestor(input[i].getElementType());
            if (input[i].getElementType() == 4 ? parent == null || parent.getElementName().equals(input[i].getElementName()) : input[i].equals(parent)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof IType) {
            Object desc = this.getTypeImageDescriptor((IType)element);
            if (desc != null) {
                IJavaElement[] elements = this.fHierarchy.getInputElements();
                if (elements != null && Arrays.asList(elements).contains(element)) {
                    desc = new FocusDescriptor((ImageDescriptor)desc);
                }
                result = JavaPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
            }
        } else {
            result = this.fImageLabelProvider.getImageLabel(element, this.evaluateImageFlags(element));
        }
        return this.decorateImage(result, element);
    }

    private ImageDescriptor getTypeImageDescriptor(IType type) {
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        int flags = hierarchy.getCachedFlags(type);
        if (flags == -1) {
            return new JavaElementImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.BIG_SIZE);
        }
        boolean isInterface = Flags.isInterface((int)flags);
        IType declaringType = type.getDeclaringType();
        boolean isInner = declaringType != null;
        boolean isInInterfaceOrAnnotation = false;
        if (isInner) {
            int declaringTypeFlags = hierarchy.getCachedFlags(declaringType);
            if (declaringTypeFlags != -1) {
                isInInterfaceOrAnnotation = Flags.isInterface((int)declaringTypeFlags);
            } else {
                try {
                    isInInterfaceOrAnnotation = declaringType.isInterface();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
        ImageDescriptor desc = JavaElementImageProvider.getTypeImageDescriptor(isInner, isInInterfaceOrAnnotation, flags, this.isInDifferentHierarchyScope(type));
        int adornmentFlags = 0;
        if (Flags.isFinal((int)flags)) {
            adornmentFlags |= 2;
        }
        if (Flags.isAbstract((int)flags) && !isInterface) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)flags)) {
            adornmentFlags |= 8;
        }
        if (Flags.isDeprecated((int)flags)) {
            adornmentFlags |= 0x400;
        }
        return new JavaElementImageDescriptor(desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
    }

    public Color getForeground(Object element) {
        if (element instanceof IMethod) {
            if (this.fSpecialColor == null) {
                this.fSpecialColor = Display.getCurrent().getSystemColor(10);
            }
            return this.fSpecialColor;
        }
        if (element instanceof IType && this.isInDifferentHierarchyScope((IType)element)) {
            return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }
        return null;
    }
}

