/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDisposer;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathOrderingWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.LibrariesWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ProjectsWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceContainerWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.NewSourceContainerWorkbookPage;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPathsBlock {
    private IWorkspaceRoot fWorkspaceRoot;
    private CheckedListDialogField<CPListElement> fClassPathList;
    private StringButtonDialogField fBuildPathDialogField;
    private StatusInfo fClassPathStatus;
    private StatusInfo fOutputFolderStatus;
    private StatusInfo fBuildPathStatus;
    private IJavaProject fCurrJProject;
    private IPath fOutputLocationPath;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private TabFolder fTabFolder;
    private int fPageIndex;
    private BuildPathBasePage fSourceContainerPage;
    private ProjectsWorkbookPage fProjectsPage;
    private LibrariesWorkbookPage fLibrariesPage;
    private BuildPathBasePage fCurrPage;
    private String fUserSettingsTimeStamp;
    private long fFileTimeStamp;
    private IRunnableContext fRunnableContext;
    private boolean fUseNewPage;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private static final int IDX_UP = 0;
    private static final int IDX_DOWN = 1;
    private static final int IDX_TOP = 3;
    private static final int IDX_BOTTOM = 4;
    private static final int IDX_SELECT_ALL = 6;
    private static final int IDX_UNSELECT_ALL = 7;

    public BuildPathsBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        this.fPageContainer = pageContainer;
        this.fWorkspaceRoot = JavaPlugin.getWorkspace().getRoot();
        this.fContext = context;
        this.fUseNewPage = useNewPage;
        this.fPageIndex = pageToShow;
        this.fSourceContainerPage = null;
        this.fLibrariesPage = null;
        this.fProjectsPage = null;
        this.fCurrPage = null;
        this.fRunnableContext = runnableContext;
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[8];
        stringArray[0] = NewWizardMessages.BuildPathsBlock_classpath_up_button;
        stringArray[1] = NewWizardMessages.BuildPathsBlock_classpath_down_button;
        stringArray[3] = NewWizardMessages.BuildPathsBlock_classpath_top_button;
        stringArray[4] = NewWizardMessages.BuildPathsBlock_classpath_bottom_button;
        stringArray[6] = NewWizardMessages.BuildPathsBlock_classpath_checkall_button;
        stringArray[7] = NewWizardMessages.BuildPathsBlock_classpath_uncheckall_button;
        String[] buttonLabels = stringArray;
        this.fClassPathList = new CheckedListDialogField<CPListElement>(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fClassPathList.setDialogFieldListener(adapter);
        this.fClassPathList.setLabelText(NewWizardMessages.BuildPathsBlock_classpath_label);
        this.fClassPathList.setUpButtonIndex(0);
        this.fClassPathList.setDownButtonIndex(1);
        this.fClassPathList.setCheckAllButtonIndex(6);
        this.fClassPathList.setUncheckAllButtonIndex(7);
        this.fBuildPathDialogField = new StringButtonDialogField(adapter);
        this.fBuildPathDialogField.setButtonLabel(NewWizardMessages.BuildPathsBlock_buildpath_button);
        this.fBuildPathDialogField.setDialogFieldListener(adapter);
        this.fBuildPathDialogField.setLabelText(NewWizardMessages.BuildPathsBlock_buildpath_label);
        this.fBuildPathStatus = new StatusInfo();
        this.fClassPathStatus = new StatusInfo();
        this.fOutputFolderStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(composite.getFont());
        TabItem item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_source);
        item.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.packagefolder_obj.gif"));
        this.fSourceContainerPage = this.fUseNewPage ? new NewSourceContainerWorkbookPage(this.fClassPathList, this.fBuildPathDialogField, this.fRunnableContext, this) : new SourceContainerWorkbookPage(this.fClassPathList, this.fBuildPathDialogField);
        item.setData((Object)this.fSourceContainerPage);
        item.setControl(this.fSourceContainerPage.getControl((Composite)folder));
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new ProjectsWorkbookPage(this.fClassPathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_projects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        this.fLibrariesPage = new LibrariesWorkbookPage(this.fClassPathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_libraries);
        item.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        ClasspathOrderingWorkbookPage ordpage = new ClasspathOrderingWorkbookPage(this.fClassPathList);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_order);
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrJProject != null) {
            this.fSourceContainerPage.init(this.fCurrJProject);
            this.fLibrariesPage.init(this.fCurrJProject);
            this.fProjectsPage.init(this.fCurrJProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathsBlock.this.tabChanged(e.item);
            }
        });
        this.fTabFolder = folder;
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    public void init(IJavaProject jproject, IPath outputLocation, IClasspathEntry[] classpathEntries) {
        this.fCurrJProject = jproject;
        boolean projectExists = false;
        List<CPListElement> newClassPath = null;
        IProject project = this.fCurrJProject.getProject();
        projectExists = project.exists() && project.getFile(".classpath").exists();
        IClasspathEntry[] existingEntries = null;
        if (projectExists) {
            if (outputLocation == null) {
                outputLocation = this.fCurrJProject.readOutputLocation();
            }
            existingEntries = this.fCurrJProject.readRawClasspath();
            if (classpathEntries == null) {
                classpathEntries = existingEntries;
            }
        }
        if (outputLocation == null) {
            outputLocation = BuildPathsBlock.getDefaultOutputLocation(jproject);
        }
        if (classpathEntries != null) {
            newClassPath = this.getCPListElements(classpathEntries, existingEntries);
        }
        if (newClassPath == null) {
            newClassPath = this.getDefaultClassPath(jproject);
        }
        ArrayList<CPListElement> exportedEntries = new ArrayList<CPListElement>();
        int i = 0;
        while (i < newClassPath.size()) {
            CPListElement curr = newClassPath.get(i);
            if (curr.isExported() || curr.getEntryKind() == 3) {
                exportedEntries.add(curr);
            }
            ++i;
        }
        this.fBuildPathDialogField.setText(outputLocation.makeRelative().toString());
        this.fBuildPathDialogField.enableButton(project.exists());
        this.fClassPathList.setElements(newClassPath);
        this.fClassPathList.setCheckedElements(exportedEntries);
        this.fClassPathList.selectFirstElement();
        if (this.fSourceContainerPage != null) {
            this.fSourceContainerPage.init(this.fCurrJProject);
            this.fProjectsPage.init(this.fCurrJProject);
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        this.initializeTimeStamps();
        this.updateUI();
    }

    protected void updateUI() {
        if (this.fSWTWidget == null || this.fSWTWidget.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (BuildPathsBlock.this.fSWTWidget == null || BuildPathsBlock.this.fSWTWidget.isDisposed()) {
                        return;
                    }
                    BuildPathsBlock.this.doUpdateUI();
                }
            });
        }
    }

    protected void doUpdateUI() {
        this.fBuildPathDialogField.refresh();
        this.fClassPathList.refresh();
        this.doStatusLineUpdate();
    }

    private String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        CPListElement.appendEncodePath(this.fOutputLocationPath, buf).append(';');
        int nElements = this.fClassPathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            CPListElement elem = (CPListElement)this.fClassPathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public boolean hasChangesInClasspathFile() {
        IFile file = this.fCurrJProject.getProject().getFile(".classpath");
        return this.fFileTimeStamp != file.getModificationStamp();
    }

    public boolean isClassfileMissing() {
        return !this.fCurrJProject.getProject().getFile(".classpath").exists();
    }

    public void initializeTimeStamps() {
        IFile file = this.fCurrJProject.getProject().getFile(".classpath");
        this.fFileTimeStamp = file.getModificationStamp();
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    private ArrayList<CPListElement> getCPListElements(IClasspathEntry[] classpathEntries, IClasspathEntry[] existingEntries) {
        List<Object> existing = existingEntries == null ? Collections.emptyList() : Arrays.asList(existingEntries);
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr;
            newClassPath.add(CPListElement.create(curr, !existing.contains(curr = classpathEntries[i]), this.fCurrJProject));
            ++i;
        }
        return newClassPath;
    }

    public IJavaProject getJavaProject() {
        return this.fCurrJProject;
    }

    public IPath getOutputLocation() {
        return new Path(this.fBuildPathDialogField.getText()).makeAbsolute();
    }

    public IClasspathEntry[] getRawClassPath() {
        List elements = this.fClassPathList.getElements();
        int nElements = elements.size();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = 0;
        while (i < nElements) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            ++i;
        }
        return entries;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    private List<CPListElement> getDefaultClassPath(IJavaProject jproj) {
        ArrayList<CPListElement> list = new ArrayList<CPListElement>();
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        String sourceFolderName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName");
        Object srcFolder = store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects") && sourceFolderName.length() > 0 ? jproj.getProject().getFolder(sourceFolderName) : jproj.getProject();
        list.add(new CPListElement(jproj, 3, srcFolder.getFullPath(), (IResource)srcFolder));
        IClasspathEntry[] jreEntries = PreferenceConstants.getDefaultJRELibrary();
        list.addAll(this.getCPListElements(jreEntries, null));
        return list;
    }

    public static IPath getDefaultOutputLocation(IJavaProject jproj) {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        if (store.getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects")) {
            String outputLocationName = store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            return jproj.getProject().getFullPath().append(outputLocationName);
        }
        return jproj.getProject().getFullPath();
    }

    private void buildPathChangeControlPressed(DialogField field) {
        IContainer container;
        if (field == this.fBuildPathDialogField && (container = this.chooseContainer()) != null) {
            this.fBuildPathDialogField.setText(container.getFullPath().makeRelative().toString());
        }
    }

    public void updateTopButtonEnablement() {
        this.fClassPathList.enableButton(4, this.fClassPathList.canMoveDown());
        this.fClassPathList.enableButton(3, this.fClassPathList.canMoveUp());
    }

    public void buildPathCustomButtonPressed(ListDialogField<CPListElement> field, int index) {
        List<CPListElement> elems = field.getSelectedElements();
        field.removeElements(elems);
        if (index == 4) {
            field.addElements(elems);
        } else if (index == 3) {
            field.addElements(elems, 0);
        }
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fClassPathList) {
            this.updateClassPathStatus();
            this.updateTopButtonEnablement();
        } else if (field == this.fBuildPathDialogField) {
            this.updateOutputLocationStatus();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            IStatus res = this.findMostSevereStatus();
            this.fContext.statusChanged(res);
        }
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fClassPathStatus, this.fOutputFolderStatus, this.fBuildPathStatus});
    }

    public void updateClassPathStatus() {
        this.fClassPathStatus.setOK();
        List elements = this.fClassPathList.getElements();
        CPListElement entryMissing = null;
        CPListElement entryDeprecated = null;
        int nEntriesMissing = 0;
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            boolean isChecked = this.fClassPathList.isChecked(currElement);
            if (currElement.getEntryKind() == 3) {
                if (!isChecked) {
                    this.fClassPathList.setCheckedWithoutUpdate(currElement, true);
                }
                if (!this.fClassPathList.isGrayed(currElement)) {
                    this.fClassPathList.setGrayedWithoutUpdate(currElement, true);
                }
            } else {
                currElement.setExported(isChecked);
            }
            entries[i] = currElement.getClasspathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            if (entryDeprecated == null & currElement.isDeprecated()) {
                entryDeprecated = currElement;
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fClassPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntryMissing, BasicElementLabels.getPathLabel(entryMissing.getPath(), false)));
            } else {
                this.fClassPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntriesMissing, String.valueOf(nEntriesMissing)));
            }
        } else if (entryDeprecated != null) {
            this.fClassPathStatus.setInfo(entryDeprecated.getDeprecationMessage());
        }
        this.updateBuildPathStatus();
    }

    private void updateOutputLocationStatus() {
        IPath path;
        this.fOutputLocationPath = null;
        String text = this.fBuildPathDialogField.getText();
        if ("".equals(text)) {
            this.fOutputFolderStatus.setError(NewWizardMessages.BuildPathsBlock_error_EnterBuildPath);
            return;
        }
        this.fOutputLocationPath = path = this.getOutputLocation();
        IResource res = this.fWorkspaceRoot.findMember(path);
        if (res != null && res.getType() == 1) {
            this.fOutputFolderStatus.setError(NewWizardMessages.BuildPathsBlock_error_InvalidBuildPath);
            return;
        }
        this.fOutputFolderStatus.setOK();
        String pathStr = this.fBuildPathDialogField.getText();
        Path outputPath = new Path(pathStr);
        pathStr = outputPath.lastSegment();
        if (pathStr.equals(".settings") && outputPath.segmentCount() == 2) {
            this.fOutputFolderStatus.setWarning(NewWizardMessages.OutputLocation_SettingsAsLocation);
        }
        if (pathStr.charAt(0) == '.' && pathStr.length() > 1) {
            this.fOutputFolderStatus.setWarning(Messages.format(NewWizardMessages.OutputLocation_DotAsLocation, BasicElementLabels.getResourceName(pathStr)));
        }
        this.updateBuildPathStatus();
    }

    private void updateBuildPathStatus() {
        List elements = this.fClassPathList.getElements();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            --i;
        }
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)this.fCurrJProject, (IClasspathEntry[])entries, (IPath)this.fOutputLocationPath);
        if (!status.isOK()) {
            this.fBuildPathStatus.setError(status.getMessage());
            return;
        }
        this.fBuildPathStatus.setOK();
    }

    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.BuildPathsBlock_operationdesc_project, 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (locationURI != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(locationURI)) {
                    locationURI = null;
                }
                desc.setLocationURI(locationURI);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.configureJavaProject(null, monitor);
    }

    public void configureJavaProject(String newProjectCompliance, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        BuildPathsBlock.flush(this.fClassPathList.getElements(), this.getOutputLocation(), this.getJavaProject(), newProjectCompliance, monitor);
        this.initializeTimeStamps();
        this.updateUI();
    }

    public static void flush(List<CPListElement> classPathEntries, IPath outputLocation, IJavaProject javaProject, String newProjectCompliance, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NewWizardMessages.BuildPathsBlock_operationdesc_java);
        monitor.beginTask("", classPathEntries.size() * 4 + 4);
        try {
            IFolder folder;
            IPath oldOutputLocation;
            IProject project = javaProject.getProject();
            IPath projPath = project.getFullPath();
            try {
                oldOutputLocation = javaProject.getOutputLocation();
            }
            catch (CoreException e) {
                oldOutputLocation = projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
            }
            if (oldOutputLocation.equals((Object)projPath) && !outputLocation.equals((Object)projPath)) {
                if (BuildPathsBlock.hasClassfiles((IResource)project) && BuildPathsBlock.getRemoveOldBinariesQuery(JavaPlugin.getActiveWorkbenchShell()).doQuery(false, projPath)) {
                    BuildPathsBlock.removeOldClassfiles((IResource)project);
                }
            } else if (!outputLocation.equals((Object)oldOutputLocation) && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(oldOutputLocation)).exists()) {
                if (folder.members().length == 0) {
                    BuildPathsBlock.removeOldClassfiles((IResource)folder);
                } else if (BuildPathsBlock.getRemoveOldBinariesQuery(JavaPlugin.getActiveWorkbenchShell()).doQuery(folder.isDerived(), oldOutputLocation)) {
                    BuildPathsBlock.removeOldClassfiles((IResource)folder);
                }
            }
            monitor.worked(1);
            IWorkspaceRoot fWorkspaceRoot = JavaPlugin.getWorkspace().getRoot();
            if (!fWorkspaceRoot.exists(outputLocation)) {
                IFolder folder2 = fWorkspaceRoot.getFolder(outputLocation);
                CoreUtility.createDerivedFolder(folder2, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            int nEntries = classPathEntries.size();
            IClasspathEntry[] classpath = new IClasspathEntry[nEntries];
            int i = 0;
            for (CPListElement entry : classPathEntries) {
                classpath[i] = entry.getClasspathEntry();
                ++i;
                IResource res = entry.getResource();
                if (res instanceof IFolder && entry.getLinkTarget() == null && !res.exists()) {
                    CoreUtility.createFolder((IFolder)res, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                if (entry.getEntryKind() == 3) {
                    IPath folderOutput = (IPath)entry.getAttribute("output");
                    if (folderOutput != null && folderOutput.segmentCount() > 1) {
                        IFolder folder3 = fWorkspaceRoot.getFolder(folderOutput);
                        CoreUtility.createDerivedFolder(folder3, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.worked(1);
                    }
                    IPath path = entry.getPath();
                    if (projPath.equals((Object)path)) {
                        monitor.worked(2);
                        continue;
                    }
                    if (projPath.isPrefixOf(path)) {
                        path = path.removeFirstSegments(projPath.segmentCount());
                    }
                    IFolder folder4 = project.getFolder(path);
                    IPath orginalPath = entry.getOrginalPath();
                    if (orginalPath == null) {
                        if (!folder4.exists()) {
                            if (entry.getLinkTarget() == null) {
                                CoreUtility.createFolder(folder4, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            } else {
                                folder4.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                            }
                        }
                    } else {
                        if (projPath.isPrefixOf(orginalPath)) {
                            orginalPath = orginalPath.removeFirstSegments(projPath.segmentCount());
                        }
                        IFolder orginalFolder = project.getFolder(orginalPath);
                        if (entry.getLinkTarget() == null) {
                            if (!folder4.exists()) {
                                IPath parentPath = entry.getPath().removeLastSegments(1);
                                if (projPath.isPrefixOf(parentPath)) {
                                    parentPath = parentPath.removeFirstSegments(projPath.segmentCount());
                                }
                                if (parentPath.segmentCount() > 0) {
                                    IFolder parentFolder = project.getFolder(parentPath);
                                    if (!parentFolder.exists()) {
                                        CoreUtility.createFolder(parentFolder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                } else {
                                    monitor.worked(1);
                                }
                                orginalFolder.move(entry.getPath(), true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        } else if (!folder4.exists() || !entry.getLinkTarget().equals((Object)entry.getOrginalLinkTarget())) {
                            orginalFolder.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            folder4.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                } else {
                    if (entry.getEntryKind() == 5) {
                        String eeID;
                        IPath path = entry.getPath();
                        if (!path.equals((Object)entry.getOrginalPath()) && (eeID = JavaRuntime.getExecutionEnvironmentId((IPath)path)) != null) {
                            BuildPathSupport.setEEComplianceOptions(javaProject, eeID, newProjectCompliance);
                            newProjectCompliance = null;
                        }
                        if (newProjectCompliance != null) {
                            Map options = javaProject.getOptions(false);
                            JavaModelUtil.setComplianceOptions(options, newProjectCompliance);
                            JavaModelUtil.setDefaultClassfileOptions(options, newProjectCompliance);
                            javaProject.setOptions(options);
                        }
                    }
                    monitor.worked(3);
                }
                if (!monitor.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            javaProject.setRawClasspath(classpath, outputLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
        }
    }

    public static boolean hasClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            return true;
        }
        if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                if (BuildPathsBlock.hasClassfiles(members[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeOldClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            resource.delete(false, null);
        } else if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                BuildPathsBlock.removeOldClassfiles(members[i]);
                ++i;
            }
        }
    }

    public static IRemoveOldBinariesQuery getRemoveOldBinariesQuery(final Shell shell) {
        return new IRemoveOldBinariesQuery(){

            public boolean doQuery(final boolean removeFolder, final IPath oldOutputLocation) throws OperationCanceledException {
                final int[] res = new int[]{1};
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        Shell sh = shell != null ? shell : JavaPlugin.getActiveWorkbenchShell();
                        String title = NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_title;
                        String pathLabel = BasicElementLabels.getPathLabel(oldOutputLocation, false);
                        String message = removeFolder ? Messages.format(NewWizardMessages.BuildPathsBlock_RemoveOldOutputFolder_description, pathLabel) : Messages.format(NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_description, pathLabel);
                        MessageDialog dialog = new MessageDialog(sh, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        res[0] = dialog.open();
                    }
                });
                if (res[0] == 0) {
                    return true;
                }
                if (res[0] == 1) {
                    return false;
                }
                throw new OperationCanceledException();
            }
        };
    }

    private IContainer chooseContainer() {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        IProject[] allProjects = this.fWorkspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fCurrJProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSelection = null;
        if (this.fOutputLocationPath != null) {
            initSelection = this.fWorkspaceRoot.findMember(this.fOutputLocationPath);
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(NewWizardMessages.BuildPathsBlock_ChooseOutputFolderDialog_title);
        dialog.setValidator(validator);
        dialog.setMessage(NewWizardMessages.BuildPathsBlock_ChooseOutputFolderDialog_description);
        dialog.addFilter(filter);
        dialog.setInput(this.fWorkspaceRoot);
        dialog.setInitialSelection(initSelection);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dialog.open() == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List<?> selection;
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection, false);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private int getPageIndex(int entryKind) {
        switch (entryKind) {
            case 1: 
            case 4: 
            case 5: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    private CPListElement findElement(IClasspathEntry entry) {
        CPListElement prefixMatch = null;
        int entryKind = entry.getEntryKind();
        int i = 0;
        int len = this.fClassPathList.getSize();
        while (i < len) {
            CPListElement curr = (CPListElement)this.fClassPathList.getElement(i);
            if (curr.getEntryKind() == entryKind) {
                int n;
                IPath entryPath = entry.getPath();
                IPath currPath = curr.getPath();
                if (currPath.equals((Object)entryPath)) {
                    return curr;
                }
                if (prefixMatch == null && entryKind == 5 && (n = entryPath.segmentCount()) > 0) {
                    IPath genericContainerPath;
                    IPath iPath = genericContainerPath = n == 1 ? entryPath : entryPath.removeLastSegments(n - 1);
                    if (n > 1 && genericContainerPath.isPrefixOf(currPath)) {
                        prefixMatch = curr;
                    }
                }
            }
            ++i;
        }
        return prefixMatch;
    }

    public void setElementToReveal(IClasspathEntry entry, String attributeKey) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            CPListElement element = this.findElement(entry);
            if (element != null) {
                CPListElementAttribute attrib;
                Object elementToSelect = element;
                if (attributeKey != null && (attrib = element.findAttributeElement(attributeKey)) != null) {
                    elementToSelect = attrib;
                }
                BuildPathBasePage page = (BuildPathBasePage)this.fTabFolder.getItem(pageIndex).getData();
                ArrayList<Object> selection = new ArrayList<Object>(1);
                selection.add(elementToSelect);
                page.setSelection(selection, true);
            }
        }
    }

    public void addElement(IClasspathEntry entry) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            Object page = this.fTabFolder.getItem(pageIndex).getData();
            if (page instanceof LibrariesWorkbookPage) {
                CPListElement element = CPListElement.create(entry, true, this.fCurrJProject);
                ((LibrariesWorkbookPage)page).addElement(element);
            }
        }
    }

    public void dispose() {
        if (this.fSourceContainerPage instanceof NewSourceContainerWorkbookPage) {
            ((NewSourceContainerWorkbookPage)this.fSourceContainerPage).dispose();
            this.fSourceContainerPage = null;
        }
    }

    public boolean isOKStatus() {
        return this.findMostSevereStatus().isOK();
    }

    public void setFocus() {
        this.fSourceContainerPage.setFocus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter<CPListElement> {
        private BuildPathAdapter() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            BuildPathsBlock.this.buildPathChangeControlPressed(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            BuildPathsBlock.this.buildPathDialogFieldChanged(field);
        }

        @Override
        public void customButtonPressed(ListDialogField<CPListElement> field, int index) {
            BuildPathsBlock.this.buildPathCustomButtonPressed(field, index);
        }

        @Override
        public void doubleClicked(ListDialogField<CPListElement> field) {
        }

        @Override
        public void selectionChanged(ListDialogField<CPListElement> field) {
            BuildPathsBlock.this.updateTopButtonEnablement();
        }
    }

    public static interface IRemoveOldBinariesQuery {
        public boolean doQuery(boolean var1, IPath var2) throws OperationCanceledException;
    }
}

