/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPListElement {
    public static final String SOURCEATTACHMENT = "sourcepath";
    public static final String OUTPUT = "output";
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUSION = "inclusion";
    public static final String ACCESSRULES = "accessrules";
    public static final String COMBINE_ACCESSRULES = "combineaccessrules";
    public static final String JAVADOC = "javadoc_location";
    public static final String SOURCE_ATTACHMENT_ENCODING = "source_encoding";
    public static final String IGNORE_OPTIONAL_PROBLEMS = "ignore_optional_problems";
    public static final String NATIVE_LIB_PATH = JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY;
    private IJavaProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IPath fOrginalPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private IClasspathEntry fCachedEntry;
    private ArrayList<Object> fChildren;
    private IPath fLinkTarget;
    private IPath fOrginalLinkTarget;

    private CPListElement() {
    }

    public CPListElement(IJavaProject project, int entryKind, IPath path, IResource res) {
        this(null, project, entryKind, path, res);
    }

    public CPListElement(Object parent, IJavaProject project, int entryKind, IPath path, IResource res) {
        this(parent, project, entryKind, path, res, null);
    }

    public CPListElement(IJavaProject project, int entryKind) {
        this(null, project, entryKind, null, null);
    }

    public CPListElement(Object parent, IJavaProject project, int entryKind, IPath path, IResource res, IPath linkTarget) {
        this(parent, project, entryKind, path, false, res, linkTarget);
    }

    public CPListElement(Object parent, IJavaProject project, int entryKind, IPath path, boolean newElement, IResource res, IPath linkTarget) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fOrginalPath = newElement ? null : path;
        this.fLinkTarget = linkTarget;
        this.fOrginalLinkTarget = linkTarget;
        this.fChildren = new ArrayList();
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = parent;
        switch (entryKind) {
            case 3: {
                this.createAttributeElement(OUTPUT, null, true);
                this.createAttributeElement(INCLUSION, new Path[0], true);
                this.createAttributeElement(EXCLUSION, new Path[0], true);
                this.createAttributeElement(NATIVE_LIB_PATH, null, false);
                this.createAttributeElement(IGNORE_OPTIONAL_PROBLEMS, null, false);
                break;
            }
            case 1: 
            case 4: {
                this.createAttributeElement(SOURCEATTACHMENT, null, true);
                this.createAttributeElement(JAVADOC, null, false);
                this.createAttributeElement(SOURCE_ATTACHMENT_ENCODING, null, false);
                this.createAttributeElement(NATIVE_LIB_PATH, null, false);
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                break;
            }
            case 2: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                this.createAttributeElement(COMBINE_ACCESSRULES, Boolean.FALSE, true);
                this.createAttributeElement(NATIVE_LIB_PATH, null, false);
                break;
            }
            case 5: {
                this.createAttributeElement(ACCESSRULES, new IAccessRule[0], true);
                try {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)this.fPath, (IJavaProject)this.fProject);
                    if (container != null) {
                        IClasspathEntry[] entries = container.getClasspathEntries();
                        if (entries != null) {
                            int i = 0;
                            while (i < entries.length) {
                                IClasspathEntry entry = entries[i];
                                if (entry != null) {
                                    CPListElement curr = CPListElement.createFromExisting(this, entry, this.fProject);
                                    this.fChildren.add(curr);
                                } else {
                                    JavaPlugin.logErrorMessage("Null entry in container '" + this.fPath + "'");
                                }
                                ++i;
                            }
                        } else {
                            JavaPlugin.logErrorMessage("container returns null as entries: '" + this.fPath + "'");
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                this.createAttributeElement(NATIVE_LIB_PATH, null, false);
            }
        }
    }

    public IClasspathEntry getClasspathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newClasspathEntry();
        }
        return this.fCachedEntry;
    }

    private IClasspathAttribute[] getClasspathAttributes() {
        ArrayList<IClasspathAttribute> res = new ArrayList<IClasspathAttribute>();
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && !(elem = (CPListElementAttribute)curr).isBuiltIn() && elem.getValue() != null) {
                res.add(elem.getClasspathAttribute());
            }
            ++i;
        }
        return res.toArray(new IClasspathAttribute[res.size()]);
    }

    private IClasspathEntry newClasspathEntry() {
        IClasspathAttribute[] extraAttributes = this.getClasspathAttributes();
        switch (this.fEntryKind) {
            case 3: {
                IPath[] inclusionPattern = (IPath[])this.getAttribute(INCLUSION);
                IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
                IPath outputLocation = (IPath)this.getAttribute(OUTPUT);
                return JavaCore.newSourceEntry((IPath)this.fPath, (IPath[])inclusionPattern, (IPath[])exclusionPattern, (IPath)outputLocation, (IClasspathAttribute[])extraAttributes);
            }
            case 1: {
                IPath attach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newLibraryEntry((IPath)this.fPath, (IPath)attach, null, (IAccessRule[])accesRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 2: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                boolean combineAccessRules = (Boolean)this.getAttribute(COMBINE_ACCESSRULES);
                return JavaCore.newProjectEntry((IPath)this.fPath, (IAccessRule[])accesRules, (boolean)combineAccessRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 5: {
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newContainerEntry((IPath)this.fPath, (IAccessRule[])accesRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 4: {
                IPath varAttach = (IPath)this.getAttribute(SOURCEATTACHMENT);
                IAccessRule[] accesRules = (IAccessRule[])this.getAttribute(ACCESSRULES);
                return JavaCore.newVariableEntry((IPath)this.fPath, (IPath)varAttach, null, (IAccessRule[])accesRules, (IClasspathAttribute[])extraAttributes, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPListElementAttribute setAttribute(String key, Object value) {
        CPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        if (key.equals(EXCLUSION) || key.equals(INCLUSION)) {
            Assert.isTrue((value != null || this.fEntryKind != 3 ? 1 : 0) != 0);
        }
        if (key.equals(ACCESSRULES)) {
            Assert.isTrue((value != null || this.fEntryKind == 3 ? 1 : 0) != 0);
        }
        if (key.equals(COMBINE_ACCESSRULES)) {
            Assert.isTrue((boolean)(value instanceof Boolean));
        }
        attribute.setValue(value);
        return attribute;
    }

    public boolean addToExclusions(IPath path) {
        String key = EXCLUSION;
        return this.addFilter(path, key);
    }

    public boolean addToInclusion(IPath path) {
        String key = INCLUSION;
        return this.addFilter(path, key);
    }

    public boolean removeFromExclusions(IPath path) {
        String key = EXCLUSION;
        return this.removeFilter(path, key);
    }

    public boolean removeFromInclusion(IPath path) {
        String key = INCLUSION;
        return this.removeFilter(path, key);
    }

    private boolean addFilter(IPath path, String key) {
        IPath[] filters = (IPath[])this.getAttribute(key);
        if (filters == null) {
            return false;
        }
        if (!JavaModelUtil.isExcludedPath(path, filters)) {
            IPath toAdd = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
            IPath[] newFilters = new IPath[filters.length + 1];
            System.arraycopy(filters, 0, newFilters, 0, filters.length);
            newFilters[filters.length] = toAdd;
            this.setAttribute(key, newFilters);
            return true;
        }
        return false;
    }

    private boolean removeFilter(IPath path, String key) {
        IPath[] filters = (IPath[])this.getAttribute(key);
        if (filters == null) {
            return false;
        }
        IPath toRemove = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
        if (JavaModelUtil.isExcludedPath(toRemove, filters)) {
            ArrayList<IPath> l = new ArrayList<IPath>(Arrays.asList(filters));
            l.remove(toRemove);
            IPath[] newFilters = l.toArray(new IPath[l.size()]);
            this.setAttribute(key, newFilters);
            return true;
        }
        return false;
    }

    public CPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && key.equals((elem = (CPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        CPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    public CPListElementAttribute[] getAllAttributes() {
        ArrayList<Object> res = new ArrayList<Object>();
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new CPListElementAttribute[res.size()]);
    }

    private void createAttributeElement(String key, Object value, boolean builtIn) {
        this.fChildren.add(new CPListElementAttribute(this, key, value, builtIn));
    }

    private static boolean isFiltered(Object entry, String[] filteredKeys) {
        if (entry instanceof CPListElementAttribute) {
            CPListElementAttribute curr = (CPListElementAttribute)entry;
            String key = curr.getKey();
            int i = 0;
            while (i < filteredKeys.length) {
                if (key.equals(filteredKeys[i])) {
                    return true;
                }
                ++i;
            }
            if (curr.isNotSupported()) {
                return true;
            }
            if (!(curr.isBuiltIn() || key.equals(JAVADOC) || key.equals(NATIVE_LIB_PATH) || key.equals(IGNORE_OPTIONAL_PROBLEMS))) {
                return !JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors().containsKey(key);
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] filteredKeys) {
        int nChildren = this.fChildren.size();
        ArrayList<Object> res = new ArrayList<Object>(nChildren);
        int i = 0;
        while (i < nChildren) {
            Object curr = this.fChildren.get(i);
            if (!CPListElement.isFiltered(curr, filteredKeys)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray();
    }

    public Object[] getChildren(boolean hideOutputFolder) {
        if (hideOutputFolder && this.fEntryKind == 3) {
            return this.getFilteredChildren(new String[]{OUTPUT});
        }
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[]{COMBINE_ACCESSRULES});
        }
        return this.getFilteredChildren(new String[0]);
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    void setParentContainer(CPUserLibraryElement parent) {
        this.fParentContainer = parent;
    }

    protected void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    private IStatus evaluateContainerChildStatus(CPListElementAttribute attrib) {
        if (this.fProject != null) {
            ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)this.fPath.segment(0));
            if (initializer != null && initializer.canUpdateClasspathContainer(this.fPath, this.fProject)) {
                if (attrib.isBuiltIn()) {
                    if (SOURCEATTACHMENT.equals(attrib.getKey())) {
                        return initializer.getSourceAttachmentStatus(this.fPath, this.fProject);
                    }
                    if (ACCESSRULES.equals(attrib.getKey())) {
                        return initializer.getAccessRulesStatus(this.fPath, this.fProject);
                    }
                } else {
                    return initializer.getAttributeStatus(this.fPath, this.fProject, attrib.getKey());
                }
            }
            return new Status(4, "org.eclipse.jdt.ui", 2, "", null);
        }
        return null;
    }

    public IStatus getContainerChildStatus(CPListElementAttribute attrib) {
        if (this.fParentContainer instanceof CPListElement) {
            CPListElement parent = (CPListElement)this.fParentContainer;
            if (parent.getEntryKind() == 5) {
                return parent.evaluateContainerChildStatus(attrib);
            }
            return ((CPListElement)this.fParentContainer).getContainerChildStatus(attrib);
        }
        return null;
    }

    public boolean isInContainer(String containerName) {
        if (this.fParentContainer instanceof CPListElement) {
            CPListElement elem = (CPListElement)this.fParentContainer;
            return new Path(containerName).isPrefixOf(elem.getPath());
        }
        return false;
    }

    public boolean isDeprecated() {
        if (this.fEntryKind != 4) {
            return false;
        }
        if (this.fPath.segmentCount() > 0) {
            return JavaCore.getClasspathVariableDeprecationMessage((String)this.fPath.segment(0)) != null;
        }
        return false;
    }

    public String getDeprecationMessage() {
        if (this.fEntryKind != 4) {
            return null;
        }
        if (this.fPath.segmentCount() > 0) {
            String varName = this.fPath.segment(0);
            return BuildPathSupport.getDeprecationMessage(varName);
        }
        return null;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            CPListElement elem = (CPListElement)other;
            return this.getClasspathEntry().equals(elem.getClasspathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public String toString() {
        return this.getClasspathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public boolean hasMissingChildren() {
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElement && ((CPListElement)curr).isMissing()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public static CPListElement createFromExisting(IClasspathEntry curr, IJavaProject project) {
        return CPListElement.create(curr, false, project);
    }

    public static CPListElement createFromExisting(Object parent, IClasspathEntry curr, IJavaProject project) {
        return CPListElement.create(parent, curr, false, project);
    }

    public static CPListElement create(IClasspathEntry curr, boolean newElement, IJavaProject project) {
        return CPListElement.create(null, curr, newElement, project);
    }

    public static CPListElement create(Object parent, IClasspathEntry curr, boolean newElement, IJavaProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        IPath linkTarget = null;
        switch (curr.getEntryKind()) {
            case 5: {
                try {
                    isMissing = project != null && JavaCore.getClasspathContainer((IPath)path, (IJavaProject)project) == null;
                }
                catch (JavaModelException e) {
                    isMissing = true;
                }
                break;
            }
            case 4: {
                IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)path);
                isMissing = root.findMember(resolvedPath) == null && !resolvedPath.toFile().exists();
                break;
            }
            case 1: {
                res = root.findMember(path);
                if (res == null) {
                    IPackageFragmentRoot[] roots;
                    if (!ArchiveFileFilter.isArchivePath(path, true) && root.getWorkspace().validatePath(path.toString(), 2).isOK() && root.getProject(path.segment(0)).exists()) {
                        res = root.getFolder(path);
                    }
                    IPath rawPath = path;
                    if (project != null && (roots = project.findPackageFragmentRoots(curr)).length == 1) {
                        rawPath = roots[0].getPath();
                    }
                    isMissing = !rawPath.toFile().exists();
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 3: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null) {
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    isMissing = true;
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        CPListElement elem = new CPListElement(parent, project, curr.getEntryKind(), path, newElement, res, linkTarget);
        elem.setExported(curr.isExported());
        elem.setAttribute(SOURCEATTACHMENT, curr.getSourceAttachmentPath());
        elem.setAttribute(OUTPUT, curr.getOutputLocation());
        elem.setAttribute(EXCLUSION, curr.getExclusionPatterns());
        elem.setAttribute(INCLUSION, curr.getInclusionPatterns());
        elem.setAttribute(ACCESSRULES, curr.getAccessRules());
        elem.setAttribute(COMBINE_ACCESSRULES, new Boolean(curr.combineAccessRules()));
        IClasspathAttribute[] extraAttributes = curr.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            IClasspathAttribute attrib = extraAttributes[i];
            CPListElementAttribute attribElem = elem.findAttributeElement(attrib.getName());
            if (attribElem == null) {
                elem.createAttributeElement(attrib.getName(), attrib.getValue(), false);
            } else {
                attribElem.setValue(attrib.getValue());
            }
            ++i;
        }
        elem.setIsMissing(isMissing);
        return elem;
    }

    public static StringBuffer appendEncodePath(IPath path, StringBuffer buf) {
        if (path != null) {
            String str = path.toString();
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedString(String str, StringBuffer buf) {
        if (str != null) {
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedFilter(IPath[] filters, StringBuffer buf) {
        if (filters != null) {
            buf.append('[').append(filters.length).append(']');
            int i = 0;
            while (i < filters.length) {
                CPListElement.appendEncodePath(filters[i], buf).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedAccessRules(IAccessRule[] rules, StringBuffer buf) {
        if (rules != null) {
            buf.append('[').append(rules.length).append(']');
            int i = 0;
            while (i < rules.length) {
                CPListElement.appendEncodePath(rules[i].getPattern(), buf).append(';');
                buf.append(rules[i].getKind()).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public StringBuffer appendEncodedSettings(StringBuffer buf) {
        buf.append(this.fEntryKind).append(';');
        if (this.getLinkTarget() == null) {
            CPListElement.appendEncodePath(this.fPath, buf).append(';');
        } else {
            CPListElement.appendEncodePath(this.fPath, buf).append('-').append('>');
            CPListElement.appendEncodePath(this.getLinkTarget(), buf).append(';');
        }
        buf.append((Object)this.fIsExported).append(';');
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute) {
                CPListElementAttribute elem = (CPListElementAttribute)curr;
                if (elem.isBuiltIn()) {
                    String key = elem.getKey();
                    if (OUTPUT.equals(key) || SOURCEATTACHMENT.equals(key)) {
                        CPListElement.appendEncodePath((IPath)elem.getValue(), buf).append(';');
                    } else if (EXCLUSION.equals(key) || INCLUSION.equals(key)) {
                        CPListElement.appendEncodedFilter((IPath[])elem.getValue(), buf).append(';');
                    } else if (ACCESSRULES.equals(key)) {
                        CPListElement.appendEncodedAccessRules((IAccessRule[])elem.getValue(), buf).append(';');
                    } else if (COMBINE_ACCESSRULES.equals(key)) {
                        buf.append((Boolean)elem.getValue()).append(';');
                    }
                } else {
                    CPListElement.appendEncodedString((String)elem.getValue(), buf);
                }
            }
            ++i;
        }
        return buf;
    }

    public IPath getLinkTarget() {
        return this.fLinkTarget;
    }

    public void setPath(IPath path) {
        this.fCachedEntry = null;
        this.fPath = path;
    }

    public void setLinkTarget(IPath linkTarget) {
        this.fCachedEntry = null;
        this.fLinkTarget = linkTarget;
    }

    public static void insert(CPListElement element, List<CPListElement> cpList) {
        int length = cpList.size();
        CPListElement[] elements = cpList.toArray(new CPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getEntryKind() != element.getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getEntryKind() == element.getEntryKind()) {
                ++i;
            }
            cpList.add(i, element);
            return;
        }
        switch (element.getEntryKind()) {
            case 3: {
                cpList.add(0, element);
                break;
            }
            default: {
                cpList.add(element);
            }
        }
    }

    public static IClasspathEntry[] convertToClasspathEntries(List<CPListElement> cpList) {
        IClasspathEntry[] result = new IClasspathEntry[cpList.size()];
        int i = 0;
        for (CPListElement cur : cpList) {
            result[i] = cur.getClasspathEntry();
            ++i;
        }
        return result;
    }

    public static CPListElement[] createFromExisting(IJavaProject project) throws JavaModelException {
        IClasspathEntry[] rawClasspath = project.getRawClasspath();
        CPListElement[] result = new CPListElement[rawClasspath.length];
        int i = 0;
        while (i < rawClasspath.length) {
            result[i] = CPListElement.createFromExisting(rawClasspath[i], project);
            ++i;
        }
        return result;
    }

    public static boolean isProjectSourceFolder(CPListElement[] existing, IJavaProject project) {
        IPath projPath = project.getProject().getFullPath();
        int i = 0;
        while (i < existing.length) {
            IClasspathEntry curr = existing[i].getClasspathEntry();
            if (curr.getEntryKind() == 3 && projPath.equals((Object)curr.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPath getOrginalPath() {
        return this.fOrginalPath;
    }

    public IPath getOrginalLinkTarget() {
        return this.fOrginalLinkTarget;
    }

    public CPListElement copy() {
        CPListElement result = new CPListElement();
        result.fProject = this.fProject;
        result.fEntryKind = this.fEntryKind;
        result.fPath = this.fPath;
        result.fOrginalPath = this.fOrginalPath;
        result.fResource = this.fResource;
        result.fIsExported = this.fIsExported;
        result.fIsMissing = this.fIsMissing;
        result.fParentContainer = this.fParentContainer;
        result.fCachedEntry = null;
        result.fChildren = new ArrayList(this.fChildren.size());
        for (Object child : this.fChildren) {
            if (child instanceof CPListElement) {
                result.fChildren.add(((CPListElement)child).copy());
                continue;
            }
            result.fChildren.add(((CPListElementAttribute)child).copy());
        }
        result.fLinkTarget = this.fLinkTarget;
        result.fOrginalLinkTarget = this.fOrginalLinkTarget;
        return result;
    }

    public void setAttributesFromExisting(CPListElement existing) {
        Assert.isTrue((existing.getEntryKind() == this.getEntryKind() ? 1 : 0) != 0);
        CPListElementAttribute[] attributes = existing.getAllAttributes();
        int i = 0;
        while (i < attributes.length) {
            CPListElementAttribute curr = attributes[i];
            CPListElementAttribute elem = this.findAttributeElement(curr.getKey());
            if (elem == null) {
                this.createAttributeElement(curr.getKey(), curr.getValue(), false);
            } else {
                elem.setValue(curr.getValue());
            }
            ++i;
        }
    }
}

