/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathContainerWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class AddLibraryToBuildpathAction
extends BuildpathModifierAction {
    public AddLibraryToBuildpathAction(IWorkbenchSite site) {
        super(site, null, 14);
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_label);
        this.setImageDescriptor(JavaPluginImages.DESC_OBJS_LIBRARY);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddLibCP_tooltip);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath_library;
    }

    public void run() {
        IClasspathEntry[] classpath;
        final IJavaProject project = (IJavaProject)this.getSelectedElements().get(0);
        Shell shell = this.getShell();
        if (shell == null) {
            shell = JavaPlugin.getActiveWorkbenchShell();
        }
        try {
            classpath = project.getRawClasspath();
        }
        catch (JavaModelException e1) {
            this.showExceptionDialog((CoreException)((Object)e1), NewWizardMessages.AddLibraryToBuildpathAction_ErrorTitle);
            return;
        }
        ClasspathContainerWizard wizard = new ClasspathContainerWizard(null, project, classpath){

            public boolean performFinish() {
                if (super.performFinish()) {
                    IWorkspaceRunnable op = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                            try {
                                this.finishPage(monitor);
                            }
                            catch (InterruptedException e) {
                                throw new OperationCanceledException(e.getMessage());
                            }
                        }
                    };
                    try {
                        ISchedulingRule rule = null;
                        Job job = Job.getJobManager().currentJob();
                        if (job != null) {
                            rule = job.getRule();
                        }
                        WorkbenchRunnableAdapter runnable = null;
                        runnable = rule != null ? new WorkbenchRunnableAdapter(op, rule, true) : new WorkbenchRunnableAdapter(op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                        this.getContainer().run(false, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e) {
                        JavaPlugin.log(e);
                        return false;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    return true;
                }
                return false;
            }

            private void finishPage(IProgressMonitor pm) throws InterruptedException {
                IClasspathEntry[] selected = this.getNewEntries();
                if (selected != null) {
                    try {
                        try {
                            pm.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, 4);
                            ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
                            int i = 0;
                            while (i < selected.length) {
                                addedEntries.add(CPListElement.create(selected[i], true, project));
                                ++i;
                            }
                            pm.worked(1);
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            List<CPListElement> existingEntries = ClasspathModifier.getExistingEntries(project);
                            ClasspathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (pm.isCanceled()) {
                                throw new InterruptedException();
                            }
                            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                            BuildpathDelta delta = new BuildpathDelta(AddLibraryToBuildpathAction.this.getToolTipText());
                            delta.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
                            AddLibraryToBuildpathAction.this.informListeners(delta);
                            ArrayList<ClassPathContainer> result = new ArrayList<ClassPathContainer>(addedEntries.size());
                            int i2 = 0;
                            while (i2 < addedEntries.size()) {
                                result.add(new ClassPathContainer(project, selected[i2]));
                                ++i2;
                            }
                            AddLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                            pm.worked(1);
                        }
                        catch (CoreException e) {
                            AddLibraryToBuildpathAction.this.showExceptionDialog(e, NewWizardMessages.AddLibraryToBuildpathAction_ErrorTitle);
                            pm.done();
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            }
        };
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        dialog.open();
    }

    protected boolean canHandle(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaProject;
    }
}

