/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementImplementationHyperlink;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class OpenImplementationAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    protected OpenImplementationAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenImplementationAction_label);
        this.setDescription(ActionMessages.OpenImplementationAction_description);
        this.setToolTipText(ActionMessages.OpenImplementationAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_implementation_action");
    }

    public OpenImplementationAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor) && this.fEditor.getSelectionProvider().getSelection() instanceof ITextSelection);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        IJavaElement element = null;
        try {
            IJavaElement[] elements = SelectionConverter.codeResolveForked(this.fEditor, true);
            if (elements.length == 1) {
                element = elements[0];
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAction_error_message);
            return;
        }
        catch (InterruptedException e) {
            return;
        }
        if (element == null || !(element instanceof IMethod)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.OpenImplementationAction_not_applicable);
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        SelectionDispatchAction openAction = (SelectionDispatchAction)this.fEditor.getAction("OpenEditor");
        if (openAction == null) {
            return;
        }
        Region region = new Region(selection.getOffset(), 0);
        JavaElementImplementationHyperlink.openImplementations((IEditorPart)this.fEditor, (IRegion)region, (IMethod)element, openAction);
    }

    private String getDialogTitle() {
        return ActionMessages.OpenImplementationAction_error_title;
    }
}

