/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenProjectAction
extends SelectionDispatchAction
implements IResourceChangeListener {
    private int CLOSED_PROJECTS_SELECTED = 1;
    private int OTHER_ELEMENTS_SELECTED = 2;
    private OpenResourceAction fWorkbenchAction;

    public OpenProjectAction(IWorkbenchSite site) {
        super(site);
        this.fWorkbenchAction = new OpenResourceAction((IShellProvider)site);
        this.setText(this.fWorkbenchAction.getText());
        this.setToolTipText(this.fWorkbenchAction.getToolTipText());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_project_action");
        this.setEnabled(this.hasClosedProjectsInWorkspace());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0) {
                    this.setEnabled(this.hasClosedProjectsInWorkspace());
                    return;
                }
                ++i;
            }
        }
    }

    @Override
    public void selectionChanged(ISelection selection) {
    }

    @Override
    public void run(ISelection selection) {
        this.internalRun(null);
    }

    private int evaluateSelection(IStructuredSelection selection, List<Object> allClosedProjects) {
        Object[] array = selection.toArray();
        int selectionStatus = 0;
        int i = 0;
        while (i < array.length) {
            Object curr = array[i];
            if (OpenProjectAction.isClosedProject(curr)) {
                if (allClosedProjects != null) {
                    allClosedProjects.add(curr);
                }
                selectionStatus |= this.CLOSED_PROJECTS_SELECTED;
            } else {
                if (curr instanceof IWorkingSet) {
                    IAdaptable[] elements = ((IWorkingSet)curr).getElements();
                    int k = 0;
                    while (k < elements.length) {
                        IAdaptable elem = elements[k];
                        if (OpenProjectAction.isClosedProject(elem)) {
                            if (allClosedProjects != null) {
                                allClosedProjects.add(elem);
                            }
                            selectionStatus |= this.CLOSED_PROJECTS_SELECTED;
                        }
                        ++k;
                    }
                }
                selectionStatus |= this.OTHER_ELEMENTS_SELECTED;
            }
            ++i;
        }
        return selectionStatus;
    }

    private static boolean isClosedProject(Object element) {
        if (element instanceof IJavaProject) {
            IProject project = ((IJavaProject)element).getProject();
            return !project.isOpen();
        }
        return element instanceof IProject && !((IProject)element).isOpen();
    }

    @Override
    public void run(IStructuredSelection selection) {
        ArrayList<Object> allClosedProjects = new ArrayList<Object>();
        int selectionStatus = this.evaluateSelection(selection, allClosedProjects);
        if ((selectionStatus & this.CLOSED_PROJECTS_SELECTED) != 0) {
            this.fWorkbenchAction.selectionChanged((IStructuredSelection)new StructuredSelection(allClosedProjects));
            this.fWorkbenchAction.run();
        } else {
            this.internalRun(allClosedProjects);
        }
    }

    private void internalRun(List<?> initialSelection) {
        int result;
        ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), (Object)this.getClosedProjectsInWorkspace(), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new JavaElementLabelProvider(), ActionMessages.OpenProjectAction_dialog_message);
        dialog.setTitle(ActionMessages.OpenProjectAction_dialog_title);
        if (initialSelection != null && !initialSelection.isEmpty()) {
            dialog.setInitialElementSelections(initialSelection);
        }
        if ((result = dialog.open()) != 0) {
            return;
        }
        Object[] projects = dialog.getResult();
        IWorkspaceRunnable runnable = this.createRunnable(projects);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.OpenProjectAction_dialog_title, ActionMessages.OpenProjectAction_error_message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private IWorkspaceRunnable createRunnable(final Object[] projects) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", projects.length);
                MultiStatus errorStatus = null;
                int i = 0;
                while (i < projects.length) {
                    IProject project = (IProject)projects[i];
                    try {
                        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        if (errorStatus == null) {
                            errorStatus = new MultiStatus(JavaPlugin.getPluginId(), 4, ActionMessages.OpenProjectAction_error_message, null);
                        }
                        errorStatus.add(e.getStatus());
                    }
                    ++i;
                }
                monitor.done();
                if (errorStatus != null) {
                    throw new CoreException(errorStatus);
                }
            }
        };
    }

    private Object[] getClosedProjectsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>(5);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }

    private boolean hasClosedProjectsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].isOpen()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

