/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends SelectionDispatchAction {
    public RefreshAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.RefreshAction_label);
        this.setToolTipText(ActionMessages.RefreshAction_toolTip);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "refresh.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.refresh_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return true;
        }
        boolean okToRefresh = false;
        for (Object element : selection) {
            if (element instanceof IWorkingSet) {
                okToRefresh = true;
                continue;
            }
            if (element instanceof IPackageFragmentRoot) {
                okToRefresh = true;
                continue;
            }
            if (element instanceof PackageFragmentRootContainer) {
                okToRefresh = true;
                continue;
            }
            if (element instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                if (resource == null) {
                    return false;
                }
                okToRefresh |= resource.getType() == 4 && ((IProject)resource).isOpen();
                continue;
            }
            return false;
        }
        return okToRefresh;
    }

    public void run(final IStructuredSelection selection) {
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                RefreshAction.this.performRefresh(selection, monitor);
            }
        };
        new WorkbenchRunnableAdapter(operation).runAsUserJob(ActionMessages.RefreshAction_refresh_operation_label, null);
    }

    private void performRefresh(IStructuredSelection selection, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor.beginTask(ActionMessages.RefreshAction_progressMessage, 2);
        WrappedWorkbenchRefreshAction workbenchAction = new WrappedWorkbenchRefreshAction((IShellProvider)this.getSite());
        workbenchAction.selectionChanged(selection);
        workbenchAction.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.refreshJavaElements(selection, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private void refreshJavaElements(IStructuredSelection selection, IProgressMonitor monitor) throws JavaModelException {
        Object[] selectedElements = selection.toArray();
        ArrayList<Object> javaElements = new ArrayList<Object>();
        int i = 0;
        while (i < selectedElements.length) {
            Object curr = selectedElements[i];
            if (curr instanceof IPackageFragmentRoot) {
                javaElements.add((IPackageFragmentRoot)curr);
            } else if (curr instanceof PackageFragmentRootContainer) {
                javaElements.addAll(Arrays.asList(((PackageFragmentRootContainer)curr).getPackageFragmentRoots()));
            } else if (curr instanceof IWorkingSet) {
                IAdaptable[] members = ((IWorkingSet)curr).getElements();
                int k = 0;
                while (k < members.length) {
                    IJavaElement adapted = (IJavaElement)members[k].getAdapter(IJavaElement.class);
                    if (adapted instanceof IPackageFragmentRoot) {
                        javaElements.add(adapted);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (!javaElements.isEmpty()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            model.refreshExternalArchives(javaElements.toArray(new IJavaElement[javaElements.size()]), monitor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrappedWorkbenchRefreshAction
    extends org.eclipse.ui.actions.RefreshAction {
        public WrappedWorkbenchRefreshAction(IShellProvider provider) {
            super(provider);
        }

        protected List<IResource> getSelectedResources() {
            List selectedResources = super.getSelectedResources();
            if (!this.getStructuredSelection().isEmpty() && selectedResources.size() == 1 && selectedResources.get(0) instanceof IWorkspaceRoot) {
                selectedResources = Collections.emptyList();
            }
            ArrayList<IResource> allResources = new ArrayList<IResource>(selectedResources);
            this.addWorkingSetResources(allResources);
            return allResources;
        }

        private void addWorkingSetResources(List<IResource> selectedResources) {
            Object[] elements = this.getStructuredSelection().toArray();
            int i = 0;
            while (i < elements.length) {
                Object curr = elements[i];
                if (curr instanceof IWorkingSet) {
                    IAdaptable[] members = ((IWorkingSet)curr).getElements();
                    int k = 0;
                    while (k < members.length) {
                        IResource adapted = (IResource)members[k].getAdapter(IResource.class);
                        if (adapted != null) {
                            selectedResources.add(adapted);
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }

        public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
            try {
                IStatus[] errorStatus = new IStatus[]{Status.OK_STATUS};
                this.createOperation(errorStatus).run(monitor);
                if (errorStatus[0].matches(4)) {
                    throw new CoreException(errorStatus[0]);
                }
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof CoreException) {
                    throw (CoreException)targetException;
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", ActionMessages.RefreshAction_error_workbenchaction_message, targetException));
            }
            catch (InterruptedException e) {
                throw new OperationCanceledException();
            }
        }
    }
}

