/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;

class Util {
    Util() {
    }

    static boolean rangeIncludesNonWhitespaceOutsideRange(ISourceRange selection, ISourceRange nodes, IBuffer buffer) {
        if (!Util.covers(selection, nodes)) {
            return false;
        }
        if (!Util.isJustWhitespace(selection.getOffset(), nodes.getOffset(), buffer)) {
            return true;
        }
        return !Util.isJustWhitespaceOrComment(nodes.getOffset() + nodes.getLength(), selection.getOffset() + selection.getLength(), buffer);
    }

    private static boolean isJustWhitespace(int start, int end, IBuffer buffer) {
        if (start == end) {
            return true;
        }
        Assert.isTrue((start <= end ? 1 : 0) != 0);
        return buffer.getText(start, end - start).trim().length() == 0;
    }

    private static boolean isJustWhitespaceOrComment(int start, int end, IBuffer buffer) {
        if (start == end) {
            return true;
        }
        Assert.isTrue((start <= end ? 1 : 0) != 0);
        String trimmedText = buffer.getText(start, end - start).trim();
        if (trimmedText.length() == 0) {
            return true;
        }
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, null);
        scanner.setSource(trimmedText.toCharArray());
        try {
            return scanner.getNextToken() == 158;
        }
        catch (InvalidInputException e) {
            return false;
        }
    }

    public static int getEndExclusive(ISourceRange sourceRange) {
        return sourceRange.getOffset() + sourceRange.getLength();
    }

    public static int getEndInclusive(ISourceRange sourceRange) {
        return Util.getEndExclusive(sourceRange) - 1;
    }

    public static boolean covers(ISourceRange sourceRange, ASTNode astNode) {
        return Util.covers(sourceRange, SourceRangeFactory.create(astNode));
    }

    public static boolean covers(ISourceRange thisRange, ISourceRange otherRange) {
        return thisRange.getOffset() <= otherRange.getOffset() && Util.getEndInclusive(thisRange) >= Util.getEndInclusive(otherRange);
    }
}

