/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ConvertLocalVariableDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.NameCollector;
import org.eclipse.jdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.jdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class PromoteTempToFieldRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_STATIC = "static";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_INITIALIZE = "initialize";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    public static final int INITIALIZE_IN_FIELD = 0;
    public static final int INITIALIZE_IN_METHOD = 1;
    public static final int INITIALIZE_IN_CONSTRUCTOR = 2;
    private static final String LINKED_NAME = "name";
    private String fFieldName;
    private int fVisibility;
    private boolean fDeclareStatic;
    private boolean fDeclareFinal;
    private int fInitializeIn;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private boolean fInitializerUsesLocalTypes;
    private boolean fTempTypeUsesClassTypeVariables;
    private boolean fSelfInitializing = false;
    private LinkedProposalModel fLinkedProposalModel;

    public PromoteTempToFieldRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fCu = unit;
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fLinkedProposalModel = null;
    }

    public PromoteTempToFieldRefactoring(VariableDeclaration declaration) {
        Assert.isTrue((declaration != null ? 1 : 0) != 0);
        this.fTempDeclarationNode = declaration;
        IVariableBinding resolveBinding = declaration.resolveBinding();
        Assert.isTrue((resolveBinding != null && !resolveBinding.isParameter() && !resolveBinding.isField() ? 1 : 0) != 0);
        ASTNode root = declaration.getRoot();
        Assert.isTrue((boolean)(root instanceof CompilationUnit));
        this.fCompilationUnitNode = (CompilationUnit)root;
        IJavaElement input = this.fCompilationUnitNode.getJavaElement();
        Assert.isTrue((boolean)(input instanceof ICompilationUnit));
        this.fCu = (ICompilationUnit)input;
        this.fSelectionStart = declaration.getStartPosition();
        this.fSelectionLength = declaration.getLength();
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fLinkedProposalModel = null;
    }

    public PromoteTempToFieldRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public String getName() {
        return RefactoringCoreMessages.PromoteTempToFieldRefactoring_name;
    }

    public int[] getAvailableVisibilities() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public int getInitializeIn() {
        return this.fInitializeIn;
    }

    public void setVisibility(int accessModifier) {
        Assert.isTrue((accessModifier == 2 || accessModifier == 0 || accessModifier == 4 || accessModifier == 1 ? 1 : 0) != 0);
        this.fVisibility = accessModifier;
    }

    public void setDeclareFinal(boolean declareFinal) {
        this.fDeclareFinal = declareFinal;
    }

    public void setDeclareStatic(boolean declareStatic) {
        this.fDeclareStatic = declareStatic;
    }

    public void setFieldName(String fieldName) {
        Assert.isNotNull((Object)fieldName);
        this.fFieldName = fieldName;
    }

    public void setInitializeIn(int initializeIn) {
        Assert.isTrue((initializeIn == 2 || initializeIn == 0 || initializeIn == 1 ? 1 : 0) != 0);
        this.fInitializeIn = initializeIn;
    }

    public boolean canEnableSettingStatic() {
        return this.fInitializeIn != 2 && !this.isTempDeclaredInStaticMethod() && !this.fTempTypeUsesClassTypeVariables;
    }

    public boolean canEnableSettingFinal() {
        if (this.fInitializeIn == 2) {
            return this.canEnableSettingDeclareInConstructors() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.fInitializeIn == 0) {
            return this.canEnableSettingDeclareInFieldDeclaration() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.getMethodDeclaration().isConstructor()) {
            return !this.tempHasAssignmentsOtherThanInitialization();
        }
        return false;
    }

    private boolean tempHasAssignmentsOtherThanInitialization() {
        TempAssignmentFinder assignmentFinder = new TempAssignmentFinder(this.fTempDeclarationNode);
        this.fCompilationUnitNode.accept((ASTVisitor)assignmentFinder);
        return assignmentFinder.hasAssignments();
    }

    public boolean canEnableSettingDeclareInConstructors() {
        return !this.fDeclareStatic && !this.fInitializerUsesLocalTypes && !this.getMethodDeclaration().isConstructor() && !this.isDeclaredInAnonymousClass() && !this.isTempDeclaredInStaticMethod() && this.tempHasInitializer();
    }

    public boolean canEnableSettingDeclareInMethod() {
        return !this.fDeclareFinal && this.tempHasInitializer();
    }

    private boolean tempHasInitializer() {
        return this.getTempInitializer() != null;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return !this.fInitializerUsesLocalTypes && this.tempHasInitializer();
    }

    private Expression getTempInitializer() {
        return this.fTempDeclarationNode.getInitializer();
    }

    private boolean isTempDeclaredInStaticMethod() {
        return Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
    }

    private MethodDeclaration getMethodDeclaration() {
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, MethodDeclaration.class);
    }

    private boolean isDeclaredInAnonymousClass() {
        return ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, AnonymousClassDeclaration.class) != null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
        if (result.hasFatalError()) {
            return result;
        }
        this.initAST(pm);
        if (this.fTempDeclarationNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration);
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, MethodDeclaration.class)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_only_declared_in_methods);
        }
        if (this.isMethodParameter()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_method_parameters);
        }
        if (this.isTempAnExceptionInCatchBlock()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_exceptions);
        }
        result.merge(this.checkTempTypeForLocalTypeUsage());
        if (result.hasFatalError()) {
            return result;
        }
        this.checkTempInitializerForLocalTypeUsage();
        if (!this.fSelfInitializing) {
            this.initializeDefaults();
        }
        return result;
    }

    private void initializeDefaults() {
        this.fVisibility = 2;
        this.fDeclareStatic = Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
        this.fDeclareFinal = false;
        if (this.canEnableSettingDeclareInMethod()) {
            this.fInitializeIn = 1;
        } else if (this.canEnableSettingDeclareInFieldDeclaration()) {
            this.fInitializeIn = 0;
        } else if (this.canEnableSettingDeclareInConstructors()) {
            this.fInitializeIn = 2;
        }
    }

    public String[] guessFieldNames() {
        String rawTempName = StubUtility.getBaseName(this.fTempDeclarationNode.resolveBinding(), this.fCu.getJavaProject());
        String[] excludedNames = this.getNamesOfFieldsInDeclaringType();
        int dim = ASTNodes.getDimensions(this.fTempDeclarationNode);
        return StubUtility.getFieldNameSuggestions(this.fCu.getJavaProject(), rawTempName, dim, this.getModifiers(), excludedNames);
    }

    private String getInitialFieldName() {
        String[] suggestedNames = this.guessFieldNames();
        if (suggestedNames.length > 0) {
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup nameGroup = this.fLinkedProposalModel.getPositionGroup(LINKED_NAME, true);
                int i = 0;
                while (i < suggestedNames.length) {
                    nameGroup.addProposal(suggestedNames[i], null, suggestedNames.length - i);
                    ++i;
                }
            }
            return suggestedNames[0];
        }
        return this.fTempDeclarationNode.getName().getIdentifier();
    }

    private String[] getNamesOfFieldsInDeclaringType() {
        AbstractTypeDeclaration type = this.getEnclosingType();
        if (type instanceof TypeDeclaration) {
            FieldDeclaration[] fields = ((TypeDeclaration)type).getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            int i = 0;
            while (i < fields.length) {
                for (VariableDeclarationFragment field : fields[i].fragments()) {
                    result.add(field.getName().getIdentifier());
                }
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    private void checkTempInitializerForLocalTypeUsage() {
        Expression initializer = this.fTempDeclarationNode.getInitializer();
        if (initializer == null) {
            return;
        }
        IMethodBinding declaringMethodBinding = this.getMethodDeclaration().resolveBinding();
        ITypeBinding[] methodTypeParameters = declaringMethodBinding == null ? new ITypeBinding[]{} : declaringMethodBinding.getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer localTypeAnalyer = new LocalTypeAndVariableUsageAnalyzer(methodTypeParameters);
        initializer.accept((ASTVisitor)localTypeAnalyer);
        this.fInitializerUsesLocalTypes = !localTypeAnalyer.getUsageOfEnclosingNodes().isEmpty();
    }

    private RefactoringStatus checkTempTypeForLocalTypeUsage() {
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        if (vds == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        Type type = vds.getType();
        ITypeBinding binding = type.resolveBinding();
        if (binding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        IMethodBinding declaringMethodBinding = this.getMethodDeclaration().resolveBinding();
        ITypeBinding[] methodTypeParameters = declaringMethodBinding == null ? new ITypeBinding[]{} : declaringMethodBinding.getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer analyzer = new LocalTypeAndVariableUsageAnalyzer(methodTypeParameters);
        type.accept((ASTVisitor)analyzer);
        boolean usesLocalTypes = !analyzer.getUsageOfEnclosingNodes().isEmpty();
        this.fTempTypeUsesClassTypeVariables = analyzer.getClassTypeVariablesUsed();
        if (usesLocalTypes) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_uses_type_declared_locally);
        }
        return null;
    }

    private VariableDeclarationStatement getTempDeclarationStatement() {
        return (VariableDeclarationStatement)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, VariableDeclarationStatement.class);
    }

    private boolean isTempAnExceptionInCatchBlock() {
        return this.fTempDeclarationNode.getParent() instanceof CatchClause;
    }

    private boolean isMethodParameter() {
        return this.fTempDeclarationNode.getParent() instanceof MethodDeclaration;
    }

    private void initAST(IProgressMonitor pm) {
        if (this.fCompilationUnitNode == null) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, pm);
            this.fTempDeclarationNode = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
        }
    }

    public RefactoringStatus validateInput() {
        return Checks.checkFieldName(this.fFieldName, (IJavaElement)this.fCu);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        try {
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkClashesWithExistingFields());
            if (this.fInitializeIn == 2) {
                result.merge(this.checkClashesInConstructors());
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkClashesInConstructors() {
        Assert.isTrue((this.fInitializeIn == 2 ? 1 : 0) != 0);
        Assert.isTrue((!this.isDeclaredInAnonymousClass() ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        if (declaration instanceof TypeDeclaration) {
            MethodDeclaration[] methods = ((TypeDeclaration)declaration).getMethods();
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration method = methods[i];
                if (method.isConstructor()) {
                    NameCollector nameCollector = new NameCollector((ASTNode)method){

                        protected boolean visitNode(ASTNode node) {
                            return true;
                        }
                    };
                    method.accept((ASTVisitor)nameCollector);
                    List<String> names = nameCollector.getNames();
                    if (names.contains(this.fFieldName)) {
                        Object[] keys = new String[]{BasicElementLabels.getJavaElementName(this.fFieldName), BindingLabelProvider.getBindingLabel((IBinding)method.resolveBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED)};
                        String msg = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict, keys);
                        return RefactoringStatus.createFatalErrorStatus((String)msg);
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private RefactoringStatus checkClashesWithExistingFields() {
        FieldDeclaration[] existingFields = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        int i = 0;
        while (i < existingFields.length) {
            FieldDeclaration declaration = existingFields[i];
            VariableDeclarationFragment[] fragments = declaration.fragments().toArray(new VariableDeclarationFragment[declaration.fragments().size()]);
            int j = 0;
            while (j < fragments.length) {
                VariableDeclarationFragment fragment = fragments[j];
                if (this.fFieldName.equals(fragment.getName().getIdentifier())) {
                    RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)this.fCu, (ASTNode)fragment);
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict_with_field, (RefactoringStatusContext)context);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private ChildListPropertyDescriptor getBodyDeclarationListOfDeclaringType() {
        ASTNode methodParent = this.getMethodDeclaration().getParent();
        if (methodParent instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)methodParent).getBodyDeclarationsProperty();
        }
        if (methodParent instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private FieldDeclaration[] getFieldDeclarations(ChildListPropertyDescriptor descriptor) {
        List bodyDeclarations = (List)this.getMethodDeclaration().getParent().getStructuralProperty((StructuralPropertyDescriptor)descriptor);
        ArrayList<FieldDeclaration> fields = new ArrayList<FieldDeclaration>(1);
        for (Object each : bodyDeclarations) {
            if (!(each instanceof FieldDeclaration)) continue;
            fields.add((FieldDeclaration)each);
        }
        return fields.toArray(new FieldDeclaration[fields.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            if (this.fFieldName.length() == 0) {
                this.fFieldName = this.getInitialFieldName();
            }
            ASTRewrite rewrite = ASTRewrite.create((AST)this.fCompilationUnitNode.getAST());
            if (this.fInitializeIn == 1 && this.tempHasInitializer()) {
                this.addLocalDeclarationSplit(rewrite);
            } else {
                this.addLocalDeclarationRemoval(rewrite);
            }
            if (this.fInitializeIn == 2) {
                this.addInitializersToConstructors(rewrite);
            }
            this.addTempRenames(rewrite);
            this.addFieldDeclaration(rewrite);
            CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.PromoteTempToFieldRefactoring_name, this.fCu);
            result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.getRefactoringDescriptor()));
            TextEdit resultingEdits = rewrite.rewriteAST();
            TextChangeCompatibility.addTextEdit((TextChange)result, RefactoringCoreMessages.PromoteTempToFieldRefactoring_editName, resultingEdits);
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void addTempRenames(ASTRewrite rewrite) {
        boolean noNameChange = this.fFieldName.equals(this.fTempDeclarationNode.getName().getIdentifier());
        if (this.fLinkedProposalModel == null && noNameChange) {
            return;
        }
        TempOccurrenceAnalyzer analyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, false);
        analyzer.perform();
        SimpleName[] tempRefs = analyzer.getReferenceNodes();
        int j = 0;
        while (j < tempRefs.length) {
            SimpleName occurence = tempRefs[j];
            if (noNameChange) {
                this.addLinkedName(rewrite, occurence, false);
            } else {
                SimpleName newName = this.getAST().newSimpleName(this.fFieldName);
                this.addLinkedName(rewrite, newName, false);
                rewrite.replace((ASTNode)occurence, (ASTNode)newName, null);
            }
            ++j;
        }
    }

    private void addInitializersToConstructors(ASTRewrite rewrite) throws CoreException {
        Assert.isTrue((!this.isDeclaredInAnonymousClass() ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        MethodDeclaration[] constructors = PromoteTempToFieldRefactoring.getAllConstructors(declaration);
        if (constructors.length == 0) {
            AST ast = rewrite.getAST();
            MethodDeclaration newConstructor = ast.newMethodDeclaration();
            newConstructor.setConstructor(true);
            newConstructor.modifiers().addAll(ast.newModifiers(declaration.getModifiers() & 7));
            newConstructor.setName(ast.newSimpleName(declaration.getName().getIdentifier()));
            newConstructor.setJavadoc(this.getNewConstructorComment(rewrite));
            newConstructor.setBody(ast.newBlock());
            this.addFieldInitializationToConstructor(rewrite, newConstructor);
            int insertionIndex = this.computeInsertIndexForNewConstructor(declaration);
            rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertAt((ASTNode)newConstructor, insertionIndex, null);
        } else {
            int index = 0;
            while (index < constructors.length) {
                if (PromoteTempToFieldRefactoring.shouldInsertTempInitialization(constructors[index])) {
                    this.addFieldInitializationToConstructor(rewrite, constructors[index]);
                }
                ++index;
            }
        }
    }

    private String getEnclosingTypeName() {
        return this.getEnclosingType().getName().getIdentifier();
    }

    private AbstractTypeDeclaration getEnclosingType() {
        return (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.getTempDeclarationStatement(), AbstractTypeDeclaration.class);
    }

    private Javadoc getNewConstructorComment(ASTRewrite rewrite) throws CoreException {
        String comment;
        if (StubUtility.doAddComments(this.fCu.getJavaProject()) && (comment = CodeGeneration.getMethodComment(this.fCu, this.getEnclosingTypeName(), this.getEnclosingTypeName(), new String[0], new String[0], null, null, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu))) != null && comment.length() > 0) {
            return (Javadoc)rewrite.createStringPlaceholder(comment, 29);
        }
        return null;
    }

    private int computeInsertIndexForNewConstructor(AbstractTypeDeclaration declaration) {
        List declarations = declaration.bodyDeclarations();
        if (declarations.isEmpty()) {
            return 0;
        }
        int index = this.findFirstMethodIndex(declaration);
        if (index == -1) {
            return declarations.size();
        }
        return index;
    }

    private int findFirstMethodIndex(AbstractTypeDeclaration typeDeclaration) {
        int i = 0;
        int n = typeDeclaration.bodyDeclarations().size();
        while (i < n) {
            if (typeDeclaration.bodyDeclarations().get(i) instanceof MethodDeclaration) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void addFieldInitializationToConstructor(ASTRewrite rewrite, MethodDeclaration constructor) {
        if (constructor.getBody() == null) {
            constructor.setBody(this.getAST().newBlock());
        }
        Statement newStatement = this.createNewAssignmentStatement(rewrite);
        rewrite.getListRewrite((ASTNode)constructor.getBody(), Block.STATEMENTS_PROPERTY).insertLast((ASTNode)newStatement, null);
    }

    private static boolean shouldInsertTempInitialization(MethodDeclaration constructor) {
        Assert.isTrue((boolean)constructor.isConstructor());
        if (constructor.getBody() == null) {
            return false;
        }
        List statements = constructor.getBody().statements();
        if (statements == null) {
            return false;
        }
        return statements.size() <= 0 || !(statements.get(0) instanceof ConstructorInvocation);
    }

    private static MethodDeclaration[] getAllConstructors(AbstractTypeDeclaration typeDeclaration) {
        if (typeDeclaration instanceof TypeDeclaration) {
            MethodDeclaration[] allMethods = ((TypeDeclaration)typeDeclaration).getMethods();
            ArrayList<MethodDeclaration> result = new ArrayList<MethodDeclaration>(Math.min(allMethods.length, 1));
            int i = 0;
            while (i < allMethods.length) {
                MethodDeclaration declaration = allMethods[i];
                if (declaration.isConstructor()) {
                    result.add(declaration);
                }
                ++i;
            }
            return result.toArray(new MethodDeclaration[result.size()]);
        }
        return new MethodDeclaration[0];
    }

    private ConvertLocalVariableDescriptor getRefactoringDescriptor() {
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCu.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        IVariableBinding binding = this.fTempDeclarationNode.resolveBinding();
        String description = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(binding.getName()));
        String header = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)binding.getDeclaringMethod(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)binding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_field_pattern, BasicElementLabels.getJavaElementName(this.fFieldName)));
        switch (this.fInitializeIn) {
            case 2: {
                comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_constructor);
                break;
            }
            case 0: {
                comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_declaration);
                break;
            }
            case 1: {
                comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_method);
            }
        }
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if ("".equals(visibility)) {
            visibility = RefactoringCoreMessages.PromoteTempToFieldRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_visibility_pattern, visibility));
        if (this.fDeclareFinal && this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_final_static);
        } else if (this.fDeclareFinal) {
            comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_final);
        } else if (this.fDeclareStatic) {
            comment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_static);
        }
        ConvertLocalVariableDescriptor descriptor = RefactoringSignatureDescriptorFactory.createConvertLocalVariableDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)2);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCu));
        arguments.put(LINKED_NAME, this.fFieldName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_STATIC, Boolean.valueOf(this.fDeclareStatic).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        arguments.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
        arguments.put(ATTRIBUTE_INITIALIZE, new Integer(this.fInitializeIn).toString());
        return descriptor;
    }

    private void addLocalDeclarationSplit(ASTRewrite rewrite) {
        ListRewrite listRewrite;
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        ASTNode parentStatement = tempDeclarationStatement.getParent();
        if (parentStatement instanceof SwitchStatement) {
            listRewrite = rewrite.getListRewrite(parentStatement, SwitchStatement.STATEMENTS_PROPERTY);
        } else if (parentStatement instanceof Block) {
            listRewrite = rewrite.getListRewrite(parentStatement, Block.STATEMENTS_PROPERTY);
        } else {
            listRewrite = null;
            Assert.isTrue((boolean)false);
        }
        int statementIndex = listRewrite.getOriginalList().indexOf(tempDeclarationStatement);
        Assert.isTrue((statementIndex != -1 ? 1 : 0) != 0);
        Statement newStatement = this.createNewAssignmentStatement(rewrite);
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue((fragmentIndex != -1 ? 1 : 0) != 0);
        if (fragments.size() == 1) {
            rewrite.replace((ASTNode)tempDeclarationStatement, (ASTNode)newStatement, null);
            return;
        }
        int i1 = fragmentIndex;
        int n = fragments.size();
        while (i1 < n) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i1);
            rewrite.remove((ASTNode)fragment, null);
            ++i1;
        }
        if (fragmentIndex == 0) {
            rewrite.remove((ASTNode)tempDeclarationStatement, null);
        }
        Assert.isTrue((boolean)this.tempHasInitializer());
        listRewrite.insertAt((ASTNode)newStatement, statementIndex + 1, null);
        if (fragmentIndex + 1 < fragments.size()) {
            VariableDeclarationFragment firstFragmentAfter = (VariableDeclarationFragment)fragments.get(fragmentIndex + 1);
            VariableDeclarationFragment copyfirstFragmentAfter = (VariableDeclarationFragment)rewrite.createCopyTarget((ASTNode)firstFragmentAfter);
            VariableDeclarationStatement statement = this.getAST().newVariableDeclarationStatement(copyfirstFragmentAfter);
            Type type = (Type)rewrite.createCopyTarget((ASTNode)tempDeclarationStatement.getType());
            statement.setType(type);
            List modifiers = tempDeclarationStatement.modifiers();
            if (modifiers.size() > 0) {
                ListRewrite modifiersRewrite = rewrite.getListRewrite((ASTNode)tempDeclarationStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                ASTNode firstModifier = (ASTNode)modifiers.get(0);
                ASTNode lastModifier = (ASTNode)modifiers.get(modifiers.size() - 1);
                ASTNode modifiersCopy = modifiersRewrite.createCopyTarget(firstModifier, lastModifier);
                statement.modifiers().add(modifiersCopy);
            }
            int i = fragmentIndex + 2;
            while (i < fragments.size()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(i);
                VariableDeclarationFragment fragmentCopy = (VariableDeclarationFragment)rewrite.createCopyTarget((ASTNode)fragment);
                statement.fragments().add(fragmentCopy);
                ++i;
            }
            listRewrite.insertAt((ASTNode)statement, statementIndex + 2, null);
        }
    }

    private Statement createNewAssignmentStatement(ASTRewrite rewrite) {
        AST ast = this.getAST();
        Assignment assignment = ast.newAssignment();
        SimpleName fieldName = ast.newSimpleName(this.fFieldName);
        this.addLinkedName(rewrite, fieldName, true);
        assignment.setLeftHandSide((Expression)fieldName);
        assignment.setRightHandSide(this.getTempInitializerCopy(rewrite));
        return ast.newExpressionStatement((Expression)assignment);
    }

    private void addLinkedName(ASTRewrite rewrite, SimpleName fieldName, boolean isFirst) {
        if (this.fLinkedProposalModel != null) {
            this.fLinkedProposalModel.getPositionGroup(LINKED_NAME, true).addPosition(rewrite.track((ASTNode)fieldName), isFirst);
        }
    }

    private Expression getTempInitializerCopy(ASTRewrite rewrite) {
        Expression initializer = (Expression)rewrite.createCopyTarget((ASTNode)this.getTempInitializer());
        if (initializer instanceof ArrayInitializer && ASTNodes.getDimensions(this.fTempDeclarationNode) > 0) {
            ArrayCreation arrayCreation = rewrite.getAST().newArrayCreation();
            arrayCreation.setType((ArrayType)ASTNodeFactory.newType(rewrite.getAST(), this.fTempDeclarationNode));
            arrayCreation.setInitializer((ArrayInitializer)initializer);
            return arrayCreation;
        }
        return initializer;
    }

    private void addLocalDeclarationRemoval(ASTRewrite rewrite) {
        VariableDeclarationStatement tempDeclarationStatement = this.getTempDeclarationStatement();
        List fragments = tempDeclarationStatement.fragments();
        int fragmentIndex = fragments.indexOf(this.fTempDeclarationNode);
        Assert.isTrue((fragmentIndex != -1 ? 1 : 0) != 0);
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(fragmentIndex);
        rewrite.remove((ASTNode)fragment, null);
        if (fragments.size() == 1) {
            rewrite.remove((ASTNode)tempDeclarationStatement, null);
        }
    }

    private void addFieldDeclaration(ASTRewrite rewrite) {
        ChildListPropertyDescriptor descriptor = this.getBodyDeclarationListOfDeclaringType();
        FieldDeclaration[] fields = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        ASTNode parent = this.getMethodDeclaration().getParent();
        int insertIndex = fields.length == 0 ? 0 : ((List)parent.getStructuralProperty((StructuralPropertyDescriptor)descriptor)).indexOf(fields[fields.length - 1]) + 1;
        FieldDeclaration declaration = this.createNewFieldDeclaration(rewrite);
        rewrite.getListRewrite(parent, descriptor).insertAt((ASTNode)declaration, insertIndex, null);
    }

    private FieldDeclaration createNewFieldDeclaration(ASTRewrite rewrite) {
        AST ast = this.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        SimpleName variableName = ast.newSimpleName(this.fFieldName);
        fragment.setName(variableName);
        this.addLinkedName(rewrite, variableName, false);
        fragment.setExtraDimensions(this.fTempDeclarationNode.getExtraDimensions());
        if (this.fInitializeIn == 0 && this.tempHasInitializer()) {
            Expression initializer = (Expression)rewrite.createCopyTarget((ASTNode)this.getTempInitializer());
            fragment.setInitializer(initializer);
        }
        FieldDeclaration fieldDeclaration = ast.newFieldDeclaration(fragment);
        VariableDeclarationStatement vds = this.getTempDeclarationStatement();
        Type type = (Type)rewrite.createCopyTarget((ASTNode)vds.getType());
        fieldDeclaration.setType(type);
        fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.getModifiers()));
        return fieldDeclaration;
    }

    private int getModifiers() {
        int flags = this.fVisibility;
        if (this.fDeclareFinal) {
            flags |= 0x10;
        }
        if (this.fDeclareStatic) {
            flags |= 8;
        }
        return flags;
    }

    private AST getAST() {
        return this.fTempDeclarationNode.getAST();
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String name;
        String initialize;
        IJavaElement element;
        int length;
        int offset;
        this.fSelfInitializing = true;
        String selection = arguments.getAttribute("selection");
        if (selection != null) {
            offset = -1;
            length = -1;
            StringTokenizer tokenizer = new StringTokenizer(selection);
            if (tokenizer.hasMoreTokens()) {
                offset = Integer.valueOf(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                length = Integer.valueOf(tokenizer.nextToken());
            }
            if (offset < 0 || length < 0) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 5) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.promote.temp");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fCu = (ICompilationUnit)element;
        String visibility = arguments.getAttribute(ATTRIBUTE_VISIBILITY);
        if (visibility != null && !"".equals(visibility)) {
            int flag = 0;
            try {
                flag = Integer.parseInt(visibility);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
            }
            this.fVisibility = flag;
        }
        if ((initialize = arguments.getAttribute(ATTRIBUTE_INITIALIZE)) != null && !"".equals(initialize)) {
            int value = 0;
            try {
                value = Integer.parseInt(initialize);
            }
            catch (NumberFormatException exception) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INITIALIZE));
            }
            this.fInitializeIn = value;
        }
        if ((name = arguments.getAttribute(LINKED_NAME)) == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, LINKED_NAME));
        }
        this.fFieldName = name;
        String declareStatic = arguments.getAttribute(ATTRIBUTE_STATIC);
        if (declareStatic == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STATIC));
        }
        this.fDeclareStatic = Boolean.valueOf(declareStatic);
        String declareFinal = arguments.getAttribute(ATTRIBUTE_FINAL);
        if (declareFinal == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
        }
        this.fDeclareFinal = Boolean.valueOf(declareFinal);
        return new RefactoringStatus();
    }

    public void setLinkedProposalModel(LinkedProposalModel model) {
        this.fLinkedProposalModel = model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalTypeAndVariableUsageAnalyzer
    extends HierarchicalASTVisitor {
        private final List<IBinding> fLocalDefinitions = new ArrayList<IBinding>(0);
        private final List<SimpleName> fLocalReferencesToEnclosing = new ArrayList<SimpleName>(0);
        private final List<ITypeBinding> fMethodTypeVariables;
        private boolean fClassTypeVariablesUsed = false;

        public LocalTypeAndVariableUsageAnalyzer(ITypeBinding[] methodTypeVariables) {
            this.fMethodTypeVariables = Arrays.asList(methodTypeVariables);
        }

        public List<SimpleName> getUsageOfEnclosingNodes() {
            return this.fLocalReferencesToEnclosing;
        }

        public boolean getClassTypeVariablesUsed() {
            return this.fClassTypeVariablesUsed;
        }

        @Override
        public boolean visit(SimpleName node) {
            IBinding binding;
            ITypeBinding typeBinding = node.resolveTypeBinding();
            if (typeBinding != null && typeBinding.isLocal()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add((IBinding)typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            if (typeBinding != null && typeBinding.isTypeVariable()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add((IBinding)typeBinding);
                } else if (!this.fLocalDefinitions.contains(typeBinding)) {
                    if (this.fMethodTypeVariables.contains(typeBinding)) {
                        this.fLocalReferencesToEnclosing.add(node);
                    } else {
                        this.fClassTypeVariablesUsed = true;
                    }
                }
            }
            if ((binding = node.resolveBinding()) != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                if (node.isDeclaration()) {
                    this.fLocalDefinitions.add(binding);
                } else if (!this.fLocalDefinitions.contains(binding)) {
                    this.fLocalReferencesToEnclosing.add(node);
                }
            }
            return super.visit(node);
        }
    }
}

