/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class NLSSourceModifier {
    private final String fSubstitutionPattern;
    private final boolean fIsEclipseNLS;

    private NLSSourceModifier(String substitutionPattern, boolean isEclipseNLS) {
        this.fSubstitutionPattern = substitutionPattern;
        this.fIsEclipseNLS = isEclipseNLS;
    }

    public static Change create(ICompilationUnit cu, NLSSubstitution[] subs, String substitutionPattern, IPackageFragment accessorPackage, String accessorClassName, boolean isEclipseNLS) throws CoreException {
        NLSSourceModifier sourceModification = new NLSSourceModifier(substitutionPattern, isEclipseNLS);
        String message = Messages.format(NLSMessages.NLSSourceModifier_change_description, BasicElementLabels.getFileName((ITypeRoot)cu));
        CompilationUnitChange change = new CompilationUnitChange(message, cu);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        boolean createImportForAccessor = true;
        int i = 0;
        while (i < subs.length) {
            NLSSubstitution substitution = subs[i];
            int newState = substitution.getState();
            if (newState == 0 && createImportForAccessor) {
                accessorClassName = sourceModification.createImportForAccessor(multiTextEdit, accessorClassName, accessorPackage, cu);
                createImportForAccessor = false;
            }
            if (substitution.hasStateChanged()) {
                if (newState == 0) {
                    if (substitution.getInitialState() == 2) {
                        sourceModification.addNLS(substitution, (TextChange)change, accessorClassName);
                    } else if (substitution.getInitialState() == 1) {
                        sourceModification.addAccessor(substitution, (TextChange)change, accessorClassName);
                    }
                } else if (newState == 2) {
                    if (substitution.getInitialState() == 1) {
                        sourceModification.deleteTag(substitution, (TextChange)change);
                        if (substitution.isValueRename()) {
                            sourceModification.replaceValue(substitution, (TextChange)change);
                        }
                    } else if (substitution.getInitialState() == 0) {
                        sourceModification.deleteAccessor(substitution, (TextChange)change, cu);
                        if (!isEclipseNLS) {
                            sourceModification.deleteTag(substitution, (TextChange)change);
                        }
                    }
                } else if (newState == 1) {
                    if (substitution.getInitialState() == 2) {
                        sourceModification.addNLS(substitution, (TextChange)change, null);
                        if (substitution.isValueRename()) {
                            sourceModification.replaceValue(substitution, (TextChange)change);
                        }
                    } else if (substitution.getInitialState() == 0) {
                        sourceModification.deleteAccessor(substitution, (TextChange)change, cu);
                    }
                }
            } else if (newState == 0) {
                if (substitution.isKeyRename()) {
                    sourceModification.replaceKey(substitution, (TextChange)change);
                }
                if (substitution.isAccessorRename()) {
                    sourceModification.replaceAccessor(substitution, (TextChange)change);
                }
            } else if (substitution.isValueRename()) {
                sourceModification.replaceValue(substitution, (TextChange)change);
            }
            ++i;
        }
        return change;
    }

    private void replaceAccessor(NLSSubstitution substitution, TextChange change) {
        AccessorClassReference accessorClassRef = substitution.getAccessorClassReference();
        if (accessorClassRef != null) {
            Region region = accessorClassRef.getRegion();
            int len = accessorClassRef.getName().length();
            Object[] args = new String[]{BasicElementLabels.getJavaElementName(accessorClassRef.getName()), BasicElementLabels.getJavaElementName(substitution.getUpdatedAccessor())};
            TextChangeCompatibility.addTextEdit(change, Messages.format(NLSMessages.NLSSourceModifier_replace_accessor, args), (TextEdit)new ReplaceEdit(region.getOffset(), len, substitution.getUpdatedAccessor()));
        }
    }

    private void replaceKey(NLSSubstitution substitution, TextChange change) {
        Region region = substitution.getNLSElement().getPosition();
        Object[] args = new String[]{substitution.getInitialKey(), BasicElementLabels.getJavaElementName(substitution.getKey())};
        ReplaceEdit replaceEdit = this.fIsEclipseNLS ? new ReplaceEdit(region.getOffset(), region.getLength(), substitution.getKey()) : new ReplaceEdit(region.getOffset(), region.getLength(), String.valueOf('\"') + this.unwindEscapeChars(substitution.getKey()) + '\"');
        TextChangeCompatibility.addTextEdit(change, Messages.format(NLSMessages.NLSSourceModifier_replace_key, args), (TextEdit)replaceEdit);
    }

    private void replaceValue(NLSSubstitution substitution, TextChange change) {
        Region region = substitution.getNLSElement().getPosition();
        Object[] args = new String[]{substitution.getInitialValue(), substitution.getValueNonEmpty()};
        TextChangeCompatibility.addTextEdit(change, Messages.format(NLSMessages.NLSSourceModifier_replace_value, args), (TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), String.valueOf('\"') + this.unwindEscapeChars(substitution.getValueNonEmpty()) + '\"'));
    }

    private void deleteAccessor(NLSSubstitution substitution, TextChange change, ICompilationUnit cu) throws CoreException {
        AccessorClassReference accessorClassRef = substitution.getAccessorClassReference();
        if (accessorClassRef != null) {
            Region region = accessorClassRef.getRegion();
            Object[] args = new String[]{substitution.getValueNonEmpty(), BasicElementLabels.getJavaElementName(substitution.getKey())};
            String label = Messages.format(NLSMessages.NLSSourceModifier_remove_accessor, args);
            String replaceString = String.valueOf('\"') + this.unwindEscapeChars(substitution.getValueNonEmpty()) + '\"';
            TextChangeCompatibility.addTextEdit(change, label, (TextEdit)new ReplaceEdit(region.getOffset(), region.getLength(), replaceString));
            if (this.fIsEclipseNLS && substitution.getState() != 2) {
                Region position = substitution.getNLSElement().getPosition();
                int lineStart = this.getLineStart(cu.getBuffer(), position.getOffset());
                int lineEnd = this.getLineEnd(cu.getBuffer(), position.getOffset());
                String cuLine = cu.getBuffer().getText(lineStart, lineEnd - lineStart);
                StringBuffer buf = new StringBuffer(cuLine);
                buf.replace(region.getOffset() - lineStart, region.getOffset() + region.getLength() - lineStart, replaceString);
                try {
                    NLSLine[] allLines = NLSScanner.scan(buf.toString());
                    NLSLine nlsLine = allLines[0];
                    NLSElement element = NLSSourceModifier.findElement(nlsLine, position.getOffset() - lineStart - accessorClassRef.getName().length() - 1);
                    if (element == null || element.hasTag()) {
                        return;
                    }
                    NLSElement[] elements = nlsLine.getElements();
                    int indexInElementList = Arrays.asList(elements).indexOf(element);
                    String editText = String.valueOf(' ') + NLSElement.createTagText(indexInElementList + 1);
                    TextChangeCompatibility.addTextEdit(change, label, (TextEdit)new InsertEdit(lineEnd, editText));
                }
                catch (InvalidInputException invalidInputException) {
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    private int getLineEnd(IBuffer buffer, int offset) {
        int pos = offset;
        int length = buffer.getLength();
        while (pos < length && !this.isDelemiter(buffer.getChar(pos))) {
            ++pos;
        }
        return pos;
    }

    private int getLineStart(IBuffer buffer, int offset) {
        int pos = offset;
        while (pos >= 0 && !this.isDelemiter(buffer.getChar(pos))) {
            --pos;
        }
        return pos + 1;
    }

    private boolean isDelemiter(char ch) {
        String[] delem = TextUtilities.DELIMITERS;
        int i = 0;
        while (i < delem.length) {
            if (delem[i].length() == 1 && ch == delem[i].charAt(0)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isPositionInElement(NLSElement element, int position) {
        Region elementPosition = element.getPosition();
        return elementPosition.getOffset() <= position && position <= elementPosition.getOffset() + elementPosition.getLength();
    }

    private static NLSElement findElement(NLSLine line, int position) {
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            NLSElement element = elements[i];
            if (NLSSourceModifier.isPositionInElement(element, position)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private String unwindEscapeChars(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            sb.append(this.getUnwoundString(c));
            ++i;
        }
        return sb.toString();
    }

    private String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    private void deleteTag(NLSSubstitution substitution, TextChange change) {
        Region textRegion = substitution.getNLSElement().getTagPosition();
        TextChangeCompatibility.addTextEdit(change, NLSMessages.NLSSourceModifier_remove_tag, (TextEdit)new DeleteEdit(textRegion.getOffset(), textRegion.getLength()));
    }

    private String createImportForAccessor(MultiTextEdit parent, String accessorClassName, IPackageFragment accessorPackage, ICompilationUnit cu) throws CoreException {
        IType type = accessorPackage.getCompilationUnit(String.valueOf(accessorClassName) + ".java").getType(accessorClassName);
        String fullyQualifiedName = type.getFullyQualifiedName();
        ImportRewrite importRewrite = StubUtility.createImportRewrite(cu, true);
        String nameToUse = importRewrite.addImport(fullyQualifiedName);
        TextEdit edit = importRewrite.rewriteImports(null);
        parent.addChild(edit);
        return nameToUse;
    }

    private void addNLS(NLSSubstitution sub, TextChange change, String accessorName) {
        if (sub.getState() == 2) {
            return;
        }
        NLSElement element = sub.getNLSElement();
        this.addAccessor(sub, change, accessorName);
        if (!this.fIsEclipseNLS || sub.getState() == 1) {
            String arg = sub.getState() == 0 ? sub.getKey() : sub.getValueNonEmpty();
            String name = Messages.format(NLSMessages.NLSSourceModifier_add_tag, arg);
            TextChangeCompatibility.addTextEdit(change, name, this.createAddTagChange(element));
        }
    }

    private void addAccessor(NLSSubstitution sub, TextChange change, String accessorName) {
        if (sub.getState() == 0) {
            NLSElement element = sub.getNLSElement();
            Region position = element.getPosition();
            Object[] args = new String[]{sub.getValueNonEmpty(), BasicElementLabels.getJavaElementName(sub.getKey())};
            String text = Messages.format(NLSMessages.NLSSourceModifier_externalize, args);
            String resourceGetter = this.createResourceGetter(sub.getKey(), accessorName);
            ReplaceEdit edit = new ReplaceEdit(position.getOffset(), position.getLength(), resourceGetter);
            if (this.fIsEclipseNLS && element.getTagPosition() != null) {
                MultiTextEdit multiEdit = new MultiTextEdit();
                multiEdit.addChild((TextEdit)edit);
                Region tagPosition = element.getTagPosition();
                multiEdit.addChild((TextEdit)new DeleteEdit(tagPosition.getOffset(), tagPosition.getLength()));
                edit = multiEdit;
            }
            TextChangeCompatibility.addTextEdit(change, text, (TextEdit)edit);
        }
    }

    private TextEdit createAddTagChange(NLSElement element) {
        int offset = element.getTagPosition().getOffset();
        String text = String.valueOf(' ') + element.getTagText();
        return new InsertEdit(offset, text);
    }

    private String createResourceGetter(String key, String accessorName) {
        StringBuffer buf = new StringBuffer();
        buf.append(accessorName);
        buf.append('.');
        if (this.fIsEclipseNLS) {
            buf.append(key);
        } else {
            int i = this.fSubstitutionPattern.indexOf("${key}");
            if (i != -1) {
                buf.append(this.fSubstitutionPattern.substring(0, i));
                buf.append('\"').append(key).append('\"');
                buf.append(this.fSubstitutionPattern.substring(i + "${key}".length()));
            }
        }
        return buf.toString();
    }
}

