/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import com.ibm.icu.text.Collator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NLSUtil {
    private NLSUtil() {
    }

    public static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            StringBuffer buffer = new StringBuffer();
            char[] part = new char[2048];
            int read = 0;
            reader = new BufferedReader(new InputStreamReader(is, encoding));
            while ((read = reader.read(part)) != -1) {
                buffer.append(part, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static TextEdit createNLSEdit(ICompilationUnit cu, int position) throws CoreException {
        NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, position);
        if (nlsLine == null) {
            return null;
        }
        NLSElement element = NLSUtil.findElement(nlsLine, position);
        if (element.hasTag()) {
            return null;
        }
        NLSElement[] elements = nlsLine.getElements();
        int indexInElementList = Arrays.asList(elements).indexOf(element);
        int editOffset = NLSUtil.computeInsertOffset(elements, indexInElementList, cu);
        String editText = String.valueOf(' ') + NLSElement.createTagText(indexInElementList + 1);
        return new InsertEdit(editOffset, editText);
    }

    public static TextEdit[] createNLSEdits(ICompilationUnit cu, int[] positions) throws CoreException {
        ArrayList<InsertEdit> result = new ArrayList<InsertEdit>();
        try {
            NLSLine[] allLines = NLSScanner.scan(cu);
            int i = 0;
            while (i < allLines.length) {
                NLSLine line = allLines[i];
                NLSElement[] elements = line.getElements();
                int j = 0;
                while (j < elements.length) {
                    NLSElement element = elements[j];
                    if (!element.hasTag()) {
                        int k = 0;
                        while (k < positions.length) {
                            if (NLSUtil.isPositionInElement(element, positions[k])) {
                                int editOffset;
                                if (j == 0) {
                                    editOffset = elements.length > j + 1 ? elements[j + 1].getTagPosition().getOffset() : NLSUtil.findLineEnd(cu, element.getPosition().getOffset());
                                } else {
                                    Region previousPosition = elements[j - 1].getTagPosition();
                                    editOffset = previousPosition.getOffset() + previousPosition.getLength();
                                }
                                String editText = String.valueOf(' ') + NLSElement.createTagText(j + 1);
                                result.add(new InsertEdit(editOffset, editText));
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidInputException e) {
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    private static NLSLine scanCurrentLine(ICompilationUnit cu, int position) throws JavaModelException {
        try {
            Assert.isTrue((position >= 0 && position <= cu.getBuffer().getLength() ? 1 : 0) != 0);
            NLSLine[] allLines = NLSScanner.scan(cu);
            int i = 0;
            while (i < allLines.length) {
                NLSLine line = allLines[i];
                if (NLSUtil.findElement(line, position) != null) {
                    return line;
                }
                ++i;
            }
            return null;
        }
        catch (InvalidInputException e) {
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static boolean isPositionInElement(NLSElement element, int position) {
        Region elementPosition = element.getPosition();
        return elementPosition.getOffset() <= position && position <= elementPosition.getOffset() + elementPosition.getLength();
    }

    private static NLSElement findElement(NLSLine line, int position) {
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            NLSElement element = elements[i];
            if (NLSUtil.isPositionInElement(element, position)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private static int computeInsertOffset(NLSElement[] elements, int index, ICompilationUnit cu) throws CoreException {
        NLSElement previousTagged = NLSUtil.findPreviousTagged(index, elements);
        if (previousTagged != null) {
            return previousTagged.getTagPosition().getOffset() + previousTagged.getTagPosition().getLength();
        }
        NLSElement nextTagged = NLSUtil.findNextTagged(index, elements);
        if (nextTagged != null) {
            return nextTagged.getTagPosition().getOffset();
        }
        return NLSUtil.findLineEnd(cu, elements[index].getPosition().getOffset());
    }

    private static NLSElement findPreviousTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex - 1;
        while (i >= 0) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            --i;
        }
        return null;
    }

    private static NLSElement findNextTagged(int startIndex, NLSElement[] elements) {
        int i = startIndex + 1;
        while (i < elements.length) {
            if (elements[i].hasTag()) {
                return elements[i];
            }
            ++i;
        }
        return null;
    }

    private static int findLineEnd(ICompilationUnit cu, int position) throws JavaModelException {
        IBuffer buffer = cu.getBuffer();
        int length = buffer.getLength();
        int i = position;
        while (i < length) {
            if (IndentManipulation.isLineDelimiterChar((char)buffer.getChar(i))) {
                return i;
            }
            ++i;
        }
        return length;
    }

    public static int getInsertionPosition(String key, List<String> keys) {
        int result = 0;
        int invertDistance = Integer.MIN_VALUE;
        int i = 0;
        for (String string : keys) {
            int currentInvertDistance = NLSUtil.invertDistance(key, string);
            if (currentInvertDistance > invertDistance) {
                invertDistance = currentInvertDistance;
                result = Collator.getInstance().compare(key, string) >= 0 ? i : i - 1;
            } else if (currentInvertDistance == invertDistance && Collator.getInstance().compare(key, string) >= 0) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public static int invertDistance(String insertKey, String existingKey) {
        int existingKeyLength = existingKey.length();
        int insertKeyLength = insertKey.length();
        int minLen = Math.min(insertKeyLength, existingKeyLength);
        int prefixMatchCount = 0;
        int i = 0;
        while (i < minLen) {
            if (insertKey.charAt(i) == existingKey.charAt(i)) {
                ++prefixMatchCount;
            } else {
                return prefixMatchCount << 16;
            }
            ++i;
        }
        if (insertKeyLength > existingKeyLength && NLSUtil.isSeparator(insertKey.charAt(existingKeyLength))) {
            return prefixMatchCount + 1 << 16;
        }
        int existingLonger = existingKeyLength - insertKeyLength;
        return (prefixMatchCount << 16) - Math.max(0, existingLonger);
    }

    private static boolean isSeparator(char ch) {
        return ch == '.' || ch == '-' || ch == '_';
    }
}

