/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateFileChange;

public class CreateTextFileChange
extends CreateFileChange {
    private final String fTextType;

    public CreateTextFileChange(IPath path, String source, String encoding, String textType) {
        super(path, source, encoding);
        this.fTextType = textType;
    }

    public String getTextType() {
        return this.fTextType;
    }

    public String getCurrentContent() throws JavaModelException {
        IFile file = this.getOldFile((IProgressMonitor)new NullProgressMonitor());
        if (!file.exists()) {
            return "";
        }
        InputStream stream = null;
        try {
            stream = file.getContents();
            String encoding = file.getCharset();
            String c = NLSUtil.readString(stream, encoding);
            String string = c == null ? "" : c;
            return string;
        }
        catch (CoreException e) {
            throw new JavaModelException((Throwable)e, 966);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getPreview() {
        return this.getSource();
    }
}

