/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractInterfaceDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ASTNodeDeleteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsSolver;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeRefactoringProcessor;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ISourceConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtractInterfaceProcessor
extends SuperTypeRefactoringProcessor {
    private static final String ATTRIBUTE_ABSTRACT = "abstract";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_PUBLIC = "public";
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.extractInterfaceProcessor";
    private static final GroupCategorySet SET_EXTRACT_INTERFACE = new GroupCategorySet(new GroupCategory("org.eclipse.jdt.internal.corext.extractInterface", RefactoringCoreMessages.ExtractInterfaceProcessor_category_name, RefactoringCoreMessages.ExtractInterfaceProcessor_category_description));
    private boolean fAbstract = true;
    private boolean fAnnotations = false;
    private TextEditBasedChangeManager fChangeManager = null;
    private boolean fComments = true;
    private IMember[] fMembers = null;
    private boolean fPublic = true;
    private IType fSubType;
    private String fSuperName;
    private String fSuperSource = null;

    protected static boolean isExtractableMember(IMember member) throws JavaModelException {
        Assert.isNotNull((Object)member);
        switch (member.getElementType()) {
            case 9: {
                return JdtFlags.isPublic(member) && !JdtFlags.isStatic(member) && !((IMethod)member).isConstructor();
            }
            case 8: {
                return JdtFlags.isPublic(member) && JdtFlags.isStatic(member) && JdtFlags.isFinal(member) && !JdtFlags.isEnum(member);
            }
        }
        return false;
    }

    public ExtractInterfaceProcessor(IType type, CodeGenerationSettings settings) {
        super(settings);
        this.fSubType = type;
        if (this.fSubType != null) {
            this.fSuperName = this.fSubType.getElementName();
        }
    }

    public ExtractInterfaceProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        super(null);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public final RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)context);
        RefactoringStatus status = new RefactoringStatus();
        this.fChangeManager = new TextEditBasedChangeManager();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_checking);
            status.merge(Checks.checkIfCuBroken((IMember)this.fSubType));
            if (!status.hasError()) {
                if (this.fSubType.isBinary() || this.fSubType.isReadOnly() || !this.fSubType.exists()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_binary, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                } else if (this.fSubType.isAnonymous()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_anonymous, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                } else if (this.fSubType.isAnnotation()) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_no_annotation, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fSubType)));
                } else {
                    status.merge(this.checkSuperType());
                    if (!status.hasFatalError() && !status.hasFatalError()) {
                        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
                        if (!status.hasFatalError()) {
                            Checks.addModifiedFilesToChecker(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), context);
                        }
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    public final RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_checking);
            status.merge(Checks.checkIfCuBroken((IMember)this.fSubType));
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected final RefactoringStatus checkSuperType() throws JavaModelException {
        IPackageFragment fragment = this.fSubType.getPackageFragment();
        IType type = Checks.findTypeInPackage(fragment, this.fSuperName);
        if (type != null && type.exists()) {
            if (fragment.isDefaultPackage()) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_default_type, BasicElementLabels.getJavaElementName(this.fSuperName)));
            }
            String packageLabel = JavaElementLabels.getElementLabel((IJavaElement)fragment, JavaElementLabels.ALL_DEFAULT);
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_type, new String[]{BasicElementLabels.getJavaElementName(this.fSuperName), packageLabel}));
        }
        return new RefactoringStatus();
    }

    public final RefactoringStatus checkTypeName(String name) {
        Assert.isNotNull((Object)name);
        try {
            RefactoringStatus result = Checks.checkTypeName(name, (IJavaElement)this.fSubType);
            if (result.hasFatalError()) {
                return result;
            }
            String unitName = JavaModelUtil.getRenamedCUName(this.fSubType.getCompilationUnit(), name);
            result.merge(Checks.checkCompilationUnitName(unitName, (IJavaElement)this.fSubType));
            if (result.hasFatalError()) {
                return result;
            }
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            if (fragment.getCompilationUnit(unitName).exists()) {
                result.addFatalError(Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_existing_compilation_unit, new String[]{BasicElementLabels.getResourceName(unitName), JavaElementLabels.getElementLabel((IJavaElement)fragment, JavaElementLabels.ALL_DEFAULT)}));
                return result;
            }
            result.merge(this.checkSuperType());
            return result;
        }
        catch (JavaModelException exception) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error);
        }
    }

    public final Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaProject javaProject = this.fSubType.getJavaProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 589830;
            try {
                if (this.fSubType.isLocal() || this.fSubType.isAnonymous()) {
                    flags |= 0x40000;
                }
            }
            catch (JavaModelException exception) {
                JavaPlugin.log(exception);
            }
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            ICompilationUnit cu = fragment.getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fSubType.getCompilationUnit(), this.fSuperName));
            IType type = cu.getType(this.fSuperName);
            String description = Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_description_descriptor_short, BasicElementLabels.getJavaElementName(this.fSuperName));
            String header = Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_descriptor_description, new String[]{JavaElementLabels.getElementLabel((IJavaElement)type, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)this.fSubType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractInterfaceProcessor_refactored_element_pattern, JavaElementLabels.getElementLabel((IJavaElement)type, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            String[] settings = new String[this.fMembers.length];
            int index = 0;
            while (index < settings.length) {
                settings[index] = JavaElementLabels.getElementLabel((IJavaElement)this.fMembers[index], JavaElementLabels.ALL_FULLY_QUALIFIED);
                ++index;
            }
            comment.addSetting(JDTRefactoringDescriptorComment.createCompositeSetting(RefactoringCoreMessages.ExtractInterfaceProcessor_extracted_members_pattern, settings));
            this.addSuperTypeSettings(comment, true);
            ExtractInterfaceDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractInterfaceDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)flags);
            arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fSubType));
            arguments.put("name", this.fSuperName);
            int index2 = 0;
            while (index2 < this.fMembers.length) {
                arguments.put("element" + (index2 + 1), JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fMembers[index2]));
                ++index2;
            }
            arguments.put(ATTRIBUTE_ABSTRACT, Boolean.valueOf(this.fAbstract).toString());
            arguments.put(ATTRIBUTE_COMMENTS, Boolean.valueOf(this.fComments).toString());
            arguments.put(ATTRIBUTE_PUBLIC, Boolean.valueOf(this.fPublic).toString());
            arguments.put("replace", Boolean.valueOf(this.fReplace).toString());
            arguments.put("instanceof", Boolean.valueOf(this.fInstanceOf).toString());
            DynamicValidationRefactoringChange change = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.ExtractInterfaceRefactoring_name, (Change[])this.fChangeManager.getAllChanges());
            IFile file = ResourceUtil.getFile(this.fSubType.getCompilationUnit());
            if (this.fSuperSource != null && this.fSuperSource.length() > 0) {
                change.add((Change)new CreateCompilationUnitChange(this.fSubType.getPackageFragment().getCompilationUnit(JavaModelUtil.getRenamedCUName(this.fSubType.getCompilationUnit(), this.fSuperName)), this.fSuperSource, file.getCharset(false)));
            }
            monitor.worked(1);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = change;
            return dynamicValidationRefactoringChange;
        }
        finally {
            monitor.done();
        }
    }

    protected final TextEditBasedChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws JavaModelException, CoreException {
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            this.resetEnvironment();
            TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            CompilationUnitRewrite sourceRewrite = new CompilationUnitRewrite(this.fSubType.getCompilationUnit());
            AbstractTypeDeclaration declaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(this.fSubType, sourceRewrite.getRoot());
            if (declaration != null) {
                IMethod[] methods;
                this.createTypeSignature(sourceRewrite, declaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                IField[] fields = this.getExtractedFields(this.fSubType.getCompilationUnit());
                if (fields.length > 0) {
                    ASTNodeDeleteUtil.markAsDeleted((IJavaElement[])fields, sourceRewrite, (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_remove_field_label, SET_EXTRACT_INTERFACE));
                }
                if (this.fSubType.isInterface() && (methods = this.getExtractedMethods(this.fSubType.getCompilationUnit())).length > 0) {
                    ASTNodeDeleteUtil.markAsDeleted((IJavaElement[])methods, sourceRewrite, (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_remove_method_label, SET_EXTRACT_INTERFACE));
                }
                String name = JavaModelUtil.getRenamedCUName(this.fSubType.getCompilationUnit(), this.fSuperName);
                ICompilationUnit original = this.fSubType.getPackageFragment().getCompilationUnit(name);
                ICompilationUnit copy = this.getSharedWorkingCopy(original.getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                this.fSuperSource = this.createTypeSource(copy, this.fSubType, this.fSuperName, sourceRewrite, declaration, status, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
                if (this.fSuperSource != null) {
                    copy.getBuffer().setContents(this.fSuperSource);
                    JavaModelUtil.reconcile(copy);
                }
                HashSet<String> replacements = new HashSet<String>();
                if (this.fReplace) {
                    this.rewriteTypeOccurrences(manager, sourceRewrite, copy, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 220));
                }
                this.createMethodComments(sourceRewrite, replacements);
                manager.manage(this.fSubType.getCompilationUnit(), (TextEditBasedChange)sourceRewrite.createChange(true));
            }
            TextEditBasedChangeManager textEditBasedChangeManager = manager;
            return textEditBasedChangeManager;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected final SuperTypeConstraintsSolver createContraintSolver(SuperTypeConstraintsModel model) {
        return new ExtractInterfaceConstraintsSolver(model, this.fSuperName);
    }

    protected final void createFieldDeclaration(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration, VariableDeclarationFragment fragment) throws CoreException {
        Assert.isNotNull((Object)targetDeclaration);
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)fragment);
        FieldDeclaration field = (FieldDeclaration)fragment.getParent();
        ImportRewriteUtil.collectImports(this.fSubType.getJavaProject(), (ASTNode)field, this.fTypeBindings, this.fStaticBindings, false);
        ASTRewrite rewrite = ASTRewrite.create((AST)field.getAST());
        ITrackedNodePosition position = rewrite.track((ASTNode)field);
        ListRewrite rewriter = rewrite.getListRewrite((ASTNode)field, FieldDeclaration.FRAGMENTS_PROPERTY);
        VariableDeclarationFragment current2 = null;
        for (VariableDeclarationFragment current2 : field.fragments()) {
            if (current2.getName().getIdentifier().equals(fragment.getName().getIdentifier())) continue;
            rewriter.remove((ASTNode)current2, null);
        }
        ICompilationUnit unit = sourceRewrite.getCu();
        ITextFileBuffer buffer = RefactoringFileBuffers.acquire(unit);
        try {
            Document document = new Document(buffer.getDocument().get());
            try {
                rewrite.rewriteAST((IDocument)document, unit.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
                targetRewrite.getListRewrite((ASTNode)targetDeclaration, targetDeclaration.getBodyDeclarationsProperty()).insertFirst(targetRewrite.createStringPlaceholder(this.normalizeText(document.get(position.getStartPosition(), position.getLength())), 23), null);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
            }
        }
        finally {
            RefactoringFileBuffers.release(unit);
        }
    }

    @Override
    protected final void createMemberDeclarations(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)targetDeclaration);
        Arrays.sort(this.fMembers, new Comparator<IMember>(){

            @Override
            public final int compare(IMember first, IMember second) {
                try {
                    return first.getSourceRange().getOffset() - second.getSourceRange().getOffset();
                }
                catch (JavaModelException exception) {
                    return first.hashCode() - second.hashCode();
                }
            }
        });
        this.fTypeBindings.clear();
        this.fStaticBindings.clear();
        if (this.fMembers.length > 0) {
            IMember member = null;
            int index = this.fMembers.length - 1;
            while (index >= 0) {
                member = this.fMembers[index];
                if (member instanceof IField) {
                    this.createFieldDeclaration(sourceRewrite, targetRewrite, targetDeclaration, ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)member, sourceRewrite.getRoot()));
                } else if (member instanceof IMethod) {
                    this.createMethodDeclaration(sourceRewrite, targetRewrite, targetDeclaration, ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, sourceRewrite.getRoot()));
                }
                --index;
            }
        }
    }

    protected final void createMethodComment(CompilationUnitRewrite sourceRewrite, MethodDeclaration declaration, Set<String> replacements, boolean javadoc) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull(replacements);
        IMethodBinding binding = declaration.resolveBinding();
        if (binding != null) {
            IVariableBinding variable = null;
            SingleVariableDeclaration argument = null;
            IPackageFragment fragment = this.fSubType.getPackageFragment();
            String string = fragment.isDefaultPackage() ? this.fSuperName : String.valueOf(fragment.getElementName()) + "." + this.fSuperName;
            ITypeBinding[] bindings = binding.getParameterTypes();
            String[] names = new String[bindings.length];
            int offset = 0;
            while (offset < names.length) {
                argument = (SingleVariableDeclaration)declaration.parameters().get(offset);
                variable = argument.resolveBinding();
                if (variable != null) {
                    names[offset] = replacements.contains(variable.getKey()) ? string : (binding.isVarargs() && bindings[offset].isArray() && offset == names.length - 1 ? Bindings.getFullyQualifiedName(bindings[offset].getElementType()) : Bindings.getFullyQualifiedName(bindings[offset]));
                }
                ++offset;
            }
            String comment = CodeGeneration.getMethodComment(this.fSubType.getCompilationUnit(), this.fSubType.getElementName(), declaration, false, binding.getName(), string, names, StubUtility.getLineDelimiterUsed(this.fSubType.getJavaProject()));
            if (comment != null) {
                ASTRewrite rewrite = sourceRewrite.getASTRewrite();
                if (declaration.getJavadoc() != null) {
                    rewrite.replace((ASTNode)declaration.getJavadoc(), rewrite.createStringPlaceholder(comment, 29), (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_rewrite_comment, SET_EXTRACT_INTERFACE));
                } else if (javadoc) {
                    rewrite.set((ASTNode)declaration, (StructuralPropertyDescriptor)MethodDeclaration.JAVADOC_PROPERTY, (Object)rewrite.createStringPlaceholder(comment, 29), (TextEditGroup)sourceRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_add_comment, SET_EXTRACT_INTERFACE));
                }
            }
        }
    }

    protected final void createMethodComments(CompilationUnitRewrite sourceRewrite, Set<String> replacements) throws CoreException {
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull(replacements);
        if (this.fMembers.length > 0 && (this.fAnnotations || this.fComments)) {
            IJavaProject project = this.fSubType.getJavaProject();
            boolean annotations = this.fAnnotations && !JavaModelUtil.isVersionLessThan(project.getOption("org.eclipse.jdt.core.compiler.source", true), "1.6");
            boolean javadoc = project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true).equals("enabled");
            IMember member = null;
            int index = 0;
            while (index < this.fMembers.length) {
                member = this.fMembers[index];
                if (member instanceof IMethod) {
                    MethodDeclaration declaration = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)member, sourceRewrite.getRoot());
                    if (annotations) {
                        ASTRewrite rewrite = sourceRewrite.getASTRewrite();
                        AST ast = rewrite.getAST();
                        MarkerAnnotation marker = ast.newMarkerAnnotation();
                        marker.setTypeName((Name)ast.newSimpleName("Override"));
                        rewrite.getListRewrite((ASTNode)declaration, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
                    }
                    if (this.fComments) {
                        this.createMethodComment(sourceRewrite, declaration, replacements, javadoc);
                    }
                }
                ++index;
            }
        }
    }

    protected final void createMethodDeclaration(CompilationUnitRewrite sourceRewrite, ASTRewrite targetRewrite, AbstractTypeDeclaration targetDeclaration, MethodDeclaration declaration) throws CoreException {
        Assert.isNotNull((Object)targetDeclaration);
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaration);
        ImportRewriteUtil.collectImports(this.fSubType.getJavaProject(), (ASTNode)declaration, this.fTypeBindings, this.fStaticBindings, true);
        ASTRewrite rewrite = ASTRewrite.create((AST)declaration.getAST());
        ITrackedNodePosition position = rewrite.track((ASTNode)declaration);
        if (declaration.getBody() != null) {
            rewrite.remove((ASTNode)declaration.getBody(), null);
        }
        ListRewrite list = rewrite.getListRewrite((ASTNode)declaration, declaration.getModifiersProperty());
        boolean publicFound = false;
        boolean abstractFound = false;
        Annotation annotation = null;
        for (IExtendedModifier extended : declaration.modifiers()) {
            ITypeBinding binding;
            if (!extended.isAnnotation()) {
                Modifier modifier = (Modifier)extended;
                if (this.fPublic && modifier.getKeyword().equals(Modifier.ModifierKeyword.PUBLIC_KEYWORD)) {
                    publicFound = true;
                    continue;
                }
                if (this.fAbstract && modifier.getKeyword().equals(Modifier.ModifierKeyword.ABSTRACT_KEYWORD)) {
                    abstractFound = true;
                    continue;
                }
                list.remove((ASTNode)modifier, null);
                continue;
            }
            if (!extended.isAnnotation() || !(binding = (annotation = (Annotation)extended).resolveTypeBinding()).getQualifiedName().equals("java.lang.Override") && Bindings.isClassOrRuntimeAnnotation(binding)) continue;
            list.remove((ASTNode)annotation, null);
        }
        ModifierRewrite rewriter = ModifierRewrite.create(rewrite, (ASTNode)declaration);
        if (this.fPublic && !publicFound) {
            rewriter.setVisibility(1, null);
        }
        if (this.fAbstract && !abstractFound) {
            rewriter.setModifiers(1024, 0, null);
        }
        for (SingleVariableDeclaration param : declaration.parameters()) {
            ListRewrite modifierRewrite = rewrite.getListRewrite((ASTNode)param, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            for (IExtendedModifier extended : param.modifiers()) {
                ITypeBinding binding;
                if (!extended.isAnnotation()) {
                    Modifier modifier = (Modifier)extended;
                    modifierRewrite.remove((ASTNode)modifier, null);
                    continue;
                }
                if (!extended.isAnnotation() || Bindings.isClassOrRuntimeAnnotation(binding = (annotation = (Annotation)extended).resolveTypeBinding())) continue;
                modifierRewrite.remove((ASTNode)annotation, null);
            }
        }
        ICompilationUnit unit = sourceRewrite.getCu();
        ITextFileBuffer buffer = RefactoringFileBuffers.acquire(unit);
        try {
            Document document = new Document(buffer.getDocument().get());
            try {
                rewrite.rewriteAST((IDocument)document, unit.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
                targetRewrite.getListRewrite((ASTNode)targetDeclaration, targetDeclaration.getBodyDeclarationsProperty()).insertFirst(targetRewrite.createStringPlaceholder(this.normalizeText(document.get(position.getStartPosition(), position.getLength())), 31), null);
            }
            catch (MalformedTreeException exception) {
                JavaPlugin.log(exception);
            }
            catch (BadLocationException exception) {
                JavaPlugin.log(exception);
            }
        }
        finally {
            RefactoringFileBuffers.release(unit);
        }
    }

    protected final void createTypeSignature(CompilationUnitRewrite rewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            AST ast = declaration.getAST();
            ITypeParameter[] parameters = this.fSubType.getTypeParameters();
            SimpleType type = ast.newSimpleType((Name)ast.newSimpleName(this.fSuperName));
            if (parameters.length > 0) {
                ParameterizedType parameterized = ast.newParameterizedType((Type)type);
                int index = 0;
                while (index < parameters.length) {
                    parameterized.typeArguments().add(ast.newSimpleType((Name)ast.newSimpleName(parameters[index].getElementName())));
                    ++index;
                }
                type = parameterized;
            }
            ASTRewrite rewriter = rewrite.getASTRewrite();
            if (declaration instanceof TypeDeclaration) {
                rewriter.getListRewrite((ASTNode)declaration, TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY).insertLast((ASTNode)type, (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_add_super_interface, SET_EXTRACT_INTERFACE));
            } else if (declaration instanceof EnumDeclaration) {
                rewriter.getListRewrite((ASTNode)declaration, EnumDeclaration.SUPER_INTERFACE_TYPES_PROPERTY).insertLast((ASTNode)type, (TextEditGroup)rewrite.createCategorizedGroupDescription(RefactoringCoreMessages.ExtractInterfaceProcessor_add_super_interface, SET_EXTRACT_INTERFACE));
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    public final boolean getAbstract() {
        return this.fAbstract;
    }

    public final Object[] getElements() {
        return new Object[]{this.fSubType};
    }

    public final IMember[] getExtractableMembers() throws JavaModelException {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        IJavaElement[] children = this.fSubType.getChildren();
        int index = 0;
        while (index < children.length) {
            if (children[index] instanceof IMember && ExtractInterfaceProcessor.isExtractableMember((IMember)children[index])) {
                list.add(children[index]);
            }
            ++index;
        }
        IMember[] members = new IMember[list.size()];
        list.toArray(members);
        return members;
    }

    protected final IField[] getExtractedFields(ICompilationUnit unit) {
        Assert.isNotNull((Object)unit);
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < this.fMembers.length) {
            IJavaElement element;
            if (this.fMembers[index] instanceof IField && (element = JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)this.fMembers[index])) instanceof IField) {
                list.add(element);
            }
            ++index;
        }
        IField[] fields = new IField[list.size()];
        list.toArray(fields);
        return fields;
    }

    protected final IMethod[] getExtractedMethods(ICompilationUnit unit) {
        Assert.isNotNull((Object)unit);
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
        int index = 0;
        while (index < this.fMembers.length) {
            IJavaElement element;
            if (this.fMembers[index] instanceof IMethod && (element = JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)this.fMembers[index])) instanceof IMethod) {
                list.add(element);
            }
            ++index;
        }
        IMethod[] methods = new IMethod[list.size()];
        list.toArray(methods);
        return methods;
    }

    public final String getIdentifier() {
        return IDENTIFIER;
    }

    public final String getProcessorName() {
        return RefactoringCoreMessages.ExtractInterfaceProcessor_name;
    }

    public final boolean getPublic() {
        return this.fPublic;
    }

    public final IType getType() {
        return this.fSubType;
    }

    public final String getTypeName() {
        return this.fSuperName;
    }

    public final boolean isAnnotations() {
        return this.fAnnotations;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 7) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.extract.interface");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fSubType = (IType)element;
        String name = extended.getAttribute("name");
        if (name != null) {
            this.fSuperName = name;
            RefactoringStatus status = this.checkTypeName(name);
            if (status.hasError()) {
                return status;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        String deferred = extended.getAttribute(ATTRIBUTE_ABSTRACT);
        if (deferred == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ABSTRACT));
        }
        this.fAbstract = Boolean.valueOf(deferred);
        String comment = extended.getAttribute(ATTRIBUTE_COMMENTS);
        if (comment == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
        }
        this.fComments = Boolean.valueOf(comment);
        String instance = extended.getAttribute("instanceof");
        if (instance == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "instanceof"));
        }
        this.fInstanceOf = Boolean.valueOf(instance);
        String visibility = extended.getAttribute(ATTRIBUTE_PUBLIC);
        if (visibility == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PUBLIC));
        }
        this.fPublic = Boolean.valueOf(visibility);
        String replace = extended.getAttribute("replace");
        if (replace == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "replace"));
        }
        this.fReplace = Boolean.valueOf(replace);
        int count = 1;
        ArrayList<IJavaElement> elements = new ArrayList<IJavaElement>();
        String attribute = "element" + count;
        RefactoringStatus status = new RefactoringStatus();
        while ((handle = extended.getAttribute(attribute)) != null) {
            IJavaElement element2 = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element2 == null || !element2.exists()) {
                status.merge(JavaRefactoringDescriptorUtil.createInputWarningStatus(element2, this.getProcessorName(), "org.eclipse.jdt.ui.extract.interface"));
            } else {
                elements.add(element2);
            }
            attribute = "element" + ++count;
        }
        this.fMembers = elements.toArray(new IMember[elements.size()]);
        this.fSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fSubType.getJavaProject());
        if (!status.isOK()) {
            return status;
        }
        return new RefactoringStatus();
    }

    public final boolean isApplicable() throws CoreException {
        return Checks.isAvailable((IJavaElement)this.fSubType) && !this.fSubType.isBinary() && !this.fSubType.isReadOnly() && !this.fSubType.isAnnotation() && !this.fSubType.isAnonymous();
    }

    public final boolean isComments() {
        return this.fComments;
    }

    public final RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    protected final String normalizeText(String code) throws JavaModelException {
        Assert.isNotNull((Object)code);
        String[] lines = Strings.convertIntoLines(code);
        IJavaProject project = this.fSubType.getJavaProject();
        Strings.trimIndentation(lines, project, false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed(project));
    }

    protected void resetEnvironment() {
        this.fSuperSource = null;
        this.resetWorkingCopies();
    }

    @Override
    protected final void rewriteTypeOccurrences(TextEditBasedChangeManager manager, ASTRequestor requestor, CompilationUnitRewrite rewrite, ICompilationUnit unit, CompilationUnit node, Set<String> replacements, IProgressMonitor monitor) throws CoreException {
        try {
            CompilationUnitChange change;
            monitor.beginTask("", 100);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            CompilationUnitRewrite currentRewrite = null;
            boolean isSubUnit = rewrite.getCu().equals(unit.getPrimary());
            currentRewrite = isSubUnit ? rewrite : new CompilationUnitRewrite(unit, node);
            Collection collection = (Collection)this.fTypeOccurrences.get(unit);
            if (collection != null && !collection.isEmpty()) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 100);
                try {
                    subMonitor.beginTask("", collection.size() * 10);
                    subMonitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
                    TType estimate = null;
                    ISourceConstraintVariable variable2 = null;
                    ITypeConstraintVariable constraint = null;
                    for (ISourceConstraintVariable variable2 : collection) {
                        if (!(variable2 instanceof ITypeConstraintVariable) || (estimate = (TType)(constraint = (ITypeConstraintVariable)variable2).getData("te")) == null) continue;
                        CompilationUnitRange range = constraint.getRange();
                        if (isSubUnit) {
                            this.rewriteTypeOccurrence(range, estimate, requestor, currentRewrite, node, replacements, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                        } else {
                            ASTNode result = NodeFinder.perform((ASTNode)node, (ISourceRange)range.getSourceRange());
                            if (result != null) {
                                this.rewriteTypeOccurrence(estimate, currentRewrite, result, (TextEditGroup)currentRewrite.createCategorizedGroupDescription(RefactoringCoreMessages.SuperTypeRefactoringProcessor_update_type_occurrence, SET_SUPER_TYPE));
                            }
                        }
                        subMonitor.worked(10);
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
            if (!isSubUnit && (change = currentRewrite.createChange(true)) != null) {
                manager.manage(unit, (TextEditBasedChange)change);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected final void rewriteTypeOccurrences(final TextEditBasedChangeManager manager, final CompilationUnitRewrite sourceRewrite, final ICompilationUnit superUnit, final Set<String> replacements, final RefactoringStatus status, final IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)manager);
        Assert.isNotNull((Object)sourceRewrite);
        Assert.isNotNull((Object)superUnit);
        Assert.isNotNull(replacements);
        Assert.isNotNull((Object)status);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 300);
            monitor.setTaskName(RefactoringCoreMessages.ExtractInterfaceProcessor_creating);
            ICompilationUnit subUnit = this.getSharedWorkingCopy(this.fSubType.getCompilationUnit().getPrimary(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            ITextFileBuffer buffer = RefactoringFileBuffers.acquire(this.fSubType.getCompilationUnit());
            ASTRewrite rewrite = sourceRewrite.getASTRewrite();
            try {
                Document document = new Document(buffer.getDocument().get());
                try {
                    rewrite.rewriteAST((IDocument)document, this.fSubType.getJavaProject().getOptions(true)).apply((IDocument)document, 2);
                }
                catch (MalformedTreeException exception) {
                    JavaPlugin.log(exception);
                }
                catch (BadLocationException exception) {
                    JavaPlugin.log(exception);
                }
                subUnit.getBuffer().setContents(document.get());
            }
            finally {
                RefactoringFileBuffers.release(this.fSubType.getCompilationUnit());
            }
            JavaModelUtil.reconcile(subUnit);
            IJavaProject project = subUnit.getJavaProject();
            ASTParser parser = ASTParser.newParser((int)4);
            parser.setWorkingCopyOwner(this.fOwner);
            parser.setResolveBindings(true);
            parser.setProject(project);
            parser.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)project));
            parser.createASTs(new ICompilationUnit[]{subUnit}, new String[0], new ASTRequestor(){

                public final void acceptAST(ICompilationUnit unit, CompilationUnit node) {
                    block7: {
                        try {
                            TextEdit edit;
                            TextEditBasedChange change;
                            ITypeBinding subBinding;
                            IType subType = (IType)JavaModelUtil.findInCompilationUnit(unit, (IJavaElement)ExtractInterfaceProcessor.this.fSubType);
                            AbstractTypeDeclaration subDeclaration = ASTNodeSearchUtil.getAbstractTypeDeclarationNode(subType, node);
                            if (subDeclaration == null || (subBinding = subDeclaration.resolveBinding()) == null) break block7;
                            String name = null;
                            ITypeBinding superBinding = null;
                            ITypeBinding[] superBindings = subBinding.getInterfaces();
                            int index = 0;
                            while (index < superBindings.length) {
                                name = superBindings[index].getName();
                                if (name.startsWith(ExtractInterfaceProcessor.this.fSuperName) && superBindings[index].getTypeArguments().length == subBinding.getTypeParameters().length) {
                                    superBinding = superBindings[index];
                                }
                                ++index;
                            }
                            if (superBinding == null) break block7;
                            ExtractInterfaceProcessor.this.solveSuperTypeConstraints(unit, node, subType, subBinding, superBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 80), status);
                            if (status.hasFatalError()) break block7;
                            ExtractInterfaceProcessor.this.rewriteTypeOccurrences(manager, this, sourceRewrite, unit, node, replacements, status, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                            if (!manager.containsChangesIn(superUnit) || !((change = manager.get(superUnit)) instanceof TextChange) || (edit = ((TextChange)change).getEdit()) == null) break block7;
                            Document document = new Document(superUnit.getBuffer().getContents());
                            try {
                                edit.apply((IDocument)document, 2);
                            }
                            catch (MalformedTreeException exception) {
                                JavaPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                            }
                            catch (BadLocationException exception) {
                                JavaPlugin.log(exception);
                                status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                            }
                            ExtractInterfaceProcessor.this.fSuperSource = document.get();
                            manager.remove(superUnit);
                        }
                        catch (JavaModelException exception) {
                            JavaPlugin.log(exception);
                            status.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ExtractInterfaceProcessor_internal_error));
                        }
                    }
                }

                public final void acceptBinding(String key, IBinding binding) {
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            monitor.done();
        }
    }

    public final void setAbstract(boolean declare) {
        this.fAbstract = declare;
    }

    public final void setAnnotations(boolean annotations) {
        this.fAnnotations = annotations;
    }

    public final void setComments(boolean comments) {
        this.fComments = comments;
    }

    public final void setExtractedMembers(IMember[] members) throws JavaModelException {
        this.fMembers = members;
    }

    public final void setPublic(boolean declare) {
        this.fPublic = declare;
    }

    public final void setTypeName(String name) {
        Assert.isNotNull((Object)name);
        this.fSuperName = name;
    }
}

