/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.text.template.contentassist.MultiVariableGuess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;

public abstract class CompilationUnitContext
extends DocumentTemplateContext {
    private final ICompilationUnit fCompilationUnit;
    protected boolean fForceEvaluation;
    protected MultiVariableGuess fMultiVariableGuess;
    protected final boolean fIsManaged;

    protected CompilationUnitContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength);
        this.fCompilationUnit = compilationUnit;
        this.fIsManaged = false;
    }

    protected CompilationUnitContext(TemplateContextType type, IDocument document, Position completionPosition, ICompilationUnit compilationUnit) {
        super(type, document, completionPosition);
        this.fCompilationUnit = compilationUnit;
        this.fIsManaged = true;
    }

    public final ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public IJavaElement findEnclosingElement(int elementType) {
        if (this.fCompilationUnit == null) {
            return null;
        }
        try {
            IJavaElement element = this.fCompilationUnit.getElementAt(this.getStart());
            if (element == null) {
                element = this.fCompilationUnit;
            }
            return element.getAncestor(elementType);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public void setForceEvaluation(boolean evaluate) {
        this.fForceEvaluation = evaluate;
    }

    public MultiVariableGuess getMultiVariableGuess() {
        return this.fMultiVariableGuess;
    }

    void setMultiVariableGuess(MultiVariableGuess multiVariableGuess) {
        this.fMultiVariableGuess = multiVariableGuess;
    }

    protected IJavaProject getJavaProject() {
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        IJavaProject project = compilationUnit == null ? null : compilationUnit.getJavaProject();
        return project;
    }
}

