/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

class SelectWorkingSetAction
extends Action {
    private final SearchScopeActionGroup fGroup;

    public SelectWorkingSetAction(SearchScopeActionGroup group) {
        super(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
    }

    public void run() {
        try {
            IWorkingSet[] workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets();
            if (workingSets != null) {
                this.fGroup.setActiveWorkingSets(workingSets);
                SearchUtil.updateLRUWorkingSets(workingSets);
            } else {
                this.fGroup.setActiveWorkingSets(null);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

