/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.commands;

import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JavaElementReferenceConverter
extends AbstractParameterValueConverter {
    private static final char PROJECT_END_CHAR = '/';
    private static final char TYPE_END_CHAR = '#';
    private static final char PARAM_START_CHAR = '(';
    private static final char PARAM_END_CHAR = ')';

    public Object convertToObject(String parameterValue) throws ParameterValueConversionException {
        this.assertWellFormed(parameterValue != null);
        int projectEndPosition = parameterValue.indexOf(47);
        this.assertWellFormed(projectEndPosition != -1);
        String projectName = parameterValue.substring(0, projectEndPosition);
        String javaElementRef = parameterValue.substring(projectEndPosition + 1);
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.assertExists((IJavaElement)javaModel);
        IJavaProject javaProject = javaModel.getJavaProject(projectName);
        this.assertExists((IJavaElement)javaProject);
        int typeEndPosition = javaElementRef.indexOf(35);
        String typeName = typeEndPosition == -1 ? javaElementRef : javaElementRef.substring(0, typeEndPosition);
        IType type = null;
        try {
            type = javaProject.findType(typeName);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        this.assertExists((IJavaElement)type);
        if (typeEndPosition == -1) {
            return type;
        }
        String memberRef = javaElementRef.substring(typeEndPosition + 1);
        int paramStartPosition = memberRef.indexOf(40);
        if (paramStartPosition == -1) {
            IField field = type.getField(memberRef);
            this.assertExists((IJavaElement)field);
            return field;
        }
        String methodName = memberRef.substring(0, paramStartPosition);
        String signature = memberRef.substring(paramStartPosition);
        String[] parameterTypes = null;
        try {
            parameterTypes = Signature.getParameterTypes((String)signature);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.assertWellFormed(parameterTypes != null);
        IMethod method = type.getMethod(methodName, parameterTypes);
        this.assertExists((IJavaElement)method);
        return method;
    }

    private void assertWellFormed(boolean assertion) throws ParameterValueConversionException {
        if (!assertion) {
            throw new ParameterValueConversionException("Malformed parameterValue");
        }
    }

    private void assertExists(IJavaElement javaElement) throws ParameterValueConversionException {
        if (javaElement == null || !javaElement.exists()) {
            throw new ParameterValueConversionException("parameterValue must reference an existing IJavaElement");
        }
    }

    public String convertToString(Object parameterValue) throws ParameterValueConversionException {
        StringBuffer buffer;
        if (!(parameterValue instanceof IJavaElement)) {
            throw new ParameterValueConversionException("parameterValue must be an IJavaElement");
        }
        IJavaElement javaElement = (IJavaElement)parameterValue;
        IJavaProject javaProject = javaElement.getJavaProject();
        if (javaProject == null) {
            throw new ParameterValueConversionException("Could not get IJavaProject for element");
        }
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            buffer = this.composeTypeReference(type);
        } else if (javaElement instanceof IMethod) {
            IMethod method = (IMethod)javaElement;
            buffer = this.composeTypeReference(method.getDeclaringType());
            buffer.append('#');
            buffer.append(method.getElementName());
            String[] parameterTypes = method.getParameterTypes();
            buffer.append('(');
            int i = 0;
            while (i < parameterTypes.length) {
                buffer.append(parameterTypes[i]);
                ++i;
            }
            buffer.append(')');
        } else if (javaElement instanceof IField) {
            IField field = (IField)javaElement;
            buffer = this.composeTypeReference(field.getDeclaringType());
            buffer.append('#');
            buffer.append(field.getElementName());
        } else {
            throw new ParameterValueConversionException("Unsupported IJavaElement type");
        }
        return buffer.toString();
    }

    private StringBuffer composeTypeReference(IType type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(type.getJavaProject().getElementName());
        buffer.append('/');
        buffer.append(type.getFullyQualifiedName());
        return buffer;
    }
}

