/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.ExtractToNullCheckedLocalProposal;
import org.eclipse.jdt.internal.ui.fix.NullAnnotationsCleanUp;
import org.eclipse.jdt.internal.ui.fix.NullFixMessages;
import org.eclipse.jdt.internal.ui.fix.NullRewriteOperations;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullQuickFixes {
    public static void addReturnAndArgumentTypeProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        boolean isArgumentProblem = NullQuickFixes.isComplainingAboutArgument(selectedNode);
        if (isArgumentProblem || NullQuickFixes.isComplainingAboutReturn(selectedNode)) {
            NullQuickFixes.addNullAnnotationInSignatureProposal(context, problem, proposals, false, isArgumentProblem);
        }
    }

    public static void addNullAnnotationInSignatureProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals, boolean modifyOverridden, boolean isArgumentProblem) {
        MyCURewriteOperationsFix fix = NullQuickFixes.createNullAnnotationInSignatureFix(context.getASTRoot(), problem, modifyOverridden, isArgumentProblem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            if (fix.cu != context.getASTRoot()) {
                final CompilationUnit cu = fix.cu;
                final IInvocationContext originalContext = context;
                context = new IInvocationContext(){

                    public int getSelectionOffset() {
                        return originalContext.getSelectionOffset();
                    }

                    public int getSelectionLength() {
                        return originalContext.getSelectionLength();
                    }

                    public ASTNode getCoveringNode() {
                        return originalContext.getCoveringNode();
                    }

                    public ASTNode getCoveredNode() {
                        return originalContext.getCoveredNode();
                    }

                    public ICompilationUnit getCompilationUnit() {
                        return (ICompilationUnit)cu.getJavaElement();
                    }

                    public CompilationUnit getASTRoot() {
                        return cu;
                    }
                };
            }
            int relevance = modifyOverridden ? 9 : 10;
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new NullAnnotationsCleanUp(options, problem.getProblemId()), relevance, image, context);
            proposals.add(proposal);
        }
    }

    public static boolean isComplainingAboutArgument(ASTNode selectedNode) {
        if (!(selectedNode instanceof SimpleName)) {
            return false;
        }
        SimpleName nameNode = (SimpleName)selectedNode;
        IBinding binding = nameNode.resolveBinding();
        if (binding.getKind() == 3 && ((IVariableBinding)binding).isParameter()) {
            return true;
        }
        VariableDeclaration argDecl = (VariableDeclaration)ASTNodes.getParent(selectedNode, VariableDeclaration.class);
        if (argDecl != null) {
            binding = argDecl.resolveBinding();
        }
        return binding.getKind() == 3 && ((IVariableBinding)binding).isParameter();
    }

    public static boolean isComplainingAboutReturn(ASTNode selectedNode) {
        return selectedNode.getParent().getNodeType() == 41;
    }

    private static MyCURewriteOperationsFix createNullAnnotationInSignatureFix(CompilationUnit compilationUnit, IProblemLocation problem, boolean modifyOverridden, boolean isArgumentProblem) {
        String nullableAnnotationName = NullQuickFixes.getNullableAnnotationName(compilationUnit.getJavaElement(), false);
        String nonNullAnnotationName = NullQuickFixes.getNonNullAnnotationName(compilationUnit.getJavaElement(), false);
        String annotationToAdd = nullableAnnotationName;
        String annotationToRemove = nonNullAnnotationName;
        switch (problem.getProblemId()) {
            case 67109779: 
            case 67109780: {
                if (!modifyOverridden) break;
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
                break;
            }
            case 67109778: 
            case 67109781: {
                if (modifyOverridden) break;
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
                break;
            }
            case 16778126: 
            case 16778127: 
            case 16778128: 
            case 536871845: {
                if (!isArgumentProblem) break;
                annotationToAdd = nonNullAnnotationName;
                annotationToRemove = nullableAnnotationName;
            }
        }
        NullRewriteOperations.SignatureAnnotationRewriteOperation operation = NullRewriteOperations.createAddAnnotationOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, null, false, true, modifyOverridden);
        if (operation == null) {
            return null;
        }
        return new MyCURewriteOperationsFix(operation.getMessage(), operation.getCompilationUnit(), new NullRewriteOperations.SignatureAnnotationRewriteOperation[]{operation});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] locations, int problemID) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        if (!JavaModelUtil.is50OrHigher(cu.getJavaProject())) {
            return null;
        }
        ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> operations = new ArrayList<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation>();
        if (locations == null) {
            IProblem[] problems = compilationUnit.getProblems();
            locations = new IProblemLocation[problems.length];
            int i = 0;
            while (i < problems.length) {
                if (problems[i].getID() == problemID) {
                    locations[i] = new ProblemLocation(problems[i]);
                }
                ++i;
            }
        }
        NullQuickFixes.createAddNullAnnotationOperations(compilationUnit, locations, operations);
        if (operations.size() == 0) {
            return null;
        }
        CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operationsArray = operations.toArray(new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[operations.size()]);
        return new MyCURewriteOperationsFix(NullFixMessages.QuickFixes_add_annotation_change_name, compilationUnit, operationsArray);
    }

    private static void createAddNullAnnotationOperations(CompilationUnit compilationUnit, IProblemLocation[] locations, List<CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation> result) {
        String nullableAnnotationName = NullQuickFixes.getNullableAnnotationName(compilationUnit.getJavaElement(), false);
        String nonNullAnnotationName = NullQuickFixes.getNonNullAnnotationName(compilationUnit.getJavaElement(), false);
        HashSet<String> handledPositions = new HashSet<String>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation problem = locations[i];
            if (problem != null) {
                String annotationToAdd = nullableAnnotationName;
                String annotationToRemove = nonNullAnnotationName;
                switch (problem.getProblemId()) {
                    case 67109778: 
                    case 67109779: 
                    case 67109780: 
                    case 67109781: {
                        annotationToAdd = nonNullAnnotationName;
                        annotationToRemove = nullableAnnotationName;
                        break;
                    }
                    case 16778126: 
                    case 16778127: 
                    case 16778128: 
                    case 536871845: {
                        ASTNode selectedNode = problem.getCoveredNode(compilationUnit);
                        if (!NullQuickFixes.isComplainingAboutArgument(selectedNode)) break;
                        annotationToAdd = nonNullAnnotationName;
                        annotationToRemove = nullableAnnotationName;
                    }
                }
                NullRewriteOperations.SignatureAnnotationRewriteOperation fix = NullRewriteOperations.createAddAnnotationOperation(compilationUnit, problem, annotationToAdd, annotationToRemove, handledPositions, true, false, false);
                if (fix != null) {
                    result.add(fix);
                }
            }
            ++i;
        }
    }

    public static boolean hasExplicitNullAnnotation(ICompilationUnit compilationUnit, int offset) {
        return false;
    }

    public static String getNullableAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        int lastDot;
        String qualifiedName = javaElement.getJavaProject().getOption("org.eclipse.jdt.core.compiler.annotation.nullable", true);
        if (makeSimple && qualifiedName != null && (lastDot = qualifiedName.lastIndexOf(46)) != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    public static String getNonNullAnnotationName(IJavaElement javaElement, boolean makeSimple) {
        int lastDot;
        String qualifiedName = javaElement.getJavaProject().getOption("org.eclipse.jdt.core.compiler.annotation.nonnull", true);
        if (makeSimple && qualifiedName != null && (lastDot = qualifiedName.lastIndexOf(46)) != -1) {
            return qualifiedName.substring(lastDot + 1);
        }
        return qualifiedName;
    }

    public static void addExtractCheckedLocalProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        CompilationUnit compilationUnit = context.getASTRoot();
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode instanceof SimpleName) {
            ASTNode method = ASTNodes.getParent(selectedNode, MethodDeclaration.class);
            if (method == null) {
                method = ASTNodes.getParent(selectedNode, Initializer.class);
            }
            if (method != null) {
                proposals.add(new ExtractToNullCheckedLocalProposal(cu, compilationUnit, (SimpleName)selectedNode, method));
            }
        }
    }

    private static class MyCURewriteOperationsFix
    extends CompilationUnitRewriteOperationsFix {
        CompilationUnit cu;

        public MyCURewriteOperationsFix(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[] operations) {
            super(name, compilationUnit, operations);
            this.cu = compilationUnit;
        }
    }
}

