/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarimport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.filters.EmptyPackageFilter;
import org.eclipse.jdt.internal.ui.jarimport.JarImportData;
import org.eclipse.jdt.internal.ui.jarimport.JarImportMessages;
import org.eclipse.jdt.internal.ui.jarimport.JarImportWizard;
import org.eclipse.jdt.internal.ui.jarimport.RefactoringLocationControl;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.refactoring.binary.BinaryRefactoringHistoryWizard;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class JarImportWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "JarImportWizardPage";
    protected static final String SETTING_HISTORY = "org.eclipse.jdt.ui.refactoring.jarHistory";
    private boolean fFirstTime = true;
    private final boolean fImportWizard;
    private RefactoringLocationControl fLocationControl = null;
    private TreeViewer fTreeViewer = null;
    private final JarImportWizard fWizard;

    public JarImportWizardPage(JarImportWizard wizard, boolean importWizard) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)((Object)wizard));
        this.fWizard = wizard;
        this.fImportWizard = importWizard;
        if (this.fImportWizard) {
            this.setTitle(JarImportMessages.JarImportWizardPage_page_title);
            this.setDescription(JarImportMessages.JarImportWizardPage_page_description);
        } else {
            this.setTitle(JarImportMessages.JarImportWizardPage_page_replace_title);
            this.setDescription(JarImportMessages.JarImportWizardPage_page_replace_description);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createLocationGroup(composite);
        if (this.fImportWizard) {
            this.createInputGroup(composite);
        }
        this.createRenameGroup(composite);
        this.setPageComplete(false);
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            this.setMessage(JarImportMessages.JarImportWizardPage_no_jar_files, 1);
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_import_wizard_page_context");
    }

    protected GridData createGridData(int flag, int hspan, int indent) {
        GridData data = new GridData(flag);
        data.horizontalIndent = indent;
        data.horizontalSpan = hspan;
        return data;
    }

    protected void createInputGroup(Composite parent) {
        Assert.isNotNull((Object)parent);
        new Label(parent, 0);
        Label label = new Label(parent, 0);
        label.setText(JarImportMessages.JarImportWizardPage_import_message);
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof IJavaProject || element instanceof IJavaModel) {
                    return super.getChildren(element);
                }
                return new Object[0];
            }

            protected Object[] getJavaProjects(IJavaModel model) throws JavaModelException {
                HashSet<IJavaProject> set = new HashSet<IJavaProject>();
                IJavaProject[] projects = model.getJavaProjects();
                int index = 0;
                while (index < projects.length) {
                    Object[] roots;
                    if (JarImportWizard.isValidJavaProject(projects[index]) && (roots = this.getPackageFragmentRoots(projects[index])).length > 0) {
                        set.add(projects[index]);
                    }
                    ++index;
                }
                return set.toArray();
            }

            protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
                HashSet<IPackageFragmentRoot> set = new HashSet<IPackageFragmentRoot>();
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int offset = 0;
                while (offset < roots.length) {
                    IPackageFragmentRoot root = roots[offset];
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    if (JarImportWizard.isValidClassPathEntry(entry) && root.getResolvedClasspathEntry().getReferencingEntry() == null) {
                        set.add(root);
                    }
                    ++offset;
                }
                return set.toArray();
            }

            public boolean hasChildren(Object element) {
                return element instanceof IJavaProject || element instanceof IJavaModel;
            }
        };
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(272), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.fTreeViewer = new TreeViewer(parent, 2052);
        this.fTreeViewer.getTree().setLayoutData((Object)this.createGridData(1808, 6, 0));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTreeViewer.addFilter((ViewerFilter)new EmptyPackageFilter());
        this.fTreeViewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.fTreeViewer.setAutoExpandLevel(2);
        this.fTreeViewer.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        IPackageFragmentRoot root = this.fWizard.getPackageFragmentRoot();
        if (root != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{root}), true);
            this.fTreeViewer.expandToLevel((Object)root, 1);
        }
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        if (contentProvider.getChildren(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot())).length == 0) {
            this.fTreeViewer.getControl().setEnabled(false);
            label.setEnabled(false);
        }
    }

    protected void createLocationGroup(Composite parent) {
        Assert.isNotNull((Object)parent);
        new Label(parent, 0).setText(JarImportMessages.JarImportWizardPage_import_label);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(JarImportMessages.JarImportWizardPage_location_label);
        label.setLayoutData((Object)this.createGridData(32, 1, 0));
        this.fLocationControl = new RefactoringLocationControl((IWizard)this.fWizard, composite, SETTING_HISTORY);
        this.fLocationControl.setLayoutData(this.createGridData(768, 1, 0));
        this.fLocationControl.loadHistory();
        this.fLocationControl.getControl().addModifyListener(new ModifyListener(){

            public final void modifyText(ModifyEvent event) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        this.fLocationControl.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        this.fLocationControl.setFocus();
        Button button = new Button(composite, 8);
        button.setText(JarImportMessages.JarImportWizardPage_browse_button_label);
        button.setLayoutData((Object)this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                JarImportWizardPage.this.handleBrowseButtonSelected();
            }
        });
    }

    protected void createRenameGroup(Composite parent) {
        Assert.isNotNull((Object)parent);
        final JarImportData data = this.fWizard.getImportData();
        final Button button = new Button(parent, 32);
        button.setText(JarImportMessages.JarImportWizardPage_replace_jar_file);
        button.setSelection(!data.isRenameJarFile());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                data.setRenameJarFile(!button.getSelection());
            }
        });
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            button.setEnabled(false);
        }
        if (!this.fImportWizard) {
            GridData gd = new GridData();
            gd.horizontalIndent = 7;
            button.setLayoutData((Object)gd);
        }
    }

    protected void handleBrowseButtonSelected() {
        FileDialog file = new FileDialog(this.getShell(), 4096);
        file.setText(JarImportMessages.JarImportWizardPage_browse_caption);
        file.setFilterNames(ArchiveFileFilter.ALL_ARCHIVES_FILTER_EXTENSIONS);
        file.setFilterExtensions(ArchiveFileFilter.ALL_ARCHIVES_FILTER_EXTENSIONS);
        String path = file.open();
        if (path != null) {
            this.fLocationControl.setText(path);
            this.handleInputChanged();
        }
    }

    protected void handleInputChanged() {
        JarImportData data = this.fWizard.getImportData();
        data.setRefactoringHistory(null);
        data.setRefactoringFileLocation(null);
        this.setErrorMessage(null);
        this.setMessage(null, 0);
        this.setPageComplete(true);
        this.handleJarFileChanged();
        if (this.isPageComplete()) {
            this.handlePackageFragmentRootChanged();
        }
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            this.setErrorMessage(JarImportMessages.JarImportWizardPage_no_jar_files);
        }
        this.fFirstTime = false;
        this.getContainer().updateButtons();
    }

    /*
     * Exception decompiling
     */
    protected void handleJarFileChanged() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 42[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handlePackageFragmentRootChanged() {
        if (this.fTreeViewer != null) {
            IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
            Object[] elements = selection.toArray();
            if (elements.length != 1) {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_select_single_jar);
                this.setPageComplete(false);
                return;
            }
            JarImportData data = this.fWizard.getImportData();
            Object element = elements[0];
            if (element instanceof IPackageFragmentRoot) {
                data.setPackageFragmentRoot((IPackageFragmentRoot)element);
            } else if (element instanceof IPackageFragment) {
                data.setPackageFragmentRoot((IPackageFragmentRoot)((IJavaElement)element).getParent());
            } else {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_select_single_jar);
                this.setPageComplete(false);
            }
        }
    }

    protected void handleTimeStampChanged() {
        block16: {
            IPackageFragmentRoot root = this.fWizard.getPackageFragmentRoot();
            if (root != null) {
                try {
                    File file;
                    URI uri = BinaryRefactoringHistoryWizard.getLocationURI(root.getRawClasspathEntry());
                    if (uri == null || !(file = new File(uri)).exists()) break block16;
                    ZipFile zip = null;
                    try {
                        try {
                            zip = new ZipFile(file, 1);
                            ZipEntry entry = zip.getEntry(JarPackagerUtil.getRefactoringsEntry());
                            if (entry != null) {
                                this.fWizard.getImportData().setExistingTimeStamp(entry.getTime());
                            }
                        }
                        catch (IOException iOException) {
                            if (zip == null) break block16;
                            try {
                                zip.close();
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                    finally {
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            }
        }
    }

    public void performFinish() {
        this.fLocationControl.saveHistory();
    }

    public void setErrorMessage(String message) {
        if (!this.fFirstTime) {
            super.setErrorMessage(message);
        } else {
            this.setMessage(message, 0);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.handleInputChanged();
        }
    }
}

