/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocLinkDialogLabelProvider;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocLinkRef;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.jdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocStandardWizardPage
extends JavadocWizardPage {
    private final int STYLESHEETSTATUS = 1;
    private final int LINK_REFERENCES = 2;
    private JavadocOptionsManager fStore;
    private Composite fUpperComposite;
    private Group fBasicOptionsGroup;
    private Group fTagsGroup;
    private Button fTitleButton;
    private Text fTitleText;
    private Text fStyleSheetText;
    private FlaggedButton fDeprecatedList;
    private FlaggedButton fDeprecatedCheck;
    private FlaggedButton fIndexCheck;
    private FlaggedButton fSeperatedIndexCheck;
    private Button fStyleSheetBrowseButton;
    private Button fStyleSheetButton;
    private CheckedListDialogField<JavadocLinkRef> fListDialogField;
    private StatusInfo fStyleSheetStatus;
    private StatusInfo fLinkRefStatus;
    private ArrayList<FlaggedButton> fButtonsList;
    private JavadocTreeWizardPage fFirstPage;

    public JavadocStandardWizardPage(String pageName, JavadocTreeWizardPage firstPage, JavadocOptionsManager store) {
        super(pageName);
        this.fFirstPage = firstPage;
        this.setDescription(JavadocExportMessages.JavadocStandardWizardPage_description);
        this.fStore = store;
        this.fButtonsList = new ArrayList();
        this.fStyleSheetStatus = new StatusInfo();
        this.fLinkRefStatus = new StatusInfo();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fUpperComposite = new Composite(parent, 0);
        this.fUpperComposite.setFont(parent.getFont());
        this.fUpperComposite.setLayoutData((Object)this.createGridData(1808, 1, 0));
        GridLayout layout = this.createGridLayout(4);
        layout.marginHeight = 0;
        this.fUpperComposite.setLayout((Layout)layout);
        this.createBasicOptionsGroup(this.fUpperComposite);
        this.createTagOptionsGroup(this.fUpperComposite);
        this.createListDialogField(this.fUpperComposite);
        this.createStyleSheetGroup(this.fUpperComposite);
        this.setControl((Control)this.fUpperComposite);
        Dialog.applyDialogFont((Control)this.fUpperComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fUpperComposite, "org.eclipse.jdt.ui.javadoc_standard_page_context");
    }

    private void createBasicOptionsGroup(Composite composite) {
        this.fTitleButton = this.createButton(composite, 32, JavadocExportMessages.JavadocStandardWizardPage_titlebutton_label, this.createGridData(1));
        this.fTitleText = this.createText(composite, 2052, null, this.createGridData(768, 3, 0));
        SWTUtil.setAccessibilityText((Control)this.fTitleText, JavadocExportMessages.JavadocStandardWizardPage_titlebutton_description);
        String text = this.fStore.getTitle();
        if (!text.equals("")) {
            this.fTitleText.setText(text);
            this.fTitleButton.setSelection(true);
        } else {
            this.fTitleText.setEnabled(false);
        }
        this.fBasicOptionsGroup = new Group(composite, 16);
        this.fBasicOptionsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fBasicOptionsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fBasicOptionsGroup.setText(JavadocExportMessages.JavadocStandardWizardPage_basicgroup_label);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_usebutton_label, new GridData(768), this.fStore.USE, true);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_hierarchybutton_label, new GridData(768), this.fStore.NOTREE, false);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_navigartorbutton_label, new GridData(768), this.fStore.NONAVBAR, false);
        this.fIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_indexbutton_label, new GridData(768), this.fStore.NOINDEX, false);
        this.fSeperatedIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_seperateindexbutton_label, this.createGridData(512, 1, this.convertWidthInCharsToPixels(3)), this.fStore.SPLITINDEX, true);
        this.fSeperatedIndexCheck.getButton().setEnabled(this.fIndexCheck.getButton().getSelection());
        this.fIndexCheck.getButton().addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fSeperatedIndexCheck.getButton()}));
        this.fTitleButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fTitleText}));
    }

    private void createTagOptionsGroup(Composite composite) {
        this.fTagsGroup = new Group(composite, 16);
        this.fTagsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fTagsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fTagsGroup.setText(JavadocExportMessages.JavadocStandardWizardPage_tagsgroup_label);
        new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_authorbutton_label, new GridData(768), this.fStore.AUTHOR, true);
        new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_versionbutton_label, new GridData(768), this.fStore.VERSION, true);
        this.fDeprecatedCheck = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_deprecatedbutton_label, new GridData(768), this.fStore.NODEPRECATED, false);
        this.fDeprecatedList = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_deprecatedlistbutton_label, this.createGridData(768, 1, this.convertWidthInCharsToPixels(3)), this.fStore.NODEPRECATEDLIST, false);
        this.fDeprecatedList.getButton().setEnabled(this.fDeprecatedCheck.getButton().getSelection());
        this.fDeprecatedCheck.getButton().addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fDeprecatedList.getButton()}));
    }

    private void createStyleSheetGroup(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(768, 4, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        this.fStyleSheetButton = this.createButton(c, 32, JavadocExportMessages.JavadocStandardWizardPage_stylesheettext_label, this.createGridData(1));
        this.fStyleSheetText = this.createText(c, 2052, null, this.createGridData(768, 1, 0));
        SWTUtil.setAccessibilityText((Control)this.fStyleSheetText, JavadocExportMessages.JavadocStandardWizardPage_stylesheettext_description);
        ((GridData)this.fStyleSheetText.getLayoutData()).widthHint = 200;
        this.fStyleSheetBrowseButton = this.createButton(c, 8, JavadocExportMessages.JavadocStandardWizardPage_stylesheetbrowsebutton_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fStyleSheetBrowseButton);
        String str = this.fStore.getStyleSheet();
        if (str.equals("")) {
            this.fStyleSheetText.setEnabled(false);
            this.fStyleSheetBrowseButton.setEnabled(false);
        } else {
            this.fStyleSheetButton.setSelection(true);
            this.fStyleSheetText.setText(str);
        }
        this.fStyleSheetButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fStyleSheetText, this.fStyleSheetBrowseButton}){

            public void validate() {
                JavadocStandardWizardPage.this.doValidation(1);
            }
        });
        this.fStyleSheetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavadocStandardWizardPage.this.doValidation(1);
            }
        });
        this.fStyleSheetBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavadocStandardWizardPage.this.handleFileBrowseButtonPressed(JavadocStandardWizardPage.this.fStyleSheetText, new String[]{"*.css"}, JavadocExportMessages.JavadocSpecificsWizardPage_stylesheetbrowsedialog_title);
            }
        });
    }

    private void createListDialogField(Composite composite) {
        Composite c = new Composite(composite, 0);
        c.setFont(composite.getFont());
        c.setLayout((Layout)this.createGridLayout(3));
        c.setLayoutData((Object)this.createGridData(1808, 4, 0));
        ((GridLayout)c.getLayout()).marginWidth = 0;
        String[] buttonlabels = new String[]{JavadocExportMessages.JavadocStandardWizardPage_selectallbutton_label, JavadocExportMessages.JavadocStandardWizardPage_clearallbutton_label, JavadocExportMessages.JavadocStandardWizardPage_configurebutton_label};
        JavadocLinkDialogLabelProvider labelProvider = new JavadocLinkDialogLabelProvider();
        ListAdapter adapter = new ListAdapter();
        this.fListDialogField = new CheckedListDialogField<JavadocLinkRef>(adapter, buttonlabels, (ILabelProvider)labelProvider);
        this.fListDialogField.setDialogFieldListener(adapter);
        this.fListDialogField.setCheckAllButtonIndex(0);
        this.fListDialogField.setUncheckAllButtonIndex(1);
        this.fListDialogField.setViewerComparator(new ViewerComparator());
        this.createLabel(c, 0, JavadocExportMessages.JavadocStandardWizardPage_referencedclasses_label, this.createGridData(32, 4, 0));
        this.fListDialogField.doFillIntoGrid(c, 3);
        LayoutUtil.setHorizontalGrabbing(this.fListDialogField.getListControl(null));
        this.fListDialogField.enableButton(2, false);
    }

    private List<JavadocLinkRef> getCheckedReferences(JavadocLinkRef[] referencesClasses) {
        ArrayList<JavadocLinkRef> checkedElements = new ArrayList<JavadocLinkRef>();
        String[] hrefs = this.fStore.getHRefs();
        if (hrefs.length > 0) {
            HashSet<String> set = new HashSet<String>();
            int i = 0;
            while (i < hrefs.length) {
                set.add(hrefs[i]);
                ++i;
            }
            i = 0;
            while (i < referencesClasses.length) {
                JavadocLinkRef curr = referencesClasses[i];
                URL url = curr.getURL();
                if (url != null && set.contains(url.toExternalForm())) {
                    checkedElements.add(curr);
                }
                ++i;
            }
        }
        return checkedElements;
    }

    private JavadocLinkRef[] getReferencedElements(IJavaProject[] checkedProjects) {
        HashSet<JavadocLinkRef> result = new HashSet<JavadocLinkRef>();
        int i = 0;
        while (i < checkedProjects.length) {
            IJavaProject project = checkedProjects[i];
            try {
                this.collectReferencedElements(project, result);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
        return result.toArray(new JavadocLinkRef[result.size()]);
    }

    private void collectReferencedElements(IJavaProject project, HashSet<JavadocLinkRef> result) throws CoreException {
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project);
        int i = 0;
        while (i < unresolved.length) {
            IRuntimeClasspathEntry curr = unresolved[i];
            if (curr.getType() == 1) {
                result.add(new JavadocLinkRef(JavaCore.create((IProject)((IProject)curr.getResource()))));
            } else {
                IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)curr, (IJavaProject)project);
                int k = 0;
                while (k < entries.length) {
                    IClasspathEntry classpathEntry;
                    IRuntimeClasspathEntry entry = entries[k];
                    if (entry.getType() == 1) {
                        result.add(new JavadocLinkRef(JavaCore.create((IProject)((IProject)entry.getResource()))));
                    } else if (entry.getType() == 2 && (classpathEntry = entry.getClasspathEntry()) != null) {
                        IPath containerPath = null;
                        if (curr.getType() == 4) {
                            containerPath = curr.getPath();
                        }
                        result.add(new JavadocLinkRef(containerPath, classpathEntry, project));
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    final void doValidation(int VALIDATE) {
        block0 : switch (VALIDATE) {
            case 1: {
                this.fStyleSheetStatus = new StatusInfo();
                if (!this.fStyleSheetButton.getSelection()) break;
                String filename = this.fStyleSheetText.getText();
                if (filename.length() == 0) {
                    this.fStyleSheetStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewnotfound_error);
                    break;
                }
                File file = new File(filename);
                String ext = filename.substring(filename.lastIndexOf(46) + 1);
                if (!file.isFile()) {
                    this.fStyleSheetStatus.setError(JavadocExportMessages.JavadocStandardWizardPage_stylesheetnopath_error);
                    break;
                }
                if (ext.equalsIgnoreCase("css")) break;
                this.fStyleSheetStatus.setError(JavadocExportMessages.JavadocStandardWizardPage_stylesheetnotcss_error);
                break;
            }
            case 2: {
                this.fLinkRefStatus = new StatusInfo();
                List<JavadocLinkRef> list = this.fListDialogField.getCheckedElements();
                int i = 0;
                while (i < list.size()) {
                    JavadocLinkRef curr = list.get(i);
                    URL url = curr.getURL();
                    if (url == null) {
                        this.fLinkRefStatus.setWarning(JavadocExportMessages.JavadocStandardWizardPage_nolinkref_error);
                        break block0;
                    }
                    if ("jar".equals(url.getProtocol())) {
                        this.fLinkRefStatus.setWarning(JavadocExportMessages.JavadocStandardWizardPage_nojarlinkref_error);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fStyleSheetStatus, this.fLinkRefStatus});
    }

    public void updateStore() {
        if (this.fTitleButton.getSelection()) {
            this.fStore.setTitle(this.fTitleText.getText());
        } else {
            this.fStore.setTitle("");
        }
        Object[] buttons = this.fButtonsList.toArray();
        int i = 0;
        while (i < buttons.length) {
            FlaggedButton button = (FlaggedButton)buttons[i];
            if (button.getButton().getEnabled()) {
                this.fStore.setBoolean(button.getFlag(), !(button.getButton().getSelection() ^ button.show()));
            } else {
                this.fStore.setBoolean(button.getFlag(), !button.show());
            }
            ++i;
        }
        if (this.fStyleSheetText.getEnabled()) {
            this.fStore.setStyleSheet(this.fStyleSheetText.getText());
        } else {
            this.fStore.setStyleSheet("");
        }
        this.fStore.setHRefs(this.getHRefs());
    }

    private String[] getHRefs() {
        HashSet<String> res = new HashSet<String>();
        List<JavadocLinkRef> checked = this.fListDialogField.getCheckedElements();
        for (JavadocLinkRef element : checked) {
            URL url = element.getURL();
            if (url == null) continue;
            res.add(url.toExternalForm());
        }
        return res.toArray(new String[res.size()]);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.doValidation(1);
            this.updateHRefList(this.fFirstPage.getCheckedProjects());
        } else {
            this.updateStore();
        }
    }

    private void updateHRefList(IJavaProject[] checkedProjects) {
        JavadocLinkRef[] res = this.getReferencedElements(checkedProjects);
        this.fListDialogField.setElements(Arrays.asList(res));
        List<JavadocLinkRef> checked = this.getCheckedReferences(res);
        this.fListDialogField.setCheckedElements(checked);
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    private void doEditButtonPressed() {
        JavadocPropertyDialog jdialog;
        List selected = this.fListDialogField.getSelectedElements();
        if (selected.isEmpty()) {
            return;
        }
        JavadocLinkRef obj = (JavadocLinkRef)selected.get(0);
        if (obj != null && (jdialog = new JavadocPropertyDialog(this.getShell(), obj)).open() == 0) {
            this.fListDialogField.refresh();
        }
    }

    protected class FlaggedButton {
        private Button fButton;
        private String fFlag;
        private boolean fShowFlag;

        public FlaggedButton(Composite composite, String message, GridData gridData, String flag, boolean show) {
            this.fFlag = flag;
            this.fShowFlag = show;
            this.fButton = JavadocStandardWizardPage.this.createButton(composite, 32, message, gridData);
            JavadocStandardWizardPage.this.fButtonsList.add(this);
            this.setButtonSettings();
        }

        public Button getButton() {
            return this.fButton;
        }

        public String getFlag() {
            return this.fFlag;
        }

        public boolean show() {
            return this.fShowFlag;
        }

        private void setButtonSettings() {
            this.fButton.setSelection(!(JavadocStandardWizardPage.this.fStore.getBoolean(this.fFlag) ^ this.fShowFlag));
        }
    }

    private class JavadocPropertyDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private JavadocConfigurationBlock fJavadocConfigurationBlock;
        private JavadocLinkRef fElement;

        public JavadocPropertyDialog(Shell parent, JavadocLinkRef selection) {
            super(parent);
            this.setTitle(JavadocExportMessages.JavadocStandardWizardPage_javadocpropertydialog_title);
            this.fElement = selection;
            URL initialLocation = selection.getURL();
            this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(parent, this, initialLocation, selection.isProjectRef());
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Control inner = this.fJavadocConfigurationBlock.createContents(composite);
            inner.setLayoutData((Object)new GridData(1808));
            JavadocPropertyDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void statusChanged(IStatus status) {
            this.updateStatus(status);
        }

        protected void okPressed() {
            try {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        URL javadocLocation = JavadocPropertyDialog.this.fJavadocConfigurationBlock.getJavadocLocation();
                        JavadocPropertyDialog.this.fElement.setURL(javadocLocation, monitor);
                    }
                };
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
            }
            catch (InvocationTargetException e) {
                String title = JavadocExportMessages.JavadocStandardWizardPage_configurecontainer_error_title;
                String message = JavadocExportMessages.JavadocStandardWizardPage_configurecontainer_error_message;
                ExceptionHandler.handle(e, this.getShell(), title, message);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            JavadocStandardWizardPage.this.fListDialogField.refresh();
            JavadocStandardWizardPage.this.doValidation(2);
            super.okPressed();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.javadoc_property_dialog_context");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListAdapter
    implements IListAdapter<JavadocLinkRef>,
    IDialogFieldListener {
        private ListAdapter() {
        }

        @Override
        public void customButtonPressed(ListDialogField<JavadocLinkRef> field, int index) {
            if (index == 2) {
                JavadocStandardWizardPage.this.doEditButtonPressed();
            }
        }

        @Override
        public void selectionChanged(ListDialogField<JavadocLinkRef> field) {
            List selection = JavadocStandardWizardPage.this.fListDialogField.getSelectedElements();
            if (selection.size() != 1) {
                JavadocStandardWizardPage.this.fListDialogField.enableButton(2, false);
            } else {
                JavadocStandardWizardPage.this.fListDialogField.enableButton(2, true);
            }
        }

        @Override
        public void doubleClicked(ListDialogField<JavadocLinkRef> field) {
            JavadocStandardWizardPage.this.doEditButtonPressed();
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            JavadocStandardWizardPage.this.doValidation(2);
        }
    }
}

