/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.internal.corext.util.CollectionsUtil;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.jdt.internal.ui.search.BreakContinueTargetFinder;
import org.eclipse.jdt.internal.ui.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static ITypeRoot fLastInput;
    private static long fLastModStamp;
    private static IRegion fLastWordRegion;
    private static IJavaElement[] fLastElements;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<IHyperlink> links;
        block16: {
            IJavaElement[] elements;
            IRegion wordRegion;
            IAction openAction;
            ITextEditor textEditor;
            block15: {
                IEditorInput editorInput;
                IDocumentProvider documentProvider;
                ITypeRoot input;
                block14: {
                    IDocument document;
                    block13: {
                        textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
                        if (region == null || !(textEditor instanceof JavaEditor)) {
                            return null;
                        }
                        openAction = textEditor.getAction("OpenEditor");
                        if (!(openAction instanceof SelectionDispatchAction)) {
                            return null;
                        }
                        int offset = region.getOffset();
                        input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, false);
                        if (input == null) {
                            return null;
                        }
                        documentProvider = textEditor.getDocumentProvider();
                        editorInput = textEditor.getEditorInput();
                        document = documentProvider.getDocument((Object)editorInput);
                        wordRegion = JavaWordFinder.findWord(document, offset);
                        if (wordRegion != null && wordRegion.getLength() != 0) break block13;
                        return null;
                    }
                    if (!JavaElementHyperlinkDetector.isInheritDoc(document, wordRegion) || ((Object)((Object)this)).getClass() == JavaElementHyperlinkDetector.class) break block14;
                    return null;
                }
                if (JavaElementHyperlinkDetector.class == ((Object)((Object)this)).getClass() && JavaElementHyperlinkDetector.findBreakOrContinueTarget(input, region) != null) {
                    return new IHyperlink[]{new JavaElementHyperlink(wordRegion, (SelectionDispatchAction)openAction, null, false)};
                }
                long modStamp = documentProvider.getModificationStamp((Object)editorInput);
                if (input.equals(fLastInput) && modStamp == fLastModStamp && wordRegion.equals(fLastWordRegion)) {
                    elements = fLastElements;
                } else {
                    elements = input.codeSelect(wordRegion.getOffset(), wordRegion.getLength());
                    elements = this.selectOpenableElements(elements);
                    fLastInput = input;
                    fLastModStamp = modStamp;
                    fLastWordRegion = wordRegion;
                    fLastElements = elements;
                }
                if (elements.length != 0) break block15;
                return null;
            }
            try {
                links = new ArrayList<IHyperlink>(elements.length);
                int i = 0;
                while (i < elements.length) {
                    this.addHyperlinks(links, wordRegion, (SelectionDispatchAction)openAction, elements[i], elements.length > 1, (JavaEditor)textEditor);
                    ++i;
                }
                if (links.size() != 0) break block16;
                return null;
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        return CollectionsUtil.toArray(links, IHyperlink.class);
    }

    public void dispose() {
        super.dispose();
        fLastElements = null;
        fLastInput = null;
        fLastWordRegion = null;
    }

    private static boolean isInheritDoc(IDocument document, IRegion wordRegion) {
        try {
            String word = document.get(wordRegion.getOffset(), wordRegion.getLength());
            return "inheritDoc".equals(word);
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    protected void addHyperlinks(List<IHyperlink> hyperlinksCollector, IRegion wordRegion, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, JavaEditor editor) {
        hyperlinksCollector.add(new JavaElementHyperlink(wordRegion, openAction, element, qualify));
    }

    private IJavaElement[] selectOpenableElements(IJavaElement[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            switch (element.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: {
                    break;
                }
                default: {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    public static IOccurrencesFinder.OccurrenceLocation findBreakOrContinueTarget(ITypeRoot input, IRegion region) {
        IOccurrencesFinder.OccurrenceLocation[] locations;
        CompilationUnit astRoot = SharedASTProvider.getAST(input, SharedASTProvider.WAIT_NO, null);
        if (astRoot == null) {
            return null;
        }
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)region.getOffset(), (int)region.getLength());
        ASTNode breakOrContinueNode = null;
        boolean labelSelected = false;
        if (node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            StructuralPropertyDescriptor location = simpleName.getLocationInParent();
            if (location == ContinueStatement.LABEL_PROPERTY || location == BreakStatement.LABEL_PROPERTY) {
                breakOrContinueNode = simpleName.getParent();
                labelSelected = true;
            }
        } else if (node instanceof ContinueStatement || node instanceof BreakStatement) {
            breakOrContinueNode = node;
        }
        if (breakOrContinueNode == null) {
            return null;
        }
        BreakContinueTargetFinder finder = new BreakContinueTargetFinder();
        if (finder.initialize(astRoot, breakOrContinueNode) == null && (locations = finder.getOccurrences()) != null) {
            if (breakOrContinueNode instanceof BreakStatement && !labelSelected) {
                return locations[locations.length - 1];
            }
            return locations[0];
        }
        return null;
    }
}

