/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.javaeditor.OverrideIndicatorManager;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistLightBulbUpdater;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.VerticalRulerEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.SelectAnnotationRulerAction;

public class JavaSelectMarkerRulerAction2
extends SelectAnnotationRulerAction {
    public JavaSelectMarkerRulerAction2(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.java_select_marker_ruler_action");
    }

    public void annotationDefaultSelected(VerticalRulerEvent event) {
        Position position;
        Annotation annotation = event.getSelectedAnnotation();
        IAnnotationModel model = this.getAnnotationModel();
        if (this.isOverrideIndicator(annotation)) {
            ((OverrideIndicatorManager.OverrideIndicator)annotation).open();
            return;
        }
        if (this.isBreakpoint(annotation)) {
            this.triggerAction("RulerDoubleClick", event.getEvent());
        }
        if ((position = model.getPosition(annotation)) == null) {
            return;
        }
        if (this.isQuickFixTarget(annotation)) {
            ITextOperationTarget operation = (ITextOperationTarget)this.getTextEditor().getAdapter(ITextOperationTarget.class);
            int opCode = 22;
            if (operation != null && operation.canDoOperation(22)) {
                this.getTextEditor().selectAndReveal(position.getOffset(), position.getLength());
                operation.doOperation(22);
                return;
            }
        }
        super.annotationDefaultSelected(event);
    }

    private boolean isOverrideIndicator(Annotation annotation) {
        return annotation instanceof OverrideIndicatorManager.OverrideIndicator;
    }

    private boolean isBreakpoint(Annotation annotation) {
        return annotation.getType().equals("org.eclipse.debug.core.breakpoint") || annotation.getType().equals("org.eclipse.jdt.internal.ui.NoBreakpointAnnotation");
    }

    private boolean isQuickFixTarget(Annotation a) {
        return JavaCorrectionProcessor.hasCorrections(a) || a instanceof QuickAssistLightBulbUpdater.AssistAnnotation;
    }

    private void triggerAction(String actionID, Event event) {
        IAction action = this.getTextEditor().getAction(actionID);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (action instanceof ISelectionListener) {
                ((ISelectionListener)action).selectionChanged(null, null);
            }
            if (action.isEnabled()) {
                if (event == null) {
                    action.run();
                } else {
                    event.type = 8;
                    event.count = 2;
                    action.runWithEvent(event);
                }
            }
        }
    }
}

