/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.text.java.ProposalSorterHandle;
import org.eclipse.jdt.internal.ui.text.java.ProposalSorterRegistry;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CodeAssistConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_AUTOACTIVATION = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_autoactivation");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_AUTOACTIVATION_DELAY = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_autoactivation_delay");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_AUTOINSERT = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_autoinsert");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVA = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_autoactivation_triggers_java");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVADOC = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_autoactivation_triggers_javadoc");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_SHOW_VISIBLE_PROPOSALS = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_show_visible_proposals");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_SORTER = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_sorter");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_CASE_SENSITIVITY = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_case_sensitivity");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_ADDIMPORT = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_add_import");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_SUGGEST_STATIC_IMPORTS = CodeAssistConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.suggestStaticImports");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_INSERT_COMPLETION = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_insert_completion");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_FILL_ARGUMENT_NAMES = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_fill_method_arguments");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_GUESS_METHOD_ARGUMENTS = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_guess_method_arguments");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_PREFIX_COMPLETION = CodeAssistConfigurationBlock.getJDTUIKey("content_assist_prefix_completion");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_DEPRECATION_CHECK = CodeAssistConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.deprecationCheck");
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_CAMEL_CASE_MATCH = CodeAssistConfigurationBlock.getJDTCoreKey("org.eclipse.jdt.core.codeComplete.camelCaseMatch");
    private static final String[] trueFalse = new String[]{"true", "false"};
    private static final String[] enabledDisabled = new String[]{"enabled", "disabled"};
    private Button fCompletionInsertsRadioButton;
    private Button fCompletionOverwritesRadioButton;
    private Button fInsertParameterNamesRadioButton;
    private Button fInsertBestGuessRadioButton;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_CODEASSIST_AUTOACTIVATION, PREF_CODEASSIST_AUTOACTIVATION_DELAY, PREF_CODEASSIST_AUTOINSERT, PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVA, PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVADOC, PREF_CODEASSIST_SHOW_VISIBLE_PROPOSALS, PREF_CODEASSIST_SORTER, PREF_CODEASSIST_CASE_SENSITIVITY, PREF_CODEASSIST_ADDIMPORT, PREF_CODEASSIST_SUGGEST_STATIC_IMPORTS, PREF_CODEASSIST_INSERT_COMPLETION, PREF_CODEASSIST_FILL_ARGUMENT_NAMES, PREF_CODEASSIST_GUESS_METHOD_ARGUMENTS, PREF_CODEASSIST_PREFIX_COMPLETION, PREF_CODEASSIST_DEPRECATION_CHECK, PREF_CODEASSIST_CAMEL_CASE_MATCH};
    }

    public CodeAssistConfigurationBlock(IStatusChangeListener statusListener, IWorkbenchPreferenceContainer workbenchcontainer) {
        super(statusListener, null, CodeAssistConfigurationBlock.getAllKeys(), workbenchcontainer);
    }

    @Override
    protected Control createContents(Composite parent) {
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite control = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        control.setLayout((Layout)layout);
        Composite composite = this.createSubsection(control, PreferencesMessages.CodeAssistConfigurationBlock_insertionSection_title);
        this.addInsertionSection(composite);
        composite = this.createSubsection(control, PreferencesMessages.CodeAssistConfigurationBlock_sortingSection_title);
        this.addSortingSection(composite);
        composite = this.createSubsection(control, PreferencesMessages.CodeAssistConfigurationBlock_autoactivationSection_title);
        this.addAutoActivationSection(composite);
        this.initialize();
        scrolled.setContent((Control)control);
        Point size = control.computeSize(-1, -1);
        scrolled.setMinSize(size.x, size.y);
        return scrolled;
    }

    protected Composite createSubsection(Composite parent, String label) {
        Group group = new Group(parent, 32);
        group.setText(label);
        GridData data = new GridData(4, 0x1000000, true, false);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        return group;
    }

    private void addInsertionSection(Composite composite) {
        this.addCompletionRadioButtons(composite);
        String label = PreferencesMessages.JavaEditorPreferencePage_insertSingleProposalsAutomatically;
        this.addCheckBox(composite, label, PREF_CODEASSIST_AUTOINSERT, trueFalse, 0);
        label = PreferencesMessages.JavaEditorPreferencePage_completePrefixes;
        this.addCheckBox(composite, label, PREF_CODEASSIST_PREFIX_COMPLETION, trueFalse, 0);
        label = PreferencesMessages.JavaEditorPreferencePage_automaticallyAddImportInsteadOfQualifiedName;
        Button master = this.addCheckBox(composite, label, PREF_CODEASSIST_ADDIMPORT, trueFalse, 0);
        label = PreferencesMessages.JavaEditorPreferencePage_suggestStaticImports;
        Button slave = this.addCheckBoxWithLink(composite, label, PREF_CODEASSIST_SUGGEST_STATIC_IMPORTS, enabledDisabled, 20, -1, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistConfigurationBlock.this.openStaticImportFavoritesPage();
            }
        });
        CodeAssistConfigurationBlock.createSelectionDependency(master, (Control)slave.getParent());
        label = PreferencesMessages.JavaEditorPreferencePage_fillArgumentsOnMethodCompletion;
        master = this.addCheckBox(composite, label, PREF_CODEASSIST_FILL_ARGUMENT_NAMES, trueFalse, 0);
        Composite fillComposite = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        fillComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        fillComposite.setLayout((Layout)layout);
        SelectionAdapter completionSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = CodeAssistConfigurationBlock.this.fInsertBestGuessRadioButton.getSelection();
                CodeAssistConfigurationBlock.this.setValue(PREF_CODEASSIST_GUESS_METHOD_ARGUMENTS, state);
            }
        };
        this.fInsertParameterNamesRadioButton = new Button(fillComposite, 16400);
        this.fInsertParameterNamesRadioButton.setText(PreferencesMessages.JavaEditorPreferencePage_fillParameterNamesOnMethodCompletion);
        this.fInsertParameterNamesRadioButton.setLayoutData((Object)new GridData());
        this.fInsertParameterNamesRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        this.fInsertBestGuessRadioButton = new Button(fillComposite, 16400);
        this.fInsertBestGuessRadioButton.setText(PreferencesMessages.JavaEditorPreferencePage_fillBestGuessedArgumentsOnMethodCompletion);
        this.fInsertBestGuessRadioButton.setLayoutData((Object)new GridData());
        this.fInsertBestGuessRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        CodeAssistConfigurationBlock.createSelectionDependency(master, (Control)this.fInsertParameterNamesRadioButton);
        CodeAssistConfigurationBlock.createSelectionDependency(master, (Control)this.fInsertBestGuessRadioButton);
    }

    protected final void openStaticImportFavoritesPage() {
        if (this.getPreferenceContainer() != null) {
            this.getPreferenceContainer().openPage("org.eclipse.jdt.ui.preferences.CodeAssistPreferenceFavorites", null);
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.jdt.ui.preferences.CodeAssistPreferenceFavorites", null, null).open();
        }
    }

    protected static void createSelectionDependency(final Button master, final Control slave) {
        master.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                this.deepSetEnabled(slave, master.getSelection());
            }

            private void deepSetEnabled(Control control, boolean enabled) {
                control.setEnabled(enabled);
                if (control instanceof Composite) {
                    Control[] children = ((Composite)control).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.deepSetEnabled(children[i], enabled);
                        ++i;
                    }
                }
            }
        });
        slave.setEnabled(master.getSelection());
    }

    private void addSortingSection(Composite composite) {
        String label = PreferencesMessages.CodeAssistConfigurationBlock_typeFilters_link;
        this.createPreferencePageLink(composite, label, null);
        new Label(composite, 0);
        label = PreferencesMessages.JavaEditorPreferencePage_presentProposalsInAlphabeticalOrder;
        ProposalSorterHandle[] sorters = ProposalSorterRegistry.getDefault().getSorters();
        String[] labels = new String[sorters.length];
        String[] values = new String[sorters.length];
        int i = 0;
        while (i < sorters.length) {
            ProposalSorterHandle handle = sorters[i];
            labels[i] = handle.getName();
            values[i] = handle.getId();
            ++i;
        }
        this.addComboBox(composite, label, PREF_CODEASSIST_SORTER, values, labels, 0);
        label = PreferencesMessages.CodeAssistConfigurationBlock_matchCamelCase_label;
        this.addCheckBox(composite, label, PREF_CODEASSIST_CAMEL_CASE_MATCH, enabledDisabled, 0);
        label = PreferencesMessages.JavaEditorPreferencePage_showOnlyProposalsVisibleInTheInvocationContext;
        this.addCheckBox(composite, label, PREF_CODEASSIST_SHOW_VISIBLE_PROPOSALS, trueFalse, 0);
        label = PreferencesMessages.CodeAssistConfigurationBlock_hideDeprecated_label;
        this.addCheckBox(composite, label, PREF_CODEASSIST_DEPRECATION_CHECK, enabledDisabled, 0);
    }

    private void createPreferencePageLink(Composite composite, String label, final Map<String, String> targetInfo) {
        final Link link = new Link(composite, 0);
        link.setText(label);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)link.getShell(), (String)e.text, null, (Object)targetInfo);
            }
        });
    }

    private void addAutoActivationSection(Composite composite) {
        String label = PreferencesMessages.JavaEditorPreferencePage_enableAutoActivation;
        Button autoactivation = this.addCheckBox(composite, label, PREF_CODEASSIST_AUTOACTIVATION, trueFalse, 0);
        autoactivation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistConfigurationBlock.this.updateAutoactivationControls();
            }
        });
        label = PreferencesMessages.JavaEditorPreferencePage_autoActivationDelay;
        this.addLabelledTextField(composite, label, PREF_CODEASSIST_AUTOACTIVATION_DELAY, 4, 20);
        label = PreferencesMessages.JavaEditorPreferencePage_autoActivationTriggersForJava;
        this.addLabelledTextField(composite, label, PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVA, 100, 4, 20);
        label = PreferencesMessages.JavaEditorPreferencePage_autoActivationTriggersForJavaDoc;
        this.addLabelledTextField(composite, label, PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVADOC, 100, 4, 20);
    }

    protected Text addLabelledTextField(Composite parent, String label, OptionsConfigurationBlock.Key key, int textlimit, int indent) {
        return this.addLabelledTextField(parent, label, key, textlimit, textlimit, indent);
    }

    protected Text addLabelledTextField(Composite parent, String label, OptionsConfigurationBlock.Key key, int modelTextLimit, int fieldTextLimit, int indent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Label labelControl = new Label(parent, 0);
        labelControl.setText(label);
        GridData data = new GridData();
        data.horizontalIndent = indent;
        labelControl.setLayoutData((Object)data);
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        textBox.setLayoutData((Object)new GridData());
        this.fLabels.put(textBox, labelControl);
        String currValue = this.getValue(key);
        if (currValue != null) {
            textBox.setText(currValue);
        }
        textBox.addModifyListener(this.getTextModifyListener());
        data = new GridData(256);
        if (modelTextLimit != 0) {
            textBox.setTextLimit(modelTextLimit);
        }
        if (fieldTextLimit != 0) {
            data.widthHint = pixelConverter.convertWidthInCharsToPixels(fieldTextLimit + 1);
        }
        data.horizontalSpan = 2;
        textBox.setLayoutData((Object)data);
        this.fTextBoxes.add(textBox);
        return textBox;
    }

    private void addCompletionRadioButtons(Composite contentAssistComposite) {
        Composite completionComposite = new Composite(contentAssistComposite, 0);
        GridData ccgd = new GridData();
        ccgd.horizontalSpan = 2;
        completionComposite.setLayoutData((Object)ccgd);
        GridLayout ccgl = new GridLayout();
        ccgl.marginWidth = 0;
        ccgl.numColumns = 2;
        completionComposite.setLayout((Layout)ccgl);
        SelectionAdapter completionSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean insert = CodeAssistConfigurationBlock.this.fCompletionInsertsRadioButton.getSelection();
                CodeAssistConfigurationBlock.this.setValue(PREF_CODEASSIST_INSERT_COMPLETION, insert);
            }
        };
        this.fCompletionInsertsRadioButton = new Button(completionComposite, 16400);
        this.fCompletionInsertsRadioButton.setText(PreferencesMessages.JavaEditorPreferencePage_completionInserts);
        this.fCompletionInsertsRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionInsertsRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        this.fCompletionOverwritesRadioButton = new Button(completionComposite, 16400);
        this.fCompletionOverwritesRadioButton.setText(PreferencesMessages.JavaEditorPreferencePage_completionOverwrites);
        this.fCompletionOverwritesRadioButton.setLayoutData((Object)new GridData());
        this.fCompletionOverwritesRadioButton.addSelectionListener((SelectionListener)completionSelectionListener);
        Label label = new Label(completionComposite, 0);
        label.setText(PreferencesMessages.JavaEditorPreferencePage_completionToggleHint);
        GridData gd = new GridData();
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
    }

    public void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        boolean value = this.getBooleanValue(PREF_CODEASSIST_INSERT_COMPLETION);
        this.fCompletionInsertsRadioButton.setSelection(value);
        this.fCompletionOverwritesRadioButton.setSelection(!value);
        value = this.getBooleanValue(PREF_CODEASSIST_GUESS_METHOD_ARGUMENTS);
        this.fInsertBestGuessRadioButton.setSelection(value);
        this.fInsertParameterNamesRadioButton.setSelection(!value);
        value = this.getBooleanValue(PREF_CODEASSIST_FILL_ARGUMENT_NAMES);
        this.fInsertParameterNamesRadioButton.setEnabled(value);
        this.fInsertBestGuessRadioButton.setEnabled(value);
        this.updateAutoactivationControls();
    }

    private void updateAutoactivationControls() {
        boolean autoactivation = this.getBooleanValue(PREF_CODEASSIST_AUTOACTIVATION);
        this.setControlEnabled(PREF_CODEASSIST_AUTOACTIVATION_DELAY, autoactivation);
        this.setControlEnabled(PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVA, autoactivation);
        this.setControlEnabled(PREF_CODEASSIST_AUTOACTIVATION_TRIGGERS_JAVADOC, autoactivation);
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.initializeFields();
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected static IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.SpellingPreferencePage_empty_threshold);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
                }
            }
            catch (NumberFormatException exception) {
                status.setError(Messages.format(PreferencesMessages.SpellingPreferencePage_invalid_threshold, number));
            }
        }
        return status;
    }

    @Override
    protected void validateSettings(OptionsConfigurationBlock.Key key, String oldValue, String newValue) {
        if (key == null || PREF_CODEASSIST_AUTOACTIVATION_DELAY.equals(key)) {
            this.fContext.statusChanged(CodeAssistConfigurationBlock.validatePositiveNumber(this.getValue(PREF_CODEASSIST_AUTOACTIVATION_DELAY)));
        }
    }

    protected void setControlEnabled(OptionsConfigurationBlock.Key key, boolean enabled) {
        Control control = this.getControl(key);
        control.setEnabled(enabled);
        Label label = (Label)this.fLabels.get(control);
        if (label != null) {
            label.setEnabled(enabled);
        }
    }

    private Control getControl(OptionsConfigurationBlock.Key key) {
        OptionsConfigurationBlock.ControlData data;
        Control curr;
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            curr = (Control)this.fComboBoxes.get(i);
            data = (OptionsConfigurationBlock.ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            curr = (Control)this.fCheckBoxes.get(i);
            data = (OptionsConfigurationBlock.ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            curr = (Control)this.fTextBoxes.get(i);
            OptionsConfigurationBlock.Key currKey = (OptionsConfigurationBlock.Key)curr.getData();
            if (key.equals(currKey)) {
                return curr;
            }
            --i;
        }
        return null;
    }
}

