/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffOnTagsTabPage
extends FormatterTabPage {
    public OffOnTagsTabPage(ModifyDialog modifyDialog, Map<String, String> workingValues) {
        super(modifyDialog, workingValues);
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        OffOnTagsTabPage.createLabel(numColumns, composite, FormatterMessages.OffOnTagsTabPage_description);
        Label separator = new Label(composite, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, numColumns, 1);
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        final ModifyDialogTabPage.CheckboxPreference enablePref = this.createCheckboxPref(composite, numColumns, FormatterMessages.OffOnTagsTabPage_enableOffOnTags, "org.eclipse.jdt.core.formatter.use_on_off_tags", FALSE_TRUE);
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String input) {
                if (input.length() == 0) {
                    return null;
                }
                if (Character.isWhitespace(input.charAt(0))) {
                    return FormatterMessages.OffOnTagsTabPage_error_startsWithWhitespace;
                }
                if (Character.isWhitespace(input.charAt(input.length() - 1))) {
                    return FormatterMessages.OffOnTagsTabPage_error_endsWithWhitespace;
                }
                return null;
            }
        };
        Composite tagComposite = new Composite(composite, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = indent;
        tagComposite.setLayout((Layout)layout);
        final ModifyDialogTabPage.StringPreference disableTagPref = this.createStringPref(tagComposite, numColumns, FormatterMessages.OffOnTagsTabPage_disableTag, "org.eclipse.jdt.core.formatter.disabling_tag", inputValidator);
        final ModifyDialogTabPage.StringPreference enableTagPref = this.createStringPref(tagComposite, numColumns, FormatterMessages.OffOnTagsTabPage_enableTag, "org.eclipse.jdt.core.formatter.enabling_tag", inputValidator);
        enablePref.getControl().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean enabled = enablePref.getChecked();
                enableTagPref.setEnabled(enabled);
                disableTagPref.setEnabled(enabled);
            }
        });
        boolean enabled = enablePref.getChecked();
        enableTagPref.setEnabled(enabled);
        disableTagPref.setEnabled(enabled);
    }

    @Override
    public final Composite createContents(Composite parent) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData());
        int numColumns = 2;
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        this.doCreatePreferences(composite, 2);
        return composite;
    }

    @Override
    protected void initializePage() {
    }

    @Override
    protected void doUpdatePreview() {
    }

    @Override
    protected JavaPreview doCreateJavaPreview(Composite parent) {
        return null;
    }
}

