/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.EscapeBackslashCompletionProposal;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesCorrectionProcessor;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEscapes;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.progress.WorkbenchJob;

public class PropertiesFileAutoEditStrategy
implements IAutoEditStrategy {
    private final IFile fFile;
    private String fCharsetName;
    private CharsetEncoder fCharsetEncoder;
    private final ISourceViewer fSourceViewer;

    public PropertiesFileAutoEditStrategy(IFile file, ISourceViewer sourceViewer) {
        this.fFile = file;
        this.fSourceViewer = sourceViewer;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        this.showProposal(this.escape(command), document);
    }

    private ICompletionProposal escape(DocumentCommand command) {
        boolean escapeBackslash;
        try {
            String charsetName = this.fFile.getCharset();
            if (!charsetName.equals(this.fCharsetName)) {
                this.fCharsetName = charsetName;
                this.fCharsetEncoder = Charset.forName(this.fCharsetName).newEncoder();
            }
        }
        catch (CoreException e) {
            return null;
        }
        String text = command.text;
        boolean escapeUnicodeChars = !this.fCharsetEncoder.canEncode(text);
        boolean bl = escapeBackslash = text.length() > 1 && (escapeUnicodeChars && PropertiesFileEscapes.containsUnescapedBackslash(text) || PropertiesFileEscapes.containsInvalidEscapeSequence(text));
        if (!escapeUnicodeChars && !escapeBackslash) {
            return null;
        }
        command.text = PropertiesFileEscapes.escape(text, false, false, escapeUnicodeChars);
        if (escapeBackslash) {
            String proposalText = PropertiesFileEscapes.escape(text, false, true, escapeUnicodeChars);
            return new EscapeBackslashCompletionProposal(proposalText, command.offset, command.text.length(), PropertiesFileEditorMessages.EscapeBackslashCompletionProposal_escapeBackslashesInOriginalString);
        }
        return null;
    }

    private void showProposal(final ICompletionProposal proposal, final IDocument document) {
        if (proposal != null && this.fSourceViewer instanceof ISourceViewerExtension3) {
            final WorkbenchJob job = new WorkbenchJob(PropertiesFileEditorMessages.PropertiesFileAutoEditStrategy_showQuickAssist){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IQuickAssistAssistant assistant = ((ISourceViewerExtension3)PropertiesFileAutoEditStrategy.this.fSourceViewer).getQuickAssistAssistant();
                    IQuickAssistProcessor processor = assistant.getQuickAssistProcessor();
                    if (processor instanceof PropertiesCorrectionProcessor) {
                        ((PropertiesCorrectionProcessor)processor).setProposals(new ICompletionProposal[]{proposal});
                        assistant.showPossibleQuickAssists();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule(500L);
            final StyledText textWidget = this.fSourceViewer.getTextWidget();
            textWidget.addVerifyKeyListener(new VerifyKeyListener(){

                public void verifyKey(VerifyEvent event) {
                    job.cancel();
                    textWidget.removeVerifyKeyListener((VerifyKeyListener)this);
                }
            });
            IDocumentListener documentListener = new IDocumentListener(){
                private boolean pasteComplete = false;

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (this.pasteComplete) {
                        job.cancel();
                        document.removeDocumentListener((IDocumentListener)this);
                    }
                    this.pasteComplete = true;
                }
            };
            document.addDocumentListener(documentListener);
        }
    }
}

