/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.search.LRUWorkingSetsList;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetComparator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class SearchUtil {
    public static final int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSetsList fgLRUWorkingSets;
    private static final String DIALOG_SETTINGS_KEY = "JavaElementSearchActions";
    private static final String STORE_LRU_WORKING_SET_NAMES = "lastUsedWorkingSetNames";
    private static final String BIN_PRIM_CONST_WARN_DIALOG_ID = "BinaryPrimitiveConstantWarningDialog";

    public static boolean isSearchPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.search").getState() == 32;
    }

    public static void runQueryInBackground(Object query) {
        NewSearchUI.runQueryInBackground((ISearchQuery)((ISearchQuery)query));
    }

    public static IStatus runQueryInForeground(IRunnableContext context, Object query) {
        return NewSearchUI.runQueryInForeground((IRunnableContext)context, (ISearchQuery)((ISearchQuery)query));
    }

    static ICompilationUnit findCompilationUnit(IJavaElement element) {
        if (element == null) {
            return null;
        }
        return (ICompilationUnit)element.getAncestor(5);
    }

    public static String toString(IWorkingSet[] workingSets) {
        Arrays.sort(workingSets, new WorkingSetComparator());
        String result = "";
        if (workingSets != null && workingSets.length > 0) {
            boolean firstFound = false;
            int i = 0;
            while (i < workingSets.length) {
                String workingSetLabel = BasicElementLabels.getWorkingSetLabel(workingSets[i]);
                if (firstFound) {
                    result = Messages.format(SearchMessages.SearchUtil_workingSetConcatenation, new String[]{result, workingSetLabel});
                } else {
                    result = workingSetLabel;
                    firstFound = true;
                }
                ++i;
            }
        }
        return result;
    }

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        SearchUtil.getLRUWorkingSets().add(workingSets);
        SearchUtil.saveState(SearchUtil.getDialogStoreSection());
    }

    private static void saveState(IDialogSettings settingsStore) {
        Iterator<IWorkingSet[]> iter = fgLRUWorkingSets.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IWorkingSet[] workingSets = iter.next();
            String[] names = new String[workingSets.length];
            int j = 0;
            while (j < workingSets.length) {
                names[j] = workingSets[j].getName();
                ++j;
            }
            settingsStore.put(STORE_LRU_WORKING_SET_NAMES + i, names);
            ++i;
        }
    }

    public static LRUWorkingSetsList getLRUWorkingSets() {
        if (fgLRUWorkingSets == null) {
            SearchUtil.restoreState();
        }
        return fgLRUWorkingSets;
    }

    private static void restoreState() {
        fgLRUWorkingSets = new LRUWorkingSetsList(3);
        IDialogSettings settingsStore = SearchUtil.getDialogStoreSection();
        boolean foundLRU = false;
        int i = 2;
        while (i >= 0) {
            String[] lruWorkingSetNames = settingsStore.getArray(STORE_LRU_WORKING_SET_NAMES + i);
            if (lruWorkingSetNames != null) {
                HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(2);
                int j = 0;
                while (j < lruWorkingSetNames.length) {
                    IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[j]);
                    if (workingSet != null) {
                        workingSets.add(workingSet);
                    }
                    ++j;
                }
                foundLRU = true;
                if (!workingSets.isEmpty()) {
                    fgLRUWorkingSets.add(workingSets.toArray(new IWorkingSet[workingSets.size()]));
                }
            }
            --i;
        }
        if (!foundLRU) {
            SearchUtil.restoreFromOldFormat();
        }
    }

    private static IDialogSettings getDialogStoreSection() {
        IDialogSettings settingsStore = JavaPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
        if (settingsStore == null) {
            settingsStore = JavaPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
        }
        return settingsStore;
    }

    private static void restoreFromOldFormat() {
        fgLRUWorkingSets = new LRUWorkingSetsList(3);
        IDialogSettings settingsStore = SearchUtil.getDialogStoreSection();
        boolean foundLRU = false;
        String[] lruWorkingSetNames = settingsStore.getArray(STORE_LRU_WORKING_SET_NAMES);
        if (lruWorkingSetNames != null) {
            int i = lruWorkingSetNames.length - 1;
            while (i >= 0) {
                IWorkingSet workingSet = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(lruWorkingSetNames[i]);
                if (workingSet != null) {
                    foundLRU = true;
                    fgLRUWorkingSets.add(new IWorkingSet[]{workingSet});
                }
                --i;
            }
        }
        if (foundLRU) {
            SearchUtil.saveState(settingsStore);
        }
    }

    public static void warnIfBinaryConstant(IJavaElement element, Shell shell) {
        if (SearchUtil.isPrimitiveConstantOrString(element)) {
            OptionalMessageDialog.open(BIN_PRIM_CONST_WARN_DIALOG_ID, shell, SearchMessages.Search_FindReferencesAction_BinPrimConstWarnDialog_title, null, SearchMessages.Search_FindReferencesAction_BinPrimConstWarnDialog_message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
        }
    }

    private static boolean isPrimitiveConstantOrString(IJavaElement element) {
        if (element != null && element.getElementType() == 8) {
            int flags;
            IField field = (IField)element;
            try {
                flags = field.getFlags();
            }
            catch (JavaModelException ex) {
                return false;
            }
            return Flags.isStatic((int)flags) && Flags.isFinal((int)flags) && SearchUtil.isPrimitiveOrString(field);
        }
        return false;
    }

    private static boolean isPrimitiveOrString(IField field) {
        String fieldType;
        try {
            fieldType = field.getTypeSignature();
        }
        catch (JavaModelException ex) {
            return false;
        }
        char first = fieldType.charAt(0);
        return first != 'L' && first != 'Q' && first != '[' || (first == 'L' || first == 'Q') && fieldType.substring(1, fieldType.length() - 1).equals(String.class.getName()) || first == 'Q' && fieldType.substring(1, fieldType.length() - 1).equals("String");
    }
}

