/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

class ChangeHoverInformationControl
extends SourceViewerInformationControl {
    private static final String SYMBOLIC_FONT_NAME = "org.eclipse.jdt.ui.editors.textfont";
    int fMaxWidth = Integer.MAX_VALUE;
    int fMaxHeight = Integer.MAX_VALUE;
    private String fPartition;
    private int fHorizontalScrollPixel;

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public ChangeHoverInformationControl(Shell parent, boolean isResizable, int orientation, String partition, String statusFieldText) {
        super(parent, isResizable, orientation, statusFieldText);
        this.setViewerFont();
        this.setStartingPartitionType(partition);
    }

    public Point computeSizeHint() {
        Point size = super.computeSizeHint();
        size.x = Math.min(size.x, this.fMaxWidth);
        size.y = Math.min(size.y, this.fMaxHeight);
        return size;
    }

    private void setViewerFont() {
        Font font = JFaceResources.getFont((String)SYMBOLIC_FONT_NAME);
        if (this.getViewer().getDocument() != null) {
            StyledText styledText;
            Point selection = this.getViewer().getSelectedRange();
            int topIndex = this.getViewer().getTopIndex();
            StyledText parent = styledText = this.getViewer().getTextWidget();
            if (this.getViewer() instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)this.getViewer();
                parent = extension.getControl();
            }
            parent.setRedraw(false);
            styledText.setFont(font);
            this.getViewer().setSelectedRange(selection.x, selection.y);
            this.getViewer().setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = this.getViewer().getTextWidget();
            styledText.setFont(font);
        }
    }

    public void setStartingPartitionType(String partition) {
        this.fPartition = partition == null ? "__dftl_partition_content_type" : partition;
    }

    public void setInformation(String content) {
        super.setInformation(content);
        IDocument doc = this.getViewer().getDocument();
        if (doc == null) {
            return;
        }
        this.ensureScrollable();
        String start = null;
        if ("__java_javadoc".equals(this.fPartition)) {
            start = "/**" + doc.getLegalLineDelimiters()[0];
        } else if ("__java_multiline_comment".equals(this.fPartition)) {
            start = "/*" + doc.getLegalLineDelimiters()[0];
        }
        if (start != null) {
            try {
                doc.replace(0, 0, start);
                int startLen = start.length();
                this.getViewer().setDocument(doc, startLen, doc.getLength() - startLen);
            }
            catch (BadLocationException e) {
                Assert.isTrue((boolean)false);
            }
        }
        this.getViewer().getTextWidget().setHorizontalPixel(this.fHorizontalScrollPixel);
    }

    private void ensureScrollable() {
        IDocument doc = this.getViewer().getDocument();
        if (doc == null) {
            return;
        }
        StyledText widget = this.getViewer().getTextWidget();
        if (widget == null || widget.isDisposed()) {
            return;
        }
        int last = doc.getNumberOfLines() - 1;
        GC gc = new GC((Drawable)widget);
        gc.setFont(widget.getFont());
        int maxWidth = 0;
        String content = new String();
        try {
            try {
                int i = 0;
                while (i <= last) {
                    IRegion line = doc.getLineInformation(i);
                    content = doc.get(line.getOffset(), line.getLength());
                    int width = gc.textExtent((String)content).x;
                    if (width > maxWidth) {
                        maxWidth = width;
                    }
                    ++i;
                }
            }
            catch (BadLocationException e) {
                gc.dispose();
                return;
            }
        }
        finally {
            gc.dispose();
        }
        this.fMaxWidth = Math.max(0, Math.min(this.fMaxWidth, maxWidth - this.fHorizontalScrollPixel + 8));
    }

    public boolean hasContents() {
        return super.hasContents() && this.fMaxWidth > 0;
    }

    public void setHorizontalScrollPixel(int scrollIndex) {
        this.fHorizontalScrollPixel = scrollIndex = Math.max(0, scrollIndex);
    }
}

