/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class CorrectionCommandHandler
extends AbstractHandler {
    private final JavaEditor fEditor;
    private final String fId;
    private final boolean fIsAssist;

    public CorrectionCommandHandler(JavaEditor editor, String id, boolean isAssist) {
        this.fEditor = editor;
        this.fId = id;
        this.fIsAssist = isAssist;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doExecute();
        return null;
    }

    public boolean doExecute() {
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(this.fEditor.getEditorInput());
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (selection instanceof ITextSelection && cu != null && model != null) {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return false;
            }
            ICompletionProposal proposal = this.findCorrection(this.fId, this.fIsAssist, (ITextSelection)selection, cu, model);
            if (proposal != null) {
                this.invokeProposal(proposal, ((ITextSelection)selection).getOffset());
                return true;
            }
        }
        return false;
    }

    private ICompletionProposal findCorrection(String id, boolean isAssist, ITextSelection selection, ICompilationUnit cu, IAnnotationModel model) {
        AssistContext context = new AssistContext(cu, this.fEditor.getViewer(), (IEditorPart)this.fEditor, selection.getOffset(), selection.getLength());
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>(10);
        if (isAssist) {
            if (id.equals("org.eclipse.jdt.ui.correction.renameInFile.assist")) {
                return this.getLocalRenameProposal(context);
            }
            JavaCorrectionProcessor.collectAssists(context, new ProblemLocation[0], proposals);
        } else {
            try {
                boolean goToClosest = selection.getLength() == 0;
                Annotation[] annotationArray = this.getAnnotations(selection.getOffset(), goToClosest);
                JavaCorrectionProcessor.collectProposals(context, model, annotationArray, true, false, proposals);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        for (Object e : proposals) {
            if (!(e instanceof ICommandAccess) || !id.equals(((ICommandAccess)e).getCommandId())) continue;
            return (ICompletionProposal)e;
        }
        return null;
    }

    private Annotation[] getAnnotations(int offset, boolean goToClosest) throws BadLocationException {
        ArrayList<Annotation> resultingAnnotations = new ArrayList<Annotation>();
        JavaCorrectionAssistant.collectQuickFixableAnnotations((ITextEditor)this.fEditor, offset, goToClosest, resultingAnnotations);
        return resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
    }

    private ICompletionProposal getLocalRenameProposal(IInvocationContext context) {
        ASTNode node = context.getCoveringNode();
        if (node instanceof SimpleName) {
            return new LinkedNamesAssistProposal(context, (SimpleName)node);
        }
        return null;
    }

    private IDocument getDocument() {
        return JavaUI.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
    }

    private void invokeProposal(ICompletionProposal proposal, int offset) {
        IDocument document;
        if (proposal instanceof ICompletionProposalExtension2) {
            ISourceViewer viewer = this.fEditor.getViewer();
            if (viewer != null) {
                ((ICompletionProposalExtension2)proposal).apply((ITextViewer)viewer, '\u0000', 0, offset);
                return;
            }
        } else if (proposal instanceof ICompletionProposalExtension && (document = this.getDocument()) != null) {
            ((ICompletionProposalExtension)proposal).apply(document, '\u0000', offset);
            return;
        }
        if ((document = this.getDocument()) != null) {
            proposal.apply(document);
        }
    }

    public static String getShortCutString(String proposalId) {
        TriggerSequence[] activeBindingsFor;
        IBindingService bindingService;
        if (proposalId != null && (bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)) != null && (activeBindingsFor = bindingService.getActiveBindingsFor(proposalId)).length > 0) {
            return activeBindingsFor[0].format();
        }
        return null;
    }
}

