/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.internal.corext.codemanipulation.AddImportsOperation;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.MoveCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUp;
import org.eclipse.jdt.internal.ui.javaeditor.AddImportOnSelectionAction;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.preferences.BuildPathsPropertyPage;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectMainTypeNameProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CorrectPackageDeclarationProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathFixSelectionDialog;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.OrganizeImportsAction;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReorgCorrectionsSubProcessor {
    public static void getWrongTypeNameProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        IJavaProject javaProject = cu.getJavaProject();
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        String compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        CompilationUnit root = context.getASTRoot();
        ASTNode coveredNode = problem.getCoveredNode(root);
        if (!(coveredNode instanceof SimpleName)) {
            return;
        }
        ASTNode parentType = coveredNode.getParent();
        if (!(parentType instanceof AbstractTypeDeclaration)) {
            return;
        }
        String currTypeName = ((SimpleName)coveredNode).getIdentifier();
        String newTypeName = JavaCore.removeJavaLikeExtension((String)cu.getElementName());
        boolean hasOtherPublicTypeBefore = false;
        boolean found = false;
        List types = root.types();
        int i = 0;
        while (i < types.size()) {
            AbstractTypeDeclaration curr = (AbstractTypeDeclaration)types.get(i);
            if (parentType != curr) {
                if (newTypeName.equals(curr.getName().getIdentifier())) {
                    return;
                }
                if (!found && Modifier.isPublic((int)curr.getModifiers())) {
                    hasOtherPublicTypeBefore = true;
                }
            } else {
                found = true;
            }
            ++i;
        }
        if (!JavaConventions.validateJavaTypeName((String)newTypeName, (String)sourceLevel, (String)compliance).matches(4)) {
            proposals.add(new CorrectMainTypeNameProposal(cu, context, currTypeName, newTypeName, 5));
        }
        if (!hasOtherPublicTypeBefore) {
            String newCUName = JavaModelUtil.getRenamedCUName(cu, currTypeName);
            ICompilationUnit newCU = ((IPackageFragment)cu.getParent()).getCompilationUnit(newCUName);
            if (!(newCU.exists() || isLinked || JavaConventions.validateCompilationUnitName((String)newCUName, (String)sourceLevel, (String)compliance).matches(4))) {
                RenameCompilationUnitChange change = new RenameCompilationUnitChange(cu, newCUName);
                String label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_renamecu_description, BasicElementLabels.getResourceName(newCUName));
                proposals.add(new ChangeCorrectionProposal(label, (Change)change, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif")));
            }
        }
    }

    public static void getWrongPackageDeclNameProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean isLinked = cu.getResource().isLinked();
        int relevance = cu.getPackageDeclarations().length == 0 ? 7 : 5;
        proposals.add(new CorrectPackageDeclarationProposal(cu, problem, relevance));
        IPackageDeclaration[] packDecls = cu.getPackageDeclarations();
        String newPackName = packDecls.length > 0 ? packDecls[0].getElementName() : "";
        IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)cu);
        IPackageFragment newPack = root.getPackageFragment(newPackName);
        ICompilationUnit newCU = newPack.getCompilationUnit(cu.getElementName());
        if (!newCU.exists() && !isLinked) {
            String label;
            if (newPack.isDefaultPackage()) {
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_default_description, BasicElementLabels.getFileName((ITypeRoot)cu));
            } else {
                String packageLabel = JavaElementLabels.getElementLabel((IJavaElement)newPack, JavaElementLabels.ALL_DEFAULT);
                label = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_movecu_description, new Object[]{BasicElementLabels.getFileName((ITypeRoot)cu), packageLabel});
            }
            CompositeChange composite = new CompositeChange(label);
            composite.add((Change)new CreatePackageChange(newPack));
            composite.add((Change)new MoveCompilationUnitChange(cu, newPack));
            proposals.add(new ChangeCorrectionProposal(label, (Change)composite, 6, JavaPluginImages.get("org.eclipse.jdt.ui.correction_move.gif")));
        }
    }

    public static void removeImportStatementProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ChangeCorrectionProposal proposal;
        UnusedCodeFix fix = UnusedCodeFix.createRemoveUnusedImportFix(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_delete_import.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.remove_unused_imports", "true");
            proposal = new FixCorrectionProposal(fix, new UnusedCodeCleanUp(options), 6, image, context);
            proposals.add(proposal);
        }
        final ICompilationUnit cu = context.getCompilationUnit();
        String name = CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description;
        proposal = new ChangeCorrectionProposal(name, null, 5, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif")){

            public void apply(IDocument document) {
                FileEditorInput input = new FileEditorInput((IFile)cu.getResource());
                IWorkbenchPage p = JavaPlugin.getActivePage();
                if (p == null) {
                    return;
                }
                IEditorPart part = p.findEditor((IEditorInput)input);
                if (part instanceof JavaEditor) {
                    OrganizeImportsAction action = new OrganizeImportsAction((JavaEditor)part);
                    action.run(cu);
                }
            }
        };
        proposals.add(proposal);
    }

    public static void addProjectSetupFixProposal(IInvocationContext context, IProblemLocation problem, String missingType, Collection<ICommandAccess> proposals) {
        proposals.add(new ClasspathFixCorrectionProposal(context.getCompilationUnit(), problem.getOffset(), problem.getLength(), missingType));
    }

    public static void importNotFoundProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) throws CoreException {
        Object name;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        ImportDeclaration importDeclaration = (ImportDeclaration)ASTNodes.getParent(selectedNode, 26);
        if (importDeclaration == null) {
            return;
        }
        if (!importDeclaration.isOnDemand()) {
            name = importDeclaration.getName();
            if (importDeclaration.isStatic() && name.isQualifiedName()) {
                name = ((QualifiedName)name).getQualifier();
            }
            int kind = JavaModelUtil.is50OrHigher(cu.getJavaProject()) ? 30 : 6;
            UnresolvedElementsSubProcessor.addNewTypeProposals(cu, name, kind, 5, proposals);
        }
        name = ASTNodes.asString((ASTNode)importDeclaration.getName());
        if (importDeclaration.isOnDemand()) {
            name = JavaModelUtil.concatenateName((String)name, "*");
        }
        ReorgCorrectionsSubProcessor.addProjectSetupFixProposal(context, problem, (String)name, proposals);
    }

    public static void getNeedHigherComplianceProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals, String requiredVersion) {
        IJavaProject project = context.getCompilationUnit().getJavaProject();
        String label1 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_change_project_compliance_description, requiredVersion);
        proposals.add(new ChangeToRequiredCompilerCompliance(label1, project, false, requiredVersion, 5));
        if (project.getOption("org.eclipse.jdt.core.compiler.compliance", false) == null) {
            String label2 = Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_change_workspace_compliance_description, requiredVersion);
            proposals.add(new ChangeToRequiredCompilerCompliance(label2, project, true, requiredVersion, 6));
        }
    }

    public static void getIncorrectBuildPathProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        IProject project = context.getCompilationUnit().getJavaProject().getProject();
        String label = CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_label;
        OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, null);
        proposals.add(proposal);
    }

    public static void getAccessRulesProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ITypeBinding referencedElement = null;
        ASTNode node = problem.getCoveredNode(context.getASTRoot());
        if (node instanceof Type) {
            referencedElement = ((Type)node).resolveBinding();
        } else if (node instanceof Name) {
            referencedElement = ((Name)node).resolveBinding();
        }
        if (referencedElement != null && ReorgCorrectionsSubProcessor.canModifyAccessRules((IBinding)referencedElement)) {
            IProject project = context.getCompilationUnit().getJavaProject().getProject();
            String label = CorrectionMessages.ReorgCorrectionsSubProcessor_accessrules_description;
            OpenBuildPathCorrectionProposal proposal = new OpenBuildPathCorrectionProposal(project, label, 5, (IBinding)referencedElement);
            proposals.add(proposal);
        }
    }

    private static boolean canModifyAccessRules(IBinding binding) {
        IClasspathEntry classpathEntry;
        IPackageFragmentRoot root;
        block8: {
            block7: {
                IJavaElement element = binding.getJavaElement();
                if (element == null) {
                    return false;
                }
                root = JavaModelUtil.getPackageFragmentRoot(element);
                if (root == null) {
                    return false;
                }
                try {
                    classpathEntry = root.getRawClasspathEntry();
                    if (classpathEntry != null) break block7;
                    return false;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
            if (classpathEntry.getEntryKind() != 1) break block8;
            return true;
        }
        if (classpathEntry.getEntryKind() == 5) {
            ClasspathContainerInitializer classpathContainerInitializer = JavaCore.getClasspathContainerInitializer((String)classpathEntry.getPath().segment(0));
            IStatus status = classpathContainerInitializer.getAccessRulesStatus(classpathEntry.getPath(), root.getJavaProject());
            return status.isOK();
        }
        return false;
    }

    private static final class ChangeToRequiredCompilerCompliance
    extends ChangeCorrectionProposal
    implements IWorkspaceRunnable {
        private final IJavaProject fProject;
        private final boolean fChangeOnWorkspace;
        private final String fRequiredVersion;
        private Job fUpdateJob;
        private boolean fRequiredJREFound;

        public ChangeToRequiredCompilerCompliance(String name, IJavaProject project, boolean changeOnWorkspace, String requiredVersion, int relevance) {
            super(name, null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            this.fProject = project;
            this.fChangeOnWorkspace = changeOnWorkspace;
            this.fRequiredVersion = requiredVersion;
            this.fUpdateJob = null;
            this.fRequiredJREFound = false;
        }

        private boolean isRequiredOrGreaterVMInstall(IVMInstall install) {
            if (install instanceof IVMInstall2) {
                String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)install, "1.3");
                return !JavaModelUtil.isVersionLessThan(compliance, this.fRequiredVersion);
            }
            return false;
        }

        private String getVMInstallCompliance(IVMInstall install) {
            if (install instanceof IVMInstall2) {
                String compliance = JavaModelUtil.getCompilerCompliance((IVMInstall2)install, "1.3");
                return compliance;
            }
            return "1.1";
        }

        private IVMInstall findRequiredOrGreaterVMInstall() {
            String bestMatchingCompliance = null;
            IVMInstall bestMatchingVMInstall = null;
            IVMInstallType[] installTypes = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < installTypes.length) {
                IVMInstall[] installs = installTypes[i].getVMInstalls();
                int k = 0;
                while (k < installs.length) {
                    String vmInstallCompliance = this.getVMInstallCompliance(installs[k]);
                    if (this.fRequiredVersion.equals(vmInstallCompliance)) {
                        return installs[k];
                    }
                    if (!(JavaModelUtil.isVersionLessThan(vmInstallCompliance, this.fRequiredVersion) || bestMatchingVMInstall != null && JavaModelUtil.isVersionLessThan(bestMatchingCompliance, vmInstallCompliance))) {
                        bestMatchingCompliance = vmInstallCompliance;
                        bestMatchingVMInstall = installs[k];
                    }
                    ++k;
                }
                ++i;
            }
            return null;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            boolean needsBuild = this.updateJRE(monitor);
            if (needsBuild) {
                this.fUpdateJob = CoreUtility.getBuildJob(this.fChangeOnWorkspace ? null : this.fProject.getProject());
            }
        }

        private boolean updateJRE(IProgressMonitor monitor) throws CoreException, JavaModelException {
            try {
                if (this.fChangeOnWorkspace) {
                    IVMInstall vmInstall = this.findRequiredOrGreaterVMInstall();
                    boolean bl = this.fRequiredJREFound = vmInstall != null;
                    if (vmInstall != null) {
                        IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.fProject);
                        monitor.beginTask(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_operation, 4);
                        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
                        if (defaultVM != null && !defaultVM.equals(install)) {
                            Path newPath = new Path(JavaRuntime.JRE_CONTAINER);
                            this.updateClasspath((IPath)newPath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            monitor.worked(1);
                        }
                        if (defaultVM == null || !this.isRequiredOrGreaterVMInstall(defaultVM)) {
                            JavaRuntime.setDefaultVMInstall((IVMInstall)vmInstall, (IProgressMonitor)new SubProgressMonitor(monitor, 3), (boolean)true);
                            return false;
                        }
                        return true;
                    }
                } else {
                    IExecutionEnvironment bestEE = this.findBestMatchingEE();
                    boolean bl = this.fRequiredJREFound = bestEE != null;
                    if (bestEE != null) {
                        IPath newPath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)bestEE);
                        boolean classpathUpdated = this.updateClasspath(newPath, monitor);
                        boolean bl2 = !classpathUpdated;
                        return bl2;
                    }
                }
            }
            finally {
                monitor.done();
            }
            return true;
        }

        private IExecutionEnvironment findBestMatchingEE() {
            IExecutionEnvironmentsManager eeManager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment[] ees = eeManager.getExecutionEnvironments();
            IExecutionEnvironment bestEE = null;
            String bestEECompliance = null;
            int i = 0;
            while (i < ees.length) {
                block8: {
                    String eeCompliance;
                    IExecutionEnvironment ee;
                    block7: {
                        String eeId;
                        block6: {
                            ee = ees[i];
                            eeCompliance = JavaModelUtil.getExecutionEnvironmentCompliance(ee);
                            eeId = ee.getId();
                            if (!this.fRequiredVersion.equals(eeCompliance)) break block6;
                            if (eeId.startsWith("J") && eeId.endsWith(this.fRequiredVersion)) {
                                bestEE = ee;
                                break;
                            }
                            break block7;
                        }
                        if (JavaModelUtil.isVersionLessThan(eeCompliance, this.fRequiredVersion) || bestEE != null && (!eeId.startsWith("J") || JavaModelUtil.isVersionLessThan(bestEECompliance, eeCompliance))) break block8;
                    }
                    bestEE = ee;
                    bestEECompliance = eeCompliance;
                }
                ++i;
            }
            return bestEE;
        }

        private boolean updateClasspath(IPath newPath, IProgressMonitor monitor) throws JavaModelException {
            boolean updated = false;
            IClasspathEntry[] classpath = this.fProject.getRawClasspath();
            Path jreContainerPath = new Path(JavaRuntime.JRE_CONTAINER);
            int i = 0;
            while (i < classpath.length) {
                IClasspathEntry curr = classpath[i];
                if (curr.getEntryKind() == 5 && curr.getPath().matchingFirstSegments((IPath)jreContainerPath) > 0 && !newPath.equals((Object)curr.getPath())) {
                    updated = true;
                    classpath[i] = JavaCore.newContainerEntry((IPath)newPath, (IAccessRule[])curr.getAccessRules(), (IClasspathAttribute[])curr.getExtraAttributes(), (boolean)curr.isExported());
                }
                ++i;
            }
            if (updated) {
                this.fProject.setRawClasspath(classpath, monitor);
            }
            return updated;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            StringBuffer message = new StringBuffer();
            if (this.fChangeOnWorkspace) {
                message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_required_compliance_changeworkspace_description, this.fRequiredVersion));
            } else {
                message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_required_compliance_changeproject_description, this.fRequiredVersion));
            }
            try {
                IVMInstall install = JavaRuntime.getVMInstall((IJavaProject)this.fProject);
                if (this.fChangeOnWorkspace) {
                    IVMInstall vmInstall = this.findRequiredOrGreaterVMInstall();
                    if (vmInstall != null) {
                        IVMInstall defaultVM = JavaRuntime.getDefaultVMInstall();
                        if (defaultVM != null && !defaultVM.equals(install)) {
                            message.append(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJREToDefault_description);
                        }
                        if (defaultVM == null || !this.isRequiredOrGreaterVMInstall(defaultVM)) {
                            message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeWorkspaceJRE_description, vmInstall.getName()));
                        }
                    }
                } else {
                    IExecutionEnvironment bestEE = this.findBestMatchingEE();
                    if (!(bestEE == null || install != null && this.isEEOnClasspath(bestEE))) {
                        message.append(Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_50_compliance_changeProjectJRE_description, bestEE.getId()));
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return message.toString();
        }

        private boolean isEEOnClasspath(IExecutionEnvironment ee) throws JavaModelException {
            IPath eePath = JavaRuntime.newJREContainerPath((IExecutionEnvironment)ee);
            IClasspathEntry[] iClasspathEntryArray = this.fProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)eePath)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void apply(IDocument document) {
            Map<String, String> map;
            if (this.fChangeOnWorkspace) {
                map = JavaCore.getOptions();
                JavaModelUtil.setComplianceOptions(map, this.fRequiredVersion);
                JavaCore.setOptions(map);
            } else {
                map = this.fProject.getOptions(false);
                int optionsCount = map.size();
                JavaModelUtil.setComplianceOptions(map, this.fRequiredVersion);
                if (map.size() > optionsCount) {
                    JavaModelUtil.setDefaultClassfileOptions(map, this.fRequiredVersion);
                }
                this.fProject.setOptions(map);
            }
            try {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(this));
            }
            catch (InvocationTargetException e) {
                JavaPlugin.log(e);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.fUpdateJob != null) {
                this.fUpdateJob.schedule();
            }
            if (!this.fRequiredJREFound) {
                MessageDialog.openInformation((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_no_required_jre_title, this.fRequiredVersion), (String)Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_no_required_jre_message, this.fRequiredVersion));
            }
        }
    }

    public static class ClasspathFixCorrectionProposal
    extends CUCorrectionProposal {
        private final int fOffset;
        private final int fLength;
        private final String fMissingType;
        private TextEdit fResultingEdit;

        public ClasspathFixCorrectionProposal(ICompilationUnit cu, int offset, int length, String missingType) {
            super(CorrectionMessages.ReorgCorrectionsSubProcessor_project_seup_fix_description, cu, -10, JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
            this.fOffset = offset;
            this.fLength = length;
            this.fMissingType = missingType;
        }

        public void apply(IDocument document) {
            Shell shell;
            Object context = JavaPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = new BusyIndicatorRunnableContext();
            }
            if (ClasspathFixSelectionDialog.openClasspathFixSelectionDialog(shell = JavaPlugin.getActiveWorkbenchShell(), this.getCompilationUnit().getJavaProject(), this.fMissingType, (IRunnableContext)context) && this.fMissingType.indexOf(46) == -1) {
                try {
                    AddImportsOperation.IChooseImportQuery query = AddImportOnSelectionAction.newDialogQuery(shell);
                    AddImportsOperation op = new AddImportsOperation(this.getCompilationUnit(), this.fOffset, this.fLength, query, false, false);
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    progressService.runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                    this.fResultingEdit = op.getResultingEdit();
                    super.apply(document);
                }
                catch (InvocationTargetException e) {
                    JavaPlugin.log(e);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
            if (this.fResultingEdit != null) {
                editRoot.addChild(this.fResultingEdit);
            }
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_project_seup_fix_info, BasicElementLabels.getJavaElementName(this.fMissingType));
        }
    }

    private static final class OpenBuildPathCorrectionProposal
    extends ChangeCorrectionProposal {
        private final IProject fProject;
        private final IBinding fReferencedType;

        private OpenBuildPathCorrectionProposal(IProject project, String label, int relevance, IBinding referencedType) {
            super(label, null, relevance, null);
            this.fProject = project;
            this.fReferencedType = referencedType;
            this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.access_restriction_attrib.gif"));
        }

        public void apply(IDocument document) {
            IPackageFragmentRoot root;
            IJavaElement elem;
            HashMap<Object, Object> data = null;
            if (this.fReferencedType != null && (elem = this.fReferencedType.getJavaElement()) != null && (root = (IPackageFragmentRoot)elem.getAncestor(3)) != null) {
                try {
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    if (entry != null) {
                        data = new HashMap<Object, Object>(1);
                        data.put(BuildPathsPropertyPage.DATA_REVEAL_ENTRY, entry);
                        if (entry.getEntryKind() != 5) {
                            data.put(BuildPathsPropertyPage.DATA_REVEAL_ATTRIBUTE_KEY, "accessrules");
                        }
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            PreferencesUtil.createPropertyDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (IAdaptable)this.fProject, (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, data).open();
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return Messages.format(CorrectionMessages.ReorgCorrectionsSubProcessor_configure_buildpath_description, BasicElementLabels.getResourceName((IResource)this.fProject));
        }
    }
}

