/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.ProposalSorterHandle;
import org.eclipse.jdt.internal.ui.text.java.ProposalSorterRegistry;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalSorter;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentAssistProcessor
implements IContentAssistProcessor {
    private static final boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jdt.ui/debug/ResultCollector"));
    private static final String PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY = "EmptyDefaultAssistCategory";
    private static final Comparator<CompletionProposalCategory> ORDER_COMPARATOR = new Comparator<CompletionProposalCategory>(){

        @Override
        public int compare(CompletionProposalCategory d1, CompletionProposalCategory d2) {
            return d1.getSortOrder() - d2.getSortOrder();
        }
    };
    private final List<CompletionProposalCategory> fCategories;
    private final String fPartition;
    private final ContentAssistant fAssistant;
    private char[] fCompletionAutoActivationCharacters;
    private int fRepetition = -1;
    private List<List<CompletionProposalCategory>> fCategoryIteration = null;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;
    private CompletionProposalComputerRegistry fComputerRegistry;
    private boolean fNeedsSortingAfterFiltering;

    public ContentAssistProcessor(ContentAssistant assistant, String partition) {
        Assert.isNotNull((Object)partition);
        Assert.isNotNull((Object)assistant);
        this.fPartition = partition;
        this.fComputerRegistry = CompletionProposalComputerRegistry.getDefault();
        this.fCategories = this.fComputerRegistry.getProposalCategories();
        this.fAssistant = assistant;
        this.fAssistant.addCompletionListener((ICompletionListener)new CompletionListener());
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        long start = DEBUG ? System.currentTimeMillis() : 0L;
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_proposals, this.fCategories.size() + 1);
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        long setup = DEBUG ? System.currentTimeMillis() : 0L;
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_proposals);
        List<ICompletionProposal> proposals = this.collectProposals(viewer, offset, monitor, context);
        long collect = DEBUG ? System.currentTimeMillis() : 0L;
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_proposals);
        if (this.fNeedsSortingAfterFiltering) {
            this.setContentAssistSorter();
        } else {
            proposals = this.sortProposals(proposals, monitor, context);
        }
        this.fNumberOfComputedResults = proposals.size();
        long filter = DEBUG ? System.currentTimeMillis() : 0L;
        ICompletionProposal[] result = proposals.toArray(new ICompletionProposal[proposals.size()]);
        monitor.done();
        if (DEBUG) {
            System.err.println("Code Assist Stats (" + result.length + " proposals)");
            System.err.println("Code Assist (setup):\t" + (setup - start));
            System.err.println("Code Assist (collect):\t" + (collect - setup));
            System.err.println("Code Assist (sort):\t" + (filter - collect));
        }
        return result;
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    private List<ICompletionProposal> collectProposals(ITextViewer viewer, int offset, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        boolean needsSortingAfterFiltering = false;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        List<CompletionProposalCategory> providers = this.getCategories();
        for (CompletionProposalCategory cat : providers) {
            List<ICompletionProposal> computed = cat.computeCompletionProposals(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            boolean bl = needsSortingAfterFiltering = needsSortingAfterFiltering || cat.isSortingAfterFilteringNeeded() && !computed.isEmpty();
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        if (this.fNeedsSortingAfterFiltering && !needsSortingAfterFiltering) {
            this.fAssistant.setSorter(null);
        }
        this.fNeedsSortingAfterFiltering = needsSortingAfterFiltering;
        return proposals;
    }

    protected List<ICompletionProposal> sortProposals(List<ICompletionProposal> proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(JavaTextMessages.ContentAssistProcessor_computing_contexts, this.fCategories.size() + 1);
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_collecting_contexts);
        List<IContextInformation> proposals = this.collectContextInformation(viewer, offset, monitor);
        monitor.subTask(JavaTextMessages.ContentAssistProcessor_sorting_contexts);
        List<IContextInformation> filtered = this.filterAndSortContextInformation(proposals, monitor);
        this.fNumberOfComputedResults = filtered.size();
        IContextInformation[] result = filtered.toArray(new IContextInformation[filtered.size()]);
        monitor.done();
        return result;
    }

    private List<IContextInformation> collectContextInformation(ITextViewer viewer, int offset, IProgressMonitor monitor) {
        ArrayList<IContextInformation> proposals = new ArrayList<IContextInformation>();
        ContentAssistInvocationContext context = this.createContext(viewer, offset);
        List<CompletionProposalCategory> providers = this.getCategories();
        for (CompletionProposalCategory cat : providers) {
            List<IContextInformation> computed = cat.computeContextInformation(context, this.fPartition, new SubProgressMonitor(monitor, 1));
            proposals.addAll(computed);
            if (this.fErrorMessage != null) continue;
            this.fErrorMessage = cat.getErrorMessage();
        }
        return proposals;
    }

    protected List<IContextInformation> filterAndSortContextInformation(List<IContextInformation> contexts, IProgressMonitor monitor) {
        return contexts;
    }

    public final void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fCompletionAutoActivationCharacters = activationSet;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return this.fCompletionAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        return JavaUIMessages.JavaEditor_codeassist_noCompletions;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new ContentAssistInvocationContext(viewer, offset);
    }

    private List<CompletionProposalCategory> getCategories() {
        if (this.fCategoryIteration == null) {
            return this.fCategories;
        }
        int iteration = this.fRepetition % this.fCategoryIteration.size();
        this.fAssistant.setStatusMessage(this.createIterationMessage());
        this.fAssistant.setEmptyMessage(this.createEmptyMessage());
        ++this.fRepetition;
        return this.fCategoryIteration.get(iteration);
    }

    private void setCategoryIteration() {
        this.fCategoryIteration = this.getCategoryIteration();
    }

    private List<List<CompletionProposalCategory>> getCategoryIteration() {
        ArrayList<List<CompletionProposalCategory>> sequence = new ArrayList<List<CompletionProposalCategory>>();
        sequence.add(this.getDefaultCategories());
        for (CompletionProposalCategory cat : this.getSeparateCategories()) {
            sequence.add(Collections.singletonList(cat));
        }
        return sequence;
    }

    private List<CompletionProposalCategory> getDefaultCategories() {
        List<CompletionProposalCategory> included = this.getDefaultCategoriesUnchecked();
        if (this.fComputerRegistry.hasUninstalledComputers(this.fPartition, included)) {
            if (this.informUserAboutEmptyDefaultCategory()) {
                included = this.getDefaultCategoriesUnchecked();
            }
            this.fComputerRegistry.resetUnistalledComputers();
        }
        return included;
    }

    private List<CompletionProposalCategory> getDefaultCategoriesUnchecked() {
        ArrayList<CompletionProposalCategory> included = new ArrayList<CompletionProposalCategory>();
        for (CompletionProposalCategory category : this.fCategories) {
            if (!this.checkDefaultEnablement(category)) continue;
            included.add(category);
        }
        return included;
    }

    protected boolean checkDefaultEnablement(CompletionProposalCategory category) {
        return category.isIncluded() && category.hasComputers(this.fPartition);
    }

    private boolean informUserAboutEmptyDefaultCategory() {
        if (OptionalMessageDialog.isDialogEnabled(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY)) {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            String title = JavaTextMessages.ContentAssistProcessor_all_disabled_title;
            String message = JavaTextMessages.ContentAssistProcessor_all_disabled_message;
            final String restoreButtonLabel = JFaceResources.getString((String)"defaults");
            final String linkMessage = Messages.format(JavaTextMessages.ContentAssistProcessor_all_disabled_preference_link, LegacyActionTools.removeMnemonics((String)restoreButtonLabel));
            int restoreId = 1034;
            int settingsId = 1035;
            OptionalMessageDialog dialog = new OptionalMessageDialog(PREF_WARN_ABOUT_EMPTY_ASSIST_CATEGORY, shell, title, null, message, 4, new String[]{restoreButtonLabel, IDialogConstants.CLOSE_LABEL}, 1){

                protected Control createCustomArea(Composite composite) {
                    Composite parent = new Composite(composite, 0);
                    GridLayout layout = new GridLayout();
                    layout.marginHeight = 0;
                    layout.marginWidth = 0;
                    layout.verticalSpacing = 0;
                    parent.setLayout((Layout)layout);
                    Composite linkComposite = new Composite(parent, 0);
                    layout = new GridLayout();
                    layout.marginHeight = this.convertVerticalDLUsToPixels(7);
                    layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
                    layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
                    linkComposite.setLayout((Layout)layout);
                    Link link = new Link(linkComposite, 0);
                    link.setText(linkMessage);
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            this.setReturnCode(1035);
                            this.close();
                        }
                    });
                    GridData gridData = new GridData(4, 1, true, false);
                    gridData.widthHint = this.getMinimumMessageWidth();
                    link.setLayoutData((Object)gridData);
                    super.createCustomArea(parent);
                    return parent;
                }

                protected void createButtonsForButtonBar(Composite parent) {
                    Button[] buttons = new Button[]{this.createButton(parent, 1034, restoreButtonLabel, false), this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true)};
                    this.setButtons(buttons);
                }
            };
            int returnValue = dialog.open();
            if (1034 == returnValue || 1035 == returnValue) {
                if (1034 == returnValue) {
                    IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
                    store.setToDefault("content_assist_category_order");
                    store.setToDefault("content_assist_disabled_computers");
                }
                if (1035 == returnValue) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)"org.eclipse.jdt.ui.preferences.CodeAssistPreferenceAdvanced", null, null).open();
                }
                this.fComputerRegistry.reload();
                return true;
            }
        }
        return false;
    }

    private List<CompletionProposalCategory> getSeparateCategories() {
        ArrayList<CompletionProposalCategory> sorted = new ArrayList<CompletionProposalCategory>();
        for (CompletionProposalCategory category : this.fCategories) {
            if (!this.checkSeparateEnablement(category)) continue;
            sorted.add(category);
        }
        Collections.sort(sorted, ORDER_COMPARATOR);
        return sorted;
    }

    protected boolean checkSeparateEnablement(CompletionProposalCategory category) {
        return category.isSeparateCommand() && category.hasComputers(this.fPartition);
    }

    private String createEmptyMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_empty_message, new String[]{this.getCategoryLabel(this.fRepetition)});
    }

    private String createIterationMessage() {
        return Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_update_message, new String[]{this.getCategoryLabel(this.fRepetition), this.fIterationGesture, this.getCategoryLabel(this.fRepetition + 1)});
    }

    private String getCategoryLabel(int repetition) {
        int iteration = repetition % this.fCategoryIteration.size();
        if (iteration == 0) {
            return JavaTextMessages.ContentAssistProcessor_defaultProposalCategory;
        }
        return this.toString(this.fCategoryIteration.get(iteration).get(0));
    }

    private String toString(CompletionProposalCategory category) {
        return category.getDisplayName();
    }

    private String getIterationGesture() {
        KeySequence binding = this.getIterationBinding();
        return binding != null ? Messages.format(JavaTextMessages.ContentAssistProcessor_toggle_affordance_press_gesture, new Object[]{binding.format()}) : JavaTextMessages.ContentAssistProcessor_toggle_affordance_click_gesture;
    }

    private KeySequence getIterationBinding() {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence binding = bindingSvc.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (binding instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }

    private void setContentAssistSorter() {
        ProposalSorterHandle currentSorter = ProposalSorterRegistry.getDefault().getCurrentSorter();
        try {
            this.fAssistant.setSorter((ICompletionProposalSorter)currentSorter.getSorter());
        }
        catch (InvalidRegistryObjectException x) {
            JavaPlugin.log((IStatus)currentSorter.createExceptionStatus(x));
        }
        catch (CoreException x) {
            JavaPlugin.log((IStatus)currentSorter.createExceptionStatus(x));
        }
        catch (RuntimeException x) {
            JavaPlugin.log((IStatus)currentSorter.createExceptionStatus(x));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CompletionListener
    implements ICompletionListener,
    ICompletionListenerExtension {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            if (event.processor != ContentAssistProcessor.this) {
                return;
            }
            ContentAssistProcessor.this.fIterationGesture = ContentAssistProcessor.this.getIterationGesture();
            KeySequence binding = ContentAssistProcessor.this.getIterationBinding();
            ContentAssistProcessor.this.setCategoryIteration();
            for (CompletionProposalCategory cat : this.getCategoriesToNotify()) {
                cat.sessionStarted();
            }
            ContentAssistProcessor.this.fRepetition = 0;
            if (event.assistant instanceof IContentAssistantExtension2) {
                IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                if (ContentAssistProcessor.this.fCategoryIteration.size() == 1) {
                    extension.setRepeatedInvocationMode(false);
                    extension.setShowEmptyList(false);
                } else {
                    extension.setRepeatedInvocationMode(true);
                    extension.setStatusLineVisible(true);
                    extension.setStatusMessage(ContentAssistProcessor.this.createIterationMessage());
                    extension.setShowEmptyList(true);
                    if (extension instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                        ((ContentAssistant)ext3).setRepeatedInvocationTrigger(binding);
                    }
                }
            }
        }

        private Set<CompletionProposalCategory> getCategoriesToNotify() {
            HashSet<CompletionProposalCategory> currentCategories = new HashSet<CompletionProposalCategory>(ContentAssistProcessor.this.fCategories.size());
            if (ContentAssistProcessor.this.fCategoryIteration != null) {
                Iterator it = ContentAssistProcessor.this.fCategoryIteration.iterator();
                while (it.hasNext()) {
                    currentCategories.addAll((Collection)it.next());
                }
            }
            for (CompletionProposalCategory cat : ContentAssistProcessor.this.fCategories) {
                if (cat.getEnablementExpression() != null) continue;
                currentCategories.add(cat);
            }
            return currentCategories;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            if (event.processor != ContentAssistProcessor.this) {
                return;
            }
            for (CompletionProposalCategory cat : this.getCategoriesToNotify()) {
                cat.sessionEnded();
            }
            ContentAssistProcessor.this.fCategoryIteration = null;
            ContentAssistProcessor.this.fRepetition = -1;
            ContentAssistProcessor.this.fIterationGesture = null;
            if (event.assistant instanceof IContentAssistantExtension2) {
                IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                extension.setShowEmptyList(false);
                extension.setRepeatedInvocationMode(false);
                extension.setStatusLineVisible(false);
                if (extension instanceof IContentAssistantExtension3) {
                    IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                    ((ContentAssistant)ext3).setRepeatedInvocationTrigger(null);
                }
            }
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }

        public void assistSessionRestarted(ContentAssistEvent event) {
            ContentAssistProcessor.this.fRepetition = 0;
        }
    }
}

