/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.jdt.internal.ui.util.StringMatcher;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterGuesser {
    private static final char[] NO_TRIGGERS = new char[0];
    private final Set<String> fAlreadyMatchedNames;
    private final IJavaElement fEnclosingElement;

    public ParameterGuesser(IJavaElement enclosingElement) {
        this.fEnclosingElement = enclosingElement;
        this.fAlreadyMatchedNames = new HashSet<String>();
    }

    private List<Variable> evaluateVisibleMatches(String expectedType, IJavaElement[] suggestions) throws JavaModelException {
        PrimitiveType.Code primitiveTypeCode;
        String fullyQualifiedName;
        IType currentType = null;
        if (this.fEnclosingElement != null) {
            currentType = (IType)this.fEnclosingElement.getAncestor(7);
        }
        ArrayList<Variable> res = new ArrayList<Variable>();
        int i = 0;
        while (i < suggestions.length) {
            Variable variable = this.createVariable(suggestions[i], currentType, expectedType, i);
            if (variable != null) {
                if (this.fAlreadyMatchedNames.contains(variable.name)) {
                    variable.alreadyMatched = true;
                }
                res.add(variable);
            }
            ++i;
        }
        if (!(currentType == null || this.fEnclosingElement instanceof IMethod && Flags.isStatic((int)((IMethod)this.fEnclosingElement).getFlags()) || !(fullyQualifiedName = currentType.getFullyQualifiedName('.')).equals(expectedType))) {
            JavaElementImageDescriptor desc = new JavaElementImageDescriptor(JavaPluginImages.DESC_FIELD_PUBLIC, 10, JavaElementImageProvider.SMALL_SIZE);
            res.add(new Variable(fullyQualifiedName, "this", 5, false, res.size(), new char[]{'.'}, (ImageDescriptor)desc));
        }
        if ((primitiveTypeCode = this.getPrimitiveTypeCode(expectedType)) == null) {
            res.add(new Variable(expectedType, "null", 5, false, res.size(), NO_TRIGGERS, null));
        } else {
            boolean isAutoboxing;
            String typeName = primitiveTypeCode.toString();
            boolean bl = isAutoboxing = !typeName.equals(expectedType);
            if (primitiveTypeCode == PrimitiveType.BOOLEAN) {
                res.add(new Variable(typeName, "true", 5, isAutoboxing, res.size(), NO_TRIGGERS, null));
                res.add(new Variable(typeName, "false", 5, isAutoboxing, res.size(), NO_TRIGGERS, null));
            } else {
                res.add(new Variable(typeName, "0", 5, isAutoboxing, res.size(), NO_TRIGGERS, null));
            }
        }
        return res;
    }

    public Variable createVariable(IJavaElement element, IType enclosingType, String expectedType, int positionScore) throws JavaModelException {
        String typeSignature;
        int variableType;
        int elementType = element.getElementType();
        String elementName = element.getElementName();
        switch (elementType) {
            case 8: {
                IField field = (IField)element;
                variableType = field.getDeclaringType().equals(enclosingType) ? 1 : 2;
                if (field.isResolved()) {
                    typeSignature = new BindingKey(field.getKey()).toSignature();
                    break;
                }
                typeSignature = field.getTypeSignature();
                break;
            }
            case 14: {
                ILocalVariable locVar = (ILocalVariable)element;
                variableType = 0;
                typeSignature = locVar.getTypeSignature();
                break;
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (this.isMethodToSuggest(method)) {
                    variableType = method.getDeclaringType().equals(enclosingType) ? 3 : 4;
                    typeSignature = method.isResolved() ? Signature.getReturnType((String)new BindingKey(method.getKey()).toSignature()) : method.getReturnType();
                    elementName = String.valueOf(elementName) + "()";
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        String type = Signature.toString((String)typeSignature);
        boolean isAutoboxMatch = this.isPrimitiveType(expectedType) ^ this.isPrimitiveType(type);
        return new Variable(type, elementName, variableType, isAutoboxMatch, positionScore, NO_TRIGGERS, this.getImageDescriptor(element));
    }

    private ImageDescriptor getImageDescriptor(IJavaElement elem) {
        JavaElementImageProvider imageProvider = new JavaElementImageProvider();
        ImageDescriptor desc = imageProvider.getBaseImageDescriptor(elem, 1);
        imageProvider.dispose();
        return desc;
    }

    private boolean isPrimitiveType(String type) {
        return PrimitiveType.toCode((String)type) != null;
    }

    private PrimitiveType.Code getPrimitiveTypeCode(String type) {
        PrimitiveType.Code code = PrimitiveType.toCode((String)type);
        if (code != null) {
            return code;
        }
        if (this.fEnclosingElement != null && JavaModelUtil.is50OrHigher(this.fEnclosingElement.getJavaProject()) && (code == PrimitiveType.SHORT ? "java.lang.Short".equals(type) : (code == PrimitiveType.INT ? "java.lang.Integer".equals(type) : (code == PrimitiveType.LONG ? "java.lang.Long".equals(type) : (code == PrimitiveType.FLOAT ? "java.lang.Float".equals(type) : (code == PrimitiveType.DOUBLE ? "java.lang.Double".equals(type) : (code == PrimitiveType.CHAR ? "java.lang.Character".equals(type) : code == PrimitiveType.BYTE && "java.lang.Byte".equals(type)))))))) {
            return code;
        }
        return null;
    }

    private boolean isMethodToSuggest(IMethod method) {
        try {
            String methodName = method.getElementName();
            return method.getNumberOfParameters() == 0 && !"V".equals(method.getReturnType()) && (methodName.startsWith("get") || methodName.startsWith("is"));
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public ICompletionProposal[] parameterProposals(String expectedType, String paramName, Position pos, IJavaElement[] suggestions, boolean fillBestGuess, boolean isLastParameter) throws JavaModelException {
        List<Variable> typeMatches = this.evaluateVisibleMatches(expectedType, suggestions);
        ParameterGuesser.orderMatches(typeMatches, paramName);
        boolean hasVarWithParamName = false;
        ICompletionProposal[] ret = new ICompletionProposal[typeMatches.size()];
        int i = 0;
        int replacementLength = 0;
        for (Variable v : typeMatches) {
            char[] triggers;
            if (i == 0) {
                this.fAlreadyMatchedNames.add(v.name);
                replacementLength = v.name.length();
            }
            String displayString = v.name;
            hasVarWithParamName |= displayString.equals(paramName);
            if (isLastParameter) {
                triggers = v.triggerChars;
            } else {
                triggers = new char[v.triggerChars.length + 1];
                System.arraycopy(v.triggerChars, 0, triggers, 0, v.triggerChars.length);
                triggers[triggers.length - 1] = 44;
            }
            ret[i++] = new PositionBasedCompletionProposal(v.name, pos, replacementLength, this.getImage(v.descriptor), displayString, null, null, triggers);
        }
        if (!fillBestGuess && !hasVarWithParamName) {
            char[] cArray;
            ICompletionProposal[] extended = new ICompletionProposal[ret.length + 1];
            System.arraycopy(ret, 0, extended, 1, ret.length);
            if (isLastParameter) {
                cArray = null;
            } else {
                char[] cArray2 = new char[1];
                cArray = cArray2;
                cArray2[0] = 44;
            }
            extended[0] = new PositionBasedCompletionProposal(paramName, pos, replacementLength, null, paramName, null, null, cArray);
            return extended;
        }
        return ret;
    }

    private static void orderMatches(List<Variable> typeMatches, String paramName) {
        if (typeMatches != null) {
            Collections.sort(typeMatches, new MatchComparator(paramName));
        }
    }

    private static String getLongestCommonSubstring(String first, String second) {
        String shorter = first.length() <= second.length() ? first : second;
        String longer = shorter == first ? second : first;
        int minLength = shorter.length();
        StringBuffer pattern = new StringBuffer(shorter.length() + 2);
        String longestCommonSubstring = "";
        int i = 0;
        while (i < minLength) {
            int j = i + 1;
            while (j <= minLength) {
                if (j - i >= longestCommonSubstring.length()) {
                    String substring = shorter.substring(i, j);
                    pattern.setLength(0);
                    pattern.append('*');
                    pattern.append(substring);
                    pattern.append('*');
                    StringMatcher matcher = new StringMatcher(pattern.toString(), true, false);
                    if (matcher.match(longer)) {
                        longestCommonSubstring = substring;
                    }
                }
                ++j;
            }
            ++i;
        }
        return longestCommonSubstring;
    }

    private Image getImage(ImageDescriptor descriptor) {
        return descriptor == null ? null : JavaPlugin.getImageDescriptorRegistry().get(descriptor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchComparator
    implements Comparator<Variable> {
        private String fParamName;

        MatchComparator(String paramName) {
            this.fParamName = paramName;
        }

        @Override
        public int compare(Variable one, Variable two) {
            return this.score(two) - this.score(one);
        }

        private int score(Variable v) {
            int shorter;
            int variableScore = 100 - v.variableType;
            int subStringScore = ParameterGuesser.getLongestCommonSubstring(v.name, this.fParamName).length();
            if ((double)subStringScore < 0.6 * (double)(shorter = Math.min(v.name.length(), this.fParamName.length()))) {
                subStringScore = 0;
            }
            int positionScore = v.positionScore;
            int matchedScore = v.alreadyMatched ? 0 : 1;
            int autoboxingScore = v.isAutoboxingMatch ? 0 : 1;
            int score = autoboxingScore << 30 | variableScore << 21 | subStringScore << 11 | matchedScore << 10 | positionScore;
            return score;
        }
    }

    private static final class Variable {
        public static final int LOCAL = 0;
        public static final int FIELD = 1;
        public static final int INHERITED_FIELD = 2;
        public static final int METHOD = 3;
        public static final int INHERITED_METHOD = 4;
        public static final int LITERALS = 5;
        public final String qualifiedTypeName;
        public final String name;
        public final int variableType;
        public final int positionScore;
        public final boolean isAutoboxingMatch;
        public final char[] triggerChars;
        public final ImageDescriptor descriptor;
        public boolean alreadyMatched;

        public Variable(String qualifiedTypeName, String name, int variableType, boolean isAutoboxMatch, int positionScore, char[] triggerChars, ImageDescriptor descriptor) {
            this.qualifiedTypeName = qualifiedTypeName;
            this.name = name;
            this.variableType = variableType;
            this.positionScore = positionScore;
            this.triggerChars = triggerChars;
            this.descriptor = descriptor;
            this.isAutoboxingMatch = isAutoboxMatch;
            this.alreadyMatched = false;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.qualifiedTypeName);
            buffer.append(' ');
            buffer.append(this.name);
            buffer.append(" (");
            buffer.append(this.variableType);
            buffer.append(')');
            return buffer.toString();
        }
    }
}

