/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.text.spelling.AddWordProposal;
import org.eclipse.jdt.internal.ui.text.spelling.ChangeCaseProposal;
import org.eclipse.jdt.internal.ui.text.spelling.DisableSpellCheckingProposal;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.spelling.WordIgnoreProposal;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.jdt.internal.ui.text.spelling.engine.ISpellEvent;
import org.eclipse.jdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class JavaSpellingProblem
extends SpellingProblem {
    private ISpellEvent fSpellEvent;
    private IDocument fDocument;

    public JavaSpellingProblem(ISpellEvent spellEvent, IDocument document) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        Assert.isLegal((spellEvent != null ? 1 : 0) != 0);
        this.fSpellEvent = spellEvent;
        this.fDocument = document;
    }

    public int getOffset() {
        return this.fSpellEvent.getBegin();
    }

    public int getLength() {
        return this.fSpellEvent.getEnd() - this.fSpellEvent.getBegin() + 1;
    }

    public String getMessage() {
        if (this.isSentenceStart() && this.isDictionaryMatch()) {
            return Messages.format(JavaUIMessages.Spelling_error_case_label, new String[]{this.fSpellEvent.getWord()});
        }
        return Messages.format(JavaUIMessages.Spelling_error_label, new String[]{this.fSpellEvent.getWord()});
    }

    public ICompletionProposal[] getProposals() {
        return this.getProposals(null);
    }

    public ICompletionProposal[] getProposals(IQuickAssistInvocationContext context) {
        String[] arguments = this.getArguments();
        if (arguments == null) {
            return new ICompletionProposal[0];
        }
        if (arguments[0].indexOf(38) != -1 && this.isIgnoringAmpersand()) {
            return new ICompletionProposal[0];
        }
        int threshold = PreferenceConstants.getPreferenceStore().getInt("spelling_proposal_threshold");
        int size = 0;
        List<RankedWordProposal> proposals = null;
        RankedWordProposal proposal = null;
        IJavaCompletionProposal[] result = null;
        int index = 0;
        boolean fixed = false;
        boolean match = false;
        boolean sentence = false;
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.getSpellChecker();
        if (checker != null) {
            context = context == null ? new TextInvocationContext(null, this.getOffset(), this.getLength()) : new TextInvocationContext(context.getSourceViewer(), this.getOffset(), this.getLength());
            boolean bl = fixed = arguments[0].charAt(0) == '<' || arguments[0].charAt(0) == '@';
            if (sentence && match && !fixed) {
                result = new IJavaCompletionProposal[]{new ChangeCaseProposal(arguments, this.getOffset(), this.getLength(), context, engine.getLocale())};
            } else {
                proposals = new ArrayList<RankedWordProposal>(checker.getProposals(arguments[0], sentence));
                size = proposals.size();
                if (threshold > 0 && size > threshold) {
                    Collections.sort(proposals);
                    proposals = proposals.subList(size - threshold - 1, size - 1);
                    size = proposals.size();
                }
                boolean extendable = !fixed ? checker.acceptsWords() || AddWordProposal.canAskToConfigure() : false;
                result = new IJavaCompletionProposal[size + (extendable ? 3 : 2)];
                index = 0;
                while (index < size) {
                    proposal = proposals.get(index);
                    result[index] = new WordCorrectionProposal(proposal.getText(), arguments, this.getOffset(), this.getLength(), context, proposal.getRank());
                    ++index;
                }
                if (extendable) {
                    result[index++] = new AddWordProposal(arguments[0], context);
                }
                result[index++] = new WordIgnoreProposal(arguments[0], context);
                result[index++] = new DisableSpellCheckingProposal(context);
            }
        }
        return result;
    }

    private boolean isIgnoringAmpersand() {
        return PreferenceConstants.getPreferenceStore().getBoolean("spelling_ignore_ampersand_in_properties");
    }

    public String[] getArguments() {
        String word;
        String prefix = "";
        String postfix = "";
        try {
            word = this.fDocument.get(this.getOffset(), this.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(this.getOffset());
            prefix = this.fDocument.get(line.getOffset(), this.getOffset() - line.getOffset());
            int postfixStart = this.getOffset() + this.getLength();
            postfix = this.fDocument.get(postfixStart, line.getOffset() + line.getLength() - postfixStart);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new String[]{word, prefix, postfix, this.isSentenceStart() ? Boolean.toString(true) : Boolean.toString(false), this.isDictionaryMatch() ? Boolean.toString(true) : Boolean.toString(false)};
    }

    public boolean isDictionaryMatch() {
        return this.fSpellEvent.isMatch();
    }

    public boolean isSentenceStart() {
        return this.fSpellEvent.isStart();
    }
}

