/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.template.java.SWTContextType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private TemplateContextType fContextType;
    private ArrayList<TemplateProposal> fProposals = new ArrayList();
    private final Map<IDocument, Position> fPositions = new HashMap<IDocument, Position>();

    public TemplateEngine(TemplateContextType contextType) {
        Assert.isNotNull((Object)contextType);
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
        for (Map.Entry<IDocument, Position> entry : this.fPositions.entrySet()) {
            IDocument doc = entry.getKey();
            Position position = entry.getValue();
            doc.removePosition(position);
        }
        this.fPositions.clear();
    }

    public TemplateProposal[] getResults() {
        return this.fProposals.toArray(new TemplateProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition, ICompilationUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        Position position = new Position(completionPosition, selection.y);
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
                document.addPosition(position);
                this.fPositions.put(document, position);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        CompilationUnitContext context = ((CompilationUnitContextType)this.fContextType).createContext(document, position, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = JavaPlugin.getDefault().getTemplateStore().getTemplates();
        if (selection.y == 0) {
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template)) {
                    this.fProposals.add(new TemplateProposal(template, (TemplateContext)context, (IRegion)region, this.getImage()));
                }
                ++i;
            }
        } else {
            if (context.getKey().length() == 0) {
                context.setForceEvaluation(true);
            }
            boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new TemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, this.getImage()));
                }
                ++i;
            }
        }
    }

    private Image getImage() {
        if (this.fContextType instanceof SWTContextType) {
            return JavaPluginImages.get("org.eclipse.jdt.ui.template_swt_obj.gif");
        }
        return JavaPluginImages.get("org.eclipse.jdt.ui.template_obj.gif");
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException x) {
            return false;
        }
    }
}

