/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcludeFromBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public ExcludeFromBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public ExcludeFromBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private ExcludeFromBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 2);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_EXCLUDE_FROM_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_EXCLUDE_FROM_BUILDPATH);
    }

    @Override
    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Exclude;
        }
        IJavaElement elem = (IJavaElement)this.getSelectedElements().get(0);
        String name = ClasspathModifier.escapeSpecialChars(JavaElementLabels.getElementLabel(elem, JavaElementLabels.ALL_DEFAULT));
        if (elem instanceof IPackageFragment) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludePackage, name);
        }
        if (elem instanceof ICompilationUnit) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludeFile, name);
        }
        return null;
    }

    public void run() {
        Object object = this.getSelectedElements().get(0);
        final IJavaProject project = object instanceof ICompilationUnit ? ((ICompilationUnit)object).getJavaProject() : ((IPackageFragment)object).getJavaProject();
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = ExcludeFromBuildpathAction.this.exclude(ExcludeFromBuildpathAction.this.getSelectedElements(), project, monitor);
                        ExcludeFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.ExcludeFromBuildathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List<IResource> exclude(List<?> javaElements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, javaElements.size() + 4);
            List<CPListElement> existingEntries = ClasspathModifier.getExistingEntries(project);
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < javaElements.size()) {
                IPackageFragmentRoot root;
                CPListElement entry;
                IJavaElement javaElement = (IJavaElement)javaElements.get(i);
                IResource resource = ClasspathModifier.exclude(javaElement, entry = ClasspathModifier.getClasspathEntry(existingEntries, root = (IPackageFragmentRoot)javaElement.getAncestor(3)), project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (resource != null) {
                    resources.add(resource);
                }
                ++i;
            }
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            delta.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
            this.informListeners(delta);
            ArrayList<IResource> arrayList = resources;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        for (Object element : elements) {
            if (element instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)element;
                if (ClasspathModifier.isDefaultFragment(fragment)) {
                    return false;
                }
                if (!ClasspathModifier.isInExternalOrArchive((IJavaElement)fragment)) continue;
                return false;
            }
            if (element instanceof ICompilationUnit) continue;
            return false;
        }
        return true;
    }
}

