/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetAllOutputFoldersAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;
    private final IJavaProject fJavaProject;

    public ResetAllOutputFoldersAction(IRunnableContext context, IJavaProject project, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context, project);
    }

    public ResetAllOutputFoldersAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context, IJavaProject javaProject) {
        super(site, selectionTarget, 17);
        this.fContext = context;
        this.fJavaProject = javaProject;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
    }

    @Override
    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAllOutputFolders;
    }

    public void run() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ResetAllOutputFoldersAction.this.resetOutputFolders(ResetAllOutputFoldersAction.this.fJavaProject, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List<Object> resetOutputFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetOutputFolder, roots.length + 10);
            ArrayList<CPListElementAttribute> entries = new ArrayList<CPListElementAttribute>();
            int i = 0;
            while (i < roots.length) {
                monitor.worked(1);
                IPackageFragmentRoot root = roots[i];
                if (!root.isArchive() && !root.isExternal()) {
                    IClasspathEntry entry = root.getRawClasspathEntry();
                    CPListElement element = CPListElement.createFromExisting(entry, project);
                    CPListElementAttribute outputFolder = new CPListElementAttribute(element, "output", element.getAttribute("output"), true);
                    entries.add(outputFolder);
                }
                ++i;
            }
            List<Object> list = this.reset(entries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private List<Object> reset(List<CPListElementAttribute> selection, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Resetting, selection.size());
            List<CPListElement> entries = ClasspathModifier.getExistingEntries(project);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < selection.size()) {
                CPListElementAttribute element = selection.get(i);
                if (element instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)element;
                    IPackageFragmentRoot root = element instanceof IJavaProject ? project.getPackageFragmentRoot(project.getResource()) : (IPackageFragmentRoot)element;
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, root);
                    ClasspathModifier.resetFilters(javaElement, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(javaElement);
                } else {
                    CPListElement selElement = element.getParent();
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, selElement);
                    CPListElementAttribute outputFolder = ClasspathModifier.resetOutputFolder(entry, project);
                    result.add(outputFolder);
                }
                ++i;
            }
            ClasspathModifier.commitClassPath(entries, project, null);
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            delta.setNewEntries(entries.toArray(new CPListElement[entries.size()]));
            this.informListeners(delta);
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected boolean canHandle(IStructuredSelection elements) {
        return true;
    }
}

