/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.jdt.internal.ui.search.OccurrencesFinder;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class FindOccurrencesInFileAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private IActionBars fActionBars;

    public FindOccurrencesInFileAction(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    public FindOccurrencesInFileAction(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public FindOccurrencesInFileAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindOccurrencesInFileAction.getEditorInput(editor) != null);
    }

    public FindOccurrencesInFileAction(IWorkbenchSite site) {
        super(site);
        if (site instanceof IViewSite) {
            this.fActionBars = ((IViewSite)site).getActionBars();
        } else if (site instanceof IEditorSite) {
            this.fActionBars = ((IEditorSite)site).getActionBars();
        } else if (site instanceof IPageSite) {
            this.fActionBars = ((IPageSite)site).getActionBars();
        }
        this.setText(SearchMessages.Search_FindOccurrencesInFile_label);
        this.setToolTipText(SearchMessages.Search_FindOccurrencesInFile_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.find_occurrences_in_file_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getMember(selection) != null);
    }

    private IMember getMember(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IMember) {
            IMember member = (IMember)o;
            try {
                if (member.getNameRange() == null) {
                    return null;
                }
            }
            catch (JavaModelException ex) {
                return null;
            }
            IClassFile file = member.getClassFile();
            if (file != null) {
                try {
                    if (file.getSourceRange() != null) {
                        return member;
                    }
                }
                catch (JavaModelException e) {
                    return null;
                }
            }
            return member;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        IMember member = this.getMember(selection);
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)member)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(new OccurrencesFinder());
        try {
            ISourceRange range = member.getNameRange();
            String result = engine.run(member.getTypeRoot(), range.getOffset(), range.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fActionBars, result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private static void showMessage(Shell shell, IActionBars actionBars, String msg) {
        IStatusLineManager statusLine;
        if (actionBars != null && (statusLine = actionBars.getStatusLineManager()) != null) {
            statusLine.setMessage(msg);
        }
        shell.getDisplay().beep();
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        CompilationUnit astRoot = selection.resolvePartialAstAtOffset();
        this.setEnabled(astRoot != null && new OccurrencesFinder().initialize(astRoot, selection.getOffset(), selection.getLength()) == null);
    }

    public final void run(ITextSelection ts) {
        ITypeRoot input = FindOccurrencesInFileAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)input)) {
            return;
        }
        OccurrencesFinder finder = new OccurrencesFinder();
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(finder);
        try {
            String result = engine.run(input, ts.getOffset(), ts.getLength());
            if (result != null) {
                FindOccurrencesInFileAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private static ITypeRoot getEditorInput(JavaEditor editor) {
        return JavaUI.getEditorInputTypeRoot(editor.getEditorInput());
    }

    private static void showMessage(Shell shell, JavaEditor editor, String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }
}

