/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text.folding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.DocumentCharacterIterator;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProviderExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaFoldingStructureProvider
implements IJavaFoldingStructureProvider,
IJavaFoldingStructureProviderExtension {
    private JavaEditor fEditor;
    private ProjectionListener fProjectionListener;
    private IJavaElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fCollapseJavadoc = false;
    private boolean fCollapseImportContainer = true;
    private boolean fCollapseInnerTypes = true;
    private boolean fCollapseMembers = false;
    private boolean fCollapseHeaderComments = true;
    private final Filter fMemberFilter = new MemberFilter();
    private final Filter fCommentFilter = new CommentFilter();
    private IScanner fSharedScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
    private volatile int fUpdatingCount = 0;

    @Override
    public void install(ITextEditor editor, ProjectionViewer viewer) {
        Assert.isLegal((editor != null ? 1 : 0) != 0);
        Assert.isLegal((viewer != null ? 1 : 0) != 0);
        this.internalUninstall();
        if (editor instanceof JavaEditor) {
            this.fProjectionListener = new ProjectionListener(viewer);
            this.fEditor = (JavaEditor)editor;
        }
    }

    @Override
    public void uninstall() {
        this.internalUninstall();
    }

    private void internalUninstall() {
        if (this.isInstalled()) {
            this.handleProjectionDisabled();
            this.fProjectionListener.dispose();
            this.fProjectionListener = null;
            this.fEditor = null;
        }
    }

    protected final boolean isInstalled() {
        return this.fEditor != null;
    }

    protected void handleProjectionEnabled() {
        this.handleProjectionDisabled();
        if (this.isInstalled()) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    protected void handleProjectionDisabled() {
        if (this.fElementListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    @Override
    public final void initialize() {
        ++this.fUpdatingCount;
        try {
            this.update(this.createInitialContext());
        }
        finally {
            --this.fUpdatingCount;
        }
    }

    private FoldingStructureComputationContext createInitialContext() {
        this.initializePreferences();
        this.fInput = this.getInputElement();
        if (this.fInput == null) {
            return null;
        }
        return this.createContext(true);
    }

    private FoldingStructureComputationContext createContext(boolean allowCollapse) {
        if (!this.isInstalled()) {
            return null;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return null;
        }
        IDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        IScanner scanner = null;
        if (this.fUpdatingCount == 1) {
            scanner = this.fSharedScanner;
        }
        return new FoldingStructureComputationContext(doc, model, allowCollapse, scanner);
    }

    private IJavaElement getInputElement() {
        if (this.fEditor == null) {
            return null;
        }
        return EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
    }

    private void initializePreferences() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        this.fCollapseInnerTypes = store.getBoolean("editor_folding_default_innertypes");
        this.fCollapseImportContainer = store.getBoolean("editor_folding_default_imports");
        this.fCollapseJavadoc = store.getBoolean("editor_folding_default_javadoc");
        this.fCollapseMembers = store.getBoolean("editor_folding_default_methods");
        this.fCollapseHeaderComments = store.getBoolean("editor_folding_default_headers");
    }

    private void update(FoldingStructureComputationContext ctx) {
        if (ctx == null) {
            return;
        }
        HashMap<JavaProjectionAnnotation, Position> additions = new HashMap<JavaProjectionAnnotation, Position>();
        ArrayList<JavaProjectionAnnotation> deletions = new ArrayList<JavaProjectionAnnotation>();
        ArrayList<JavaProjectionAnnotation> updates = new ArrayList<JavaProjectionAnnotation>();
        this.computeFoldingStructure(ctx);
        LinkedHashMap newStructure = ctx.fMap;
        Map<IJavaElement, List<Tuple>> oldStructure = this.computeCurrentStructure(ctx);
        for (JavaProjectionAnnotation newAnnotation : newStructure.keySet()) {
            Position newPosition = (Position)newStructure.get((Object)newAnnotation);
            IJavaElement element = newAnnotation.getElement();
            boolean isMalformedAnonymousType = newPosition.getOffset() == 0 && element.getElementType() == 7 && this.isInnerType((IType)element);
            List<Tuple> annotations = oldStructure.get(element);
            if (annotations == null) {
                if (isMalformedAnonymousType) continue;
                additions.put(newAnnotation, newPosition);
                continue;
            }
            Iterator<Tuple> x = annotations.iterator();
            boolean matched = false;
            while (x.hasNext()) {
                boolean updateCollapsedState;
                Tuple tuple = x.next();
                JavaProjectionAnnotation existingAnnotation = tuple.annotation;
                Position existingPosition = tuple.position;
                if (newAnnotation.isComment() != existingAnnotation.isComment()) continue;
                boolean bl = updateCollapsedState = ctx.allowCollapsing() && existingAnnotation.isCollapsed() != newAnnotation.isCollapsed();
                if (!(isMalformedAnonymousType || existingPosition == null || newPosition.equals((Object)existingPosition) && !updateCollapsedState)) {
                    existingPosition.setOffset(newPosition.getOffset());
                    existingPosition.setLength(newPosition.getLength());
                    if (updateCollapsedState) {
                        if (newAnnotation.isCollapsed()) {
                            existingAnnotation.markCollapsed();
                        } else {
                            existingAnnotation.markExpanded();
                        }
                    }
                    updates.add(existingAnnotation);
                }
                matched = true;
                x.remove();
                break;
            }
            if (!matched) {
                additions.put(newAnnotation, newPosition);
            }
            if (!annotations.isEmpty()) continue;
            oldStructure.remove(element);
        }
        for (List<Tuple> list : oldStructure.values()) {
            int size = list.size();
            int i = 0;
            while (i < size) {
                deletions.add(list.get((int)i).annotation);
                ++i;
            }
        }
        this.match(deletions, additions, updates, ctx);
        Annotation[] deletedArray = deletions.toArray(new Annotation[deletions.size()]);
        Annotation[] changedArray = updates.toArray(new Annotation[updates.size()]);
        ctx.getModel().modifyAnnotations(deletedArray, additions, changedArray);
        ctx.fScanner.setSource(null);
    }

    private void computeFoldingStructure(FoldingStructureComputationContext ctx) {
        IParent parent = (IParent)this.fInput;
        try {
            if (!(this.fInput instanceof ISourceReference)) {
                return;
            }
            String source = ((ISourceReference)this.fInput).getSource();
            if (source == null) {
                return;
            }
            ctx.getScanner().setSource(source.toCharArray());
            this.computeFoldingStructure(parent.getChildren(), ctx);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void computeFoldingStructure(IJavaElement[] elements, FoldingStructureComputationContext ctx) throws JavaModelException {
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            this.computeFoldingStructure(element, ctx);
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.computeFoldingStructure(parent.getChildren(), ctx);
            }
            ++i;
        }
    }

    protected void computeFoldingStructure(IJavaElement element, FoldingStructureComputationContext ctx) {
        boolean collapse = false;
        boolean collapseCode = true;
        switch (element.getElementType()) {
            case 12: {
                collapse = ctx.collapseImportContainer();
                break;
            }
            case 7: {
                collapseCode = this.isInnerType((IType)element) && !this.isAnonymousEnum((IType)element);
                collapse = ctx.collapseInnerTypes() && collapseCode;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                collapse = ctx.collapseMembers();
                break;
            }
            default: {
                return;
            }
        }
        IRegion[] regions = this.computeProjectionRanges((ISourceReference)element, ctx);
        if (regions.length > 0) {
            IRegion normalized;
            int i = 0;
            while (i < regions.length - 1) {
                Position position;
                IRegion normalized2 = this.alignRegion(regions[i], ctx);
                if (normalized2 != null && (position = this.createCommentPosition(normalized2)) != null) {
                    boolean commentCollapse = i == 0 && (regions.length > 2 || ctx.hasHeaderComment()) && element == ctx.getFirstType() ? ctx.collapseHeaderComments() : ctx.collapseJavadoc();
                    ctx.addProjectionRange(new JavaProjectionAnnotation(commentCollapse, element, true), position);
                }
                ++i;
            }
            if (collapseCode && (normalized = this.alignRegion(regions[regions.length - 1], ctx)) != null) {
                Position position;
                Position position2 = position = element instanceof IMember ? this.createMemberPosition(normalized, (IMember)element) : this.createCommentPosition(normalized);
                if (position != null) {
                    ctx.addProjectionRange(new JavaProjectionAnnotation(collapse, element, false), position);
                }
            }
        }
    }

    private boolean isAnonymousEnum(IType type) {
        try {
            return type.isEnum() && type.isAnonymous();
        }
        catch (JavaModelException x) {
            return false;
        }
    }

    private boolean isInnerType(IType type) {
        return type.getDeclaringType() != null;
    }

    protected final IRegion[] computeProjectionRanges(ISourceReference reference, FoldingStructureComputationContext ctx) {
        try {
            ISourceRange range = reference.getSourceRange();
            if (!SourceRange.isAvailable((ISourceRange)range)) {
                return new IRegion[0];
            }
            String contents = reference.getSource();
            if (contents == null) {
                return new IRegion[0];
            }
            ArrayList<Object> regions = new ArrayList<Object>();
            if (!ctx.hasFirstType() && reference instanceof IType) {
                ctx.setFirstType((IType)reference);
                IRegion headerComment = this.computeHeaderComment(ctx);
                if (headerComment != null) {
                    regions.add(headerComment);
                    ctx.setHasHeaderComment();
                }
            }
            int shift = range.getOffset();
            IScanner scanner = ctx.getScanner();
            scanner.resetTo(shift, shift + range.getLength());
            int start = shift;
            block7: while (true) {
                int token = scanner.getNextToken();
                start = scanner.getCurrentTokenStartPosition();
                switch (token) {
                    case 1002: 
                    case 1003: {
                        int end = scanner.getCurrentTokenEndPosition() + 1;
                        regions.add(new Region(start, end - start));
                        continue block7;
                    }
                    case 1001: {
                        continue block7;
                    }
                }
                break;
            }
            regions.add(new Region(start, shift + range.getLength() - start));
            IRegion[] result = new IRegion[regions.size()];
            regions.toArray(result);
            return result;
        }
        catch (JavaModelException javaModelException) {
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return new IRegion[0];
    }

    private IRegion computeHeaderComment(FoldingStructureComputationContext ctx) throws JavaModelException {
        ISourceRange range = ctx.getFirstType().getSourceRange();
        if (range == null) {
            return null;
        }
        int start = 0;
        int end = range.getOffset();
        IScanner scanner = ctx.getScanner();
        scanner.resetTo(start, end);
        int headerStart = -1;
        int headerEnd = -1;
        try {
            boolean foundComment = false;
            int terminal = scanner.getNextToken();
            while (terminal != 158 && terminal != 165 && terminal != 180 && terminal != 400 && (!foundComment || terminal != 191 && terminal != 214)) {
                if (terminal == 1003 || terminal == 1002 || terminal == 1001) {
                    if (!foundComment) {
                        headerStart = scanner.getCurrentTokenStartPosition();
                    }
                    headerEnd = scanner.getCurrentTokenEndPosition();
                    foundComment = true;
                }
                terminal = scanner.getNextToken();
            }
        }
        catch (InvalidInputException ex) {
            return null;
        }
        if (headerEnd != -1) {
            return new Region(headerStart, headerEnd - headerStart);
        }
        return null;
    }

    protected final Position createCommentPosition(IRegion aligned) {
        return new CommentPosition(aligned.getOffset(), aligned.getLength());
    }

    protected final Position createMemberPosition(IRegion aligned, IMember member) {
        return new JavaElementPosition(aligned.getOffset(), aligned.getLength(), member);
    }

    protected final IRegion alignRegion(IRegion region, FoldingStructureComputationContext ctx) {
        int end;
        int start;
        IDocument document;
        block4: {
            if (region == null) {
                return null;
            }
            document = ctx.getDocument();
            try {
                start = document.getLineOfOffset(region.getOffset());
                end = document.getLineOfOffset(region.getOffset() + region.getLength());
                if (start < end) break block4;
                return null;
            }
            catch (BadLocationException x) {
                return null;
            }
        }
        int offset = document.getLineOffset(start);
        int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
        return new Region(offset, endOffset - offset);
    }

    private ProjectionAnnotationModel getModel() {
        return (ProjectionAnnotationModel)this.fEditor.getAdapter(ProjectionAnnotationModel.class);
    }

    private IDocument getDocument() {
        JavaEditor editor = this.fEditor;
        if (editor == null) {
            return null;
        }
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider == null) {
            return null;
        }
        return provider.getDocument((Object)editor.getEditorInput());
    }

    private void match(List<JavaProjectionAnnotation> deletions, Map<JavaProjectionAnnotation, Position> additions, List<JavaProjectionAnnotation> changes, FoldingStructureComputationContext ctx) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<JavaProjectionAnnotation> newDeletions = new ArrayList<JavaProjectionAnnotation>();
        ArrayList<JavaProjectionAnnotation> newChanges = new ArrayList<JavaProjectionAnnotation>();
        Iterator<JavaProjectionAnnotation> deletionIterator = deletions.iterator();
        while (deletionIterator.hasNext()) {
            JavaProjectionAnnotation deleted = deletionIterator.next();
            Position deletedPosition = ctx.getModel().getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Tuple deletedTuple = new Tuple(deleted, deletedPosition);
            Tuple match = this.findMatch(deletedTuple, changes, null, ctx);
            boolean addToDeletions = true;
            if (match == null) {
                match = this.findMatch(deletedTuple, additions.keySet(), additions, ctx);
                addToDeletions = false;
            }
            if (match == null) continue;
            IJavaElement element = match.annotation.getElement();
            deleted.setElement(element);
            deletedPosition.setLength(match.position.getLength());
            if (deletedPosition instanceof JavaElementPosition && element instanceof IMember) {
                JavaElementPosition jep = (JavaElementPosition)deletedPosition;
                jep.setMember((IMember)element);
            }
            deletionIterator.remove();
            newChanges.add(deleted);
            if (!addToDeletions) continue;
            newDeletions.add(match.annotation);
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Tuple findMatch(Tuple tuple, Collection<JavaProjectionAnnotation> annotations, Map<JavaProjectionAnnotation, Position> positionMap, FoldingStructureComputationContext ctx) {
        Iterator<JavaProjectionAnnotation> it = annotations.iterator();
        while (it.hasNext()) {
            Position position;
            JavaProjectionAnnotation annotation = it.next();
            if (tuple.annotation.isComment() != annotation.isComment()) continue;
            Position position2 = position = positionMap == null ? ctx.getModel().getPosition((Annotation)annotation) : positionMap.get((Object)annotation);
            if (position == null || tuple.position.getOffset() != position.getOffset()) continue;
            it.remove();
            return new Tuple(annotation, position);
        }
        return null;
    }

    private Map<IJavaElement, List<Tuple>> computeCurrentStructure(FoldingStructureComputationContext ctx) {
        HashMap<IJavaElement, List<Tuple>> map = new HashMap<IJavaElement, List<Tuple>>();
        ProjectionAnnotationModel model = ctx.getModel();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof JavaProjectionAnnotation)) continue;
            JavaProjectionAnnotation java = (JavaProjectionAnnotation)((Object)annotation);
            Position position = model.getPosition((Annotation)java);
            Assert.isNotNull((Object)position);
            ArrayList<Tuple> list = (ArrayList<Tuple>)map.get(java.getElement());
            if (list == null) {
                list = new ArrayList<Tuple>(2);
                map.put(java.getElement(), list);
            }
            list.add(new Tuple(java, position));
        }
        Comparator<Tuple> comparator = new Comparator<Tuple>(){

            @Override
            public int compare(Tuple o1, Tuple o2) {
                return o1.position.getOffset() - o2.position.getOffset();
            }
        };
        for (List list : map.values()) {
            Collections.sort(list, comparator);
        }
        return map;
    }

    @Override
    public final void collapseMembers() {
        this.modifyFiltered(this.fMemberFilter, false);
    }

    @Override
    public final void collapseComments() {
        this.modifyFiltered(this.fCommentFilter, false);
    }

    @Override
    public final void collapseElements(IJavaElement[] elements) {
        HashSet<IJavaElement> set = new HashSet<IJavaElement>(Arrays.asList(elements));
        this.modifyFiltered(new JavaElementSetFilter(set, false), false);
    }

    @Override
    public final void expandElements(IJavaElement[] elements) {
        HashSet<IJavaElement> set = new HashSet<IJavaElement>(Arrays.asList(elements));
        this.modifyFiltered(new JavaElementSetFilter(set, true), true);
    }

    private void modifyFiltered(Filter filter, boolean expand) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        ArrayList<JavaProjectionAnnotation> modified = new ArrayList<JavaProjectionAnnotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            JavaProjectionAnnotation java;
            Object annotation = iter.next();
            if (!(annotation instanceof JavaProjectionAnnotation) || expand != (java = (JavaProjectionAnnotation)((Object)annotation)).isCollapsed() || !filter.match(java)) continue;
            if (expand) {
                java.markExpanded();
            } else {
                java.markCollapsed();
            }
            modified.add(java);
        }
        model.modifyAnnotations(null, null, modified.toArray(new Annotation[modified.size()]));
    }

    private static final class CommentFilter
    implements Filter {
        private CommentFilter() {
        }

        public boolean match(JavaProjectionAnnotation annotation) {
            return annotation.isComment() && !annotation.isMarkedDeleted();
        }
    }

    private static final class CommentPosition
    extends Position
    implements IProjectionPosition {
        CommentPosition(int offset, int length) {
            super(offset, length);
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            int postOffset;
            int postLength;
            Region preRegion;
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            int prefixEnd = 0;
            int contentStart = this.findFirstContent(sequence, prefixEnd);
            int firstLine = document.getLineOfOffset(this.offset + prefixEnd);
            int captionLine = document.getLineOfOffset(this.offset + contentStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            Assert.isTrue((firstLine <= captionLine ? 1 : 0) != 0, (String)"first folded line is greater than the caption line");
            Assert.isTrue((captionLine <= lastLine ? 1 : 0) != 0, (String)"caption line is greater than the last folded line");
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine && (postLength = this.offset + this.length - (postOffset = document.getLineOffset(captionLine + 1))) > 0) {
                Region postRegion = new Region(postOffset, postLength);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(CharSequence content, int prefixEnd) {
            int lenght = content.length();
            int i = prefixEnd;
            while (i < lenght) {
                if (Character.isUnicodeIdentifierPart(content.charAt(i))) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            DocumentCharacterIterator sequence = new DocumentCharacterIterator(document, this.offset, this.offset + this.length);
            return this.findFirstContent(sequence, 0);
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IJavaElementDelta delta = this.findElement(DefaultJavaFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null && (delta.getFlags() & 9) != 0) {
                if (this.shouldIgnoreDelta(e.getDelta().getCompilationUnitAST(), delta)) {
                    return;
                }
                DefaultJavaFoldingStructureProvider defaultJavaFoldingStructureProvider = DefaultJavaFoldingStructureProvider.this;
                defaultJavaFoldingStructureProvider.fUpdatingCount = defaultJavaFoldingStructureProvider.fUpdatingCount + 1;
                try {
                    DefaultJavaFoldingStructureProvider.this.update(DefaultJavaFoldingStructureProvider.this.createContext(false));
                }
                finally {
                    DefaultJavaFoldingStructureProvider defaultJavaFoldingStructureProvider2 = DefaultJavaFoldingStructureProvider.this;
                    defaultJavaFoldingStructureProvider2.fUpdatingCount = defaultJavaFoldingStructureProvider2.fUpdatingCount - 1;
                }
            }
        }

        private boolean shouldIgnoreDelta(CompilationUnit ast, IJavaElementDelta delta) {
            if (ast == null) {
                return false;
            }
            IDocument document = DefaultJavaFoldingStructureProvider.this.getDocument();
            if (document == null) {
                return false;
            }
            JavaEditor editor = DefaultJavaFoldingStructureProvider.this.fEditor;
            if (editor == null || editor.getCachedSelectedRange() == null) {
                return false;
            }
            try {
                IJavaElement elem;
                if (delta.getAffectedChildren().length == 1 && delta.getAffectedChildren()[0].getElement() instanceof IImportContainer && !((elem = SelectionConverter.getElementAtOffset(ast.getTypeRoot(), (ITextSelection)new TextSelection(editor.getCachedSelectedRange().x, editor.getCachedSelectedRange().y))) instanceof IImportDeclaration)) {
                    return false;
                }
            }
            catch (JavaModelException e) {
                return false;
            }
            int caretLine = 0;
            try {
                caretLine = document.getLineOfOffset(editor.getCachedSelectedRange().x) + 1;
            }
            catch (BadLocationException x) {
                return false;
            }
            if (caretLine > 0) {
                IProblem[] problems = ast.getProblems();
                int i = 0;
                while (i < problems.length) {
                    if (problems[i].isError() && caretLine == problems[i].getSourceLineNumber()) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        private IJavaElementDelta findElement(IJavaElement target, IJavaElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IJavaElement element = delta.getElement();
            if (element.getElementType() > 6) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IJavaElementDelta d = this.findElement(target, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    private static interface Filter {
        public boolean match(JavaProjectionAnnotation var1);
    }

    protected final class FoldingStructureComputationContext {
        private final ProjectionAnnotationModel fModel;
        private final IDocument fDocument;
        private final boolean fAllowCollapsing;
        private IType fFirstType;
        private boolean fHasHeaderComment;
        private LinkedHashMap<JavaProjectionAnnotation, Position> fMap = new LinkedHashMap();
        private IScanner fScanner;

        private FoldingStructureComputationContext(IDocument document, ProjectionAnnotationModel model, boolean allowCollapsing, IScanner scanner) {
            Assert.isNotNull((Object)document);
            Assert.isNotNull((Object)model);
            this.fDocument = document;
            this.fModel = model;
            this.fAllowCollapsing = allowCollapsing;
            this.fScanner = scanner;
        }

        private void setFirstType(IType type) {
            if (this.hasFirstType()) {
                throw new IllegalStateException();
            }
            this.fFirstType = type;
        }

        boolean hasFirstType() {
            return this.fFirstType != null;
        }

        private IType getFirstType() {
            return this.fFirstType;
        }

        private boolean hasHeaderComment() {
            return this.fHasHeaderComment;
        }

        private void setHasHeaderComment() {
            this.fHasHeaderComment = true;
        }

        public boolean allowCollapsing() {
            return this.fAllowCollapsing;
        }

        private IDocument getDocument() {
            return this.fDocument;
        }

        private ProjectionAnnotationModel getModel() {
            return this.fModel;
        }

        private IScanner getScanner() {
            if (this.fScanner == null) {
                this.fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
            }
            return this.fScanner;
        }

        public void addProjectionRange(JavaProjectionAnnotation annotation, Position position) {
            this.fMap.put(annotation, position);
        }

        public boolean collapseHeaderComments() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseHeaderComments;
        }

        public boolean collapseImportContainer() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseImportContainer;
        }

        public boolean collapseInnerTypes() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseInnerTypes;
        }

        public boolean collapseJavadoc() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseJavadoc;
        }

        public boolean collapseMembers() {
            return this.fAllowCollapsing && DefaultJavaFoldingStructureProvider.this.fCollapseMembers;
        }
    }

    private static final class JavaElementPosition
    extends Position
    implements IProjectionPosition {
        private IMember fMember;

        public JavaElementPosition(int offset, int length, IMember member) {
            super(offset, length);
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public void setMember(IMember member) {
            Assert.isNotNull((Object)member);
            this.fMember = member;
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            int postOffset;
            int postLength;
            Region preRegion;
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (JavaModelException nameRange) {
                // empty catch block
            }
            int firstLine = document.getLineOfOffset(this.offset);
            int captionLine = document.getLineOfOffset(nameStart);
            int lastLine = document.getLineOfOffset(this.offset + this.length);
            if (captionLine < firstLine) {
                captionLine = firstLine;
            }
            if (captionLine > lastLine) {
                captionLine = lastLine;
            }
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine && (postLength = this.offset + this.length - (postOffset = document.getLineOffset(captionLine + 1))) > 0) {
                Region postRegion = new Region(postOffset, postLength);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            int nameStart = this.offset;
            try {
                ISourceRange nameRange = this.fMember.getNameRange();
                if (nameRange != null) {
                    nameStart = nameRange.getOffset();
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return nameStart - this.offset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JavaElementSetFilter
    implements Filter {
        private final Set<? extends IJavaElement> fSet;
        private final boolean fMatchCollapsed;

        private JavaElementSetFilter(Set<? extends IJavaElement> set, boolean matchCollapsed) {
            this.fSet = set;
            this.fMatchCollapsed = matchCollapsed;
        }

        @Override
        public boolean match(JavaProjectionAnnotation annotation) {
            IJavaElement element;
            boolean stateMatch;
            boolean bl = stateMatch = this.fMatchCollapsed == annotation.isCollapsed();
            return stateMatch && !annotation.isComment() && !annotation.isMarkedDeleted() && this.fSet.contains(element = annotation.getElement());
        }
    }

    protected static final class JavaProjectionAnnotation
    extends ProjectionAnnotation {
        private IJavaElement fJavaElement;
        private boolean fIsComment;

        public JavaProjectionAnnotation(boolean isCollapsed, IJavaElement element, boolean isComment) {
            super(isCollapsed);
            this.fJavaElement = element;
            this.fIsComment = isComment;
        }

        IJavaElement getElement() {
            return this.fJavaElement;
        }

        void setElement(IJavaElement element) {
            this.fJavaElement = element;
        }

        boolean isComment() {
            return this.fIsComment;
        }

        void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }

        public String toString() {
            return "JavaProjectionAnnotation:\n\telement: \t" + this.fJavaElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment() + "\n";
        }
    }

    private static final class MemberFilter
    implements Filter {
        private MemberFilter() {
        }

        public boolean match(JavaProjectionAnnotation annotation) {
            IJavaElement element;
            return !annotation.isComment() && !annotation.isMarkedDeleted() && (element = annotation.getElement()) instanceof IMember && (element.getElementType() != 7 || ((IMember)element).getDeclaringType() != null);
        }
    }

    private final class ProjectionListener
    implements IProjectionListener {
        private ProjectionViewer fViewer;

        public ProjectionListener(ProjectionViewer viewer) {
            Assert.isLegal((viewer != null ? 1 : 0) != 0);
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }

        public void dispose() {
            if (this.fViewer != null) {
                this.fViewer.removeProjectionListener((IProjectionListener)this);
                this.fViewer = null;
            }
        }

        public void projectionEnabled() {
            DefaultJavaFoldingStructureProvider.this.handleProjectionEnabled();
        }

        public void projectionDisabled() {
            DefaultJavaFoldingStructureProvider.this.handleProjectionDisabled();
        }
    }

    private static final class Tuple {
        JavaProjectionAnnotation annotation;
        Position position;

        Tuple(JavaProjectionAnnotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }
    }
}

