/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.Binding;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.swt.graphics.Image;

public class WellKnownTypesProperty
extends ASTAttribute {
    public static final String[] WELL_KNOWN_TYPES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Class", "java.lang.Cloneable", "java.lang.Double", "java.lang.Error", "java.lang.Exception", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Object", "java.lang.RuntimeException", "java.lang.Short", "java.lang.String", "java.lang.StringBuffer", "java.lang.Throwable", "java.lang.Void", "java.io.Serializable", "_.$UnknownType$"};
    private final CompilationUnit fRoot;

    public WellKnownTypesProperty(CompilationUnit root) {
        this.fRoot = root;
    }

    public Object getParent() {
        return this.fRoot;
    }

    public Object[] getChildren() {
        AST ast = this.fRoot.getAST();
        Object[] res = new Binding[WELL_KNOWN_TYPES.length];
        int i = 0;
        while (i < WELL_KNOWN_TYPES.length) {
            String type = WELL_KNOWN_TYPES[i];
            res[i] = new Binding(this, type, (IBinding)ast.resolveWellKnownType(type), true);
            ++i;
        }
        return res;
    }

    public String getLabel() {
        return "> RESOLVE_WELL_KNOWN_TYPES";
    }

    public Image getImage() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return 57;
    }
}

