/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.util.ArrayList;
import org.eclipse.jdt.astview.ASTViewPlugin;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.BindingProperty;
import org.eclipse.jdt.astview.views.Error;
import org.eclipse.jdt.astview.views.GeneralAttribute;
import org.eclipse.jdt.astview.views.JavaElement;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.swt.graphics.Image;

public class Binding
extends ASTAttribute {
    private final IBinding fBinding;
    private final String fLabel;
    private final Object fParent;
    private final boolean fIsRelevant;
    private static final int ARRAY_TYPE = 1;
    private static final int NULL_TYPE = 2;
    private static final int VARIABLE_TYPE = 4;
    private static final int WILDCARD_TYPE = 8;
    private static final int CAPTURE_TYPE = 16;
    private static final int PRIMITIVE_TYPE = 32;
    private static final int REF_TYPE = 64;
    private static final int GENERIC = 256;
    private static final int PARAMETRIZED = 512;

    public Binding(Object parent, String label, IBinding binding, boolean isRelevant) {
        this.fParent = parent;
        this.fBinding = binding;
        this.fLabel = label;
        this.fIsRelevant = isRelevant;
    }

    public Object getParent() {
        return this.fParent;
    }

    public IBinding getBinding() {
        return this.fBinding;
    }

    public boolean hasBindingProperties() {
        return this.fBinding != null;
    }

    public boolean isRelevant() {
        return this.fIsRelevant;
    }

    private static boolean isType(int typeKinds, int kind) {
        return (typeKinds & kind) != 0;
    }

    public Object[] getChildren() {
        if (this.fBinding != null) {
            String label;
            ArrayList<ASTAttribute> res = new ArrayList<ASTAttribute>();
            res.add(new BindingProperty(this, "NAME", this.fBinding.getName(), true));
            res.add(new BindingProperty(this, "KEY", this.fBinding.getKey(), true));
            res.add(new BindingProperty(this, "IS RECOVERED", this.fBinding.isRecovered(), true));
            switch (this.fBinding.getKind()) {
                case 3: {
                    IVariableBinding variableBinding = (IVariableBinding)this.fBinding;
                    res.add(new BindingProperty(this, "IS FIELD", variableBinding.isField(), true));
                    res.add(new BindingProperty(this, "IS ENUM CONSTANT", variableBinding.isEnumConstant(), true));
                    res.add(new BindingProperty(this, "IS PARAMETER", variableBinding.isParameter(), true));
                    res.add(new BindingProperty(this, "VARIABLE ID", variableBinding.getVariableId(), true));
                    res.add(new BindingProperty(this, "MODIFIERS", Flags.toString((int)this.fBinding.getModifiers()), true));
                    res.add(new Binding(this, "TYPE", (IBinding)variableBinding.getType(), true));
                    res.add(new Binding(this, "DECLARING CLASS", (IBinding)variableBinding.getDeclaringClass(), true));
                    res.add(new Binding(this, "DECLARING METHOD", (IBinding)variableBinding.getDeclaringMethod(), true));
                    res.add(new Binding(this, "VARIABLE DECLARATION", (IBinding)variableBinding.getVariableDeclaration(), true));
                    res.add(new BindingProperty(this, "IS SYNTHETIC", this.fBinding.isSynthetic(), true));
                    res.add(new BindingProperty(this, "IS DEPRECATED", this.fBinding.isDeprecated(), true));
                    res.add(new BindingProperty(this, "CONSTANT VALUE", variableBinding.getConstantValue(), true));
                    break;
                }
                case 1: {
                    IPackageBinding packageBinding = (IPackageBinding)this.fBinding;
                    res.add(new BindingProperty(this, "IS UNNAMED", packageBinding.isUnnamed(), true));
                    res.add(new BindingProperty(this, "IS SYNTHETIC", this.fBinding.isSynthetic(), true));
                    res.add(new BindingProperty(this, "IS DEPRECATED", this.fBinding.isDeprecated(), true));
                    break;
                }
                case 2: {
                    ITypeBinding typeBinding = (ITypeBinding)this.fBinding;
                    res.add(new BindingProperty(this, "QUALIFIED NAME", typeBinding.getQualifiedName(), true));
                    int typeKind = this.getTypeKind(typeBinding);
                    boolean isRefType = Binding.isType(typeKind, 64);
                    boolean isNonPrimitive = !Binding.isType(typeKind, 32);
                    StringBuffer kinds = new StringBuffer("KIND:");
                    if (typeBinding.isArray()) {
                        kinds.append(" isArray");
                    }
                    if (typeBinding.isCapture()) {
                        kinds.append(" isCapture");
                    }
                    if (typeBinding.isNullType()) {
                        kinds.append(" isNullType");
                    }
                    if (typeBinding.isPrimitive()) {
                        kinds.append(" isPrimitive");
                    }
                    if (typeBinding.isTypeVariable()) {
                        kinds.append(" isTypeVariable");
                    }
                    if (typeBinding.isWildcardType()) {
                        kinds.append(" isWildcardType");
                    }
                    if (typeBinding.isAnnotation()) {
                        kinds.append(" isAnnotation");
                    }
                    if (typeBinding.isClass()) {
                        kinds.append(" isClass");
                    }
                    if (typeBinding.isInterface()) {
                        kinds.append(" isInterface");
                    }
                    if (typeBinding.isEnum()) {
                        kinds.append(" isEnum");
                    }
                    res.add(new BindingProperty(this, kinds, true));
                    StringBuffer generics = new StringBuffer("GENERICS:");
                    if (typeBinding.isRawType()) {
                        generics.append(" isRawType");
                    }
                    if (typeBinding.isGenericType()) {
                        generics.append(" isGenericType");
                    }
                    if (typeBinding.isParameterizedType()) {
                        generics.append(" isParameterizedType");
                    }
                    if (!Binding.isType(typeKind, 768)) {
                        generics.append(" (non-generic, non-parameterized)");
                    }
                    res.add(new BindingProperty(this, generics, isRefType));
                    res.add(new Binding(this, "ELEMENT TYPE", (IBinding)typeBinding.getElementType(), Binding.isType(typeKind, 1)));
                    res.add(new Binding(this, "COMPONENT TYPE", (IBinding)typeBinding.getComponentType(), Binding.isType(typeKind, 1)));
                    res.add(new BindingProperty(this, "DIMENSIONS", typeBinding.getDimensions(), Binding.isType(typeKind, 1)));
                    try {
                        ITypeBinding arrayType = typeBinding.createArrayType(1);
                        res.add(new Binding(this, "CREATE ARRAY TYPE (+1)", (IBinding)arrayType, true));
                    }
                    catch (RuntimeException e) {
                        boolean isRelevant;
                        String msg = String.valueOf(e.getClass().getName()) + ": " + e.getLocalizedMessage();
                        boolean bl = isRelevant = !typeBinding.getName().equals(PrimitiveType.VOID.toString()) && !typeBinding.isRecovered();
                        if (isRelevant) {
                            res.add(new Error(this, "CREATE ARRAY TYPE (+1): " + msg, e));
                        }
                        res.add(new BindingProperty(this, "CREATE ARRAY TYPE (+1)", msg, false));
                    }
                    res.add(new BindingProperty(this, "TYPE BOUNDS", (IBinding[])typeBinding.getTypeBounds(), Binding.isType(typeKind, 20)));
                    StringBuffer origin = new StringBuffer("ORIGIN:");
                    if (typeBinding.isTopLevel()) {
                        origin.append(" isTopLevel");
                    }
                    if (typeBinding.isNested()) {
                        origin.append(" isNested");
                    }
                    if (typeBinding.isLocal()) {
                        origin.append(" isLocal");
                    }
                    if (typeBinding.isMember()) {
                        origin.append(" isMember");
                    }
                    if (typeBinding.isAnonymous()) {
                        origin.append(" isAnonymous");
                    }
                    res.add(new BindingProperty(this, origin, isRefType));
                    res.add(new BindingProperty(this, "IS FROM SOURCE", typeBinding.isFromSource(), Binding.isType(typeKind, 84)));
                    res.add(new Binding(this, "PACKAGE", (IBinding)typeBinding.getPackage(), isRefType));
                    res.add(new Binding(this, "DECLARING CLASS", (IBinding)typeBinding.getDeclaringClass(), Binding.isType(typeKind, 84)));
                    res.add(new Binding(this, "DECLARING METHOD", (IBinding)typeBinding.getDeclaringMethod(), Binding.isType(typeKind, 84)));
                    res.add(new BindingProperty(this, "MODIFIERS", Flags.toString((int)this.fBinding.getModifiers()), isRefType));
                    res.add(new BindingProperty(this, "BINARY NAME", typeBinding.getBinaryName(), true));
                    res.add(new Binding(this, "TYPE DECLARATION", (IBinding)typeBinding.getTypeDeclaration(), isNonPrimitive));
                    res.add(new Binding(this, "ERASURE", (IBinding)typeBinding.getErasure(), isNonPrimitive));
                    res.add(new BindingProperty(this, "TYPE PARAMETERS", (IBinding[])typeBinding.getTypeParameters(), Binding.isType(typeKind, 256)));
                    res.add(new BindingProperty(this, "TYPE ARGUMENTS", (IBinding[])typeBinding.getTypeArguments(), Binding.isType(typeKind, 512)));
                    res.add(new Binding(this, "BOUND", (IBinding)typeBinding.getBound(), Binding.isType(typeKind, 8)));
                    res.add(new BindingProperty(this, "IS UPPERBOUND", typeBinding.isUpperbound(), Binding.isType(typeKind, 8)));
                    res.add(new Binding(this, "GENERIC TYPE OF WILDCARD TYPE", (IBinding)typeBinding.getGenericTypeOfWildcardType(), Binding.isType(typeKind, 8)));
                    res.add(new BindingProperty(this, "RANK", typeBinding.getRank(), Binding.isType(typeKind, 8)));
                    res.add(new Binding(this, "WILDCARD", (IBinding)typeBinding.getWildcard(), Binding.isType(typeKind, 16)));
                    res.add(new Binding(this, "SUPERCLASS", (IBinding)typeBinding.getSuperclass(), isRefType));
                    res.add(new BindingProperty(this, "INTERFACES", (IBinding[])typeBinding.getInterfaces(), isRefType));
                    res.add(new BindingProperty(this, "DECLARED TYPES", (IBinding[])typeBinding.getDeclaredTypes(), isRefType));
                    res.add(new BindingProperty(this, "DECLARED FIELDS", (IBinding[])typeBinding.getDeclaredFields(), isRefType));
                    res.add(new BindingProperty(this, "DECLARED METHODS", (IBinding[])typeBinding.getDeclaredMethods(), isRefType));
                    res.add(new BindingProperty(this, "IS SYNTHETIC", this.fBinding.isSynthetic(), isNonPrimitive));
                    res.add(new BindingProperty(this, "IS DEPRECATED", this.fBinding.isDeprecated(), isRefType));
                    break;
                }
                case 4: {
                    IMethodBinding methodBinding = (IMethodBinding)this.fBinding;
                    res.add(new BindingProperty(this, "IS CONSTRUCTOR", methodBinding.isConstructor(), true));
                    res.add(new BindingProperty(this, "IS DEFAULT CONSTRUCTOR", methodBinding.isDefaultConstructor(), true));
                    res.add(new Binding(this, "DECLARING CLASS", (IBinding)methodBinding.getDeclaringClass(), true));
                    res.add(new Binding(this, "RETURN TYPE", (IBinding)methodBinding.getReturnType(), true));
                    res.add(new BindingProperty(this, "MODIFIERS", Flags.toString((int)this.fBinding.getModifiers()), true));
                    res.add(new BindingProperty(this, "PARAMETER TYPES", (IBinding[])methodBinding.getParameterTypes(), true));
                    res.add(new BindingProperty(this, "IS VARARGS", methodBinding.isVarargs(), true));
                    res.add(new BindingProperty(this, "EXCEPTION TYPES", (IBinding[])methodBinding.getExceptionTypes(), true));
                    StringBuffer genericsM = new StringBuffer("GENERICS:");
                    if (methodBinding.isRawMethod()) {
                        genericsM.append(" isRawMethod");
                    }
                    if (methodBinding.isGenericMethod()) {
                        genericsM.append(" isGenericMethod");
                    }
                    if (methodBinding.isParameterizedMethod()) {
                        genericsM.append(" isParameterizedMethod");
                    }
                    res.add(new BindingProperty(this, genericsM, true));
                    res.add(new Binding(this, "METHOD DECLARATION", (IBinding)methodBinding.getMethodDeclaration(), true));
                    res.add(new BindingProperty(this, "TYPE PARAMETERS", (IBinding[])methodBinding.getTypeParameters(), true));
                    res.add(new BindingProperty(this, "TYPE ARGUMENTS", (IBinding[])methodBinding.getTypeArguments(), true));
                    res.add(new BindingProperty(this, "IS SYNTHETIC", this.fBinding.isSynthetic(), true));
                    res.add(new BindingProperty(this, "IS DEPRECATED", this.fBinding.isDeprecated(), true));
                    res.add(new BindingProperty(this, "IS ANNOTATION MEMBER", methodBinding.isAnnotationMember(), true));
                    res.add(Binding.createValueAttribute(this, "DEFAULT VALUE", methodBinding.getDefaultValue()));
                    int parameterCount = methodBinding.getParameterTypes().length;
                    ASTAttribute[] parametersAnnotations = new BindingProperty[parameterCount];
                    int i = 0;
                    while (i < parameterCount) {
                        parametersAnnotations[i] = new BindingProperty(this, "Parameter " + String.valueOf(i), (IBinding[])methodBinding.getParameterAnnotations(i), true);
                        ++i;
                    }
                    res.add(new BindingProperty(this, "PARAMETER ANNOTATIONS", parametersAnnotations, true));
                    break;
                }
                case 5: {
                    IAnnotationBinding annotationBinding = (IAnnotationBinding)this.fBinding;
                    res.add(new Binding(this, "ANNOTATION TYPE", (IBinding)annotationBinding.getAnnotationType(), true));
                    res.add(new BindingProperty(this, "DECLARED MEMBER VALUE PAIRS", (IBinding[])annotationBinding.getDeclaredMemberValuePairs(), true));
                    res.add(new BindingProperty(this, "ALL MEMBER VALUE PAIRS", (IBinding[])annotationBinding.getAllMemberValuePairs(), true));
                    break;
                }
                case 6: {
                    IMemberValuePairBinding memberValuePairBinding = (IMemberValuePairBinding)this.fBinding;
                    res.add(new Binding(this, "METHOD BINDING", (IBinding)memberValuePairBinding.getMethodBinding(), true));
                    res.add(new BindingProperty(this, "IS DEFAULT", memberValuePairBinding.isDefault(), true));
                    res.add(Binding.createValueAttribute(this, "VALUE", memberValuePairBinding.getValue()));
                }
            }
            try {
                IAnnotationBinding[] annotations = this.fBinding.getAnnotations();
                res.add(new BindingProperty(this, "ANNOTATIONS", (IBinding[])annotations, true));
            }
            catch (RuntimeException e) {
                label = "Error in IBinding#getAnnotations() for \"" + this.fBinding.getKey() + "\"";
                res.add(new Error(this, label, e));
                ASTViewPlugin.log("Exception thrown in IBinding#getAnnotations() for \"" + this.fBinding.getKey() + "\"", e);
            }
            try {
                IJavaElement javaElement = this.fBinding.getJavaElement();
                res.add(new JavaElement(this, javaElement));
            }
            catch (RuntimeException e) {
                label = ">java element: " + e.getClass().getName() + " for \"" + this.fBinding.getKey() + "\"";
                res.add(new Error(this, label, e));
                ASTViewPlugin.log("Exception thrown in IBinding#getJavaElement() for \"" + this.fBinding.getKey() + "\"", e);
            }
            return res.toArray();
        }
        return EMPTY;
    }

    private int getTypeKind(ITypeBinding typeBinding) {
        if (typeBinding.isArray()) {
            return 1;
        }
        if (typeBinding.isCapture()) {
            return 16;
        }
        if (typeBinding.isNullType()) {
            return 2;
        }
        if (typeBinding.isPrimitive()) {
            return 32;
        }
        if (typeBinding.isTypeVariable()) {
            return 4;
        }
        if (typeBinding.isWildcardType()) {
            return 8;
        }
        if (typeBinding.isGenericType()) {
            return 320;
        }
        if (typeBinding.isParameterizedType() || typeBinding.isRawType()) {
            return 576;
        }
        return 64;
    }

    public String getLabel() {
        StringBuffer buf = new StringBuffer(this.fLabel);
        buf.append(": ");
        if (this.fBinding != null) {
            switch (this.fBinding.getKind()) {
                case 3: {
                    IVariableBinding variableBinding = (IVariableBinding)this.fBinding;
                    if (!variableBinding.isField()) {
                        buf.append(variableBinding.getName());
                        break;
                    }
                    if (variableBinding.getDeclaringClass() == null) {
                        buf.append("array type");
                        break;
                    }
                    buf.append(variableBinding.getDeclaringClass().getName());
                    buf.append('.');
                    buf.append(variableBinding.getName());
                    break;
                }
                case 1: {
                    IPackageBinding packageBinding = (IPackageBinding)this.fBinding;
                    buf.append(packageBinding.getName());
                    break;
                }
                case 2: {
                    ITypeBinding typeBinding = (ITypeBinding)this.fBinding;
                    buf.append(typeBinding.getQualifiedName());
                    break;
                }
                case 4: {
                    IMethodBinding methodBinding = (IMethodBinding)this.fBinding;
                    buf.append(methodBinding.getDeclaringClass().getName());
                    buf.append('.');
                    buf.append(methodBinding.getName());
                    buf.append('(');
                    ITypeBinding[] parameters = methodBinding.getParameterTypes();
                    int i = 0;
                    while (i < parameters.length) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        ITypeBinding parameter = parameters[i];
                        buf.append(parameter.getName());
                        ++i;
                    }
                    buf.append(')');
                    break;
                }
                case 5: 
                case 6: {
                    buf.append(this.fBinding.toString());
                }
            }
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public Image getImage() {
        return null;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Binding other = (Binding)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        if (this.fBinding == null ? other.fBinding != null : !this.fBinding.equals((Object)other.fBinding)) {
            return false;
        }
        return !(this.fLabel == null ? other.fLabel != null : !this.fLabel.equals(other.fLabel));
    }

    public int hashCode() {
        int result = this.fParent != null ? this.fParent.hashCode() : 0;
        result += this.fBinding != null && this.fBinding.getKey() != null ? this.fBinding.getKey().hashCode() : 0;
        return result += this.fLabel != null ? this.fLabel.hashCode() : 0;
    }

    public static String getBindingLabel(IBinding binding) {
        String label;
        if (binding == null) {
            label = ">binding";
        } else {
            switch (binding.getKind()) {
                case 3: {
                    label = "> variable binding";
                    break;
                }
                case 2: {
                    label = "> type binding";
                    break;
                }
                case 4: {
                    label = "> method binding";
                    break;
                }
                case 1: {
                    label = "> package binding";
                    break;
                }
                case 5: {
                    label = "> annotation binding";
                    break;
                }
                case 6: {
                    label = "> member value pair binding";
                    break;
                }
                default: {
                    label = "> unknown binding";
                }
            }
        }
        return label;
    }

    public static ASTAttribute createValueAttribute(ASTAttribute parent, String name, Object value) {
        ASTAttribute res;
        if (value instanceof IBinding) {
            IBinding binding = (IBinding)value;
            res = new Binding(parent, String.valueOf(name) + ": " + Binding.getBindingLabel(binding), binding, true);
        } else {
            res = value instanceof String ? new GeneralAttribute((Object)parent, name, Binding.getEscapedStringLiteral((String)value)) : (value instanceof Object[] ? new GeneralAttribute((Object)parent, name, (Object[])value) : (value instanceof ASTAttribute ? (ASTAttribute)value : new GeneralAttribute((Object)parent, name, value)));
        }
        return res;
    }

    public static String getEscapedStringLiteral(String stringValue) {
        StringLiteral stringLiteral = AST.newAST((int)4).newStringLiteral();
        stringLiteral.setLiteralValue(stringValue);
        return stringLiteral.getEscapedValue();
    }

    public static String getEscapedCharLiteral(char charValue) {
        CharacterLiteral charLiteral = AST.newAST((int)4).newCharacterLiteral();
        charLiteral.setCharValue(charValue);
        return charLiteral.getEscapedValue();
    }
}

