/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.GeneralAttribute;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.swt.graphics.Image;

public class ProblemNode
extends ASTAttribute {
    private final IProblem fProblem;
    private final Object fParent;
    static /* synthetic */ Class class$0;

    public ProblemNode(Object parent, IProblem problem) {
        this.fParent = parent;
        this.fProblem = problem;
    }

    public Object getParent() {
        return this.fParent;
    }

    public Object[] getChildren() {
        String[] arguments = this.fProblem.getArguments();
        ArrayList<GeneralAttribute> children = new ArrayList<GeneralAttribute>();
        children.add(new GeneralAttribute((Object)this, "CONSTANT NAME", this.getConstantName()));
        children.add(new GeneralAttribute((Object)this, "ID", this.getErrorLabel()));
        children.add(new GeneralAttribute((Object)this, "OPTION FOR CONFIGURABLE SEVERITY", JavaCore.getOptionForConfigurableSeverity((int)this.fProblem.getID())));
        if (this.fProblem instanceof CategorizedProblem) {
            children.add(new GeneralAttribute((Object)this, "CATEGORY ID", this.getCategoryCode()));
            children.add(new GeneralAttribute((Object)this, "MARKER TYPE", ((CategorizedProblem)this.fProblem).getMarkerType()));
        }
        int i = 0;
        while (i < arguments.length) {
            children.add(new GeneralAttribute((Object)this, "ARGUMENT " + i, arguments[i]));
            ++i;
        }
        return children.toArray();
    }

    public String getLabel() {
        StringBuffer buf = new StringBuffer();
        int offset = this.fProblem.getSourceStart();
        int length = this.fProblem.getSourceEnd() + 1 - offset;
        if (this.fProblem.isError()) {
            buf.append("E");
        }
        if (this.fProblem.isWarning()) {
            buf.append("W");
        }
        buf.append('[').append(offset).append(", ").append(length).append(']').append(' ');
        buf.append(this.fProblem.getMessage());
        return buf.toString();
    }

    private String getErrorLabel() {
        int id = this.fProblem.getID();
        StringBuffer buf = new StringBuffer();
        if ((id & 0x1000000) != 0) {
            buf.append("TypeRelated + ");
        }
        if ((id & 0x2000000) != 0) {
            buf.append("FieldRelated + ");
        }
        if ((id & 0x8000000) != 0) {
            buf.append("ConstructorRelated + ");
        }
        if ((id & 0x4000000) != 0) {
            buf.append("MethodRelated + ");
        }
        if ((id & 0x10000000) != 0) {
            buf.append("ImportRelated + ");
        }
        if ((id & 0x20000000) != 0) {
            buf.append("Internal + ");
        }
        if ((id & 0x40000000) != 0) {
            buf.append("Syntax + ");
        }
        if ((id & Integer.MIN_VALUE) != 0) {
            buf.append("Javadoc + ");
        }
        buf.append(id & 0xFFFFFF);
        buf.append(" = 0x").append(Integer.toHexString(id)).append(" = ").append(id);
        return buf.toString();
    }

    private String getConstantName() {
        int id = this.fProblem.getID();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = clazz.getFields();
        int i = 0;
        while (i < fields.length) {
            Field f = fields[i];
            try {
                if (f.getType() == Integer.TYPE && f.getInt(f) == id) {
                    return "IProblem." + f.getName();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++i;
        }
        return "<UNKNOWN CONSTANT>";
    }

    private String getCategoryCode() {
        CategorizedProblem categorized = (CategorizedProblem)this.fProblem;
        int categoryID = categorized.getCategoryID();
        StringBuffer buf = new StringBuffer();
        switch (categoryID) {
            case 0: {
                buf.append("Unspecified");
                break;
            }
            case 10: {
                buf.append("Buildpath");
                break;
            }
            case 20: {
                buf.append("Syntax");
                break;
            }
            case 30: {
                buf.append("Import");
                break;
            }
            case 40: {
                buf.append("Type");
                break;
            }
            case 50: {
                buf.append("Member");
                break;
            }
            case 60: {
                buf.append("Internal");
                break;
            }
            case 70: {
                buf.append("Javadoc");
                break;
            }
            case 80: {
                buf.append("Code Style");
                break;
            }
            case 90: {
                buf.append("Potential Programming Problem");
                break;
            }
            case 100: {
                buf.append("Name Shadowing Conflict");
                break;
            }
            case 110: {
                buf.append("Deprecation");
                break;
            }
            case 120: {
                buf.append("Unnecessary Code");
                break;
            }
            case 130: {
                buf.append("Unchecked Raw");
                break;
            }
            case 140: {
                buf.append("NLS");
                break;
            }
            case 150: {
                buf.append("Restriction");
                break;
            }
            default: {
                buf.append("<UNKNOWN CATEGORY>");
            }
        }
        buf.append(" = ").append(categoryID);
        return buf.toString();
    }

    public Image getImage() {
        return null;
    }

    public int getOffset() {
        return this.fProblem.getSourceStart();
    }

    public int getLength() {
        return this.fProblem.getSourceEnd() + 1 - this.fProblem.getSourceStart();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ProblemNode other = (ProblemNode)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        return !(this.fProblem == null ? other.fProblem != null : !this.fProblem.equals(other.fProblem));
    }

    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fProblem != null ? this.fProblem.hashCode() : 0);
    }
}

