/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.astview.views;

import java.util.ArrayList;
import org.eclipse.jdt.astview.views.ASTAttribute;
import org.eclipse.jdt.astview.views.Binding;
import org.eclipse.jdt.astview.views.DynamicAttributeProperty;
import org.eclipse.jdt.astview.views.DynamicBindingProperty;
import org.eclipse.jdt.astview.views.ExceptionAttribute;
import org.eclipse.jdt.astview.views.TrayContentProvider;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TrayContentProvider
implements ITreeContentProvider {
    public static final int DEFAULT_CHILDREN_COUNT = 7;
    protected static final String N_A = "N/A";
    protected static final Object[] EMPTY = new Object[0];

    public Object[] getChildren(Object parentElement) {
        ArrayList result = new ArrayList();
        if (parentElement instanceof ExceptionAttribute) {
            return EMPTY;
        }
        this.addObjectComparisons(result, parentElement);
        if (parentElement instanceof Binding) {
            Binding trayElement = (Binding)parentElement;
            IBinding trayBinding = trayElement.getBinding();
            this.addBindingComparisons(result, trayElement);
            if (trayBinding instanceof ITypeBinding) {
                this.addTypeBindingComparions(result, trayElement);
            }
            if (trayBinding instanceof IMethodBinding) {
                this.addMethodBindingComparions(result, trayElement);
            }
        }
        return result.toArray();
    }

    private void addObjectComparisons(ArrayList result, Object trayElement) {
        class IdentityProperty
        extends DynamicAttributeProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public IdentityProperty(TrayContentProvider trayContentProvider, Object parent) {
                super(parent, "* == this: ");
                this.this$0 = trayContentProvider;
            }

            protected String executeQuery(Object viewerObject, Object trayObject) {
                return Boolean.toString(viewerObject == trayObject);
            }
        }
        result.add(new IdentityProperty(this, trayElement));
        class EqualsProperty
        extends DynamicAttributeProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public EqualsProperty(TrayContentProvider trayContentProvider, Object parent) {
                super(parent, "*.equals(this): ");
                this.this$0 = trayContentProvider;
            }

            protected String executeQuery(Object viewerObject, Object trayObject) {
                if (viewerObject != null) {
                    return Boolean.toString(viewerObject.equals(trayObject));
                }
                return "* is null";
            }
        }
        result.add(new EqualsProperty(this, trayElement));
    }

    private void addBindingComparisons(ArrayList result, Binding trayElement) {
        class IsEqualToProperty
        extends DynamicBindingProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public IsEqualToProperty(TrayContentProvider trayContentProvider, Binding parent) {
                super(parent);
                this.this$0 = trayContentProvider;
            }

            protected String getName() {
                return "*.isEqualTo(this): ";
            }

            protected String executeQuery(IBinding viewerBinding, IBinding trayBinding) {
                if (viewerBinding != null) {
                    return Boolean.toString(viewerBinding.isEqualTo(trayBinding));
                }
                return "* is null";
            }
        }
        result.add(new IsEqualToProperty(this, trayElement));
        class KeysEqualProperty
        extends DynamicBindingProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public KeysEqualProperty(TrayContentProvider trayContentProvider, Binding parent) {
                super(parent);
                this.this$0 = trayContentProvider;
            }

            protected String getName() {
                return "*.getKey().equals(this.getKey()): ";
            }

            protected String executeQuery(IBinding viewerBinding, IBinding trayBinding) {
                if (viewerBinding == null) {
                    return "* is null";
                }
                if (viewerBinding.getKey() == null) {
                    return "*.getKey() is null";
                }
                if (trayBinding.getKey() == null) {
                    return "this.getKey() is null";
                }
                return Boolean.toString(viewerBinding.getKey().equals(trayBinding.getKey()));
            }
        }
        result.add(new KeysEqualProperty(this, trayElement));
    }

    private void addTypeBindingComparions(ArrayList result, Binding trayElement) {
        class IsSubTypeCompatibleProperty
        extends DynamicBindingProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public IsSubTypeCompatibleProperty(TrayContentProvider trayContentProvider, Binding parent) {
                super(parent);
                this.this$0 = trayContentProvider;
            }

            protected String getName() {
                return "*.isSubTypeCompatible(this): ";
            }

            protected String executeQuery(IBinding viewerBinding, IBinding trayBinding) {
                if (viewerBinding instanceof ITypeBinding) {
                    ITypeBinding viewerTB = (ITypeBinding)viewerBinding;
                    ITypeBinding trayTB = (ITypeBinding)trayBinding;
                    return Boolean.toString(viewerTB.isSubTypeCompatible(trayTB));
                }
                return "* not an ITypeBinding";
            }
        }
        result.add(new IsSubTypeCompatibleProperty(this, trayElement));
        class IsCastCompatibleProperty
        extends DynamicBindingProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public IsCastCompatibleProperty(TrayContentProvider trayContentProvider, Binding parent) {
                super(parent);
                this.this$0 = trayContentProvider;
            }

            protected String getName() {
                return "*.isCastCompatible(this): ";
            }

            protected String executeQuery(IBinding viewerBinding, IBinding trayBinding) {
                if (viewerBinding instanceof ITypeBinding) {
                    ITypeBinding viewerTB = (ITypeBinding)viewerBinding;
                    ITypeBinding trayTB = (ITypeBinding)trayBinding;
                    return Boolean.toString(viewerTB.isCastCompatible(trayTB));
                }
                return "* not an ITypeBinding";
            }
        }
        result.add(new IsCastCompatibleProperty(this, trayElement));
        class IsAssignmentCompatibleProperty
        extends DynamicBindingProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public IsAssignmentCompatibleProperty(TrayContentProvider trayContentProvider, Binding parent) {
                super(parent);
                this.this$0 = trayContentProvider;
            }

            protected String getName() {
                return "*.isAssignmentCompatible(this): ";
            }

            protected String executeQuery(IBinding viewerBinding, IBinding trayBinding) {
                if (viewerBinding instanceof ITypeBinding) {
                    ITypeBinding viewerTB = (ITypeBinding)viewerBinding;
                    ITypeBinding trayTB = (ITypeBinding)trayBinding;
                    return Boolean.toString(viewerTB.isAssignmentCompatible(trayTB));
                }
                return "* not an ITypeBinding";
            }
        }
        result.add(new IsAssignmentCompatibleProperty(this, trayElement));
    }

    private void addMethodBindingComparions(ArrayList result, Binding trayElement) {
        class OverridesProperty
        extends DynamicBindingProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public OverridesProperty(TrayContentProvider trayContentProvider, Binding parent) {
                super(parent);
                this.this$0 = trayContentProvider;
            }

            protected String getName() {
                return "*.overrides(this): ";
            }

            protected String executeQuery(IBinding viewerBinding, IBinding trayBinding) {
                if (viewerBinding instanceof IMethodBinding) {
                    IMethodBinding viewerMB = (IMethodBinding)viewerBinding;
                    IMethodBinding trayMB = (IMethodBinding)trayBinding;
                    return Boolean.toString(viewerMB.overrides(trayMB));
                }
                return "* not an IMethodBinding";
            }
        }
        result.add(new OverridesProperty(this, trayElement));
        class IsSubsignatureProperty
        extends DynamicBindingProperty {
            final /* synthetic */ TrayContentProvider this$0;

            public IsSubsignatureProperty(TrayContentProvider trayContentProvider, Binding parent) {
                super(parent);
                this.this$0 = trayContentProvider;
            }

            protected String getName() {
                return "*.isSubsignature(this): ";
            }

            protected String executeQuery(IBinding viewerBinding, IBinding trayBinding) {
                if (viewerBinding instanceof IMethodBinding) {
                    IMethodBinding viewerMB = (IMethodBinding)viewerBinding;
                    IMethodBinding trayMB = (IMethodBinding)trayBinding;
                    return Boolean.toString(viewerMB.isSubsignature(trayMB));
                }
                return "* not an IMethodBinding";
            }
        }
        result.add(new IsSubsignatureProperty(this, trayElement));
    }

    public Object getParent(Object element) {
        if (element instanceof ASTAttribute) {
            return ((ASTAttribute)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof DynamicAttributeProperty) && !(element instanceof DynamicBindingProperty);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ArrayList) {
            return ((ArrayList)inputElement).toArray();
        }
        return EMPTY;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

