/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import org.eclipse.jdt.jeview.JEPluginImages;
import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JEClasspathEntry;
import org.eclipse.jdt.jeview.views.JEJarEntryResource;
import org.eclipse.jdt.jeview.views.JEMarker;
import org.eclipse.jdt.jeview.views.JEMemberValuePair;
import org.eclipse.jdt.jeview.views.JEResource;
import org.eclipse.jdt.jeview.views.JavaElement;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;
import org.eclipse.jdt.jeview.views.JavaElementProperty;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class JEViewLabelProvider
extends LabelProvider {
    JavaElementLabelProvider fJavaElementLabelProvider;
    private Image fChildrenImg = JEPluginImages.IMG_CHILDREN.createImage();
    private Image fInfoImg = JEPluginImages.IMG_INFO.createImage();

    public JEViewLabelProvider() {
        this.fJavaElementLabelProvider = new JavaElementLabelProvider(256);
    }

    public String getText(Object element) {
        if (element instanceof JEAttribute) {
            return ((JEAttribute)element).getLabel();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof JavaElement) {
            return this.fJavaElementLabelProvider.getImage((Object)((JavaElement)element).getJavaElement());
        }
        if (element instanceof JEResource) {
            return this.fJavaElementLabelProvider.getImage((Object)((JEResource)element).getResource());
        }
        if (element instanceof JEJarEntryResource) {
            return this.fJavaElementLabelProvider.getImage((Object)((JEJarEntryResource)element).getJarEntryResource());
        }
        if (element instanceof JavaElementProperty) {
            return this.fInfoImg;
        }
        if (element instanceof JEMemberValuePair) {
            return this.fInfoImg;
        }
        if (element instanceof JavaElementChildrenProperty) {
            return this.fChildrenImg;
        }
        if (element instanceof JEClasspathEntry) {
            return this.fChildrenImg;
        }
        if (element instanceof Error) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof JEMarker) {
            JEMarker marker = (JEMarker)element;
            Object severity = marker.getMarkerAttribute("severity");
            if (severity instanceof Integer) {
                Integer sev = (Integer)severity;
                switch (sev) {
                    case 0: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                    }
                    case 1: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    }
                    case 2: {
                        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                    }
                }
            }
            return null;
        }
        return super.getImage(element);
    }

    public void dispose() {
        super.dispose();
        this.fChildrenImg.dispose();
        this.fInfoImg.dispose();
        this.fJavaElementLabelProvider.dispose();
    }
}

