/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JEClasspathEntry;
import org.eclipse.jdt.jeview.views.JEJarEntryResource;
import org.eclipse.jdt.jeview.views.JEMemberValuePair;
import org.eclipse.jdt.jeview.views.JEResource;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;
import org.eclipse.jdt.jeview.views.JavaElementProperty;
import org.eclipse.jdt.jeview.views.Null;
import org.eclipse.jdt.ui.JavaElementLabels;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElement
extends JEAttribute {
    private static final long LABEL_OPTIONS = 0x4021L | JavaElementLabels.ALL_FULLY_QUALIFIED | 0x200000L | 0x1000000000000L;
    private final JEAttribute fParent;
    private final String fName;
    private final IJavaElement fJavaElement;

    public JavaElement(JEAttribute parent, String name, IJavaElement element) {
        this.fParent = parent;
        this.fName = name;
        this.fJavaElement = element;
    }

    public JavaElement(JEAttribute parent, IJavaElement element) {
        this(parent, null, element);
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    public IJavaElement getJavaElement() {
        return this.fJavaElement;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaElement other = (JavaElement)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        if (this.fName == null ? other.fName != null : !this.fName.equals(other.fName)) {
            return false;
        }
        return !(this.fJavaElement == null ? other.fJavaElement != null : !this.fJavaElement.equals(other.fJavaElement));
    }

    @Override
    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0) + (this.fJavaElement != null ? this.fJavaElement.hashCode() : 0);
    }

    @Override
    public Object getWrappedObject() {
        return this.fJavaElement;
    }

    @Override
    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        if (this.fName != null) {
            sb.append(this.fName).append(": ");
        }
        if (this.fJavaElement == null) {
            sb.append("java element: null");
        } else {
            String classname = this.fJavaElement.getClass().getName();
            sb.append(classname.substring(classname.lastIndexOf(46) + 1)).append(": ");
            sb.append(JavaElementLabels.getElementLabel((IJavaElement)this.fJavaElement, (long)LABEL_OPTIONS));
            if (!this.fJavaElement.exists()) {
                sb.append(" (does not exist)");
            }
        }
        return sb.toString();
    }

    @Override
    public JEAttribute[] getChildren() {
        if (this.fJavaElement == null) {
            return EMPTY;
        }
        ArrayList<JEAttribute> result = new ArrayList<JEAttribute>();
        if (this.fJavaElement instanceof IParent) {
            this.addParentChildren(result, (IParent)this.fJavaElement);
        }
        this.addJavaElementChildren(result, this.fJavaElement);
        if (this.fJavaElement instanceof IJavaModel) {
            this.addJavaModelChildren(result, (IJavaModel)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IJavaProject) {
            this.addJavaProjectChildren(result, (IJavaProject)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IPackageFragmentRoot) {
            this.addPackageFragmentRootChildren(result, (IPackageFragmentRoot)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IPackageFragment) {
            this.addPackageFragmentChildren(result, (IPackageFragment)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ITypeRoot) {
            this.addTypeRootChildren(result, (ITypeRoot)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IClassFile) {
            this.addClassFileChildren(result, (IClassFile)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ICompilationUnit) {
            this.addCompilationUnitChildren(result, (ICompilationUnit)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IType) {
            this.addTypeChildren(result, (IType)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IMethod) {
            this.addMethodChildren(result, (IMethod)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IMember) {
            this.addMemberChildren(result, (IMember)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ITypeParameter) {
            this.addTypeParameterChildren(result, (ITypeParameter)this.fJavaElement);
        }
        if (this.fJavaElement instanceof ILocalVariable) {
            this.addLocalVariableChildren(result, (ILocalVariable)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IAnnotation) {
            this.addAnnotationChildren(result, (IAnnotation)this.fJavaElement);
        }
        if (this.fJavaElement instanceof IAnnotatable) {
            this.addAnnotatableChildren(result, (IAnnotatable)this.fJavaElement);
        }
        return result.toArray(new JEAttribute[result.size()]);
    }

    private void addParentChildren(ArrayList<JEAttribute> result, final IParent parent) {
        result.add(new JavaElementChildrenProperty(this, "CHILDREN"){

            public JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, parent.getChildren());
            }
        });
    }

    private void addJavaElementChildren(ArrayList<JEAttribute> result, final IJavaElement javaElement) {
        result.add(new JavaElement(this, "PARENT", javaElement.getParent()));
        result.add(new JavaElement(this, "PRIMARY ELEMENT", javaElement.getPrimaryElement()));
        result.add(new JavaElement(this, "JAVA MODEL", (IJavaElement)javaElement.getJavaModel()));
        result.add(new JavaElement(this, "JAVA PROJECT", (IJavaElement)javaElement.getJavaProject()));
        result.add(JEResource.create(this, "RESOURCE", javaElement.getResource()));
        result.add(JEResource.compute(this, "CORRESPONDING RESOURCE", new Callable<IResource>(){

            @Override
            public IResource call() throws JavaModelException {
                return javaElement.getCorrespondingResource();
            }
        }));
        result.add(JEResource.compute(this, "UNDERLYING RESOURCE", new Callable<IResource>(){

            @Override
            public IResource call() throws JavaModelException {
                return javaElement.getUnderlyingResource();
            }
        }));
    }

    private void addJavaModelChildren(ArrayList<JEAttribute> result, final IJavaModel javaModel) {
        result.add(new JavaElementChildrenProperty(this, "JAVA PROJECTS"){

            public JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])javaModel.getJavaProjects());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            public JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, javaModel.getNonJavaResources());
            }
        });
    }

    private void addJavaProjectChildren(ArrayList<JEAttribute> result, final IJavaProject project) {
        result.add(new JavaElementChildrenProperty(this, "ALL PACKAGE FRAGMENT ROOTS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])project.getAllPackageFragmentRoots());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PACKAGE FRAGMENT ROOTS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])project.getPackageFragmentRoots());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PACKAGE FRAGMENTS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])project.getPackageFragments());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, project.getNonJavaResources());
            }
        });
        result.add(JEResource.create(this, "PROJECT", (IResource)project.getProject()));
        result.add(new JavaElementChildrenProperty(this, "REQUIRED PROJECT NAMES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, project.getRequiredProjectNames());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "OPTIONS(FALSE)"){

            protected JEAttribute[] computeChildren() {
                return JavaElement.createOptions(this, project.getOptions(false));
            }
        });
        result.add(new JavaElementChildrenProperty(this, "OPTIONS(TRUE)"){

            protected JEAttribute[] computeChildren() {
                return JavaElement.createOptions(this, project.getOptions(true));
            }
        });
        result.add(new JavaElementChildrenProperty(this, "RAW CLASSPATH"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createCPEntries(this, project.getRawClasspath());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "REFERENCED CLASSPATH ENTRIES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createCPEntries(this, project.getReferencedClasspathEntries());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "RESOLVED CLASSPATH"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createCPEntries(this, project.getResolvedClasspath(false));
            }
        });
    }

    private void addPackageFragmentRootChildren(ArrayList<JEAttribute> result, final IPackageFragmentRoot packageFragmentRoot) {
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, packageFragmentRoot.getNonJavaResources());
            }
        });
        result.add(JEClasspathEntry.compute(this, "RAW CLASSPATH ENTRY", new Callable<IClasspathEntry>(){

            @Override
            public IClasspathEntry call() throws JavaModelException {
                return packageFragmentRoot.getRawClasspathEntry();
            }
        }));
        result.add(JEClasspathEntry.compute(this, "RESOLVED CLASSPATH ENTRY", new Callable<IClasspathEntry>(){

            @Override
            public IClasspathEntry call() throws JavaModelException {
                return packageFragmentRoot.getResolvedClasspathEntry();
            }
        }));
    }

    private void addPackageFragmentChildren(ArrayList<JEAttribute> result, final IPackageFragment packageFragment) {
        result.add(new JavaElementChildrenProperty(this, "COMPILATION UNITS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])packageFragment.getCompilationUnits());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "CLASS FILES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])packageFragment.getClassFiles());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "NON JAVA RESOURCES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createResources(this, packageFragment.getNonJavaResources());
            }
        });
    }

    private void addTypeRootChildren(ArrayList<JEAttribute> result, final ITypeRoot typeRoot) {
        result.add(JavaElement.compute(this, "FIND PRIMARY TYPE", new Callable<IJavaElement>(){

            @Override
            public IJavaElement call() {
                return typeRoot.findPrimaryType();
            }
        }));
    }

    private void addClassFileChildren(ArrayList<JEAttribute> result, final IClassFile classFile) {
        result.add(JavaElement.compute(this, "TYPE", new Callable<IJavaElement>(){

            @Override
            public IJavaElement call() throws JavaModelException {
                return classFile.getType();
            }
        }));
    }

    private void addCompilationUnitChildren(ArrayList<JEAttribute> result, final ICompilationUnit compilationUnit) {
        result.add(new JavaElement(this, "PRIMARY", (IJavaElement)compilationUnit.getPrimary()));
        result.add(new JavaElementChildrenProperty(this, "TYPES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getTypes());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "ALL TYPES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getAllTypes());
            }
        });
        result.add(new JavaElement(this, "IMPORT CONTAINER", (IJavaElement)compilationUnit.getImportContainer()));
        result.add(new JavaElementChildrenProperty(this, "IMPORTS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getImports());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PACKAGE DECLARATIONS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])compilationUnit.getPackageDeclarations());
            }
        });
    }

    private void addMemberChildren(ArrayList<JEAttribute> result, final IMember member) {
        result.add(new JavaElement(this, "CLASS FILE", (IJavaElement)member.getClassFile()));
        result.add(new JavaElement(this, "COMPILATION UNIT", (IJavaElement)member.getCompilationUnit()));
        result.add(new JavaElement(this, "TYPE ROOT", (IJavaElement)member.getTypeRoot()));
        result.add(new JavaElement(this, "DECLARING TYPE", (IJavaElement)member.getDeclaringType()));
        result.add(new JavaElementChildrenProperty(this, "CATEGORIES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, member.getCategories());
            }
        });
    }

    private void addAnnotationChildren(ArrayList<JEAttribute> result, final IAnnotation annotation) {
        result.add(new JavaElementChildrenProperty(this, "MEMBER VALUE PAIRS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
                return JavaElement.createMemberValuePairs(this, memberValuePairs);
            }
        });
    }

    private void addAnnotatableChildren(ArrayList<JEAttribute> result, final IAnnotatable annotatable) {
        result.add(new JavaElementChildrenProperty(this, "ANNOTATIONS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                IAnnotation[] annotations = annotatable.getAnnotations();
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])annotations);
            }
        });
    }

    private void addTypeChildren(ArrayList<JEAttribute> result, final IType type) {
        result.add(new JavaElementProperty(this, "IS RESOLVED", type.isResolved()));
        result.add(new JavaElementProperty(this, "KEY", type.getKey()));
        result.add(new JavaElement(this, "PACKAGE FRAGMENT", (IJavaElement)type.getPackageFragment()));
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETERS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getTypeParameters());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETER SIGNATURES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, type.getTypeParameterSignatures());
            }
        });
        result.add(new JavaElementProperty(this, "SUPERCLASS NAME"){

            protected Object computeValue() throws Exception {
                return type.getSuperclassName();
            }
        });
        result.add(new JavaElementProperty(this, "SUPERCLASS TYPE SIGNATURE"){

            protected Object computeValue() throws Exception {
                return type.getSuperclassTypeSignature();
            }
        });
        result.add(new JavaElementChildrenProperty(this, "SUPER INTERFACE NAMES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, type.getSuperInterfaceNames());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "SUPER INTERFACE TYPE SIGNATURES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, type.getSuperInterfaceTypeSignatures());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "FIELDS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getFields());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "INITIALIZERS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getInitializers());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "METHODS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getMethods());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])type.getTypes());
            }
        });
    }

    private void addMethodChildren(ArrayList<JEAttribute> result, final IMethod method) {
        result.add(new JavaElementChildrenProperty(this, "EXCEPTION TYPES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getExceptionTypes());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PARAMETERS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])method.getParameters());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PARAMETER NAMES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getParameterNames());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "PARAMETER TYPES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getParameterTypes());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETERS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createJavaElements((JEAttribute)this, (IJavaElement[])method.getTypeParameters());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "TYPE PARAMETER SIGNATURES"){

            @Deprecated
            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, method.getTypeParameterSignatures());
            }
        });
        try {
            result.add(new JEMemberValuePair(this, "DEFAULT_VALUE", method.getDefaultValue()));
        }
        catch (JavaModelException e) {
            result.add(new Error(this, "DEFAULT_VALUE", (Exception)((Object)e)));
        }
    }

    private void addTypeParameterChildren(ArrayList<JEAttribute> result, final ITypeParameter typeParameter) {
        result.add(new JavaElement(this, "TYPE ROOT", (IJavaElement)typeParameter.getTypeRoot()));
        result.add(new JavaElement(this, "DECLARING MEMBER", (IJavaElement)typeParameter.getDeclaringMember()));
        result.add(new JavaElementChildrenProperty(this, "BOUNDS"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, typeParameter.getBounds());
            }
        });
        result.add(new JavaElementChildrenProperty(this, "BOUNDS SIGNATURES"){

            protected JEAttribute[] computeChildren() throws JavaModelException {
                return JavaElement.createStrings(this, typeParameter.getBoundsSignatures());
            }
        });
    }

    private void addLocalVariableChildren(ArrayList<JEAttribute> result, ILocalVariable localVariable) {
        result.add(new JavaElement(this, "TYPE ROOT", (IJavaElement)localVariable.getTypeRoot()));
        result.add(new JavaElement(this, "DECLARING MEMBER", (IJavaElement)localVariable.getDeclaringMember()));
    }

    static JavaElement[] createJavaElements(JEAttribute parent, Object[] javaElements) {
        JavaElement[] jeChildren = new JavaElement[javaElements.length];
        int i = 0;
        while (i < javaElements.length) {
            jeChildren[i] = new JavaElement(parent, (IJavaElement)javaElements[i]);
            ++i;
        }
        return jeChildren;
    }

    static JavaElement[] createJavaElements(JEAttribute parent, IJavaElement[] javaElements) {
        JavaElement[] jeChildren = new JavaElement[javaElements.length];
        int i = 0;
        while (i < javaElements.length) {
            jeChildren[i] = new JavaElement(parent, javaElements[i]);
            ++i;
        }
        return jeChildren;
    }

    static JEAttribute[] createResources(JEAttribute parent, Object[] resources) {
        JEAttribute[] resourceChildren = new JEAttribute[resources.length];
        int i = 0;
        while (i < resources.length) {
            Object resource = resources[i];
            resourceChildren[i] = resource instanceof IResource ? new JEResource(parent, null, (IResource)resource) : (resource instanceof IJarEntryResource ? new JEJarEntryResource(parent, null, (IJarEntryResource)resource) : new JavaElementProperty(parent, null, resource));
            ++i;
        }
        return resourceChildren;
    }

    static JEAttribute[] createMemberValuePairs(JEAttribute parent, IMemberValuePair[] mvPairs) {
        JEAttribute[] mvPairChildren = new JEAttribute[mvPairs.length];
        int i = 0;
        while (i < mvPairs.length) {
            IMemberValuePair mvPair = mvPairs[i];
            mvPairChildren[i] = new JEMemberValuePair(parent, mvPair);
            ++i;
        }
        return mvPairChildren;
    }

    static JEAttribute[] createCPEntries(JEAttribute parent, IClasspathEntry[] entries) {
        JEAttribute[] entryChildren = new JEAttribute[entries.length];
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            entryChildren[i] = new JEClasspathEntry(parent, null, entry);
            ++i;
        }
        return entryChildren;
    }

    static JEAttribute[] createOptions(JEAttribute parent, Map<String, String> options) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(options.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        JEAttribute[] children = new JEAttribute[entries.size()];
        int i = 0;
        while (i < entries.size()) {
            Map.Entry<String, String> entry = entries.get(i);
            children[i] = new JavaElementProperty(parent, entry.getKey(), entry.getValue());
            ++i;
        }
        return children;
    }

    static JEAttribute[] createStrings(JEAttribute parent, String[] strings) {
        JEAttribute[] children = new JEAttribute[strings.length];
        int i = 0;
        while (i < strings.length) {
            children[i] = new JavaElementProperty(parent, null, strings[i]);
            ++i;
        }
        return children;
    }

    public static JEAttribute compute(JEAttribute parent, String name, Callable<IJavaElement> computer) {
        try {
            IJavaElement javaElement = computer.call();
            return JavaElement.create(parent, name, javaElement);
        }
        catch (Exception e) {
            return new Error(parent, name, e);
        }
    }

    public static JEAttribute create(JEAttribute parent, String name, IJavaElement javaElement) {
        if (javaElement == null) {
            return new Null(parent, name);
        }
        return new JavaElement(parent, name, javaElement);
    }
}

