/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;

public class JavaElementProperty
extends JEAttribute {
    private final JEAttribute fParent;
    private final String fName;
    private final String fValue;
    private final Object fValueObject;

    public JavaElementProperty(JEAttribute parent, String name) {
        this.fParent = parent;
        this.fName = name;
        this.fValue = null;
        this.fValueObject = null;
    }

    public JavaElementProperty(JEAttribute parent, String name, Object value) {
        this.fParent = parent;
        this.fName = name;
        this.fValueObject = value;
        this.fValue = value instanceof String ? "\"" + value + "\"" : String.valueOf(value);
    }

    public JEAttribute getParent() {
        return this.fParent;
    }

    public Object getWrappedObject() {
        return this.fValueObject;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JavaElementProperty other = (JavaElementProperty)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        return !(this.fName == null ? other.fName != null : !this.fName.equals(other.fName));
    }

    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0);
    }

    public JEAttribute[] getChildren() {
        if (this.fValue != null) {
            return EMPTY;
        }
        try {
            this.computeValue();
            return EMPTY;
        }
        catch (Exception e) {
            return new Error[]{new Error(this, "", e)};
        }
    }

    public String getLabel() {
        String value = this.fValue;
        if (value == null) {
            try {
                value = String.valueOf(this.computeValue());
            }
            catch (Exception exception) {
                return "ERROR";
            }
        }
        if (this.fName == null) {
            return value;
        }
        return String.valueOf(this.fName) + ": " + value;
    }

    protected Object computeValue() throws Exception {
        return this.fValue;
    }
}

