/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JavaElement;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;
import org.eclipse.jdt.jeview.views.JavaElementProperty;
import org.eclipse.jdt.jeview.views.Null;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEClasspathEntry
extends JEAttribute {
    private final JEAttribute fParent;
    private final String fName;
    final IClasspathEntry fEntry;

    JEClasspathEntry(JEAttribute parent, String name, IClasspathEntry entry) {
        Assert.isNotNull((Object)entry);
        this.fParent = parent;
        this.fName = name;
        this.fEntry = entry;
    }

    @Override
    public JEAttribute getParent() {
        return this.fParent;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        JEClasspathEntry other = (JEClasspathEntry)obj;
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals(other.fParent)) {
            return false;
        }
        return !(this.fName == null ? other.fName != null : !this.fName.equals(other.fName));
    }

    @Override
    public int hashCode() {
        return (this.fParent != null ? this.fParent.hashCode() : 0) + (this.fName != null ? this.fName.hashCode() : 0) + this.fEntry.hashCode();
    }

    @Override
    public Object getWrappedObject() {
        return this.fEntry;
    }

    @Override
    public JEAttribute[] getChildren() {
        ArrayList<JEAttribute> result = new ArrayList<JEAttribute>();
        result.add(new JavaElementChildrenProperty(this, "ACCESS RULES"){

            protected JEAttribute[] computeChildren() throws CoreException {
                IAccessRule[] accessRules = JEClasspathEntry.this.fEntry.getAccessRules();
                JEAttribute[] children = new JEAttribute[accessRules.length];
                int i = 0;
                while (i < accessRules.length) {
                    children[i] = new JavaElementProperty(this, null, accessRules[i]);
                    ++i;
                }
                return children;
            }
        });
        result.add(new JavaElementChildrenProperty(this, "EXCLUSION PATTERNS"){

            protected JEAttribute[] computeChildren() throws CoreException {
                IPath[] exclusionPatterns = JEClasspathEntry.this.fEntry.getExclusionPatterns();
                JEAttribute[] children = new JEAttribute[exclusionPatterns.length];
                int i = 0;
                while (i < exclusionPatterns.length) {
                    children[i] = new JavaElementProperty(this, null, exclusionPatterns[i]);
                    ++i;
                }
                return children;
            }
        });
        result.add(new JavaElementChildrenProperty(this, "INCLUSION PATTERNS"){

            protected JEAttribute[] computeChildren() throws CoreException {
                IPath[] inclusionPatterns = JEClasspathEntry.this.fEntry.getInclusionPatterns();
                JEAttribute[] children = new JEAttribute[inclusionPatterns.length];
                int i = 0;
                while (i < inclusionPatterns.length) {
                    children[i] = new JavaElementProperty(this, null, inclusionPatterns[i]);
                    ++i;
                }
                return children;
            }
        });
        result.add(new JavaElementChildrenProperty(this, "EXTRA ATTRIBUTES"){

            protected JEAttribute[] computeChildren() throws CoreException {
                IClasspathAttribute[] extraAttributes = JEClasspathEntry.this.fEntry.getExtraAttributes();
                JEAttribute[] children = new JEAttribute[extraAttributes.length];
                int i = 0;
                while (i < extraAttributes.length) {
                    children[i] = new JavaElementProperty(this, null, extraAttributes[i]);
                    ++i;
                }
                return children;
            }
        });
        result.add(JEClasspathEntry.create(this, "REFERENCING ENTRY", this.fEntry.getReferencingEntry()));
        result.add(new JavaElementChildrenProperty(this, "JavaCore.getReferencedClasspathEntries(this)"){

            protected JEAttribute[] computeChildren() throws CoreException {
                IJavaProject project = null;
                JEAttribute parent = JEClasspathEntry.this;
                while ((parent = ((JEAttribute)parent).getParent()) != null) {
                    if (!(parent instanceof JavaElement)) continue;
                    project = ((JavaElement)parent).getJavaElement().getJavaProject();
                    break;
                }
                IClasspathEntry[] referencedEntries = JavaCore.getReferencedClasspathEntries((IClasspathEntry)JEClasspathEntry.this.fEntry, project);
                JEAttribute[] children = new JEAttribute[referencedEntries.length];
                int i = 0;
                while (i < referencedEntries.length) {
                    children[i] = new JEClasspathEntry(this, null, referencedEntries[i]);
                    ++i;
                }
                return children;
            }
        });
        result.add(new JEClasspathEntry(this, "JavaCore.getResolvedClasspathEntry(this)", JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.fEntry)));
        result.add(new JavaElementChildrenProperty(this, "JavaCore.getClasspathContainer(..).getClasspathEntries()"){

            protected JEAttribute[] computeChildren() throws CoreException {
                IJavaProject project = null;
                JEAttribute parent = JEClasspathEntry.this;
                while ((parent = ((JEAttribute)parent).getParent()) != null) {
                    if (!(parent instanceof JavaElement)) continue;
                    project = ((JavaElement)parent).getJavaElement().getJavaProject();
                    break;
                }
                IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)JEClasspathEntry.this.fEntry.getPath(), project);
                if (classpathContainer == null) {
                    return EMPTY;
                }
                IClasspathEntry[] referencedEntries = classpathContainer.getClasspathEntries();
                JEAttribute[] children = new JEAttribute[referencedEntries.length];
                int i = 0;
                while (i < referencedEntries.length) {
                    children[i] = new JEClasspathEntry(this, null, referencedEntries[i]);
                    ++i;
                }
                return children;
            }
        });
        return result.toArray(new JEAttribute[result.size()]);
    }

    @Override
    public String getLabel() {
        String label = this.fEntry.toString();
        if (this.fName != null) {
            label = String.valueOf(this.fName) + ": " + label;
        }
        return label;
    }

    public static JEAttribute compute(JEAttribute parent, String name, Callable<IClasspathEntry> computer) {
        try {
            IClasspathEntry entry = computer.call();
            return JEClasspathEntry.create(parent, name, entry);
        }
        catch (Exception e) {
            return new Error(parent, name, e);
        }
    }

    public static JEAttribute create(JEAttribute parent, String name, IClasspathEntry entry) {
        if (entry == null) {
            return new Null(parent, name);
        }
        return new JEClasspathEntry(parent, name, entry);
    }
}

