/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.views;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.jeview.EditorUtility;
import org.eclipse.jdt.jeview.JEPluginImages;
import org.eclipse.jdt.jeview.JEViewPlugin;
import org.eclipse.jdt.jeview.properties.ClasspathEntryProperties;
import org.eclipse.jdt.jeview.properties.JarEntryResourceProperties;
import org.eclipse.jdt.jeview.properties.JavaElementProperties;
import org.eclipse.jdt.jeview.properties.MarkerProperties;
import org.eclipse.jdt.jeview.properties.MemberValuePairProperties;
import org.eclipse.jdt.jeview.properties.ResourceProperties;
import org.eclipse.jdt.jeview.views.Error;
import org.eclipse.jdt.jeview.views.JEAttribute;
import org.eclipse.jdt.jeview.views.JEMarker;
import org.eclipse.jdt.jeview.views.JEResource;
import org.eclipse.jdt.jeview.views.JERoot;
import org.eclipse.jdt.jeview.views.JEViewContentProvider;
import org.eclipse.jdt.jeview.views.JEViewLabelProvider;
import org.eclipse.jdt.jeview.views.JavaElement;
import org.eclipse.jdt.jeview.views.JavaElementChildrenProperty;
import org.eclipse.jdt.jeview.views.JavaElementProperty;
import org.eclipse.jdt.jeview.views.Null;
import org.eclipse.jdt.jeview.views.TreeCopyAction;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElementView
extends ViewPart
implements IShowInSource,
IShowInTarget {
    TreeViewer fViewer;
    private DrillDownAdapter fDrillDownAdapter;
    JERoot fInput;
    private Action fFocusAction;
    private Action fFindTypeAction;
    private Action fResolveTypeAction;
    private Action fGetAnnotationAction;
    private Action fCreateFromBindingKeyAction;
    private Action fResetAction;
    private Action fCodeSelectAction;
    private Action fElementAtAction;
    private Action fCreateFromHandleAction;
    private Action fRefreshAction;
    TreeCopyAction fCopyAction;
    private Action fCompareAction;
    private Action fPropertiesAction;
    Action fDoubleClickAction;
    private Action fLogDeltasAction;
    private PropertySheetPage fPropertySheetPage;

    public void createPartControl(Composite parent) {
        this.fViewer = new TreeViewer(parent, 770);
        this.fDrillDownAdapter = new DrillDownAdapter(this.fViewer){

            protected void updateNavigationButtons() {
                super.updateNavigationButtons();
                if (JavaElementView.this.fViewer.getInput() instanceof JEAttribute && !JavaElementView.this.fViewer.getInput().equals(JavaElementView.this.fInput)) {
                    JavaElementView.this.setContentDescription(((JEAttribute)JavaElementView.this.fViewer.getInput()).getLabel());
                } else {
                    JavaElementView.this.setContentDescription("");
                }
            }
        };
        this.fViewer.setContentProvider((IContentProvider)new JEViewContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new JEViewLabelProvider());
        this.reset();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.getSite().setSelectionProvider((ISelectionProvider)new JEViewSelectionProvider(this.fViewer));
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JavaElementView.this.fCopyAction.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.contributeToActionBars();
    }

    void reset() {
        this.setSingleInput(this.getJavaModel());
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)JEViewPlugin.getWorkspace().getRoot());
    }

    void setSingleInput(Object javaElementOrResource) {
        this.setInput(Collections.singleton(javaElementOrResource));
    }

    void setInput(Collection<?> javaElementsOrResources) {
        this.fInput = new JERoot(javaElementsOrResources);
        this.fViewer.setInput((Object)this.fInput);
        ITreeContentProvider tcp = (ITreeContentProvider)this.fViewer.getContentProvider();
        Object[] elements = tcp.getElements((Object)this.fInput);
        if (elements.length > 0) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(elements[0]));
            if (elements.length == 1) {
                this.fViewer.setExpandedState(elements[0], true);
            }
        }
        this.fDrillDownAdapter.reset();
    }

    void setEmptyInput() {
        this.setInput(Collections.emptySet());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JavaElementView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        bars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fPropertiesAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fCodeSelectAction);
        manager.add((IAction)this.fElementAtAction);
        manager.add((IAction)this.fCreateFromHandleAction);
        manager.add((IAction)this.fResetAction);
        manager.add((IAction)this.fLogDeltasAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fRefreshAction);
    }

    void fillContextMenu(IMenuManager manager) {
        this.addFocusActionOrNot(manager);
        manager.add((IAction)this.fResetAction);
        manager.add((IAction)this.fRefreshAction);
        manager.add((IContributionItem)new Separator());
        if (!this.getSite().getSelectionProvider().getSelection().isEmpty()) {
            MenuManager showInSubMenu = new MenuManager(this.getShowInMenuLabel());
            IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
            showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(workbenchWindow));
            manager.add((IContributionItem)showInSubMenu);
        }
        this.addElementActionsOrNot(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fCopyAction);
        manager.add((IContributionItem)new Separator());
        this.fDrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        this.addCompareActionOrNot(manager);
        manager.add((IAction)this.fPropertiesAction);
    }

    private String getShowInMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.navigate.showInQuickMenu");
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return "Sho&w In\t" + keyBinding;
    }

    private void addFocusActionOrNot(IMenuManager manager) {
        IStructuredSelection structuredSelection;
        if (this.fViewer.getSelection() instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)this.fViewer.getSelection()).size() == 1) {
            IResource resource;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof JavaElement) {
                IJavaElement javaElement = ((JavaElement)first).getJavaElement();
                if (javaElement != null) {
                    String name = javaElement.getElementName();
                    this.fFocusAction.setText("Fo&cus On '" + name + '\'');
                    manager.add((IAction)this.fFocusAction);
                }
            } else if (first instanceof JEResource && (resource = ((JEResource)first).getResource()) != null) {
                String name = resource.getName();
                this.fFocusAction.setText("Fo&cus On '" + name + '\'');
                manager.add((IAction)this.fFocusAction);
            }
        }
    }

    private void addElementActionsOrNot(IMenuManager manager) {
        Object first;
        IStructuredSelection structuredSelection;
        if (this.fViewer.getSelection() instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)this.fViewer.getSelection()).size() == 1 && (first = structuredSelection.getFirstElement()) instanceof JavaElement) {
            IJavaElement javaElement = ((JavaElement)first).getJavaElement();
            if (javaElement instanceof IJavaProject) {
                manager.add((IAction)this.fFindTypeAction);
                manager.add((IAction)this.fCreateFromBindingKeyAction);
            }
            if (javaElement instanceof IType) {
                manager.add((IAction)this.fResolveTypeAction);
            }
            if (javaElement instanceof IAnnotatable) {
                manager.add((IAction)this.fGetAnnotationAction);
            }
        }
    }

    private void addCompareActionOrNot(IMenuManager manager) {
        ITreeSelection treeSelection;
        if (this.fViewer.getSelection() instanceof ITreeSelection && (treeSelection = (ITreeSelection)this.fViewer.getSelection()).getPaths().length == 2) {
            manager.add((IAction)this.fCompareAction);
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fCodeSelectAction);
        manager.add((IAction)this.fElementAtAction);
        manager.add((IAction)this.fResetAction);
        manager.add((IAction)this.fRefreshAction);
        manager.add((IContributionItem)new Separator());
        this.fDrillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.fCodeSelectAction = new Action("Set Input from Editor (&codeSelect)", JEPluginImages.IMG_SET_FOCUS_CODE_SELECT){

            public void run() {
                IJavaElement[] resolved;
                IEditorPart editor = JavaElementView.this.getSite().getPage().getActiveEditor();
                if (editor == null) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                IEditorInput input = editor.getEditorInput();
                ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
                if (input == null || selectionProvider == null) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof ITextSelection)) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                IJavaElement javaElement = (IJavaElement)input.getAdapter(IJavaElement.class);
                if (javaElement == null) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                try {
                    resolved = JavaElementView.codeResolve(javaElement, (ITextSelection)selection);
                }
                catch (JavaModelException javaModelException) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                if (resolved.length == 0) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                JavaElementView.this.setInput(Arrays.asList(resolved));
            }
        };
        this.fCodeSelectAction.setToolTipText("Set input from current editor's selection (codeSelect)");
        this.fElementAtAction = new Action("Set Input from Editor location (&getElementAt)", JEPluginImages.IMG_SET_FOCUS){

            public void run() {
                IJavaElement resolved;
                IEditorPart editor = JavaElementView.this.getSite().getPage().getActiveEditor();
                if (editor == null) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                IEditorInput input = editor.getEditorInput();
                ISelectionProvider selectionProvider = editor.getSite().getSelectionProvider();
                if (input == null || selectionProvider == null) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof ITextSelection)) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                IJavaElement javaElement = (IJavaElement)input.getAdapter(IJavaElement.class);
                if (javaElement == null) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                try {
                    resolved = JavaElementView.getElementAtOffset(javaElement, (ITextSelection)selection);
                }
                catch (JavaModelException javaModelException) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                if (resolved == null) {
                    JavaElementView.this.setEmptyInput();
                    return;
                }
                JavaElementView.this.setSingleInput(resolved);
            }
        };
        this.fElementAtAction.setToolTipText("Set input from current editor's selection location (getElementAt)");
        this.fCreateFromHandleAction = new Action("Create From &Handle..."){

            public void run() {
                InputDialog dialog = new InputDialog(JavaElementView.this.getSite().getShell(), "Create Java Element From Handle Identifier", "&Handle identifier:", "", null);
                if (dialog.open() != 0) {
                    return;
                }
                String handleIdentifier = dialog.getValue();
                IJavaElement javaElement = JavaCore.create((String)handleIdentifier);
                JavaElementView.this.setSingleInput(javaElement);
            }
        };
        this.fFocusAction = new Action(){

            public void run() {
                Object selected = ((IStructuredSelection)JavaElementView.this.fViewer.getSelection()).getFirstElement();
                if (selected instanceof JavaElement) {
                    JavaElementView.this.setSingleInput(((JavaElement)selected).getJavaElement());
                } else if (selected instanceof JEResource) {
                    JavaElementView.this.setSingleInput(((JEResource)selected).getResource());
                }
            }
        };
        this.fFocusAction.setToolTipText("Focus on Selection");
        this.fFindTypeAction = new Action(){

            public void run() {
                Object selected = ((IStructuredSelection)JavaElementView.this.fViewer.getSelection()).getFirstElement();
                IJavaProject project = (IJavaProject)((JavaElement)selected).getJavaElement();
                InputDialog dialog = new InputDialog(JavaElementView.this.getSite().getShell(), "IJavaProject#findType(String fullyQualifiedName, IProgressMonitor pm)", "fullyQualifiedName:", "", null);
                if (dialog.open() != 0) {
                    return;
                }
                String fullyQualifiedName = dialog.getValue();
                class Runner
                implements IRunnableWithProgress {
                    IType type;
                    private final /* synthetic */ IJavaProject val$project;
                    private final /* synthetic */ String val$fullyQualifiedName;

                    Runner(IJavaProject iJavaProject, String string) {
                        this.val$project = iJavaProject;
                        this.val$fullyQualifiedName = string;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            this.type = this.val$project.findType(this.val$fullyQualifiedName, monitor);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                Runner runner = new Runner(project, fullyQualifiedName);
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runner);
                }
                catch (InvocationTargetException e) {
                    JEViewPlugin.log(e);
                }
                catch (InterruptedException e) {
                    JEViewPlugin.log(e);
                }
                JavaElement element = new JavaElement(JavaElementView.this.fInput, fullyQualifiedName, (IJavaElement)runner.type);
                JavaElementView.this.fViewer.add((Object)JavaElementView.this.fInput, (Object)element);
                JavaElementView.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        };
        this.fFindTypeAction.setText("findType(..)...");
        this.fResolveTypeAction = new Action(){

            public void run() {
                Object selected = ((IStructuredSelection)JavaElementView.this.fViewer.getSelection()).getFirstElement();
                final IType type = (IType)((JavaElement)selected).getJavaElement();
                InputDialog dialog = new InputDialog(JavaElementView.this.getSite().getShell(), "IType#resolveType(String typeName)", "typeName:", "", null);
                if (dialog.open() != 0) {
                    return;
                }
                final String typeName = dialog.getValue();
                JavaElementChildrenProperty element = new JavaElementChildrenProperty(JavaElementView.this.fInput, "'" + type.getFullyQualifiedName() + "'.resolveType(\"" + typeName + "\")"){

                    protected JEAttribute[] computeChildren() throws Exception {
                        String[][] resolvedTypes = type.resolveType(typeName);
                        if (resolvedTypes == null) {
                            return new JEAttribute[]{new Null(this, "result")};
                        }
                        JEAttribute[] resolvedJEAttributes = new JEAttribute[resolvedTypes.length];
                        int i = 0;
                        while (i < resolvedTypes.length) {
                            String[] resolvedType = resolvedTypes[i];
                            resolvedJEAttributes[i] = new JavaElementProperty(this, null, String.valueOf(resolvedType[0]) + ", " + resolvedType[1]);
                            ++i;
                        }
                        return resolvedJEAttributes;
                    }
                };
                JavaElementView.this.fViewer.add((Object)JavaElementView.this.fInput, (Object)element);
                JavaElementView.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                JavaElementView.this.fViewer.setExpandedState((Object)element, true);
            }
        };
        this.fResolveTypeAction.setText("resolveType(String)...");
        this.fGetAnnotationAction = new Action(){

            public void run() {
                Object selected = ((IStructuredSelection)JavaElementView.this.fViewer.getSelection()).getFirstElement();
                final IAnnotatable annotatable = (IAnnotatable)((JavaElement)selected).getJavaElement();
                InputDialog dialog = new InputDialog(JavaElementView.this.getSite().getShell(), "IAnnotatable#getAnnotation(String name)", "name:", "", null);
                if (dialog.open() != 0) {
                    return;
                }
                final String name = dialog.getValue();
                JavaElementChildrenProperty element = new JavaElementChildrenProperty(JavaElementView.this.fInput, "'" + ((IJavaElement)annotatable).getElementName() + "'.getAnnotation(\"" + name + "\")"){

                    protected JEAttribute[] computeChildren() throws Exception {
                        IAnnotation annotation = annotatable.getAnnotation(name);
                        return new JEAttribute[]{new JavaElement(this, (IJavaElement)annotation)};
                    }
                };
                JavaElementView.this.fViewer.add((Object)JavaElementView.this.fInput, (Object)element);
                JavaElementView.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                JavaElementView.this.fViewer.setExpandedState((Object)element, true);
            }
        };
        this.fGetAnnotationAction.setText("getAnnotation(String)...");
        this.fCreateFromBindingKeyAction = new Action("Create From &Binding Key..."){

            public void run() {
                Object selected = ((IStructuredSelection)JavaElementView.this.fViewer.getSelection()).getFirstElement();
                IJavaProject project = (IJavaProject)((JavaElement)selected).getJavaElement();
                InputDialog dialog = new InputDialog(JavaElementView.this.getSite().getShell(), "IJavaProject#findElement(String bindingKey, WorkingCopyOwner owner)", "&bindingKey:", "", null);
                if (dialog.open() != 0) {
                    return;
                }
                String bindingKey = dialog.getValue();
                class Runner
                implements IRunnableWithProgress {
                    IJavaElement element;
                    private final /* synthetic */ IJavaProject val$project;
                    private final /* synthetic */ String val$bindingKey;

                    Runner(IJavaProject iJavaProject, String string) {
                        this.val$project = iJavaProject;
                        this.val$bindingKey = string;
                    }

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            this.element = this.val$project.findElement(this.val$bindingKey, null);
                        }
                        catch (JavaModelException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                Runner runner = new Runner(project, bindingKey);
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runner);
                }
                catch (InvocationTargetException e) {
                    JEViewPlugin.log(e);
                }
                catch (InterruptedException e) {
                    JEViewPlugin.log(e);
                }
                JavaElement element = new JavaElement(JavaElementView.this.fInput, bindingKey, runner.element);
                JavaElementView.this.fViewer.add((Object)JavaElementView.this.fInput, (Object)element);
                JavaElementView.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)element));
            }
        };
        this.fResetAction = new Action("&Reset View", this.getJavaModelImageDescriptor()){

            public void run() {
                JavaElementView.this.reset();
            }
        };
        this.fResetAction.setToolTipText("Reset View to JavaModel");
        this.fRefreshAction = new Action("Re&fresh", JEPluginImages.IMG_REFRESH){

            public void run() {
                BusyIndicator.showWhile((Display)JavaElementView.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        (this).JavaElementView.this.fViewer.refresh();
                    }
                });
            }
        };
        this.fRefreshAction.setToolTipText("Refresh");
        this.fRefreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.fCopyAction = new TreeCopyAction(new Tree[]{this.fViewer.getTree()});
        this.fPropertiesAction = new Action("&Properties", JEPluginImages.IMG_PROPERTIES){

            public void run() {
                String viewId = "org.eclipse.ui.views.PropertySheet";
                IWorkbenchPage page = JavaElementView.this.getViewSite().getPage();
                try {
                    IViewPart view = page.showView(viewId);
                    page.activate((IWorkbenchPart)JavaElementView.this);
                    page.bringToTop((IWorkbenchPart)view);
                }
                catch (PartInitException e) {
                    JEViewPlugin.log("could not find Properties view", e);
                }
            }
        };
        this.fPropertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.fDoubleClickAction = new Action(){
            private Object fPreviousDouble;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                ISelection selection = JavaElementView.this.fViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                boolean isSecondDoubleClick = obj == this.fPreviousDouble;
                Object object = this.fPreviousDouble = isSecondDoubleClick ? null : obj;
                if (obj instanceof JavaElement) {
                    IJavaElement javaElement = ((JavaElement)obj).getJavaElement();
                    if (javaElement == null) return;
                    switch (javaElement.getElementType()) {
                        case 1: {
                            return;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            ICommandService service = (ICommandService)JavaElementView.this.getSite().getService(ICommandService.class);
                            Command showInCommand = service.getCommand("org.eclipse.ui.navigate.showIn");
                            Map<String, String> params = Collections.singletonMap("org.eclipse.ui.navigate.showIn.targetId", "org.eclipse.jdt.ui.PackageExplorer");
                            try {
                                IEvaluationContext context = ((IHandlerService)JavaElementView.this.getSite().getService(IHandlerService.class)).getCurrentState();
                                showInCommand.executeWithChecks(new ExecutionEvent(null, params, null, (Object)context));
                                return;
                            }
                            catch (ExecutionException e1) {
                                JavaElementView.this.showAndLogError("Could not show element", (Exception)((Object)e1));
                                return;
                            }
                            catch (NotDefinedException e1) {
                                JavaElementView.this.showAndLogError("Could not show element", (Exception)((Object)e1));
                                return;
                            }
                            catch (NotEnabledException e1) {
                                JavaElementView.this.showAndLogError("Could not show element", (Exception)((Object)e1));
                                return;
                            }
                            catch (NotHandledException e1) {
                                JavaElementView.this.showAndLogError("Could not show element", (Exception)((Object)e1));
                            }
                            return;
                        }
                        default: {
                            try {
                                IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)javaElement);
                                if (editorPart == null) return;
                                if (isSecondDoubleClick && javaElement instanceof ISourceReference && editorPart instanceof ITextEditor) {
                                    ISourceRange sourceRange = ((ISourceReference)javaElement).getSourceRange();
                                    EditorUtility.selectInEditor((ITextEditor)editorPart, sourceRange.getOffset(), sourceRange.getLength());
                                    return;
                                }
                                JavaUI.revealInEditor((IEditorPart)editorPart, (IJavaElement)javaElement);
                                return;
                            }
                            catch (PartInitException e) {
                                JavaElementView.this.showAndLogError("Could not open editor.", (CoreException)((Object)e));
                                return;
                            }
                            catch (JavaModelException e) {
                                JavaElementView.this.showAndLogError("Could not open editor.", (CoreException)((Object)e));
                            }
                            return;
                        }
                    }
                }
                if (obj instanceof Error) {
                    Error error = (Error)obj;
                    JEViewPlugin.log(error.getException());
                    return;
                }
                if (!(obj instanceof JEMarker)) return;
                JEMarker marker = (JEMarker)obj;
                try {
                    IDE.openEditor((IWorkbenchPage)JavaElementView.this.getSite().getPage(), (IMarker)marker.getMarker());
                    return;
                }
                catch (PartInitException e) {
                    JavaElementView.this.showAndLogError("Could not open editor.", (CoreException)((Object)e));
                }
            }
        };
        this.fCompareAction = new Action(){

            public void run() {
                Object second;
                TreePath[] selection = ((ITreeSelection)JavaElementView.this.fViewer.getSelection()).getPaths();
                Object first = ((JEAttribute)selection[0].getLastSegment()).getWrappedObject();
                boolean identical = first == (second = ((JEAttribute)selection[1].getLastSegment()).getWrappedObject());
                boolean equals1 = first != null && first.equals(second);
                boolean equals2 = second != null && second.equals(first);
                boolean inconsistentEquals = equals1 ^ equals2;
                String msg = "==: " + identical + "\nequals(..): " + (inconsistentEquals ? "INCONSISTENT" : Boolean.valueOf(equals1));
                MessageDialog.openInformation((Shell)JavaElementView.this.fViewer.getTree().getShell(), (String)"Comparison", (String)msg);
            }
        };
        this.fCompareAction.setText("C&ompare with Each Other...");
        this.fLogDeltasAction = new Action("Log Java element deltas", 2){
            private IElementChangedListener fListener;
            {
                this.fListener = new IElementChangedListener(){

                    public void elementChanged(ElementChangedEvent event) {
                        String type = "\nEvent type: ";
                        switch (event.getType()) {
                            case 1: {
                                type = String.valueOf(type) + "POST_CHANGE";
                                break;
                            }
                            case 4: {
                                type = String.valueOf(type) + "POST_RECONCILE";
                                break;
                            }
                            case 2: {
                                type = String.valueOf(type) + "PRE_AUTO_BUILD";
                                break;
                            }
                            default: {
                                type = String.valueOf(type) + event.getType();
                            }
                        }
                        JEViewPlugin.logMessage(String.valueOf(event.getDelta().toString()) + type);
                    }
                };
            }

            public void run() {
                String message;
                if (!this.isChecked()) {
                    JavaCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                    message = "Element listener removed";
                } else {
                    JavaCore.addElementChangedListener((IElementChangedListener)this.fListener);
                    message = "Element listener added. Deltas are now written to log.";
                }
                MessageDialog.openInformation((Shell)JavaElementView.this.fViewer.getTree().getShell(), (String)"Log Java Element Deltas", (String)message);
            }
        };
    }

    static IJavaElement[] codeResolve(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICodeAssist) {
            IJavaElement[] elements;
            if (input instanceof ICompilationUnit) {
                JavaElementView.reconcile((ICompilationUnit)input);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset(), selection.getLength())) != null && elements.length > 0) {
                return elements;
            }
        }
        return new IJavaElement[0];
    }

    static IJavaElement getElementAtOffset(IJavaElement input, ITextSelection selection) throws JavaModelException {
        if (input instanceof ICompilationUnit) {
            ICompilationUnit cunit = (ICompilationUnit)input;
            JavaElementView.reconcile(cunit);
            IJavaElement ref = cunit.getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        if (input instanceof IClassFile) {
            IJavaElement ref = ((IClassFile)input).getElementAt(selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reconcile(ICompilationUnit unit) throws JavaModelException {
        ICompilationUnit iCompilationUnit = unit;
        synchronized (iCompilationUnit) {
            unit.reconcile(0, false, null, null);
        }
    }

    private ImageDescriptor getJavaModelImageDescriptor() {
        JavaElementLabelProvider lp = new JavaElementLabelProvider(256);
        Image modelImage = lp.getImage((Object)this.getJavaModel());
        ImageDescriptor modelImageDescriptor = ImageDescriptor.createFromImage((Image)modelImage);
        lp.dispose();
        return modelImageDescriptor;
    }

    private void hookDoubleClickAction() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                JavaElementView.this.fDoubleClickAction.run();
            }
        });
    }

    void showAndLogError(String message, CoreException e) {
        JEViewPlugin.log(message, e);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"JavaElement View", (String)message, (IStatus)e.getStatus());
    }

    void showAndLogError(String message, Exception e) {
        Status status = new Status(4, JEViewPlugin.getPluginId(), 0, message, (Throwable)e);
        JEViewPlugin.log((IStatus)status);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"JavaElement View", null, (IStatus)status);
    }

    void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.fViewer.getControl().getShell(), (String)"JavaElement View", (String)message);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext(null, this.getSite().getSelectionProvider().getSelection());
    }

    public boolean show(ShowInContext context) {
        Object elementOfInput;
        Object input;
        IStructuredSelection structuredSelection;
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() >= 1) {
            ArrayList input2 = new ArrayList();
            for (Object item : structuredSelection) {
                if (!(item instanceof IJavaElement) && !(item instanceof IResource) && !(item instanceof IJarEntryResource)) continue;
                input2.add(item);
            }
            if (input2.size() > 0) {
                this.setInput(input2);
                return true;
            }
        }
        if ((input = context.getInput()) instanceof IEditorInput && (elementOfInput = this.getElementOfInput((IEditorInput)context.getInput())) != null) {
            this.setSingleInput(elementOfInput);
            return true;
        }
        return false;
    }

    Object getElementOfInput(IEditorInput input) {
        Object adapted = input.getAdapter(IClassFile.class);
        if (adapted != null) {
            return adapted;
        }
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IJavaElement javaElement = JavaCore.create((IFile)file);
            if (javaElement != null) {
                return javaElement;
            }
            return file;
        }
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage();
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    private PropertySheetPage getPropertySheetPage() {
        if (this.fPropertySheetPage == null) {
            PropertySheetPage propertySheetPage = new PropertySheetPage();
            propertySheetPage.setPropertySourceProvider(new IPropertySourceProvider(){

                public IPropertySource getPropertySource(Object object) {
                    if (object instanceof IJavaElement) {
                        return new JavaElementProperties((IJavaElement)object);
                    }
                    if (object instanceof IResource) {
                        return new ResourceProperties((IResource)object);
                    }
                    if (object instanceof IMarker) {
                        return new MarkerProperties((IMarker)object);
                    }
                    if (object instanceof IJarEntryResource) {
                        return new JarEntryResourceProperties((IJarEntryResource)object);
                    }
                    if (object instanceof IMemberValuePair) {
                        return new MemberValuePairProperties((IMemberValuePair)object);
                    }
                    if (object instanceof IClasspathEntry) {
                        return new ClasspathEntryProperties((IClasspathEntry)object);
                    }
                    return null;
                }
            });
            this.fPropertySheetPage = propertySheetPage;
        }
        return this.fPropertySheetPage;
    }

    private static class InputDialog
    extends org.eclipse.jface.dialogs.InputDialog {
        public InputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        protected boolean isResizable() {
            return true;
        }
    }

    private static class JEViewSelectionProvider
    implements ISelectionProvider {
        private final TreeViewer fViewer;
        ListenerList fSelectionChangedListeners = new ListenerList();
        private IStructuredSelection fLastSelection;

        public JEViewSelectionProvider(TreeViewer viewer) {
            this.fViewer = viewer;
            this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    JEViewSelectionProvider.this.fireSelectionChanged();
                }
            });
        }

        void fireSelectionChanged() {
            if (this.fSelectionChangedListeners != null) {
                IStructuredSelection selection = this.getSelection();
                if (this.fLastSelection != null) {
                    List newSelection = selection.toList();
                    List oldSelection = this.fLastSelection.toList();
                    int size = newSelection.size();
                    if (size == oldSelection.size()) {
                        int i = 0;
                        while (i < size) {
                            Object oldElement;
                            Object newElement = newSelection.get(i);
                            if (newElement != (oldElement = oldSelection.get(i)) && newElement.equals(oldElement) && newElement instanceof IJavaElement) {
                                Object[] listeners;
                                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)StructuredSelection.EMPTY);
                                Object[] objectArray = listeners = this.fSelectionChangedListeners.getListeners();
                                int n = listeners.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object listener = objectArray[n2];
                                    ((ISelectionChangedListener)listener).selectionChanged(event);
                                    ++n2;
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                }
                this.fLastSelection = selection;
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection);
                Object[] listeners = this.fSelectionChangedListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                    listener.selectionChanged(event);
                    ++i;
                }
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionChangedListeners.add((Object)listener);
        }

        public IStructuredSelection getSelection() {
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
            ArrayList<Object> externalSelection = new ArrayList<Object>();
            for (Object element : selection) {
                Object wrappedObject;
                if (element instanceof JavaElement) {
                    IJavaElement javaElement = ((JavaElement)element).getJavaElement();
                    if (javaElement == null || javaElement instanceof IJavaModel) continue;
                    externalSelection.add(javaElement);
                    continue;
                }
                if (element instanceof JEResource) {
                    IResource resource = ((JEResource)element).getResource();
                    if (resource == null || resource instanceof IWorkspaceRoot) continue;
                    externalSelection.add(resource);
                    continue;
                }
                if (!(element instanceof JEAttribute) || (wrappedObject = ((JEAttribute)element).getWrappedObject()) == null) continue;
                externalSelection.add(wrappedObject);
            }
            return new StructuredSelection(externalSelection);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionChangedListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }
}

