/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 * /
 *******************************************************************************/

package org.eclipse.jet.internal.taglib.control;


import java.text.MessageFormat;

import org.eclipse.jet.JET2Context;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractIteratingTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.xpath.NodeSet;


/**
 * Implement the standard JET2 control tag 'iterate'.
 *
 */
public class IterateTag extends AbstractIteratingTag
{

  private Object[] selectedObjects;

  private int currentIndex;

  private String varName;

  private Object savedVarValue = null;

  private boolean nodeSetIteration;

  private long maxIterations = 0;

  /**
   * 
   */
  public IterateTag()
  {
    super();
  }

  /* (non-Javadoc)
   * @see org.eclipse.jet.taglib.IteratingTag#doEvalLoopCondition(org.eclipse.jet.taglib.TagInfo, org.eclipse.jet.JET2Context)
   */
  public boolean doEvalLoopCondition(TagInfo tc, JET2Context context) throws JET2TagException
  {
    boolean doAnotherIteration = currentIndex < maxIterations;

    if (doAnotherIteration)
    {
      if (nodeSetIteration)
      {
        context.setVariable(varName, selectedObjects[currentIndex]);
      }
      else
      {
        context.setVariable(varName, new Long(currentIndex + 1));
      }
      //			writeDelimiterIfAppropriate();
    }
    else
    {
      context.removeVariable(varName);
      if (savedVarValue != null)
      {
        context.setVariable(varName, savedVarValue);
      }
    }

    currentIndex++;

    return doAnotherIteration;
  }

  /* (non-Javadoc)
   * @see org.eclipse.jet.taglib.IteratingTag#doInitializeLoop(org.eclipse.jet.taglib.TagInfo, org.eclipse.jet.JET2Context)
   */
  public void doInitializeLoop(TagInfo td, JET2Context context) throws JET2TagException
  {
    String selectXPath = getAttribute("select"); //$NON-NLS-1$
    varName = getAttribute("var"); //$NON-NLS-1$

    setDelimiter(getAttribute("delimiter")); //$NON-NLS-1$

    XPathContextExtender xpathContext = XPathContextExtender.getInstance(context);

    if (context.hasVariable(varName))
    {
      savedVarValue = context.getVariable(varName);
    }

    final Object resultObject = xpathContext.resolveAsObject(xpathContext.currentXPathContextObject(), selectXPath);
    if (resultObject instanceof Number)
    {
      nodeSetIteration = false;
      maxIterations = ((Number)resultObject).longValue();
    }
    else if (resultObject instanceof NodeSet)
    {
      nodeSetIteration = true;
      selectedObjects = ((NodeSet)resultObject).toArray();
      maxIterations = selectedObjects.length;
    }
    else
    {
      throw new JET2TagException(MessageFormat.format(JET2Messages.IterateTag_CannotIterateOnResult, new Object []{ selectXPath }));
    }
    currentIndex = 0;
  }

}
