/**
 * <copyright>
 *
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.jet.internal.taglib.format;

import org.eclipse.jet.AbstractContextExtender;
import org.eclipse.jet.JET2Context;

/**
 * Provide storage for unique and milliseconds tags
 */
public class FormatContextExtender extends AbstractContextExtender
{

  private static final class ContextData {

    private long lastMilliseconds = 0;
    private int lastUnique = 0;

    public long getMilliseconds() {
        long next = System.currentTimeMillis();
        if (next <= lastMilliseconds) {
            next = lastMilliseconds + 1;
        }
        lastMilliseconds = next;
        return next;
    }

    public int getUnique() {
        int unique = lastUnique + 1;
        lastUnique = unique;
        return unique;
    }
    
  }
  
  public static FormatContextExtender getInstance(JET2Context context)
  {
    return new FormatContextExtender(context);
  }
  
  /**
   * @param context
   */
  private FormatContextExtender(JET2Context context)
  {
    super(context);
  }

  /* (non-Javadoc)
   * @see org.eclipse.jet.AbstractContextExtender#createExtendedData(org.eclipse.jet.JET2Context)
   */
  protected Object createExtendedData(JET2Context context)
  {
    return new ContextData();
  }

  
  
  /**
   * Reurns a unique system time in milliseconds.
  */
  public long getMilliseconds() {
      return getData().getMilliseconds();
  }

  private ContextData getData()
  {
    return (ContextData)getExtendedData();
  }

  /**
   * Reurns a unique integer.
  */
    public int getUnique() {
        return getData().getUnique();
    }

}
