/**
 * <copyright>
 *
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 */

package org.eclipse.jet.internal.taglib.workspace;


import java.text.MessageFormat;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;


/**
 * Copy a binary file from a source URL to a target workspace file.
 *
 */
public class WsCopyTextFileAction extends AbstractWorkspaceAction implements IWorkspaceAction
{

  private final IFile file;

  private final boolean replace;

  private final String targetEncoding;

  private final String sourceFileContents;

  private final JET2Context context;

  public WsCopyTextFileAction(
    JET2Context context,
    String templatePath,
    TagInfo td,
    String sourceFileContents,
    IFile file,
    boolean replaceExisting,
    String targetEncoding)
  {
    super(td, templatePath);
    this.context = context;
    this.sourceFileContents = sourceFileContents;
    this.file = file;
    this.replace = replaceExisting;
    this.targetEncoding = targetEncoding;
  }

  /* (non-Javadoc)
   * @see org.eclipse.jet.internal.taglib.workspace.IWorkspaceAction#getResource()
   */
  public IResource getResource()
  {
    return file;
  }

  /* (non-Javadoc)
   * @see org.eclipse.jet.internal.taglib.workspace.IWorkspaceAction#requiresValidateEdit()
   */
  public boolean requiresValidateEdit()
  {
    return replace && file.exists() && file.isReadOnly() /* && content has changed */;
  }

  /* (non-Javadoc)
   * @see org.eclipse.jet.internal.taglib.workspace.IWorkspaceAction#performAction(org.eclipse.core.runtime.IProgressMonitor)
   */
  public void performAction(IProgressMonitor monitor) throws JET2TagException
  {
    ActionsUtil.writeTextFile(file, replace, targetEncoding, false, sourceFileContents, monitor);
    
    final String fileMessage = MessageFormat.format(
      JET2Messages.WsFileFromWriterAction_WritingFile,
      new Object []{ file.getFullPath().toString() });
    RuntimeLoggerContextExtender.log(context, fileMessage, getTagInfo(), getTemplatePath(), RuntimeLoggerContextExtender.INFO_LEVEL);
  }

}
